// StatusBarCtrl.h cXe[^Xo[̃TuNX
#ifndef __WGC_STATUSBAR__
#define __WGC_STATUSBAR__

#include "Control.h"
#include <vector>                       // std::vector<>


_WGC_BEGIN                              // namespace wgc {

class StatusBarCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit StatusBarCtrl(HWND hWnd = NULL);
	virtual ~StatusBarCtrl(void);

	BOOL Create(
		Window *pParent,
		LPCTSTR lpszWindowName,
		const DWORD dwStyle          = WS_CHILD | WS_VISIBLE,
		const DWORD dwCtlStyle       = CCS_BOTTOM,
		const DWORD dwStatusBarStyle = SBARS_SIZEGRIP,
		const DWORD dwExStyle        = 0,
		const UINT  nID              = IDW_STD_STATUSBAR);

	void SetIndicators(HINSTANCE hResource, const UINT nIDArray[], const int nCount);

	// 
	void SetSimple(const BOOL bSimple = TRUE);
	void GetBorders(int *pBorders) const;
	void GetBorders(int *pHorz, int *pVert, int *nSpacing) const;
	void SetParts(const int nParts, int *pWidths);
	int  GetParts(const int nParts, int *pWidths) const;
	void SetText(const int iPart, const int uType, const tstring_t &text, const BOOL bFlexible = FALSE);
	void SetTipText(const int iPart, const tstring_t &text);

	int HitTest(const POINT &pt) const;

protected:
	// bZ[Wnh
	void OnSize(const UINT nType, const int cx, const int cy);

private:
	typedef std::vector<int> intarray_t;
	intarray_t m_pane_width;

	void CalcInsideRect(RECT &rect) const;
	void UpdatePanePosition(void);

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(StatusBarCtrl)
};

_WGC_END                                // }

#endif // __WGC_STATUSBAR__
