// Clipboard.cpp cCve[Vt@C
#include "Clipboard.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {

Clipboard::Clipboard(HWND hWndNewOwner /* = NULL */)
{
	const BOOL bResult = ::OpenClipboard(hWndNewOwner);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

Clipboard::~Clipboard(void)
{
	::CloseClipboard();
}


// wtH[}bg̃f[^Nbv{[hɂ邩H
BOOL Clipboard::IsFormatAvailable(const UINT format)
{
	return ::IsClipboardFormatAvailable(format);
}

// ɂ
void Clipboard::Empty(void)
{
	const BOOL bResult = ::EmptyClipboard();
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


// f[^̎擾/ݒ
HANDLE Clipboard::GetData(const UINT uFormat) const
{
	return ::GetClipboardData(uFormat);
}

HANDLE Clipboard::SetData(const UINT uFormat, HANDLE hMem)
{
	return ::SetClipboardData(uFormat, hMem);
}

_WGC_END                                // }
