// keyword_manager.h cL[[h}l[W
#ifndef __SGC_KEYWORD_MANAGER__
#define __SGC_KEYWORD_MANAGER__

#include "sgc.h"
#include <string>                       // std::wstring
#include <list>                         // std::list<>


_SGC_BEGIN                              // namespace sgc {

// L[[h^Cv
typedef enum _keyword_type_t
{
	KT_NONE,                                // L[[hłȂ
	KT_NORMAL,                              // ʏ
	KT_LINE,                                // sL[[h
	KT_QUOTE,                               // pL[[h
	KT_BLOCK,                               // ubNL[[h
} keyword_type_t;

// L[[h}l[W
class keyword_manager
{
public:
	typedef std::wstring keyword_t;         // L[[h^
	typedef struct _keyword_info_t          // L[[h^
	{
		keyword_type_t type;                    // L[[h^Cv
		size_t         index;                   // L[[hCfbNX
	} keyword_info_t;
	typedef struct _keyword_data_t          // L[[hf[^^iL[[h{j
	{
		keyword_t      word;                    // L[[h
		keyword_info_t info;                    // L[[h
	} keyword_data_t;

	void   set_keywords(const keyword_data_t data[], const size_t count);
	size_t find_keyword(const wchar_t *wstr, const size_t length, keyword_info_t &info, const bool head = false) const;

private:
	// nbV
	typedef unsigned int hash_t;
	enum { MAX_HASH_VAL = 0xff };
	static hash_t _Hash(const wchar_t *wstr);

	static bool _Pred(const keyword_data_t &val1, const keyword_data_t &val2);
	static int  _IsIdentifier(const wchar_t wch);

	static size_t _WordLength(const wchar_t *wstr, const size_t length);

	static int _CompareWord(const wchar_t *wstr, const size_t length_wstr, const wchar_t *keyword, const size_t length_keyword);

	size_t _FindIndex(const wchar_t *wstr, const size_t length) const;

	typedef std::list<keyword_data_t> data_list_t;
	data_list_t m_list[MAX_HASH_VAL + 1];
};

_SGC_END                                // }

#endif // __SGC_KEYWORD_MANAGER__
