// edit_manager.h cGfBbgR|[lg̃obt@암
// jł́uXgOvusȂv̈ӖŁA
// @@ueLXgvusiȂjv̈ӖŎgĂB
#ifndef __SGC_EDIT_MANAGER__
#define __SGC_EDIT_MANAGER__

#include "sgc.h"
#include "edit_line.h"                  // sgc::edit_line
#include "undo_buffer.h"                // sgc::undo_buffer<>
#include <list>                         // std::list<>


_SGC_BEGIN                              // namespace sgc {

// ȃobt@암
// obt@ɍs̃IuWFNgƂ̘AgɊւẮA
// ʂōsׂB
class edit_manager
{
private:
	////////////////////////////////////////////////////////////////
	// J̌^`
	typedef std::list<edit_line> linelist_t;
	typedef linelist_t::iterator iterator_t;

	// AhD
	typedef struct _undo_info
	{
		bool       stop;
		bool       move_cursor;                 // }ɃJ[\ړ邩H
		bool       insert;                      // }/폜
		position_t position;                    // J[\ʒu
		linelist_t text;                        // eLXg
	} undo_info;

public:
	typedef linelist_t::const_iterator const_iterator_t;
	typedef linelist_t::size_type      linenumber_t;
	typedef edit_line::size_t          size_t;

	typedef struct _modify_info
	{
		linenumber_t modified_line;
		bool         is_modified_linecount;
	} modify_info;

	// J[\ړ̑I
	typedef enum _move_select_t
	{
		MS_CLEAR,                               // INA
		MS_UPDATE,                              // XV
		MS_NOCHANGE,                            // ωȂ
	} move_select_t;

	// ĨJ[\̈ʒu
	typedef enum _select_cursor_t
	{
		SC_NOMOVE,                              // Ȃ
		SC_BEGIN,                               // I͈͂̍ŏ
		SC_END,                                 // I͈͂̍Ō
	} select_cursor_t;

	////////////////////////////////////////////////////////////////
	// RXgNV
	edit_manager (void);
	~edit_manager(void);

	////////////////////////////////////////////////////////////////
	// 
	void   get_line(sgc::wstring_t &line, const wchar_t quote_mark = charcode::wNUL) const;
	size_t get_line_count(void) const;
	size_t find_word_break(const bool forward = true) const;
	bool   is_begin(void) const;
	bool   is_end  (void) const;
	bool   is_head (void) const;
	bool   is_tail (void) const;

	////////////////////////////////////////////////////////////////
	// W
	position_t       get_xy(void) const;
	const_iterator_t set_xy(const position_t &position, const move_select_t select_status = MS_CLEAR);
	intptr_t get_x(void) const;
	intptr_t get_y(void) const;
	intptr_t set_x(const intptr_t x, const move_select_t select_status = MS_CLEAR);
	intptr_t set_y(const intptr_t y, const move_select_t select_status = MS_CLEAR);
	intptr_t shift_x(const intptr_t dx, const move_select_t select_status = MS_CLEAR);
	intptr_t shift_y(const intptr_t dy, const move_select_t select_status = MS_CLEAR);

	////////////////////////////////////////////////////////////////
	// Ce[^
	const_iterator_t get_iterator      (const linenumber_t y) const;
	const_iterator_t get_iterator_begin(void) const;
	const_iterator_t get_iterator_end  (void) const;
	const_iterator_t get_iterator_now  (void) const;

	////////////////////////////////////////////////////////////////
	// ̐ݒ/擾
	void set_readonly(const bool readonly = true);
	bool is_readonly(void) const;
	void set_modify(const bool modify = true);
	bool is_modified(void) const;

	////////////////////////////////////////////////////////////////
	// ҏW
	bool     undo(modify_info &mi);
	bool     redo(modify_info &mi);
	bool     can_undo(void) const;
	bool     can_redo(void) const;
	intptr_t set_undo_limit (const intptr_t limit = -1);
	void     empty_undo_buffer(void);
	bool     set_text        (const wchar_t *text, const size_t size);
	bool     insert_text     (const wchar_t *text, const size_t size, modify_info &mi, const wchar_t quote_mark = charcode::wNUL, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     insert_linefeed (modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     insert_string   (const wstring_t &wstr                   , modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     insert_string   (const wchar_t *wstr, const size_t length, modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     overwrite_string(const wstring_t &wstr                   , modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     overwrite_string(const wchar_t *wstr, const size_t length, modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     delete_char     (const bool forward, modify_info &mi, const move_select_t select_status = MS_CLEAR, const bool stop = true);
	bool     delete_line     (modify_info &mi, const bool stop = true);

	static void merge_modify_info(const modify_info mi_array[], const size_t count, modify_info &mi);

	////////////////////////////////////////////////////////////////
	// I
	void select_word(const select_cursor_t cursor_pos = SC_NOMOVE, const bool update_selection = false);
	void select_line(const select_cursor_t cursor_pos = SC_NOMOVE, const bool update_selection = false);
	void select_all(void);
	void select_clear(const select_cursor_t cursor_pos = SC_NOMOVE);
	bool select_delete(const bool move_cusror, modify_info &mi, const bool stop = true);
	void select_get_text(wstring_t &wtext, const wchar_t quote_mark = charcode::wNUL) const;
	void select_get_range(position_t &begin, position_t &end) const;
	bool is_selected(void) const;

protected:
	// X^C
	typedef struct _style_t
	{
		unsigned readonly : 1;                  // ݋֎~tO
	} style_t;
	style_t m_style;

	// _
	linelist_t m_buffer;                      // eLXg̃Xgf[^

	// ҏWʒȕiCe[^EWj
	typedef struct _pos_t
	{
		iterator_t it;
		position_t xy;
	} pos_t;
	pos_t m_pos;                            // ݈ʒũCe[^EWi0 originj

	// I
	typedef struct _select_t
	{
		position_t begin;
		position_t end;
	} select_t;
	select_t m_select;

	// AhD
	undo_buffer<undo_info> m_undo_buffer;


	// A
	bool _Combine(pos_t &pos, const bool forward, modify_info &mi);

	// ҏW
	void _PushUndo(const linelist_t &text, const position_t &position, const bool move_cursor = true, const bool insert = true, const bool stop = true);
	void _Delete(iterator_t &pos, const size_t count = 1, const bool forward = true);
	void _Delete(const linelist_t &buffer);
	void _Insert(linelist_t &buffer, const bool move_buffer = true, const bool move_cursor = true, const move_select_t select_status = MS_NOCHANGE);

	// I͈
	size_t _FindWordBreak(const wchar_t *line, const size_t length, const size_t pos, const bool forward = true) const;
	void   _SelectGetRange     (      position_t &pos_begin, position_t &pos_end) const;
	void   _RangeCreateLineList(const position_t &begin, const position_t &end, linelist_t &linelist) const;
	void   _RangeDelete        (const position_t &begin, const position_t &end, undo_info &info, modify_info &mi);

	void _SetSelectStatus(const move_select_t select_status);

	// XN[
	intptr_t _Scroll        (const intptr_t count, const_iterator_t &pos) const;
	intptr_t _ScrollForward (const size_t   count, const_iterator_t &pos) const;
	intptr_t _ScrollBackward(const size_t   count, const_iterator_t &pos) const;

	linenumber_t _GetPosition(const linenumber_t linenumber, const_iterator_t &pos) const;

	static void _CreateLineList(const wchar_t *text, const size_t size, linelist_t &linelist, const wchar_t quote_mark = charcode::wNUL);
};

_SGC_END                                // }

#endif // __SGC_EDIT_MANAGER__
