// MainFrame.cpp
#include "MainFrame.h"
#include "Station.h"
#include "Setting.h"                    // Setting_SaveWindowPlacement()
#include "CodePage.h"                   // CodePage_AutoDetect()
#include "Dialog/OpenSave.h"
#include "Dialog/About.h"
#include "Dialog/Jump.h"
#include "Dialog/Property.h"
#include "Dialog/Customize.h"
#include <assert.h>                     // assert()
#include <shlwapi.h>                    // ::PathFindFileName()


// EChENX
#define CLASSNAME_MAINFRAME     _T("MaxyMainFrame")

#define STR_MODIFIED    _T(" *")
#define STR_HYPHEN      _T(" - ")
#define STR_URL         _T("http://maxy.sourceforge.jp/")


// Rg[ID
#define IDW_EDIT_VIEW   550

// Xe[^Xo[̃yCԍ
#define STATUS_PANE_IDLE        0       // ACh
#define STATUS_PANE_READONLY    1       // 
#define STATUS_PANE_OVERWRITE   2       // ㏑
#define STATUS_PANE_CODEPAGE    3       // R[hy[W
#define STATUS_PANE_SIMPLE      255     // Vv[h̃yCԍ


// RXgNV
MainFrame::MainFrame(void)
	: m_hFile(INVALID_HANDLE_VALUE),
	m_uViewPropertyType(0),
	m_bActive(FALSE), m_bCloseAll(FALSE), m_bBom(FALSE)
{
	m_ftUpdate.dwLowDateTime  = 0;
	m_ftUpdate.dwHighDateTime = 0;
	m_uCodePage      = 0;
	m_uCodePageIndex = 0;
	m_pMultiLanguage2 = wxc::COM_XMultiLanguage2::CreateInstance();

	// {block}
	// GfBbgR|[lg̃hLg쐬
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

		HCURSOR hCursorMargin = ::LoadCursor(GetResourceHandle(), MAKEINTRESOURCE(IDC_MARGIN));

		EditDocPtr pEditDoc(new EditDoc(this, prView, hCursorMargin));
		m_pEditDoc = pEditDoc;
	}
}

MainFrame::~MainFrame(void)
{
	// {block}
	{
		delete m_pMultiLanguage2;
		m_pMultiLanguage2 = NULL;
	}

	if(m_hFile != INVALID_HANDLE_VALUE)
	{
		::CloseHandle(m_hFile);
		m_hFile = INVALID_HANDLE_VALUE;
	}
}


// EChENX̓o^(static)
void MainFrame::Register(void)
{
	HINSTANCE hInstance = ::GetModuleHandle(NULL);
	HICON     hIcon     = ::LoadIcon  (GetResourceHandle(), MAKEINTRESOURCE(IDR_MAINFRAME));
	HCURSOR   hCursor   = ::LoadCursor(NULL, IDC_ARROW);

	WNDCLASS wc;
	wc.style         = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
	wc.lpfnWndProc   = _WindowProcBase;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = hIcon;
	wc.hCursor       = hCursor;
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MAINFRAME);
	wc.lpszClassName = CLASSNAME_MAINFRAME;
	if(::RegisterClass(&wc) == 0)
	{
		wgc::wgfThrowLastError();
	}
}

// wEChECt[H
BOOL MainFrame::IsMainFrame(HWND hWnd)
{
	// EChENX擾
	TCHAR szClassName[256];
	::GetClassName(hWnd, szClassName, countof(szClassName));

	// NXCt[łȂΌs
	return ::lstrcmpi(szClassName, CLASSNAME_MAINFRAME) == 0;
}


// VKt[̍쐬(static)
MainFrame *MainFrame::CreateFrame(const CREATEFRAME_PARAMETER *lpParameter, const LPWINDOWPLACEMENT lpWndPl)
{
	// Ct[IuWFNg쐬
	MainFrame *pMainFrame = new MainFrame;

	// Ct[쐬
	const BOOL bResult = pMainFrame->Create(
		CLASSNAME_MAINFRAME, _T(""),
		WS_OVERLAPPEDWINDOW,
		WS_EX_ACCEPTFILES,
		NULL, NULL, NULL,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT);
	if(!bResult)
	{
		DeleteFrame(pMainFrame);
		wgc::wgfThrowLastError();
	}

	if(lpWndPl)
	{
		pMainFrame->SetWindowPlacement(*lpWndPl);
	}
	else
	{
		// Ct[\
		pMainFrame->ShowWindow(lpParameter->nCmdShow);
	}
	pMainFrame->UpdateWindow();

	// t@Cw肳ĂJ
	if(lpParameter->szPathName[0] != wgc::tNUL)
	{
		pMainFrame->OpenDocumentFile(lpParameter->szPathName, -1, lpParameter->bReadOnly, lpParameter->nCodePage);
		pMainFrame->m_pEditDoc->JumpToLine(lpParameter->nLineNumber);
	}
	return pMainFrame;
}

// t[̍폜(static)
void MainFrame::DeleteFrame(MainFrame *pMainFrame)
{
	delete pMainFrame;
}


// wt@CҏW̃t[擾
HWND MainFrame::GetEditingFrame(LPCTSTR lpszPathName)
{
	FINDWINDOW fw = {NULL, lpszPathName};
	const BOOL bResult = ::EnumWindows(FindWindowProc, reinterpret_cast<LPARAM>(&fw));
	if(bResult)
	{
		return NULL;
	}

	return fw.hWnd;
}

// SẴt[փbZ[W𑗐M
void MainFrame::BroadcastMessage(const BOOL bSend, UINT uMsg, WPARAM wParam /* = 0 */, LPARAM lParam /* = 0 */)
{
	BROADCASTPARAM bcp = {bSend, uMsg, wParam, lParam};
	::EnumWindows(BroadcastProc, reinterpret_cast<LPARAM>(&bcp));
}


// bZ[WOɌĂяo
void MainFrame::PreHandleMessage(void)
{
	// c[o[XV
	UpdateCommand(command_interface_toolbar(m_cToolBar));
}


// G[bZ[W{bNX\
int MainFrame::ErrorMessageBox(HRESULT hResult) const
{
	return AppErrorMessageBox(m_hWnd, hResult);
}


////////////////////////////////////////////////////////////
// EChEvV[W
LRESULT MainFrame::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	try
	{
		switch(uMsg)
		{
		case MAXY_GETPATHNAME:                  // LփCt[
			OnMaxyGetPathName(reinterpret_cast<LPTSTR>(lParam), wParam);
			return 0;

		case MAXY_REFRECT_FRAME:
			OnMaxyRefrectFrame();
			return 0;

		case MAXY_REFRECT_VIEW:
			OnMaxyRefrectView(wParam);
			return 0;

		case MAXY_BACKUP_UNSAVED_FILE:
			OnMaxyBackupUnsavedFile();
			return 0;
		}
		return Window::WindowProc(uMsg, wParam, lParam);
	}
	catch(const HRESULT hResult)
	{
		// EChEvV[W̗OLb`
		ErrorMessageBox(hResult);
		return 0;
	}
}


////////////////////////////////////////////////////////////
// z֐

void MainFrame::PostNcDestroy(void)
{
	// uׂĕvȂÃt[ IDM_FILE_CLOSE_ALL R}h𑗂
	if(m_bCloseAll)
	{
		// ̎_ł̓EChEjIĂ̂
		// ::FindWindow() ݂̃vZX̃Ct[wƂ͂Ȃ
		HWND hWnd = ::FindWindow(CLASSNAME_MAINFRAME, NULL);
		if(hWnd != NULL)
		{
			::PostMessage(
				hWnd,
				WM_COMMAND,
				MAKEWPARAM(IDM_FILE_CLOSE_ALL, 0),
				0);
		}
	}
}


////////////////////////////////////////////////////////////
// bZ[Wnh

////////////////////////////////////////
// RXgNV

// EChE쐬Ej
int MainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if(Window::OnCreate(lpCreateStruct) == -1)
	{
		return -1;
	}

	// R|[lg쐬
	if(!CreateControlBar   ()) { return -1; }
	if(!CreateEditComponent()) { return -1; }

	// R[hy[W̃j[ǉ
	if(m_pMultiLanguage2 != NULL)
	{
		m_pMultiLanguage2->EnumCodePages(m_cp_import, MIMECONTF_IMPORT);
		m_pMultiLanguage2->EnumCodePages(m_cp_export, MIMECONTF_EXPORT);
		AppendCodePageMenu(m_cp_import, IDM_FILE_OPENWITHCP_FIRST);
		AppendCodePageMenu(m_cp_export, IDM_FILE_SAVEWITHCP_FIRST);
		SetCodePage();
	}

	AppendSettingMenu();

	// ftHg̃^Cg쐬
	UpdateFrameTitle();
	return 0;
}

void MainFrame::OnClose(void)
{
	// ύXꍇ
	if(m_pEditDoc->IsModified())
	{
		switch(MessageBox_AskToSave())
		{
		case IDYES:
			// YESȂۑ
			if(!Save())
			{
				// ۑɎs璆~
				m_bCloseAll = FALSE;
				return;
			}
			break;

		case IDNO:
			// NOȂ疳ɕ
			break;

		case IDCANCEL:
			// LZȂ璆~
			m_bCloseAll = FALSE;
			return;
		}
	}
	DestroyWindow();
}

void MainFrame::OnDestroy(void)
{
	// {block}
	// EChȄԂL^
	{
		WINDOWPLACEMENT wndpl;
		GetWindowPlacement(wndpl);
		SetWindowPlacementParameter(wndpl);
	}

	// c[o[ۑ
	ToolSaveRestore(TRUE);

	::PostQuitMessage(0);
}


// ZbVI
void MainFrame::OnEndSession(const BOOL bEnding, const BOOL /* bLogOff */)
{
	// IȂΉȂ
	if(!bEnding)
	{
		return;
	}

	BackupUnsavedFile();
}


// TCYύX
void MainFrame::OnSize(const UINT nType, const int cx, const int cy)
{
	Window::OnSize(nType, cx, cy);

	// c[o[AXe[^Xo[̒
	m_cToolBar  .SendMessage(WM_SIZE);
	m_cStatusBar.SendMessage(WM_SIZE);

	// GfBbgR|[lg̒
	RecalcEditLayout();
}


// ANeBu/ANeBu
void MainFrame::OnActivate(const UINT nState, const BOOL /* bMinimized */, HWND /* hWndPrevious */)
{
	m_bActive = (nState != WA_INACTIVE);

	// Ct[̃vpeB擾
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// ^Cgo[XV
	UpdateFrameTitle();

	// XV`FbN
	if(m_bActive && prFrame.stFile.flags.elements.bCheckTimeStampOnActive)
	{
		if(IsUpdated())
		{
			if(MessageBox_AskToReload() == IDYES)
			{
				// ēǂݍ
				OpenDocumentFile(NULL, m_uViewPropertyType, m_pEditDoc->IsReadOnly(), m_uCodePage);
			}
		}
	}
}

// tH[JX
void MainFrame::OnSetFocus(HWND /* hWndLoseFocus */)
{
	// ANeBuȃr[ɃtH[JXݒ
	m_pEditDoc->SetFocusTo();
}


// j[
void MainFrame::OnInitMenu(HMENU hMenu)
{
	UpdateCommand(command_interface_menu(hMenu));
}

// j[̍ڂ̑I
void MainFrame::OnMenuSelect(const UINT nItemID, const UINT nFlags, HMENU /* hSysMenu */)
{
	// Xe[^Xo[Ƀj[R}h\
	SetStatusMessageCommand(nItemID, nFlags);
}

// j[[v̊Jn
void MainFrame::OnEnterMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	// Xe[^Xo[Vv[hɂ
	m_cStatusBar.SetSimple();
}

// j[[v̏I
void MainFrame::OnExitMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	// Xe[^Xo[ɖ߂
	m_cStatusBar.SetSimple(FALSE);

	// Xe[^Xo[ɃAChbZ[W\
	SetStatusMessageIdle();
}


// t@C̃hbv
void MainFrame::OnDropFiles(HDROP hDrop)
{
	// hbvꂽt@C擾
	const UINT uFileCount = ::DragQueryFile(hDrop, static_cast<UINT>(-1), NULL, 0);
	for(UINT i = 0; i < uFileCount; i++)
	{
		// hbvꂽt@C擾
		const UINT uNameLength = ::DragQueryFile(hDrop, i, NULL, 0);

		sgc::array<TCHAR> name_buffer(uNameLength + 1);
		::DragQueryFile(
			hDrop,
			i,
			name_buffer, static_cast<UINT>(name_buffer.size()));

		Open(name_buffer);
	}

	::DragFinish(hDrop);
}


// ʒmbZ[W
BOOL MainFrame::OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader)
{
	// c[`bv
	if(lpNmHeader->code == TTN_NEEDTEXT)
	{
		SetToolTip(nIdCtrl, reinterpret_cast<LPTOOLTIPTEXT>(lpNmHeader));
		return TRUE;
	}

	BOOL bResult = TRUE;
	switch(nIdCtrl)
	{
	case 0:                                 // GfBbgR|[lg
		if(HandleNotifyMessage_Edit(lpNmHeader))
		{
			return TRUE;
		}
		break;

	case IDW_STD_TOOLBAR:                   // c[o[̒ʒmbZ[W
		if(m_cToolBar.HandleNotifyMessage(lpNmHeader, bResult))
		{
			return bResult;
		}
		break;

	case IDW_STD_STATUSBAR:                 // Xe[^Xo[̒ʒmbZ[W
		if(HandleNotifyMessage_StatusBar(lpNmHeader))
		{
			return TRUE;
		}
		break;
	}

	return Window::OnNotify(nIdCtrl, lpNmHeader);
}

// R}h
BOOL MainFrame::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	// R}hbZ[W
	switch(wID)
	{
	// t@C
	case IDM_FILE_NEW:           OnCommandFileNew         (); return FALSE;
	case IDM_FILE_OPEN:          OnCommandFileOpen        (); return FALSE;
	case IDM_FILE_SAVE:          OnCommandFileSave        (); return FALSE;
	case IDM_FILE_SAVE_AS:       OnCommandFileSaveAs      (); return FALSE;
	case IDM_FILE_SAVE_ALL:      OnCommandFileSaveAll     (); return FALSE;
	case IDM_FILE_CLOSE:         OnCommandFileClose       (); return FALSE;
	case IDM_FILE_CLOSE_ALL:     OnCommandFileCloseAll    (); return FALSE;
	case IDM_FILE_PRINT:         OnCommandFilePrint       (); return FALSE;
	case IDM_FILE_PRINT_PREVIEW: OnCommandFilePrintPreview(); return FALSE;


	// ҏW
	case IDM_EDIT_UNDO: OnCommandEditUndo(); return FALSE;
	case IDM_EDIT_REDO: OnCommandEditRedo(); return FALSE;

	case IDM_EDIT_CUT:              OnCommandEditCut           (); return FALSE;
	case IDM_EDIT_COPY:             OnCommandEditCopy          (); return FALSE;
	case IDM_EDIT_COPY_WITH_QUOTE:  OnCommandEditCopyWithQuote (); return FALSE;
	case IDM_EDIT_DELETE:           OnCommandEditDelete        (); return FALSE;
	case IDM_EDIT_PASTE:            OnCommandEditPaste         (); return FALSE;
	case IDM_EDIT_PASTE_WITH_QUOTE: OnCommandEditPasteWithQuote(); return FALSE;

	case IDM_EDIT_SELECT_ALL:    OnCommandEditSelectAll   (); return FALSE;
	case IDM_EDIT_SELECT_CANCEL: OnCommandEditSelectCancel(); return FALSE;

	case IDM_EDIT_RECONVERT: OnCommandEditReconvert(); return FALSE;

	case IDM_EDIT_JUMP: OnCommandEditJump(); return FALSE;

	case IDM_EDIT_READONLY: OnCommandEditReadonly(); return FALSE;

	// \
	case IDM_VIEW_BAR_TOOLBAR:   OnCommandViewBarToolbar  (); return FALSE;
	case IDM_VIEW_BAR_STATUSBAR: OnCommandViewBarStatusbar(); return FALSE;

	case IDM_VIEW_TOPMOST: OnCommandViewTopmost(); return FALSE;


	// ݒ
	case IDM_SETTING_CHANGE_CREATE: OnCommandSettingChangeCreate(); return FALSE;
	case IDM_SETTING_PROPERTY:      OnCommandSettingProperty();  return FALSE;
	case IDM_SETTING_CUSTOMIZE:     OnCommandSettingCustomize(); return FALSE;


	// wv
	case IDM_HELP_INDEX:   OnCommandHelpIndex  (); return FALSE;
	case IDM_HELP_KEYWORD: OnCommandHelpKeyword(); return FALSE;
	case IDM_HELP_FINDER:  OnCommandHelpFinder (); return FALSE;
	case IDM_HELP_WEBPAGE: OnCommandHelpWebpage(); return FALSE;
	case IDM_HELP_ABOUT:   OnCommandHelpAbout  (); return FALSE;

	default:
		// ͈͎w肳ꂽR}h
		if(IDM_FILE_OPENWITHCP_AUTODETECT <= wID && wID < IDM_FILE_OPENWITHCP_AUTODETECT + MAX_CODEPAGE_COUNT)
		{
			OnCommandFileOpenWithCPRange(wID);
			return FALSE;
		}
		if(IDM_FILE_SAVEWITHCP_FIRST <= wID && wID < IDM_FILE_SAVEWITHCP_FIRST + MAX_CODEPAGE_COUNT)
		{
			OnCommandFileSaveWithCPRange(wID);
			return FALSE;
		}
		if(IDM_SETTING_CHANGE_NONE <= wID && wID < IDM_SETTING_CHANGE_NONE + MAX_SETTING_COUNT)
		{
			OnCommandSettingChange(wID);
			return FALSE;
		}
	}

	return Window::OnCommand(wNotifyCode, wID, hWndCtrl);
}

void MainFrame::OnSysColorChange(void)
{
	ReloadSetting();
}


////////////////////////////////////////////////////////////
// ƎbZ[W

// LփCt[
void MainFrame::OnMaxyGetPathName(LPTSTR lpszPathName, const SIZE_T cchPathName) const
{
	const wgc::tstring_t strPathName = GetPathName();
	::lstrcpyn(
		lpszPathName,
		strPathName.c_str(),
		static_cast<int>(cchPathName));
}

void MainFrame::OnMaxyRefrectFrame(void)
{
	UpdateFrameTitle();
}

void MainFrame::OnMaxyRefrectView(const UINT_PTR uIndex)
{
	if(uIndex == m_uViewPropertyType)
	{
		ReloadSetting();
	}
}

void MainFrame::OnMaxyBackupUnsavedFile(void)
{
	BackupUnsavedFile();
}


////////////////////////////////////////////////////////////
// R}hnh

// [t@C]
// VK쐬
void MainFrame::OnCommandFileNew(void)
{
	Station::CreateFrameThread();
}

// J
void MainFrame::OnCommandFileOpen(void)
{
	Open();
}

// ۑ
void MainFrame::OnCommandFileSave(void)
{
	// t@CɓǂݎpĂ疼Otĕۑ
	const wgc::tstring_t strPathName = GetPathName();
	Save(wgc::File::IsReadOnly(strPathName.c_str()));
}

// Otĕۑ
void MainFrame::OnCommandFileSaveAs(void)
{
	Save(TRUE);
}

// ׂĕۑ
void MainFrame::OnCommandFileSaveAll(void)
{
	// [㏑ۑ]R}hSEChEɑ
	BroadcastMessage(TRUE, WM_COMMAND, MAKEWPARAM(IDM_FILE_SAVE, 0));
}

// 
void MainFrame::OnCommandFileClose(void)
{
	PostMessage(WM_CLOSE);
}

// ׂĕ
void MainFrame::OnCommandFileCloseAll(void)
{
	m_bCloseAll = TRUE;
	PostMessage(WM_CLOSE);
}

// 
void MainFrame::OnCommandFilePrint(void)
{
	AppMessageBox(m_hWnd, IDS_MSGBOX_NOT_IMPLEMENTED, MB_OK);
}

// vr[
void MainFrame::OnCommandFilePrintPreview(void)
{
	AppMessageBox(m_hWnd, IDS_MSGBOX_NOT_IMPLEMENTED, MB_OK);
}

void MainFrame::OnCommandFileOpenWithCPRange(const int nID)
{
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		return;
	}

	const UINT uiPos = nID - IDM_FILE_OPENWITHCP_AUTODETECT;
	if(uiPos >= MAX_CODEPAGE_COUNT)
	{
		return;
	}

	// obt@̓eύXĂmFbZ[W\
	if(m_pEditDoc->IsModified())
	{
		const UINT uResult = AppMessageBoxFormat(
			m_hWnd,
			IDS_MSGBOX_ASKTOSAVE,
			MB_YESNOCANCEL | MB_ICONEXCLAMATION,
			m_strFileName.c_str());
		switch(uResult)
		{
		case IDYES:
			// ۑ
			if(!Save()) { return; }
			break;

		case IDNO:
			// ۑɍēǂݍ
			break;

		case IDCANCEL:
			// ēǂݍ݂𒆎~
			return;
		}
	}
	UINT uiCodePage = static_cast<UINT>(-1);
	if(uiPos > 0)
	{
		uiCodePage = m_cp_import[uiPos - 1].uiCodePage;
	}
	OpenDocumentFile(NULL, m_uViewPropertyType, m_pEditDoc->IsReadOnly(), uiCodePage);
}

void MainFrame::OnCommandFileSaveWithCPRange(const int nID)
{
	const UINT uiPos = nID - IDM_FILE_SAVEWITHCP_FIRST;
	if(uiPos >= MAX_CODEPAGE_COUNT)
	{
		return;
	}

	UINT uiCodePage = static_cast<UINT>(-1);
	if(uiPos > 0)
	{
		uiCodePage = m_cp_export[uiPos].uiCodePage;
	}
	SetCodePage(uiCodePage);
	Save();
}

void MainFrame::OnUpdateFileOpenWithCPRange(const command_interface &ci) const
{
	// WI{^ݒ
	ci.radio(
		IDM_FILE_OPENWITHCP_AUTODETECT,
		IDM_FILE_OPENWITHCP_AUTODETECT + MAX_CODEPAGE_COUNT,
		IDM_FILE_OPENWITHCP_AUTODETECT + m_uCodePageIndex + 1);

	// {block}
	// L/ݒ
	{
		const BOOL bEnabled = IsEnabledFileOpenWithCPRange();
		const UINT uSize    = static_cast<UINT>(m_cp_import.size());
		for(UINT i = 0; i <= uSize; i++)
		{
			ci.enable(IDM_FILE_OPENWITHCP_AUTODETECT + i, bEnabled);
		}
	}
}

void MainFrame::OnUpdateFileSave(const command_interface &ci) const
{
	ci.enable(IDM_FILE_SAVE, m_pEditDoc->IsModified());
}

BOOL MainFrame::IsEnabledFileOpenWithCPRange(void) const
{
	return (m_pMultiLanguage2 != NULL) && !m_strFileName.empty();
}


// [ҏW]
// AhD
void MainFrame::OnCommandEditUndo(void)
{
	m_pEditDoc->Undo();
}

// hD
void MainFrame::OnCommandEditRedo(void)
{
	m_pEditDoc->Redo();
}

// Jbgi؂j
void MainFrame::OnCommandEditCut(void)
{
	m_pEditDoc->Cut();
}

// Rs[
void MainFrame::OnCommandEditCopy(void)
{
	m_pEditDoc->Copy();
}

// ptRs[
void MainFrame::OnCommandEditCopyWithQuote(void)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	m_pEditDoc->Copy(prView.cQuoteMark);
}

// 폜
void MainFrame::OnCommandEditDelete(void)
{
	m_pEditDoc->Delete();
}

// \t
void MainFrame::OnCommandEditPaste(void)
{
	m_pEditDoc->Paste();
}

// pt\t
void MainFrame::OnCommandEditPasteWithQuote(void)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	m_pEditDoc->Paste(prView.cQuoteMark);
}

// ׂđI
void MainFrame::OnCommandEditSelectAll(void)
{
	m_pEditDoc->SelectAll();
}

// I
void MainFrame::OnCommandEditSelectCancel(void)
{
	m_pEditDoc->ClearSelection(sgc::edit_manager::SC_NOMOVE);
}

// ĕϊ
void MainFrame::OnCommandEditReconvert(void)
{
	m_pEditDoc->Reconvert();
}

// Wv
void MainFrame::OnCommandEditJump(void)
{
	DIALOGPROPERTY_JUMP property = { m_pEditDoc->GetNowLine() };

	DialogJump dlg(property, m_hWnd);
	if(dlg.DoModal() == IDOK)
	{
		// wsփWv
		m_pEditDoc->JumpToLine(property.nLineNumber);
	}
}

// ֎~
void MainFrame::OnCommandEditReadonly(void)
{
	if(IsEnabledEditReadonly())
	{
		m_pEditDoc->ToggleReadOnly();
	}
}


void MainFrame::OnUpdateEditUndo(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_UNDO, m_pEditDoc->CanUndo());
}

void MainFrame::OnUpdateEditRedo(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_REDO, m_pEditDoc->CanRedo());
}

void MainFrame::OnUpdateEditPaste(const command_interface &ci) const
{
	const BOOL bCanPaste = m_pEditDoc->CanPaste();
	ci.enable(IDM_EDIT_PASTE           , bCanPaste);
	ci.enable(IDM_EDIT_PASTE_WITH_QUOTE, bCanPaste);
}

void MainFrame::OnUpdateEditSelectCancel(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_SELECT_CANCEL, m_pEditDoc->IsSelected());
}

void MainFrame::OnUpdateEditReconvert(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_RECONVERT, m_pEditDoc->IsSelected());
}

void MainFrame::OnUpdateEditReadonly(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_READONLY, IsEnabledEditReadonly());
	ci.check (IDM_EDIT_READONLY, m_pEditDoc->IsReadOnly());
}

BOOL MainFrame::IsEnabledEditReadonly(void) const
{
	// JĂt@CAobt@ύXĂȂΕύX
	return !m_strFileName.empty() && !m_pEditDoc->IsModified();
}


// [\]
// c[o[
void MainFrame::OnCommandViewBarToolbar(void)
{
	const DWORD dwStyle = m_cToolBar.GetStyle();
	m_cToolBar.SetStyle(dwStyle ^ WS_VISIBLE);

	RecalcEditLayout();
}

// Xe[^Xo[
void MainFrame::OnCommandViewBarStatusbar(void)
{
	const DWORD dwStyle = m_cStatusBar.GetStyle();
	m_cStatusBar.SetStyle(dwStyle ^ WS_VISIBLE);

	RecalcEditLayout();
}

// ɎOɕ\
void MainFrame::OnCommandViewTopmost(void)
{
	SetTopmost(!IsTopmost());
}

void MainFrame::OnUpdateViewBar(const command_interface &ci) const
{
	ci.check(IDM_VIEW_BAR_TOOLBAR  , m_cToolBar.GetStyle  () & WS_VISIBLE);
	ci.check(IDM_VIEW_BAR_STATUSBAR, m_cStatusBar.GetStyle() & WS_VISIBLE);
}

void MainFrame::OnUpdateViewTopmost(const command_interface &ci) const
{
	ci.check(IDM_VIEW_TOPMOST, IsTopmost());
}


// [ݒ]

// ݒ̕ύX
void MainFrame::OnCommandSettingChange(const int nID)
{
	m_uViewPropertyType = nID - IDM_SETTING_CHANGE_NONE;

	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	m_pEditDoc->SetViewProperty(prView, prKeyword);
}

// Vݒ̍쐬
void MainFrame::OnCommandSettingChangeCreate(void)
{
	AppMessageBox(m_hWnd, IDS_MSGBOX_NOT_IMPLEMENTED, MB_OK);
}

// vpeB
void MainFrame::OnCommandSettingProperty(void)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	DIALOGPROPERTY_PROPERTY property =
	{
		// {
		{
			prView.infoText.flags.elements.bOpenIME,
		},

		// \
		{
			prView.flags.elements.bDisplayRuler,
			prView.flags.elements.bDisplayLineNumber,
			prView.flags.elements.bDisplayUnderline,
		},
	};

	DialogProperty dlg(property, m_hWnd);
	if(dlg.DoModal() == IDOK)
	{
		// {
		prView.infoText.flags.elements.bOpenIME = property.basic.bOpenIME;

		// \
		prView.flags.elements.bDisplayRuler      = property.display.bDisplayRuler;
		prView.flags.elements.bDisplayLineNumber = property.display.bDisplayLineNumber;
		prView.flags.elements.bDisplayUnderline  = property.display.bDisplayUnderline;

		SetEditViewProperty(prView, prKeyword, m_uViewPropertyType);
		RefrectSetting_View();
	}
}

// JX^}CY
void MainFrame::OnCommandSettingCustomize(void)
{
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	DialogCustomize dlg(prFrame, m_hWnd);
	const INT_PTR result = dlg.DoModal();
	if(result > 0)
	{
		// OKꍇ̏
		// hLgɂ́uLZ̏ꍇ0ԂvƖLĂȂ̂
		// {̓vpeBy[WɑʒmbZ[W PSN_APPLY 
		// ȂႢȂ񂾂낤ǁB
		SetMainFrameProperty(prFrame);
		RefrectSetting_Frame();
	}
}

void MainFrame::OnUpdateSettingChange(const command_interface &ci) const
{
	ci.radio(
		IDM_SETTING_CHANGE_NONE,
		IDM_SETTING_CHANGE_NONE + static_cast<UINT>(GetEditViewPropertySize()),
		IDM_SETTING_CHANGE_NONE + static_cast<UINT>(m_uViewPropertyType));
}

void MainFrame::OnUpdateSettingProperty(const command_interface &ci) const
{
	const BOOL bEnable = (m_uViewPropertyType != 0);
	ci.enable(IDM_SETTING_PROPERTY, bEnable);
}


// [wv]
// ڎ
void MainFrame::OnCommandHelpIndex(void)
{
	SendHelpMessage(HH_DISPLAY_TOC);
}

// L[[h
void MainFrame::OnCommandHelpKeyword(void)
{
	SendHelpMessage(HH_DISPLAY_INDEX);
}

// 
void MainFrame::OnCommandHelpFinder(void)
{
	SendHelpMessage(HH_DISPLAY_SEARCH);
}

// ҂̃z[y[W\
void MainFrame::OnCommandHelpWebpage(void)
{
	::ShellExecute(NULL, NULL, STR_URL, NULL, NULL, SW_SHOWNORMAL);
}

// Maxyɂ
void MainFrame::OnCommandHelpAbout()
{
	DialogAbout dlg(m_hWnd);
	dlg.DoModal();
}


// ʒmbZ[W

// GfBbgR|[lg̏֎~̐ݒ/
void MainFrame::OnNotifyXENReadonlyChanged(void)
{
	SetStatusMessageReadonly();
}

// GfBbgR|[lg̏㏑̐ݒ/
void MainFrame::OnNotifyXENOverwriteChanged(void)
{
	SetStatusMessageOverwrite();
}

// GfBbgR|[lg̃_[eBtO̕ύX
void MainFrame::OnNotifyXENModifyChanged(void)
{
	UpdateFrameTitle();
}


BOOL MainFrame::HandleNotifyMessage_Edit(LPNMHDR lpNmHeader)
{
	switch(lpNmHeader->code)
	{
	case XEN_READONLYCHANGED:               // ֎~ύXꂽ
		OnNotifyXENReadonlyChanged();
		return TRUE;

	case XEN_OVERWRITECHANGED:              // ㏑ύXꂽ
		OnNotifyXENOverwriteChanged();
		return TRUE;

	case XEN_MODIFYCHANGED:                 // _[eBtOύXꂽ
		OnNotifyXENModifyChanged();
		return TRUE;
	}
	return FALSE;
}

BOOL MainFrame::HandleNotifyMessage_StatusBar(LPNMHDR lpNmHeader)
{
	// ANVu_uNbNvłȂΏI
	if(lpNmHeader->code != NM_DBLCLK)
	{
		return FALSE;
	}

	POINT pt;
	::GetCursorPos(&pt);
	switch(m_cStatusBar.HitTest(pt))
	{
	case STATUS_PANE_READONLY:
		PostMessage(WM_COMMAND, IDM_EDIT_READONLY);
		return TRUE;

	case STATUS_PANE_OVERWRITE:
		m_pEditDoc->ToggleOverwrite();
		return TRUE;

	case STATUS_PANE_CODEPAGE:
		if(IsEnabledFileOpenWithCPRange())
		{
			HMENU hMenu = wgc::wgfFindMenu(GetMenu(), IDM_FILE_OPENWITHCP_AUTODETECT);
			TrackPopupMenu(hMenu, pt);
			return TRUE;
		}
		break;
	}
	return FALSE;
}


////////////////////////////////////////////////////////////
// private o֐

// r[IDvZ
UINT MainFrame::GetNewViewID(void) const
{
	for(UINT uID = IDW_EDIT_VIEW; ; uID++)
	{
		if(GetDlgItem(uID) == NULL)
		{
			return uID;
		}
	}
}


// Rg[o[̍쐬
BOOL MainFrame::CreateControlBar(void)
{
	if(!CreateToolBarStandard()) { return FALSE; }
	if(!CreateStatusBar      ()) { return FALSE; }

	return TRUE;
}

// Wc[o[쐬
BOOL MainFrame::CreateToolBarStandard(void)
{
	// R}hIDꗗ
	const int arCommand[] =
	{
		IDM_FILE_NEW    , IDM_FILE_OPEN         , IDM_FILE_SAVE  , IDM_FILE_SAVE_ALL, IDM_FILE_CLOSE, IDM_FILE_CLOSE_ALL, 0,
		IDM_FILE_PRINT  , IDM_FILE_PRINT_PREVIEW, 0,
		IDM_EDIT_UNDO   , IDM_EDIT_REDO         , 0,
		IDM_EDIT_CUT    , IDM_EDIT_COPY         , IDM_EDIT_PASTE , IDM_EDIT_DELETE  , 0,
		IDM_VIEW_TOPMOST, 0,
		IDM_HELP_INDEX  , IDM_HELP_WEBPAGE      , IDM_HELP_ABOUT,
	};

	m_cToolBar.Create(
		this,
		GetImageList_ToolBarXP(), GetImageList_ToolBarXP_Hot(), GetImageList_ToolBarXP_Disabled(),
		GetResourceHandle(),
		arCommand, countof(arCommand));

	// c[o[𕜌
	ToolSaveRestore(FALSE);

	return TRUE;
}

// Xe[^Xo[쐬
BOOL MainFrame::CreateStatusBar(void)
{
	// Xe[^Xo[쐬
	if(!m_cStatusBar.Create(this, _T("")))
	{
		return FALSE;
	}

	// CWP[^쐬
	SetStatusIndicator();

	// ACh\
	SetStatusMessageIdle();

	return TRUE;
}

// GfBbgR|[lg쐬
BOOL MainFrame::CreateEditComponent(void)
{
	// 쐬
	const BOOL bResult = m_pEditDoc->CreateView(
		FALSE,
		WS_CHILD | WS_VISIBLE | WS_OVERLAPPED | WS_HSCROLL | WS_VSCROLL,
		WS_EX_CLIENTEDGE,
		IDW_EDIT_VIEW);
	if(!bResult)
	{
		return FALSE;
	}

	// TCY
	RecalcEditLayout();

	return TRUE;
}

// R[hy[Wj[ɒǉ
BOOL MainFrame::AppendCodePageMenu(const wxc::COM_XMultiLanguage2::MIMECPINFO_vector_t &v_mcpi, const UINT uiCommandFirst)
{
	HMENU hMenu = wgc::wgfFindMenu(GetMenu(), uiCommandFirst);
	if(hMenu == NULL)
	{
		return FALSE;
	}

	::DeleteMenu(hMenu, uiCommandFirst, MF_BYCOMMAND);

	const UINT_PTR nCodePageCount = v_mcpi.size();
	for(UINT_PTR i = 0; i < nCodePageCount; i++)
	{
		wgc::tstring_t tstr;
#ifdef UNICODE
		tstr = v_mcpi[i].wszDescription;
#else
		wgc::wgfWideCharToMultiByte(v_mcpi[i].wszDescription, tstr);
#endif
		::InsertMenu(
			hMenu,
			static_cast<UINT>(-1),
			MF_BYPOSITION | MF_STRING,
			uiCommandFirst + i,
			tstr.c_str());
	}

	DrawMenuBar();
	return TRUE;
}

// ݒ薼j[ɒǉ
BOOL MainFrame::AppendSettingMenu(void)
{
	HMENU hMenu = wgc::wgfFindMenu(GetMenu(), IDM_SETTING_CHANGE_NONE);
	if(hMenu == NULL)
	{
		return FALSE;
	}

	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();
	for(size_t i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		::InsertMenu(
			hMenu,
			static_cast<UINT>(i),
			MF_BYPOSITION | MF_STRING,
			IDM_SETTING_CHANGE_NONE + i,
			prView.szSettingName);
	}

	DrawMenuBar();
	return TRUE;
}

BOOL MainFrame::DeleteSettingMenu(void)
{
	HMENU hMenu = GetMenu();
	if(hMenu == NULL)
	{
		return FALSE;
	}

	for(int i = IDM_SETTING_CHANGE_NONE + 1; i < IDM_SETTING_CHANGE_CREATE; i++)
	{
		::DeleteMenu(hMenu, i, MF_BYCOMMAND);
	}

	DrawMenuBar();
	return TRUE;
}


// c[`bvݒ
void MainFrame::SetToolTip(const int nIdCtrl, LPTOOLTIPTEXT lpToolTipText)
{
	// XgO\[X當擾
	wgc::tstring_t tstr;
	AppLoadString(nIdCtrl, tstr);

	// '\n'ȍ~̕擾
	wgc::tstring_t text;
	wgc::wgfExtractSubString(text, tstr, 1, wgc::tLF);

	// 擾ݒ
	const size_t size = countof(lpToolTipText->szText);
	::lstrcpyn(lpToolTipText->szText, text.c_str(), size);
}

// c[o[̑
void MainFrame::ToolSaveRestore(const BOOL bSave /* = TRUE */)
{
	TBSAVEPARAMS tbs;
	tbs.hkr          = HKEY_CURRENT_USER;
	tbs.pszSubKey    = REGKEY_SECTION_CUSTOMIZE;
	tbs.pszValueName = REGKEY_ENTRY_CUSTOMIZE_TOOLBAR;
	m_cToolBar.SaveRestore(bSave, tbs);
}

// Xe[^Xo[̑
void MainFrame::SetStatusIndicator(void)
{
	// CWP[^
	const UINT nIndicators[] =
	{
		IDS_STATUS_INDICATOR_READONLY,      // 
		IDS_STATUS_INDICATOR_OVERWRITE,     // ㏑
		IDS_STATUS_INDICATOR_CODEPAGE,      // R[hy[W
	};

	m_cStatusBar.SetIndicators(
		GetResourceHandle(),
		nIndicators,
		countof(nIndicators));
}

// Xe[^Xo[ɃACh\
void MainFrame::SetStatusMessageIdle(void)
{
	wgc::tstring_t text;
	AppLoadString(IDS_STATUS_IDLE, text);

	m_cStatusBar.SetText(STATUS_PANE_IDLE, SBT_NOBORDERS, text);
}

// Xe[^Xo[Ƀj[R}h̕\
void MainFrame::SetStatusMessageCommand(const UINT nID, const UINT nFlags)
{
	wgc::tstring_t status;
	if(!(nFlags & MF_POPUP))
	{
		wgc::tstring_t text;
		AppLoadString(nID, text);

		// '\n'O̕擾
		wgc::wgfExtractSubString(status, text, 0, wgc::tLF);
	}

	m_cStatusBar.SetText(STATUS_PANE_SIMPLE, SBT_NOBORDERS, status);
}

// Xe[^Xo[Ɂuցv\
void MainFrame::SetStatusMessageReadonly(void)
{
	wgc::tstring_t text;
	if(m_pEditDoc->IsReadOnly())
	{
		// ǂݍݐpȂXe[^Xo[ɕ\镶擾
		AppLoadString(IDS_STATUS_INDICATOR_READONLY, text);
	}
	// Xe[^Xo[XV
	m_cStatusBar.SetText(STATUS_PANE_READONLY, 0, text);
}

// Xe[^Xo[Ɂu㏑v\
void MainFrame::SetStatusMessageOverwrite(void)
{
	wgc::tstring_t text;
	if(m_pEditDoc->IsOverwrite())
	{
		// ㏑[hȂXe[^Xo[ɕ\镶擾
		AppLoadString(IDS_STATUS_INDICATOR_OVERWRITE, text);
	}
	// Xe[^Xo[XV
	m_cStatusBar.SetText(STATUS_PANE_OVERWRITE, 0, text);
}

// Xe[^Xo[ɃR[hy[W\
void MainFrame::SetStatusMessageCodePage(void)
{
	wgc::tstring_t text;
#ifdef UNICODE
	text = m_cp_import[m_uCodePageIndex].wszDescription;
#else
	wgc::wgfWideCharToMultiByte(m_cp_import[m_uCodePageIndex].wszDescription, text);
#endif
	m_cStatusBar.SetText(STATUS_PANE_CODEPAGE, 0, text, TRUE);
}



////////////////////////////////////////////////////////////
// t@C

// t@CAΉtB^̃CfbNXԂ
// ΉtB^Ȃ0Ԃ
UINT_PTR MainFrame::FindFilterIndex(LPCTSTR lpszFileName)
{
	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();

	// ݒ̐JԂi0Ԗڂ̓ftHgݒȂ̂Ŕ΂j
	for(UINT_PTR i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		// t@Cƃ}b`炱̐ݒ̃CfbNXԂ
		if(::PathMatchSpec(lpszFileName, prView.szFilter))
		{
			return i;
		}
	}

	// Ȃ0Ԃ
	return 0;
}

// r[hw肵ăt@CJ
HANDLE MainFrame::OpenForExclusion(LPCTSTR lpszPathName, const DWORD dwExclusion)
{
	// L[hw
	DWORD dwShareMode = FILE_SHARE_READ;
	switch(dwExclusion)
	{
	case EXCLUSION_NONE:             dwShareMode = FILE_SHARE_READ | FILE_SHARE_WRITE; break;
	case EXCLUSION_DISABLEWRITE:     dwShareMode = FILE_SHARE_READ; break;
	case EXCLUSION_DISABLEREADWRITE: dwShareMode = 0; break;
	}

	HANDLE hFile = ::CreateFile(
		lpszPathName,
		GENERIC_READ,
		dwShareMode,
		NULL,
		OPEN_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,
		NULL);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		wgc::wgfThrowLastError();
	}
	return hFile;
}


// R[hy[Wݒ
void MainFrame::SetCodePage(const UINT uCodePage /* = 0 */)
{
	if(uCodePage == 0)
	{
		m_uCodePage = ::GetACP();
	}
	else
	{
		m_uCodePage = uCodePage;
	}

	// {block}
	// j[ID
	{
		m_uCodePageIndex = static_cast<UINT>(-1);
		for(UINT i = 0; i < m_cp_import.size(); i++)
		{
			if(m_uCodePage == m_cp_import[i].uiCodePage)
			{
				m_uCodePageIndex = i;
				break;
			}
		}
	}

	// Xe[^Xo[XV
	SetStatusMessageCodePage();
}


// t@CJ
// 󋵂ɉāuJv_CAOoÃt[ANeBuɂ肷
BOOL MainFrame::Open(LPCTSTR lpszPathName /* = NULL */, const int nCodePage /* = CODEPAGE_SPECIFY */, const BOOL bReadOnly /* = FALSE */, const INT_PTR nFilterIndex /* = -1 */)
{
	// vpeB擾
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// ũt[ŊJvobt@ύXĂۑ邩q˂
	if(prFrame.stFile.flags.elements.bOpenByThisFrame && m_pEditDoc->IsModified())
	{
		switch(MessageBox_AskToSave())
		{
		case IDYES:    if(!Save()) { return FALSE; }    // no break
		case IDNO:     break;
		case IDCANCEL: return FALSE;
		}
	}

	// Jt@Cw肳ĂȂ΁A_CAOoĖ₢킹
	if(lpszPathName == NULL)
	{
		MAINFRAME_PROPERTY property;
		GetMainFrameProperty(property);

		DialogOpen dlg(m_hWnd, !property.stFile.flags.elements.bOpenByThisFrame);
		if(dlg.DoModal())
		{
			const BOOL    bReadOnly    = dlg.IsReadOnly();
			const INT_PTR nFilterIndex = dlg.GetFilterIndex();
			TCHAR buffer[1024] = {wgc::tNUL};

			// Iꂽt@CSĊJiċAĂяoj
			while(dlg.GetNextPathName(buffer, countof(buffer)))
			{
				Open(buffer, nCodePage, bReadOnly, nFilterIndex);
			}
			return TRUE;
		}
		return FALSE;
	}

	// {block}
	// łɂ̃t@CJĂt[΁AANeBuɂ
	{
		HWND hWnd = GetEditingFrame(lpszPathName);
		if(hWnd != NULL)
		{
			::SetForegroundWindow(hWnd);
			return TRUE;
		}
	}

	// ũt[ŊJv܂́u肩ύXvȂ炱̃t[ŊJ
	if(prFrame.stFile.flags.elements.bOpenByThisFrame || (m_strFileName.empty() && !m_pEditDoc->IsModified()))
	{
		OpenDocumentFile(lpszPathName, nFilterIndex, bReadOnly, nCodePage);
		return TRUE;
	}

	// {block}
	// ǂłȂΐVXbhŊJ
	{
		CREATEFRAME_PARAMETER *lpParameter = new CREATEFRAME_PARAMETER;
		::lstrcpyn(lpParameter->szPathName, lpszPathName, countof(lpParameter->szPathName));
		lpParameter->bReadOnly   = bReadOnly;
		lpParameter->nLineNumber = 0;
		lpParameter->nCmdShow    = SW_NORMAL;
		lpParameter->nCodePage   = nCodePage;

		Station::CreateFrameThread(lpParameter);
	}

	return TRUE;
}

// w肳ꂽpX̃t@C݂̃t[ŊJ
void MainFrame::OpenDocumentFile(LPCTSTR lpszPathName, const INT_PTR nIndex /* = -1 */, const BOOL bReadOnly /* = TRUE */, const UINT uCodePage /* = CODEPAGE_ERROR */)
{
	// {block}
	// gq̐ݒKp
	{
		const UINT_PTR uIndex = nIndex;
		if(uIndex < GetEditViewPropertySize())
		{
			m_uViewPropertyType = uIndex;
		}
		else if(lpszPathName != NULL)
		{
			m_uViewPropertyType = FindFilterIndex(lpszPathName);
		}
	}

	// {block}
	// hLg
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);
		m_pEditDoc->SetViewProperty(prView, prKeyword);
	}

	// {block}
	// t@Cǂݍ
	{
		wgc::tstring_t strPathName = (lpszPathName != NULL) ? lpszPathName : GetPathName();

		MAINFRAME_PROPERTY prFrame;
		GetMainFrameProperty(prFrame);

		HANDLE hFile = INVALID_HANDLE_VALUE;
		try
		{
			if(lpszPathName == NULL && m_hFile != INVALID_HANDLE_VALUE)
			{
				// t@CNULLȂ玩gJȂ
				hFile = m_hFile;
			}
			else
			{
				hFile = OpenForExclusion(strPathName.c_str(), prFrame.stFile.dwExclusionMode);
			}
			const BOOL bReload = (lpszPathName == NULL);
			wgc::File File(hFile);
			ReadTextData(File, uCodePage, bReload);
		}
		catch(...)
		{
			// JĂt@C
			if(hFile != m_hFile) { ::CloseHandle(hFile); }
			throw;
		}

		// nhu
		if(m_hFile != hFile)
		{
			::CloseHandle(m_hFile);
			m_hFile = hFile;
		}

		// ǂݎpw肪邩At@Cǂݎp瑮ݒ
		m_pEditDoc->SetReadOnly(bReadOnly || wgc::File::IsReadOnly(strPathName.c_str()));
	}

	// t@Cƃ^CX^vݒ
	if(lpszPathName != NULL)
	{
		SetPathName(lpszPathName);
	}
	GetTimeStamp(m_ftUpdate);
}

// w肳ꂽpX̃t@C݂̃t[ŊJ
void MainFrame::ReadTextData(wgc::File &rFile, const UINT uCodePage, const BOOL bReload /* = FALSE */)
{
	// IuWFNgj̏𖾊mɂ邽߂ɃlXg
	rFile.SeekToBegin();
	{
		const DWORD dwFileSize = rFile.GetSize();
		if(dwFileSize == 0)
		{
			// t@CTCY0̏ꍇ
			m_pEditDoc->SetText(NULL, 0);
			SetCodePage();
			return;
		}

		// t@C}bsO
		wgc::mapping_object mapping_object(rFile);
		{
			// }bsOf[^̎擾
			wgc::mapping_object::mapping_data<char> mapping_data(mapping_object);
			{
				LPCSTR lpszData   = mapping_data.GetData();
				UINT   uCodePage2 = uCodePage;
				UINT   uOffset    = 0;

				if(m_pMultiLanguage2 != NULL)
				{
					if(!bReload || uCodePage == CODEPAGE_ERROR)
					{
						uCodePage2 = DetectCodePage(lpszData, dwFileSize, uCodePage, uOffset);
					}
				}
				else
				{
					if(MessageBox_NoInterface(TRUE) == IDOK)
					{
						return;
					}
					uCodePage2 = CODEPAGE_UTF16LE;
				}

				// obt@փZbg
				SetText(lpszData + uOffset, dwFileSize - uOffset, uCodePage2);
			}
		}
	}
}

void MainFrame::SetText(LPCSTR lpszData, const DWORD dwFileSize, const UINT uCodePage)
{
	if(m_pMultiLanguage2 != NULL)
	{
		// TCYvZ
		const DWORD dwSizeTotal = m_pMultiLanguage2->ConvertToUnicodeSize(lpszData, dwFileSize, uCodePage);
		if(dwSizeTotal == static_cast<DWORD>(-1))
		{
			throw HRESULT_FROM_WIN32(ERROR_NO_UNICODE_TRANSLATION);
		}

		// R[hϊ
		std::vector<WCHAR> buf(dwSizeTotal);
		m_pMultiLanguage2->ConvertToUnicode(
			lpszData, dwFileSize,
			&buf[0], dwSizeTotal,
			uCodePage);

		// obt@ɃZbg
		m_pEditDoc->SetText(&buf[0], buf.size());
	}
	else
	{
		m_pEditDoc->SetText(
			reinterpret_cast<LPCWSTR>(lpszData),
			dwFileSize / sizeof(WCHAR));
	}
	SetCodePage(uCodePage);
}

// R[hy[Wo
UINT MainFrame::DetectCodePage(LPCSTR lpszData, const DWORD dwFileSize, const UINT uCodePage, UINT &rOffset)
{
	// gq̐ݒ擾
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	rOffset = 0;

	// BOMo
	if(prView.flags.elements.bDetectBOM)
	{
		const UINT uCodePageArray[] =
		{
			CODEPAGE_UTF8,
			CODEPAGE_UTF16LE,
			CODEPAGE_UTF16BE,
		};
		for(size_t i = 0; i < countof(uCodePageArray); i++)
		{
			const UINT uCodePage = uCodePageArray[i];
			if(CodePage_ExistsBOM(lpszData, dwFileSize, rOffset, uCodePage))
			{
				m_bBom = TRUE;
				return uCodePage;
			}
		}
	}

	// UTF-8o
	if(prView.flags.elements.bDetectUTF8)
	{
		if(sgc::charcode::utf8::detect(lpszData, dwFileSize))
		{
			return CODEPAGE_UTF8;
		}
	}

	UINT uCodePage2 = uCodePage;

	// gqƂ̃GR[hw
	if(uCodePage == CODEPAGE_SPECIFY)
	{
		uCodePage2 = prView.csDefault;
	}

	// F
	if(uCodePage2 == CODEPAGE_ERROR)
	{
		MLDETECTCP nDetectFlag = MLDETECTCP_NONE;
		if(prView.flags.elements.bDetectAsHTML) { nDetectFlag = MLDETECTCP_HTML; }

		uCodePage2 = m_pMultiLanguage2->AutoDetect(lpszData, dwFileSize, nDetectFlag);
		if(uCodePage2 == CODEPAGE_ERROR)
		{
			return uCodePage2 = ::GetACP();
		}
	}
	return uCodePage2;
}


// t@CۑiKvɉă_CAO\j
BOOL MainFrame::Save(const BOOL bSaveAs /* = FALSE */)
{
	wgc::tstring_t strPathName = GetPathName();

	// uOtĕۑv́uvȂ΃t@C擾
	if(bSaveAs || strPathName.empty())
	{
		// t@Ci[obt@
		TCHAR buffer[1024];

		DialogSave dlg(m_hWnd);
		if(!dlg.DoModal() || !dlg.GetNextPathName(buffer, countof(buffer)))
		{
			// LZ
			return FALSE;
		}

		strPathName = buffer;
	}

	// ϊłȂUTF-16LEɂ邩q˂
	if(m_pMultiLanguage2 != NULL && !CanConvertCodePage())
	{
		const int nResult = AppMessageBox(m_hWnd, IDS_MSGBOX_ASKTOSAVEBYUNICODE, MB_OKCANCEL | MB_DEFBUTTON2);
		if(nResult != IDOK)
		{
			return FALSE;
		}
		SetCodePage(CODEPAGE_UTF16LE);
	}

	SaveDocumentFile(strPathName.c_str());
	return TRUE;
}

void MainFrame::SaveDocumentFile(LPCTSTR lpszPathName)
{
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// JĂt@CΕ
	if(m_hFile != INVALID_HANDLE_VALUE)
	{
		::CloseHandle(m_hFile);
		m_hFile = INVALID_HANDLE_VALUE;
	}

	// t@Cɏ
	try
	{
		wgc::File File(lpszPathName, GENERIC_WRITE);
		WriteTextData(File);
	}
	catch(...)
	{
		// ̃t@CJ
		const wgc::tstring_t strPathName = GetPathName();
		m_hFile = OpenForExclusion(strPathName.c_str(), prFrame.stFile.dwExclusionMode);
		throw;
	}

	// rpɃt@CJ
	m_hFile = OpenForExclusion(lpszPathName, prFrame.stFile.dwExclusionMode);

	m_pEditDoc->SetModify(FALSE);           // _[eB[tONA
	m_pEditDoc->SetReadOnly(FALSE);         // ǂݎpiۑɐ݂ɐǂݎpł͂Ȃj

	// ^CX^vXV
	GetTimeStamp(m_ftUpdate);
	SetPathName(lpszPathName);
}

// w肳ꂽnhɃt@Cۑ
void MainFrame::WriteTextData(wgc::File &rFile)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	const BOOL        bAlwaysUseDefaultLFCode = prView.flags.elements.bAlwaysUseDefaultLFCode;
	const sgc::charcode::linefeed_t lfDefault = prView.lfDefault;

	// IMultiLanguage2C^[tF[X݂Ȃ΋IUTF-16LEɂ
	if(m_pMultiLanguage2 == NULL)
	{
		SetCodePage(CODEPAGE_UTF16LE);
	}
	else
	{
		// BOM
		if(m_bBom)
		{
			BYTE bom[4];
			UINT bom_size;
			if(CodePage_GetBOM(m_uCodePage, bom, bom_size))
			{
				rFile.Write(bom, bom_size);
			}
		}
	}
	SetBuffer(rFile, bAlwaysUseDefaultLFCode, lfDefault);
}

void MainFrame::SetBuffer(wgc::File &rFile, const BOOL bAlwaysUseDefaultLFCode, const sgc::charcode::linefeed_t lfDefault) const
{
	EditDoc::const_iterator_t p = m_pEditDoc->GetIteratorBegin();

	if(m_pMultiLanguage2 != NULL)
	{
		wxc::COM_XMultiLanguage2 *pMultiLanguage2 = m_pMultiLanguage2;
		for(;;)
		{
			// {block}
			// f[^R[hy[Wϊď
			{
				wgc::string_t str;
				pMultiLanguage2->ConvertFromUnicode(p->get_line(), str, m_uCodePage);
				rFile.Write(str.c_str(), static_cast<DWORD>(str.size()));
			}

			// obt@̍ŌȂI
			EditDoc::const_iterator_t tmp = p;
			if(++p == m_pEditDoc->GetIteratorEnd())
			{
				rFile.Flush();
				return;
			}

			// {block}
			// sR[h
			{
				// sR[h擾
				sgc::charcode::linefeed_t lf_type = tmp->lf_type();
				if(bAlwaysUseDefaultLFCode || lf_type == sgc::charcode::CL_DEFAULT)
				{
					lf_type = lfDefault;
				}

				// ۂ̃R[hɕϊ
				wgc::string_t lf;
				pMultiLanguage2->ConvertFromUnicode(
					sgc::charcode::get_linefeed_string(lf_type),
					lf,
					m_uCodePage);

				rFile.Write(lf.c_str(), static_cast<DWORD>(lf.length()));
			}
		}
	}
	else
	{
		for(;;)
		{
			rFile.Write(p->c_str(), static_cast<DWORD>(p->length() * sizeof(WCHAR)));

			// obt@̍ŌȂI
			EditDoc::const_iterator_t tmp = p;
			if(++p == m_pEditDoc->GetIteratorEnd())
			{
				rFile.Flush();
				return;
			}

			// {block}
			// sR[h
			{
				// sR[h擾
				sgc::charcode::linefeed_t lf_type = tmp->lf_type();
				if(bAlwaysUseDefaultLFCode || lf_type == sgc::charcode::CL_DEFAULT)
				{
					lf_type = lfDefault;
				}

				// ۂ̃R[hɕϊ
				wgc::wstring_t lf = sgc::charcode::get_linefeed_string(lf_type);
				rFile.Write(lf.c_str(), static_cast<DWORD>(lf.length() * sizeof(WCHAR)));
			}
		}
	}
}

// obt@w̕R[hɕϊł邩H
BOOL MainFrame::CanConvertCodePage(void) const
{
	EditDoc::const_iterator_t p     = m_pEditDoc->GetIteratorBegin();
	EditDoc::const_iterator_t p_end = m_pEditDoc->GetIteratorEnd  (); p_end--;
	for(;;)
	{
		const bool eob = (p == p_end);          // End of Buffer

		sgc::wstring_t wstr;
		p->get_line(wstr, !eob);
		if(!m_pMultiLanguage2->CanConvertCodePage(wstr, m_uCodePage))
		{
			return FALSE;
		}
		if(eob)
		{
			break;
		}
		p++;
	}
	return TRUE;
}


// ۑĂȂt@CobNAbv
BOOL MainFrame::BackupUnsavedFile(void)
{
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// obNAbvݒɂȂĂȂΉȂ
	if(!prFrame.stOther.flags.elements.bBackupWhenCrushed)
	{
		return FALSE;
	}

	// t@CȂ牽Ȃ
	if(m_strFileName.empty())
	{
		return FALSE;
	}

	// obNAbvۑ
	const wgc::tstring_t strPathName = m_strDirName + prFrame.stOther.strBackupPrefix + m_strFileName;
	wgc::File file(strPathName.c_str(), GENERIC_WRITE);
	WriteTextData(file);

	// {block}
	// t@CWXgɕۑ
	{
		wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_BACKUP, TRUE);
		reg.SetValue(strPathName.c_str(), m_uCodePage);
	}
	return TRUE;
}


// ύXꂽt@Cۑ邩˂
int MainFrame::MessageBox_AskToSave(void) const
{
	wgc::tstring_t title = m_strFileName;
	if(title.empty())
	{
		wgc::wgfLoadString(GetResourceHandle(), IDS_FILENAME_DEFAULT, title);
	}

	// ۑ邩q˂
	return AppMessageBoxFormat(
		m_hWnd,
		IDS_MSGBOX_ASKTOSAVE,
		MB_YESNOCANCEL | MB_ICONEXCLAMATION,
		title.c_str());
}

int MainFrame::MessageBox_AskToReload(void) const
{
	return AppMessageBoxFormat(
		m_hWnd,
		IDS_MSGBOX_ASKTORELOAD,
		MB_YESNO | MB_ICONEXCLAMATION,
		m_strFileName.c_str());
}

int MainFrame::MessageBox_NoInterface(const BOOL bOpen) const
{
	const UINT nIDResource = bOpen ? IDS_MSGBOX_NOINTERFACE_OPEN : IDS_MSGBOX_NOINTERFACE_SAVE;
	return AppMessageBox(m_hWnd, nIDResource, MB_OKCANCEL | MB_ICONEXCLAMATION);
}


// ҏW̃t@C̐UpX擾
wgc::tstring_t MainFrame::GetPathName(void) const
{
	return m_strDirName + m_strFileName;
}

// ҏW̃t@C̃^CX^viŏIXVj擾
void MainFrame::GetTimeStamp(FILETIME &rStamp) const
{
	assert(m_hFile != INVALID_HANDLE_VALUE);

	wgc::File File(m_hFile);
	File.GetTime(NULL, NULL, &rStamp);
}

// t@CXVĂ邩H
BOOL MainFrame::IsUpdated(const BOOL bUpdateTimeStamp /* = TRUE */)
{
	// t@CJĂȂFALSE
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		return FALSE;
	}

	// ^CX^v擾
	FILETIME ft;
	GetTimeStamp(ft);

	// ^CX^vOƓȂFALSE
	if(::CompareFileTime(&m_ftUpdate, &ft) == 0)
	{
		return FALSE;
	}

	// ^CX^vXV
	if(bUpdateTimeStamp)
	{
		m_ftUpdate = ft;
	}
	return TRUE;
}


////////////////////////////////////////////////////////////

// GfBbgR|[lg̗̈vZ
void MainFrame::GetEditRect(RECT &rect)
{
	// NCAg̈悩珜ORg[ID
	INT id[] =                              // {mask, id}
	{
		1, 1,
		1, IDW_STD_TOOLBAR,                     // c[o[
		1, IDW_STD_STATUSBAR,                   // Xe[^Xo[
		0, 0,
	};

	GetEffectiveClientRect(rect, id);
}

// GfBbgR|[lg̃CAEg̍ČvZ
void MainFrame::RecalcEditLayout(void)
{
	RECT rect;
	GetEditRect(rect);

	// TCYύX
	m_pEditDoc->ResizeWindow(IDW_EDIT_VIEW, rect);
}


// t[̃pXݒ
void MainFrame::SetPathName(LPCTSTR lpszPathName)
{
	// pXfBNgƃt@Cɕ
	wgc::tstring_t strPathName = lpszPathName;
	size_t pos = strPathName.find_last_of(_T('\\'));

	m_strDirName  = strPathName.substr(0, pos + 1);
	m_strFileName = strPathName.substr(pos + 1);

	UpdateFrameTitle();
}


// t[̃^CgXV
void MainFrame::UpdateFrameTitle(void)
{
	wgc::tstring_t title;

	// t@C擾
	if(m_strFileName.empty())
	{
		// JĂt@CȂ΃ftHg̖Oi{ł́uvj擾
		wgc::tstring_t file_default;
		AppLoadString(IDS_FILENAME_DEFAULT, file_default);
		title = file_default;
	}
	else
	{
		MAINFRAME_PROPERTY prFrame;
		GetMainFrameProperty(prFrame);

		BOOL bDisplayFullpath;
		if(m_bActive) { bDisplayFullpath = prFrame.stDisplay.flags.elements.bDisplayFullpathOnActive ; }
		else          { bDisplayFullpath = prFrame.stDisplay.flags.elements.bDisplayFullpathOnInactive; }

		if(bDisplayFullpath) { title = m_strDirName; }
		title += m_strFileName;
	}

	// ύXĂ}[Nt
	if(m_pEditDoc->IsModified())
	{
		title += STR_MODIFIED;
	}

	title += STR_HYPHEN;

	// {block}
	// ̌ɃAvP[Vǉ
	{
		wgc::tstring_t app_name;
		AppLoadString(IDR_MAINFRAME, app_name);
		title += app_name;
	}

	SetWindowText(title);
}

// R}hC^[tF[XXV
void MainFrame::UpdateCommand(const command_interface &ci)
{
	OnUpdateFileOpenWithCPRange(ci);
	OnUpdateFileSave(ci);

	OnUpdateEditUndo        (ci);
	OnUpdateEditRedo        (ci);
	OnUpdateEditPaste       (ci);
	OnUpdateEditSelectCancel(ci);
	OnUpdateEditReconvert   (ci);
	OnUpdateEditReadonly    (ci);

	OnUpdateViewBar    (ci);
	OnUpdateViewTopmost(ci);

	OnUpdateSettingChange  (ci);
	OnUpdateSettingProperty(ci);
}


// Xe[VɃwvbZ[W𑗂
void MainFrame::SendHelpMessage(const UINT uCommand)
{
	Station_SendHelpMessage(uCommand);
}


// ݒ𔽉f
void MainFrame::ReloadSetting(void)
{
	// vpeB擾āc
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	// Đݒ
	m_pEditDoc->SetViewProperty(prView, prKeyword);
}

// t[̐ݒ𔽉f
void MainFrame::RefrectSetting_Frame(void)
{
	BroadcastMessage(FALSE, MAXY_REFRECT_FRAME);
}

// r[̐ݒ𔽉f
void MainFrame::RefrectSetting_View(void)
{
	BroadcastMessage(FALSE, MAXY_REFRECT_VIEW, m_uViewPropertyType);
}


// ::EnumWindows() ɓnvV[W

// łɕҏW̃t[邩H
BOOL CALLBACK MainFrame::FindWindowProc(HWND hWnd, LPARAM lParam)
{
	// NXCt[łȂΌs
	if(!IsMainFrame(hWnd))
	{
		return TRUE;
	}

	// ҏWt@C擾
	TCHAR szPathName[MAX_PATH];
	LPTSTR lpszPathName = szPathName;
	::SendMessage(hWnd, MAXY_GETPATHNAME, countof(szPathName), reinterpret_cast<LPARAM>(lpszPathName));

	// t@Cr
	LPFINDWINDOW lpfw = reinterpret_cast<LPFINDWINDOW>(lParam);

	// t@CvȂΌs
	if(::lstrcmpi(szPathName, lpfw->lpszPathName) != 0)
	{
		return TRUE;
	}

	// t@Cv΃EChEi[ČI
	lpfw->hWnd = hWnd;
	return FALSE;
}

// SẴt[փbZ[W𑗐M
BOOL MainFrame::BroadcastProc(HWND hWnd, LPARAM lParam)
{
	if(IsMainFrame(hWnd))
	{
		LPBROADCASTPARAM lpBroadcastParam = reinterpret_cast<LPBROADCASTPARAM>(lParam);
		if(lpBroadcastParam->bSend)
		{
			::SendMessage(hWnd, lpBroadcastParam->uMsg, lpBroadcastParam->wParam, lpBroadcastParam->lParam);
		}
		else
		{
			::PostMessage(hWnd, lpBroadcastParam->uMsg, lpBroadcastParam->wParam, lpBroadcastParam->lParam);
		}
	}
	return TRUE;
}
