// EditDoc.cpp cCve[Vt@C
#include "EditDoc.h"
#include "EditView.h"
#include "component/wgc/wgfunc.h"       // wgc::wgfMultiByteToWideChar()
#include <algorithm>                    // std::swap()
#include <assert.h>                     // assert()


////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
EditDoc::EditDoc(
	wgc::Window       *pMainFrame,
	const EDITVIEW_PROPERTY &rProperty,
	HCURSOR            hCursorMargin /* = NULL */)
	: m_pMainFrame(pMainFrame), m_property(rProperty),
	  m_pActiveView(NULL),
	  m_hCursorMargin(hCursorMargin),
	  m_hFont(NULL),
	  m_bOverwrite(FALSE),
	  m_bDropSource(FALSE)
{
	m_hFont = CreateInfoFont(m_property.infoText.font);
}

// fXgN^
EditDoc::~EditDoc(void)
{
	// r[͔jƂɎgdeletêŁAdeletesKv͂Ȃ
	m_pActiveView = NULL;

	::DeleteObject(m_hFont);
	m_hFont = NULL;
}

BOOL EditDoc::CreateView(
	const BOOL bSetFocus,
	const DWORD dwStyle, const DWORD dwExStyle,
	const UINT nID,
	wgc::Window *pParent /* = NULL */,
	HINSTANCE hInstance /* = NULL */,
	const int x /* = CW_USEDEFAULT */,
	const int y /* = CW_USEDEFAULT */,
	const int nWidth  /* = CW_USEDEFAULT */,
	const int nHeight /* = CW_USEDEFAULT */)
{
	EditView *pView = new EditView(*this, m_property, m_hCursorMargin, m_hFont);
	const BOOL bResult = pView->Create(
		dwStyle, dwExStyle,
		(pParent != NULL) ? pParent : m_pMainFrame,
		nID,
		hInstance,
		x, y,
		nWidth, nHeight);

	if(!bResult) { return FALSE; }

	m_listView.push_back(pView);
	if(bSetFocus || m_pActiveView == NULL)
	{
		SetFocusTo(nID);
	}
	return TRUE;
}

void EditDoc::DestroyView(const UINT nID)
{
	EditView *pView = GetViewFromID(nID);
	if(pView == NULL)
	{
		return;
	}

	pView->DestroyWindow();
	if(m_pActiveView == pView)
	{
		// ANeBuȃr[AXg̐擪̃r[ANeBuƂ
		m_pActiveView = m_listView.front();
		SetFocusTo();
	}
}


// TCY
void EditDoc::ResizeWindow(const int nID, const RECT &rRect)
{
	EditView *pView = GetViewFromID(nID);
	if(pView == NULL)
	{
		return;
	}

	pView->MoveWindow(
		rRect.left, rRect.top,
		rRect.right - rRect.left, rRect.bottom - rRect.top);
}

// tH[JXړ
void EditDoc::SetFocusTo(const int nID /* = -1 */)
{
	EditView *pView = NULL;
	if(nID != -1)
	{
		pView = GetViewFromID(nID);
	}

	if(pView == NULL)
	{
		pView = m_pActiveView;
	}

	assert(pView != NULL);
	m_pActiveView = pView;
	pView->SetFocus();
}

// r[̃vpeBύX
void EditDoc::SetViewProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword)
{
	m_property = rProperty;
	m_keyword  = rKeyword;

	// {block}
	// tHgύX
	{
		::DeleteObject(m_hFont);
		m_hFont = CreateInfoFont(m_property.infoText.font);
	}

	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->SetProperty(m_property, m_keyword, m_hFont);
	}
}

void EditDoc::InvalidateAllViews(void)
{
	// ׂẴr[𖳌
	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->Invalidate();
	}

	// Jbg̈ʒuĐݒ
	m_pActiveView->ResetCaretPos();
}


////////////////////////////////////////////////////////////////////////////////
// 

// ݍsi1 originj擾
INT_PTR EditDoc::GetNowLine(void) const
{
	return GetY() + 1;
}

// wsi1 originjփWv
void EditDoc::JumpToLine(const INT_PTR nLineNumber)
{
	// sԍC
	INT_PTR nCorrectedLineNumber = nLineNumber;
	if(nCorrectedLineNumber < 1) { nCorrectedLineNumber = 1; }

	// Wv
	const position_t position = {0, nCorrectedLineNumber - 1};
	SetXY(position);
}

// hbOhbvJn
void EditDoc::DragBegin(void)
{
	m_bDropSource = TRUE;
}

// hbOhbvI
void EditDoc::DragEnd(void)
{
	m_bDropSource = FALSE;
}

// ݃hbv\[XH
BOOL EditDoc::IsDropSource(void) const
{
	return m_bDropSource;
}


////////////////////////////////////////////////////////////////////////////////
// edit_manager ̃bp{

////////////////////////////////////////////////////////////
// 

// s擾
SIZE_T EditDoc::GetLineCount(void) const
{
	return m_manager.get_line_count();
}

// P̋؂
SIZE_T EditDoc::FindWordBreak(const BOOL bForward /* = TRUE */) const
{
	bool forward = (bForward != FALSE);
	return m_manager.find_word_break(forward);
}

// ݈ʒu擪H
BOOL EditDoc::IsBegin(void) const
{
	return m_manager.is_begin();
}

// ݈ʒuH
BOOL EditDoc::IsEnd(void) const
{
	return m_manager.is_end();
}

// ݈ʒusH
BOOL EditDoc::IsHead(void) const
{
	return m_manager.is_head();
}

// ݈ʒusH
BOOL EditDoc::IsTail(void) const
{
	return m_manager.is_tail();
}


////////////////////////////////////////////////////////////
// Ce[^̎擾

EditDoc::const_iterator_t EditDoc::GetIterator(const linenumber_t linenumber) const
{
	return m_manager.get_iterator(linenumber);
}

EditDoc::const_iterator_t EditDoc::GetIteratorBegin(void) const
{
	return m_manager.get_iterator_begin();
}

EditDoc::const_iterator_t EditDoc::GetIteratorEnd(void) const
{
	return m_manager.get_iterator_end();
}

EditDoc::const_iterator_t EditDoc::GetIteratorNow(void) const
{
	return m_manager.get_iterator_now();
}


////////////////////////////////////////////////////////////
// ̐ݒ/擾

// ֎~̐ݒ
BOOL EditDoc::SetReadOnly(const BOOL bReadOnly /* = TRUE */)
{
	m_manager.set_readonly(bReadOnly != FALSE);

	// {block}
	// ׂẴr[ ES_READONLY X^Cǉ/폜
	{
		DWORD dwRemove = 0;
		DWORD dwAdd    = ES_READONLY;
		if(!bReadOnly)
		{
			std::swap(dwRemove, dwAdd);
		}

		for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
		{
			EditView *pView = *p;
			assert(pView != NULL);

			pView->ModifyStyle(dwRemove, dwAdd, 0, 0);
		}
	}
	SendNotifyCommandToMainFrame(XEN_READONLYCHANGED);

	return TRUE;
}

// ֎~Ԃ𔽓]
BOOL EditDoc::ToggleReadOnly(void)
{
	const BOOL bReadOnly = IsReadOnly();
	return SetReadOnly(!bReadOnly);
}

// ֎~H
BOOL EditDoc::IsReadOnly(void) const
{
	return m_manager.is_readonly();
}

// ㏑̐ݒ
BOOL EditDoc::SetOverwrite(const BOOL bOverwrite /* = TRUE */)
{
	m_bOverwrite = bOverwrite;
	SendNotifyCommandToMainFrame(XEN_OVERWRITECHANGED);
	return TRUE;
}

// ㏑Ԃ𔽓]
BOOL EditDoc::ToggleOverwrite(void)
{
	SetOverwrite(!m_bOverwrite);
	return m_bOverwrite;
}

// ㏑H
BOOL EditDoc::IsOverwrite(void) const
{
	return m_bOverwrite;
}

// _[eB[tO̐ݒ
BOOL EditDoc::SetModify(const BOOL bModify /* = TRUE */)
{
	// obt@̓ǂݎpݒ
	m_manager.set_modify(bModify != FALSE);
	SendNotifyCommandToMainFrame(XEN_MODIFYCHANGED);
	return TRUE;
}

// obt@ύXĂ邩H
BOOL EditDoc::IsModified(void) const
{
	return m_manager.is_modified();
}


////////////////////////////////////////////////////////////////////////////////
// Nbv{[h֘A

// ؂
void EditDoc::Cut(void)
{
	// I͈͂Nbv{[hɃRs[č폜
	Copy();
	Delete(FALSE);
}

// Rs[
void EditDoc::Copy(const wchar_t cQuoteMark /* = sgc::charcode::wNUL */)
{
	wgc::Clipboard cb;
	cb.Empty();

	// Unicode`őIꂽf[^擾
	wgc::wstring_t wtext;
	GetSelectedTextW(wtext, cQuoteMark);

	// {block}
	// Unicode`̃f[^Nbv{[hɊi[
	{
		const SIZE_T nSize = (wtext.length() + 1) * sizeof(wtext[0]);
		SetClipboard(cb, CF_UNICODETEXT, wtext.c_str(), nSize);
	}

#ifndef UNICODE
	// {block}
	// ANSI`łi[
	{
		wgc::string_t text;
		wgc::wgfWideCharToMultiByte(wtext, text);

		const SIZE_T nSize = text.length() + 1;
		SetClipboard(cb, CF_TEXT, text.c_str(), nSize);
	}
#endif
}

// 폜
void EditDoc::Delete(const BOOL bDeleteCharIfEmpty /* = TRUE */)
{
	if(IsSelected())
	{
		// IĂΑI͈͂폜
		DeleteSelection();
		return;
	}

	if(bDeleteCharIfEmpty)
	{
		// Jbgʒu̕폜iDeleteL[Ɠj
		DeleteChar(TRUE);
	}
	else
	{
		// ݍs폜
		DeleteLine();
	}
}

// \t
void EditDoc::Paste(const wchar_t cQuoteMark /* = sgc::charcode::wNUL */)
{
	if(IsReadOnly()) { return; }

	wgc::Clipboard cb;

	// \t镶
	wgc::wstring_t wtext;

	// {block}
	// Unicode`Ńf[^擾
	{
		HANDLE hData = cb.GetData(CF_UNICODETEXT);
		if(hData != NULL)
		{
			// f[^擾
			LPCVOID lpData = ::GlobalLock(hData);
			LPCWSTR lpText = reinterpret_cast<LPCWSTR>(lpData);
			{
				wtext = lpText;
			}
			::GlobalUnlock(hData);
			goto end;
		}
	}

#ifndef UNICODE
	// {block}
	// ANSI`Ńf[^擾
	{
		HANDLE hData = cb.GetData(CF_TEXT);
		if(hData != NULL)
		{
			// f[^擾
			LPCVOID lpData = ::GlobalLock(hData);
			LPCSTR  lpText = reinterpret_cast<LPCSTR>(lpData);
			{
				wgc::wgfMultiByteToWideChar(lpText, wtext);
			}
			::GlobalUnlock(hData);
			goto end;
		}
	}
#endif
	return;

end:
	// \t
	DeleteSelection();
	InsertText(wtext, cQuoteMark);
}

// \tł邩H
BOOL EditDoc::CanPaste(const UINT uFormat /* = 0 */) const
{
	// uFormat 0ȊÔƂ́AuFormat 𒲂ׂ
	if(uFormat != 0)
	{
		// CF_TEXT ` CF_UNICODETEXT `Ȃy[Xg\
		return (uFormat == CF_TEXT) || (uFormat == CF_UNICODETEXT);
	}
	// uFormat 0̂Ƃ́ANbv{[h̃f[^𒲂ׂ
	else
	{
		// NTnOSł́AO CF_TEXT Ŕ\B
		// 9xnOSłʏ CF_TEXT ł悢A
		// CF_UNICODETEXT `Ŋi[Av邩Ȃ̂
		// Ôߌ㔼ł肵ĂB
		return wgc::Clipboard::IsFormatAvailable(CF_TEXT) || wgc::Clipboard::IsFormatAvailable(CF_UNICODETEXT);
	}
}


////////////////////////////////////////////////////////////////////////////////
// ҏW

////////////////////////////////////////////////////////////
// AhDEhD

// AhD
BOOL EditDoc::Undo(void)
{
	const BOOL bSelected = IsSelected();

	sgc::edit_manager::modify_info mi;
	if(!m_manager.undo(mi)) { return FALSE; }
	if(bSelected) { mi.modified_line = 0; }

	PostModify(mi);
	return TRUE;
}

// hD
BOOL EditDoc::Redo(void)
{
	const BOOL bSelected = IsSelected();

	sgc::edit_manager::modify_info mi;
	if(!m_manager.redo(mi)) { return FALSE; }
	if(bSelected) { mi.modified_line = 0; }

	PostModify(mi);
	return TRUE;
}

// AhDł邩H
BOOL EditDoc::CanUndo(void) const
{
	return m_manager.can_undo();
}

// hDł邩H
BOOL EditDoc::CanRedo(void) const
{
	return m_manager.can_redo();
}

// őAhD񐔂ݒ
INT_PTR EditDoc::SetUndoLimit(const INT_PTR nLimit /* = -1 */)
{
	return m_manager.set_undo_limit(nLimit);
}

void EditDoc::EmptyUndoBuffer(void)
{
	m_manager.empty_undo_buffer();
}


////////////////////////////////////////////////////////////
// obt@

// steLXgobt@ɃZbgAhDobt@NA
BOOL EditDoc::SetText(const wgc::wstring_t &wtext)
{
	return SetText(wtext.c_str(), wtext.length());
}

BOOL EditDoc::SetText(LPCWSTR lpText, const SIZE_T lSize)
{
	if(m_manager.set_text(lpText, lSize))
	{
		for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
		{
			EditView *pView = *p;
			assert(pView != NULL);

			pView->m_ptLogicalPrev.x = 0;
			pView->m_ptLogicalPrev.y = 0;
			pView->m_nLineNumberTop  = 1;
			pView->m_nColumnLeft     = 0;
		}

		// Ԃ
		SetReadOnly(FALSE);

		PostModify(1, TRUE);
		return TRUE;
	}
	return FALSE;
}

// eLXgis܂ށj݈ʒuɑ}
BOOL EditDoc::InsertText(const wgc::wstring_t &wtext, const wchar_t cQuoteMark /* = sgc::charcode::wNUL */, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bStop /* = TRUE */)
{
	return InsertText(wtext.c_str(), wtext.length(), cQuoteMark, select_status, bStop);
}

BOOL EditDoc::InsertText(LPCWSTR lpText, const SIZE_T lSize, const wchar_t cQuoteMark /* = sgc::charcode::wNUL */, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bStop /* = TRUE */)
{
	const bool stop = (bStop != FALSE);
	sgc::edit_manager::modify_info mi_array[2];
	const bool result1 = m_manager.select_delete(true, mi_array[0], false);
	const bool result2 = m_manager.insert_text(lpText, lSize, mi_array[1], cQuoteMark, select_status, stop);
	if(result1 || result2)
	{
		sgc::edit_manager::modify_info mi;
		sgc::edit_manager::merge_modify_info(mi_array, sizeof(mi_array), mi);
		PostModify(mi);
		return TRUE;
	}
	return FALSE;
}

// s݈ʒuɑ}
BOOL EditDoc::InsertLinefeed(const BOOL bStop /* = TRUE */)
{
	const bool stop = (bStop != FALSE);
	sgc::edit_manager::modify_info mi_array[2];
	const bool result1 = m_manager.select_delete  (true, mi_array[0], false);
	const bool result2 = m_manager.insert_linefeed(      mi_array[1], sgc::edit_manager::MS_CLEAR, stop);
	if(result1 || result2)
	{
		sgc::edit_manager::modify_info mi;
		sgc::edit_manager::merge_modify_info(mi_array, sizeof(mi_array), mi);
		PostModify(mi);
		return TRUE;
	}
	return FALSE;
}

// isȂj́i}/㏑fj
BOOL EditDoc::InputString(const wgc::wstring_t &wstr, const BOOL bStop /* = TRUE */)
{
	sgc::edit_manager::modify_info mi_array[2];
	int mi_count = 0;
	bool stop = (bStop != FALSE);
	bool result = false;

	// I𕶎񂪂ΐɍ폜
	if(m_manager.select_delete(true, mi_array[0], stop))
	{
		mi_count++;
		stop = false;
	}
	if(IsOverwrite())
	{
		result = m_manager.overwrite_string(wstr, mi_array[mi_count++], sgc::edit_manager::MS_CLEAR, stop);
	}
	else
	{
		result = m_manager.insert_string(wstr, mi_array[mi_count++], sgc::edit_manager::MS_CLEAR, stop);
	}

	if(result)
	{
		sgc::edit_manager::modify_info mi;
		sgc::edit_manager::merge_modify_info(mi_array, mi_count, mi);
		PostModify(mi);
		return TRUE;
	}
	return FALSE;
}

// ݈ʒu̎Oɂ镶폜
BOOL EditDoc::DeleteChar(const BOOL bForward /* = TRUE */, const BOOL bStop /* = TRUE */)
{
	const bool stop = (bStop != FALSE);
	bool result = FALSE;
	sgc::edit_manager::modify_info mi;
	if(IsSelected())
	{
		result = m_manager.select_delete(true, mi, stop);
	}
	else
	{
		result = m_manager.delete_char(bForward != FALSE, mi, sgc::edit_manager::MS_CLEAR, stop);
	}

	if(result)
	{
		PostModify(mi);
	}
	return result;
}

// ݍs폜
BOOL EditDoc::DeleteLine(const BOOL bStop /* = TRUE */)
{
	const bool stop = (bStop != FALSE);
	sgc::edit_manager::modify_info mi;
	if(m_manager.delete_line(mi, stop))
	{
		PostModify(mi);
		return TRUE;
	}
	return FALSE;
}


// IĂ邩H
BOOL EditDoc::IsSelected(void) const
{
	return m_manager.is_selected();
}

// ݈ʒu̒PI
void EditDoc::SelectWord(const select_cursor_t cursor_pos /* = sgc::edit_manager::SC_NOMOVE */, const BOOL bUpdateSelection /* = FALSE */)
{
	const bool update_selection = (bUpdateSelection != FALSE);
	m_manager.select_word(cursor_pos, update_selection);
	if(cursor_pos != sgc::edit_manager::SC_NOMOVE)
	{
		SetXY(GetXY(), sgc::edit_manager::MS_UPDATE);
	}
	else
	{
		PostUpdateSelection();
	}
}

// ݍsI
void EditDoc::SelectLine(const select_cursor_t cursor_pos /* = sgc::edit_manager::SC_NOMOVE */, const BOOL bUpdateSelection /* = FALSE */)
{
	const bool update_selection = (bUpdateSelection != FALSE);
	m_manager.select_line(cursor_pos, update_selection);
	if(cursor_pos != sgc::edit_manager::SC_NOMOVE)
	{
		SetXY(GetXY(), sgc::edit_manager::MS_UPDATE);
	}
	else
	{
		PostUpdateSelection();
	}
}

// SđI
void EditDoc::SelectAll(void)
{
	m_manager.select_all();
	PostUpdateSelection();
}

// I
void EditDoc::ClearSelection(const select_cursor_t cursor_pos /* = sgc::edit_manager::SC_NOMOVE */)
{
	if(!IsSelected()) { return; }

	m_manager.select_clear(cursor_pos);
	PostUpdateSelection();
}

// I͈͂폜
BOOL EditDoc::DeleteSelection(const BOOL bMoveCursor /* = FALSE */, const BOOL bStop /* = TRUE */)
{
	const bool move_cursor = (bMoveCursor != FALSE);
	const bool stop        = (bStop       != FALSE);
	sgc::edit_manager::modify_info mi;
	if(m_manager.select_delete(move_cursor, mi, stop))
	{
		PostModify(mi);
		return TRUE;
	}
	return FALSE;
}

// Ï擾
void EditDoc::GetSelectedRange(position_t &sel_begin, position_t &sel_end) const
{
	m_manager.select_get_range(sel_begin, sel_end);
}

// I𕶎擾
void EditDoc::GetSelectedText(wgc::tstring_t &ttext, const wchar_t cQuoteMark /* = sgc::charcode::wNUL */) const
{
#ifndef UNICODE
	GetSelectedTextA(ttext, cQuoteMark);
#else
	GetSelectedTextW(ttext, cQuoteMark);
#endif
}

// I𕶎擾iANSIj
void EditDoc::GetSelectedTextA(wgc::string_t &text, const wchar_t cQuoteMark /* = sgc::charcode::wNUL */) const
{
	wgc::wstring_t wtext;
	GetSelectedTextW(wtext, cQuoteMark);

	wgc::wgfWideCharToMultiByte(wtext, text);
}

// I𕶎擾iUnicodej
void EditDoc::GetSelectedTextW(wgc::wstring_t &wtext, const wchar_t cQuoteMark /* = sgc::charcode::wNUL */) const
{
	if(m_manager.is_selected())
	{
		m_manager.select_get_text(wtext, cQuoteMark);
	}
	else
	{
		m_manager.get_line(wtext, cQuoteMark);
	}
}


////////////////////////////////////////////////////////////
// ̑

// ĕϊ
void EditDoc::Reconvert(void)
{
	EditView *pActiveView = m_pActiveView;
	assert(pActiveView != NULL);

	pActiveView->Reconversion();
}


////////////////////////////////////////////////////////////////////////////////
// Jbgʒuir[Ƃ̘AgȂj

EditDoc::position_t EditDoc::GetXY(void) const
{
	return m_manager.get_xy();
}

void EditDoc::SetXY(const position_t &position, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bUpdateInternalX /* = TRUE */)
{
	// ĕ`悪Kvȏ́Aȉ̂ꂩ
	// @1. ÏXV
	// @2. IĂāAÏ
	BOOL bUpdateSelection = (select_status == sgc::edit_manager::MS_UPDATE);
	if(IsSelected() && select_status == sgc::edit_manager::MS_CLEAR) { bUpdateSelection = TRUE; }

	m_manager.set_xy(position, select_status);

	m_pActiveView->OnSyncCaret(bUpdateSelection, bUpdateInternalX);
}

INT_PTR EditDoc::GetX(void) const
{
	return m_manager.get_x();
}

INT_PTR EditDoc::GetY(void) const
{
	return m_manager.get_y();
}

INT_PTR EditDoc::SetX(const INT_PTR x, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bSyncCaret /* = TRUE */, const BOOL bUpdateInternalX /* = TRUE */)
{
	BOOL bUpdateSelection = (select_status == sgc::edit_manager::MS_UPDATE);
	if(IsSelected() && select_status == sgc::edit_manager::MS_CLEAR) { bUpdateSelection = TRUE; }

	const intptr_t result = m_manager.set_x(x, select_status);

	if(bSyncCaret)
	{
		m_pActiveView->OnSyncCaret(bUpdateSelection, bUpdateInternalX);
	}
	return result;
}

INT_PTR EditDoc::SetY(const INT_PTR y, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bSyncCaret /* = TRUE */)
{
	BOOL bUpdateSelection = (select_status == sgc::edit_manager::MS_UPDATE);
	if(IsSelected() && select_status == sgc::edit_manager::MS_CLEAR) { bUpdateSelection = TRUE; }

	const intptr_t result = m_manager.set_y(y, select_status);

	if(bSyncCaret)
	{
		m_pActiveView->OnSyncCaret(bUpdateSelection, FALSE);
	}
	return result;
}

INT_PTR EditDoc::SetXRelative(const INT_PTR dx, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bSyncCaret /* = TRUE */, const BOOL bUpdateInternalX /* = TRUE */)
{
	BOOL bUpdateSelection = (select_status == sgc::edit_manager::MS_UPDATE);
	if(IsSelected() && select_status == sgc::edit_manager::MS_CLEAR) { bUpdateSelection = TRUE; }

	const intptr_t result = m_manager.shift_x(dx, select_status);

	if(bSyncCaret)
	{
		m_pActiveView->OnSyncCaret(bUpdateSelection, bUpdateInternalX);
	}
	return result;
}

INT_PTR EditDoc::SetYRelative(const INT_PTR dy, const sgc::edit_manager::move_select_t select_status /* = sgc::edit_manager::MS_CLEAR */, const BOOL bSyncCaret /* = TRUE */)
{
	BOOL bUpdateSelection = (select_status == sgc::edit_manager::MS_UPDATE);
	if(IsSelected() && select_status == sgc::edit_manager::MS_CLEAR) { bUpdateSelection = TRUE; }

	const intptr_t result = m_manager.shift_y(dy, select_status);

	if(bSyncCaret)
	{
		m_pActiveView->OnSyncCaret(bUpdateSelection, FALSE);
	}
	return result;
}


////////////////////////////////////////////////////////////////////////////////
// r[Ƃ̘Ag

// IDr[擾
EditView *EditDoc::GetViewFromID(const int nID) const
{
	for(viewlist_const_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		if(pView->GetDlgCtrlID() == nID)
		{
			return pView;
		}
	}
	// ȂNULLԂ
	return NULL;
}

// obt@ύXꂽɌĂяo
void EditDoc::PostModify(const sgc::edit_manager::modify_info &mi)
{
	PostModify(mi.modified_line + 1, mi.is_modified_linecount);
}

void EditDoc::PostModify(const linenumber_t lineModify, const BOOL bUpdateLineNumber /* = FALSE */)
{
	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->OnSyncBuffer(lineModify, bUpdateLineNumber);
	}

	// eEChEɒʒm
	SendNotifyCommandToMainFrame(XEN_MODIFYCHANGED);
}

// Ï悪ύXꂽɌĂяo
void EditDoc::PostUpdateCursorPos(const BOOL bUpdateSelection /* = FALSE */)
{
	m_pActiveView->OnSyncCaret(bUpdateSelection);
}

// Ï悪ύXꂽɌĂяo
void EditDoc::PostUpdateSelection(void)
{
	// ANeBuȃr[ĕ`
	m_pActiveView->Invalidate(FALSE);
}


// Ct[ɒʒmbZ[W𑗐M
LRESULT EditDoc::SendNotifyCommandToMainFrame(const WORD wNotify)
{
	const NMHDR nmHeader = {NULL, 0, wNotify};
	return m_pMainFrame->SendMessage(
		WM_NOTIFY,
		0, reinterpret_cast<LPARAM>(&nmHeader));
}


// tHgƃTCYtHg쐬
HFONT EditDoc::CreateInfoFont(const FONT_INFO &info)
{
	LOGFONT lf = {0};
	lf.lfEscapement     = 0;
	lf.lfOrientation    = 0;
	lf.lfWeight         = info.flags.elements.bBold ? FW_BOLD : FW_DONTCARE;
	lf.lfItalic         = info.flags.elements.bItalic;
	lf.lfUnderline      = info.flags.elements.bUnderline;
	lf.lfStrikeOut      = info.flags.elements.bStrikeOut;
	lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
	lf.lfQuality        = DEFAULT_QUALITY;
	lf.lfPitchAndFamily = VARIABLE_PITCH | FF_DONTCARE;
	lf.lfCharSet        = DEFAULT_CHARSET;

	::lstrcpyn(lf.lfFaceName, info.szFaceName, countof(lf.lfFaceName));

	// {block}
	// ƍvZ
	{
		wgc::DeviceContext_Client dc(NULL);
		lf.lfWidth  = 0;
		lf.lfHeight = -static_cast<LONG>(info.fPointSize * dc.GetDeviceCaps(LOGPIXELSY) / 72 + 0.5);
	}

	return ::CreateFontIndirect(&lf);
}

// Nbv{[hɃf[^u
BOOL EditDoc::SetClipboard(wgc::Clipboard &cb, const CLIPFORMAT cfFormat, LPCVOID lpData, const SIZE_T nSize)
{
	HANDLE hData     = ::GlobalAlloc(GMEM_MOVEABLE, nSize);
	LPVOID lpDataDst = ::GlobalLock(hData);
	{
		::CopyMemory(lpDataDst, lpData, nSize);
	}
	::GlobalUnlock(hData);

	HANDLE hResult = cb.SetData(cfFormat, hData);
	if(hResult == NULL)
	{
		return FALSE;
	}
	return TRUE;
}
