// Jump.cpp cCve[Vt@C
#include "Jump.h"
#include <limits.h>


// RXgN^
DialogJump::DialogJump(DIALOGPROPERTY_JUMP &rProperty, HWND hWndParent)
	: Dialog(GetResourceHandle(), MAKEINTRESOURCE(IDD), hWndParent),
	m_rProperty(rProperty), m_cLineNumber()
{
}

// fXgN^
DialogJump::~DialogJump(void)
{
}


void DialogJump::AssociateDialogControls(void)
{
	m_cLineNumber.SubclassDlgItem(IDC_JUMP_LINENUMBER_SPIN, this);
}

void DialogJump::UpdateData(const BOOL bUpdate /* = TRUE */)
{
	// _CAOIuWFNg
	if(bUpdate)
	{
		// sԍ擾
		m_rProperty.nLineNumber = m_cLineNumber.GetPos();
	}
	// IuWFNg_CAO
	else
	{
		// sԍݒ
		m_cLineNumber.SetPos(static_cast<int>(m_rProperty.nLineNumber));
	}
}


// _CAO
BOOL DialogJump::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	Dialog::OnInitDialog(hWndFocus, dwInitParam);

	// {block}
	// c[`bvݒ
	{
		const UINT array[] =
		{
			IDC_JUMP_LINENUMBER,
			IDC_JUMP_LINENUMBER_SPIN,
		};
		SetToolTips(array, countof(array));
	}

	UpdateData(FALSE);

	// Xs{^̏㉺ݒ
	m_cLineNumber.SetRange32(1, INT_MAX);

	// {block}
	// sԍ͗ɃtH[JX킹
	{
		wgc::Window edit(GetDlgItem(IDC_JUMP_LINENUMBER));
		edit.SetFocus();
		edit.SendMessage(EM_SETSEL, static_cast<WPARAM>(0), static_cast<LPARAM>(-1));
	}
	return FALSE;
}

// R}h
BOOL DialogJump::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	switch(wID)
	{
	case IDC_JUMP_LINENUMBER:
		switch(wNotifyCode)
		{
		case EN_UPDATE:
			OnUpdateLineNumber();
			return FALSE;
		}
	}
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}


////////////////////////////////////////////////////////////
// R}hnh

// WvsԍXVꂽ
void DialogJump::OnUpdateLineNumber(void)
{
	// Xs{^ĂȂΏI
	// iofB֘ẢeAOK{^Oɂ̃nhĂ΂邱Ƃj
	if(!m_cLineNumber.IsWindow())
	{
		return;
	}

	// GfBbg{bNX̒l𕄍ȂɕϊĂ݂
	BOOL bResult;
	GetDlgItemInt(IDC_JUMP_LINENUMBER, &bResult, FALSE);

	// ϊłOK{^Cl[u
	HWND hWndOK = GetDlgItem(IDOK);
	::EnableWindow(hWndOK, bResult);
}
