// Customize_Display.cpp cCve[Vt@C
#include "Customize_Display.h"


////////////////////////////////////////////////////////////////////////////////
// RXgN^
DialogCustomize_Display::DialogCustomize_Display(MAINFRAME_PROPERTY::DISPLAY &rProperty)
	: DialogPropertyPage(GetResourceHandle(), MAKEINTRESOURCE(IDD), NULL),
	m_rProperty(rProperty)
{
}

// fXgN^
DialogCustomize_Display::~DialogCustomize_Display(void)
{
}


void DialogCustomize_Display::AssociateDialogControls(void)
{
}

void DialogCustomize_Display::UpdateData(const BOOL bUpdate /* = TRUE */)
{
	// _CAOIuWFNg
	if(bUpdate)
	{
		// \
		m_rProperty.flags.elements.bRestorePlacement          = (IsDlgButtonChecked(IDC_CUSTOMIZE_DISPLAY_RESTOREPLACEMENT           == BST_CHECKED));
		m_rProperty.flags.elements.bDisplayFullpathOnActive   = (IsDlgButtonChecked(IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONACTIVE    == BST_CHECKED));
		m_rProperty.flags.elements.bDisplayFullpathOnInactive = (IsDlgButtonChecked(IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONINACTIVE) == BST_CHECKED);
	}
	// IuWFNg_CAO
	else
	{
		CheckDlgButton(IDC_CUSTOMIZE_DISPLAY_RESTOREPLACEMENT         , m_rProperty.flags.elements.bRestorePlacement);
		CheckDlgButton(IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONACTIVE  , m_rProperty.flags.elements.bDisplayFullpathOnActive);
		CheckDlgButton(IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONINACTIVE, m_rProperty.flags.elements.bDisplayFullpathOnInactive);
	}
}


// _CAO
BOOL DialogCustomize_Display::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	DialogPropertyPage::OnInitDialog(hWndFocus, dwInitParam);

	// e평
	InitToolTips();                         // c[`bv

	UpdateData(FALSE);
	return FALSE;
}

// R}h
BOOL DialogCustomize_Display::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	return DialogPropertyPage::OnCommand(wNotifyCode, wID, hWndCtrl);
}


////////////////////////////////////////////////////////////
// R}hnh


////////////////////////////////////////////////////////////
// 

// c[`bv
void DialogCustomize_Display::InitToolTips(void)
{
	const UINT array[] =
	{
		IDC_CUSTOMIZE_DISPLAY_RESTOREPLACEMENT,
		IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONACTIVE,
		IDC_CUSTOMIZE_DISPLAY_DISPLAYFULLPATHONINACTIVE,
	};
	SetToolTips(array, countof(array));
}
