// COM_XMultiLanguage.cpp cCve[Vt@C
// COM IMultiLanguage2 gpĂ̂ŁAInternet Explorer 5.0ȏオKv
#include "COM_XMultiLanguage.h"
#include "../wgfunc.h"                  // wgc::wgfThrowLastError()
#include <algorithm>                    // std::swap()
#include <assert.h>                     // assert()


_WXC_BEGIN                              // namespace wxc {

COM_XMultiLanguage2 *COM_XMultiLanguage2::CreateInstance(void)
{
	IMultiLanguage2 *pMultiLanguage2 = NULL;
	HRESULT hResult = ::CoCreateInstance(
		CLSID_CMultiLanguage,
		NULL,
		CLSCTX_ALL,
		IID_IMultiLanguage2,
		reinterpret_cast<LPVOID *>(&pMultiLanguage2));

	if(hResult != S_OK)
	{
		return NULL;
	}
	return new COM_XMultiLanguage2(pMultiLanguage2);
}

COM_XMultiLanguage2::COM_XMultiLanguage2(IMultiLanguage2 *pMultiLanguage2) : m_pMultiLanguage2(pMultiLanguage2)
{
	assert(pMultiLanguage2 != NULL);
}

COM_XMultiLanguage2::~COM_XMultiLanguage2(void)
{
}


// T|[gĂR[hy[W̐擾
UINT COM_XMultiLanguage2::GetNumberOfCodePageInfo(void) const
{
	UINT cCodePage = 0;
	const HRESULT hResult = m_pMultiLanguage2->GetNumberOfCodePageInfo(&cCodePage);
	wgc::wgfThrowIfFailed(hResult);
	return cCodePage;
}

// R[hy[W
void COM_XMultiLanguage2::EnumCodePages(MIMECPINFO_vector_t &mcpi, const DWORD dwFlags /* = 0 */, const LANGID wLangId /* = 0 */)
{
	IEnumCodePage *pInterface = NULL;

	// {block}
	// IEnumCodePageIuWFNg擾
	{
		const HRESULT hResult = m_pMultiLanguage2->EnumCodePages(dwFlags, wLangId, &pInterface);
		wgc::wgfThrowIfFailed(hResult);

		assert(pInterface != NULL);
	}

	// {block}
	// R[hy[W擾
	{
		wgc::COM_AutoInterface<IEnumCodePage> pEnumCodePage(pInterface);

		const UINT uiCodePageNumber = GetNumberOfCodePageInfo();
		ULONG ccpInfo;

		mcpi.resize(uiCodePageNumber);
		const HRESULT hResult = pEnumCodePage->Next(uiCodePageNumber, &mcpi[0], &ccpInfo);
		mcpi.resize(ccpInfo);

		wgc::wgfThrowIfFailed(hResult);
	}
}


// R[h̎o
HRESULT COM_XMultiLanguage2::AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize, DetectEncodingInfo arEncoding[], INT &rnScores, const MLDETECTCP nDetectFlag /* = MLDETECTCP_NONE */, const DWORD dwPrefWinCodePage /* = 0 */)
{
	assert(arEncoding != NULL);

	// o
	INT nSize_Copy = static_cast<INT>(cSrcSize);
	const HRESULT hResult = m_pMultiLanguage2->DetectInputCodepage(
		nDetectFlag, dwPrefWinCodePage,
		const_cast<CHAR *>(pSrcStr), &nSize_Copy,
		arEncoding, &rnScores);

	wgc::wgfThrowIfFailed(hResult);
	return hResult;
}

// R[h̎o
UINT COM_XMultiLanguage2::AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize, const MLDETECTCP nDetectFlag /* = MLDETECTCP_NONE */, const DWORD dwPrefWinCodePage /* = 0 */)
{
	// o
	DetectEncodingInfo info;
	INT nScores = 1;

	AutoDetect(
		pSrcStr, cSrcSize,
		&info, nScores,
		nDetectFlag, dwPrefWinCodePage);

	if(nScores < 1)
	{
		return CODEPAGE_ERROR;
	}
	return info.nCodePage;
}


// w肳ꂽR[hy[Wɕϊł邩H
BOOL COM_XMultiLanguage2::CanConvertCodePage(LPCWSTR pSrcStr, const SIZE_T cSrcSize, const UINT uCodePage) const
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize      = 0;
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringFromUnicode(
		&dwMode, uCodePage,
		const_cast<WCHAR *>(pSrcStr), &cSrcSize_Copy,
		NULL, &cDstSize);

	wgc::wgfThrowIfFailed(hResult);
	return (hResult == S_OK);
}

BOOL COM_XMultiLanguage2::CanConvertCodePage(const wgc::wstring_t &wtext, const UINT uCodePage) const
{
	return CanConvertCodePage(wtext.c_str(), wtext.length(), uCodePage);
}


// R[hy[W uCodePage Ŏ镶 pSrcStr UnicodeɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertToUnicodeSize(LPCSTR pSrcStr, const SIZE_T cSrcSize, const UINT uCodePage)
{
	return ConvertToUnicode(
		pSrcStr, cSrcSize,
		NULL, 0,
		uCodePage);
}

// R[hy[W uCodePage Ŏ镶 pSrcStr Unicodeɕϊ
DWORD COM_XMultiLanguage2::ConvertToUnicode(LPCSTR pSrcStr, const SIZE_T cSrcSize, LPWSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize_Copy = static_cast<UINT>(cDstSize);
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringToUnicode(
		&dwMode, uCodePage,
		const_cast<CHAR *>(pSrcStr), &cSrcSize_Copy,
		pDstStr, &cDstSize_Copy);

	wgc::wgfThrowIfFailed(hResult);
	if(hResult != S_OK) { return static_cast<DWORD>(-1); }
	return cDstSize_Copy;
}

// R[hy[W uCodePage Ŏ镶 rSrcStr Unicodeɕϊ
DWORD COM_XMultiLanguage2::ConvertToUnicode(const wgc::string_t &rSrcStr, wgc::wstring_t &rDstStr, const UINT uCodePage)
{
	const DWORD dwSize = ConvertToUnicodeSize(rSrcStr.c_str(), rSrcStr.size(), uCodePage);

	rDstStr.resize(dwSize);
	return ConvertToUnicode(
		rSrcStr.c_str(), rSrcStr.size(),
		&rDstStr[0]    , rDstStr.size(),
		uCodePage);
}


// Unicode pSrcStr R[hy[W uCodePage ɕϊƂ̕Kv擾
DWORD COM_XMultiLanguage2::ConvertFromUnicodeSize(LPCWSTR pSrcStr, const SIZE_T cSrcSize, const UINT uCodePage)
{
	return ConvertFromUnicode(
		pSrcStr, cSrcSize,
		NULL, 0,
		uCodePage);
}

// Unicode pSrcStr R[hy[W uCodePage ɕϊ
DWORD COM_XMultiLanguage2::ConvertFromUnicode(LPCWSTR pSrcStr, const SIZE_T cSrcSize, LPSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage)
{
	DWORD dwMode = 0;
	UINT cSrcSize_Copy = static_cast<UINT>(cSrcSize);
	UINT cDstSize_Copy = static_cast<UINT>(cDstSize);
	const HRESULT hResult = m_pMultiLanguage2->ConvertStringFromUnicode(
		&dwMode, uCodePage,
		const_cast<WCHAR *>(pSrcStr), &cSrcSize_Copy,
		pDstStr, &cDstSize_Copy);

	wgc::wgfThrowIfFailed(hResult);
	if(hResult != S_OK) { return static_cast<DWORD>(-1); }
	return cDstSize_Copy;
}

// Unicode pSrcStr R[hy[W uCodePage ɕϊ
DWORD COM_XMultiLanguage2::ConvertFromUnicode(const wgc::wstring_t &rSrcStr, wgc::string_t &rDstStr, const UINT uCodePage)
{
	const DWORD dwSize = ConvertFromUnicodeSize(rSrcStr.c_str(), rSrcStr.size(), uCodePage);
	if(dwSize == static_cast<DWORD>(-1))
	{
		return dwSize;
	}

	rDstStr.resize(dwSize);
	return ConvertFromUnicode(
		rSrcStr.c_str(), rSrcStr.size(),
		&rDstStr[0]    , rDstStr.size(),
		uCodePage);
}

_WXC_END                                // }
