// DialogCommon.h cR_CAO
#ifndef __WGC_DIALOGCOMMON__
#define __WGC_DIALOGCOMMON__

#include "./Dialog.h"


#define IDAPPLY (12321)                 // Kp{^ID

_WGC_BEGIN                              // namespace wgc {


class DialogCommon : public Dialog
{
public:
	DialogCommon(HINSTANCE hResource, HWND hWndParent = NULL, LPCTSTR lpTemplate = NULL);
	~DialogCommon(void);

	// [_\
	INT_PTR DoModal   (const LPARAM dwInitParam = 0);
	BOOL    DoModeless(const LPARAM dwInitParam = 0);

protected:
	// _CAO\
	virtual BOOL CreateCommonDialog_Modal   (const LPARAM dwInitParam, INT_PTR &iResult) = 0;
	virtual BOOL CreateCommonDialog_Modeless(const LPARAM dwInitParam, INT_PTR &iResult) = 0;

	// TuNX
	void Subclass(HWND hWnd);
	void Unsubclass(void);

	// _CAOvV[W
	LRESULT _Default(void);
	BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	void OnOK(void);                        // OK{^
	void OnCancel(void);                    // LZ{^
	virtual void OnApply(void);             // Kp{^
	virtual void OnHelp(void);              // wv{^

private:
	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(DialogCommon)
};

_WGC_END                                // }

#endif // __WGC_DIALOGCOMMON__
