// DeviceContext.cpp cCve[Vt@C
#include "DeviceContext.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// foCXReLXg


////////////////////////////////////////////////////////////
// RXgNV

DeviceContext::DeviceContext(HDC hDC)
	: m_hDC(NULL)
{
	m_hDC = hDC;
}

DeviceContext::~DeviceContext(void)
{
}

void DeviceContext::Delete(void)
{
	const BOOL bResult = ::DeleteDC(m_hDC);
	if(!bResult)
	{
		wgfThrowLastError();
	}
	m_hDC = NULL;
}


void DeviceContext::GetTextMetrics(TEXTMETRIC &rMetrics) const
{
	const BOOL bResult = ::GetTextMetrics(m_hDC, &rMetrics);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

int DeviceContext::GetDeviceCaps(const int nIndex) const
{
	return ::GetDeviceCaps(m_hDC, nIndex);
}


////////////////////////////////////////////////////////////
// Iy[V

HGDIOBJ DeviceContext::SelectObject(GdiObject &rNewObject)
{
	return ::SelectObject(m_hDC, rNewObject);
}

HPEN DeviceContext::SelectObject(GdiPen &rNewPen)
{
	HGDIOBJ hOldObject = ::SelectObject(m_hDC, rNewPen);

	return reinterpret_cast<HPEN>(hOldObject);
}

HFONT DeviceContext::SelectObject(GdiFont &rNewFont)
{
	HGDIOBJ hOldObject = ::SelectObject(m_hDC, rNewFont);

	return reinterpret_cast<HFONT>(hOldObject);
}


////////////////////////////////////////////////////////////
// OiF/wiF

COLORREF DeviceContext::GetTextColor(void) const
{
	const COLORREF result = ::GetTextColor(m_hDC);
	if(result == CLR_INVALID)
	{
		wgfThrowLastError();
	}
	return result;
}

COLORREF DeviceContext::GetBkColor(void) const
{
	const COLORREF result = ::GetBkColor(m_hDC);
	if(result == CLR_INVALID)
	{
		wgfThrowLastError();
	}
	return result;
}

COLORREF DeviceContext::SetTextColor(const COLORREF color)
{
	const COLORREF result = ::SetTextColor(m_hDC, color);
	if(result == CLR_INVALID)
	{
		wgfThrowLastError();
	}
	return result;
}

COLORREF DeviceContext::SetBkColor(const COLORREF color)
{
	const COLORREF result = ::SetBkColor(m_hDC, color);
	if(result == CLR_INVALID)
	{
		wgfThrowLastError();
	}
	return result;
}


////////////////////////////////////////////////////////////
// obNOEh[h

int DeviceContext::GetBkMode(void)
{
	const int nResult = ::GetBkMode(m_hDC);
	if(nResult == 0)
	{
		wgfThrowLastError();
	}
	return nResult;
}

int DeviceContext::SetBkMode(const int iBkMode)
{
	const int nResult = ::SetBkMode(m_hDC, iBkMode);
	if(nResult == 0)
	{
		wgfThrowLastError();
	}
	return nResult;
}


////////////////////////////////////////////////////////////
// 

void DeviceContext::GetCharWidth(const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const
{
	const BOOL bResult = ::GetCharWidth(m_hDC, nFirstChar, nLastChar, lpBuffer);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::GetCharWidthWide(const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const
{
	const BOOL bResult = ::GetCharWidthW(m_hDC, nFirstChar, nLastChar, lpBuffer);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////
// NbsÖ

int DeviceContext::GetClipBox(RECT &rRect) const
{
	return ::GetClipBox(m_hDC, &rRect);
}

// VNbsÖ쐬
int DeviceContext::SetClipRect(const RECT &rRect)
{
	ClearClip();
	return IntersectClipRect(rRect);
}

// NbsÖNA
int DeviceContext::ClearClip(void)
{
	return ::SelectClipRgn(m_hDC, NULL);
}

// ݂̃NbsÖ rRect VNbsÖ쐬
int DeviceContext::IntersectClipRect(const RECT &rRect)
{
	return ::IntersectClipRect(
		m_hDC,
		rRect.left, rRect.top,
		rRect.right, rRect.bottom);
}

// ݂̃NbsÖ悩 rRect 菜
int DeviceContext::ExcludeClipRect(const RECT &rRect)
{
	return ::ExcludeClipRect(
		m_hDC,
		rRect.left, rRect.top,
		rRect.right, rRect.bottom);
}

BOOL DeviceContext::RectVisible(const RECT &rRect) const
{
	return ::RectVisible(m_hDC, &rRect);
}

BOOL DeviceContext::PtVisible(const POINT &rPoint) const
{
	return ::PtVisible(m_hDC, rPoint.x, rPoint.y);
}


////////////////////////////////////////////////////////////
// hԂ

void DeviceContext::FillRect(const RECT &rect, HBRUSH hBrush)
{
	const BOOL bResult = ::FillRect(m_hDC, &rect, hBrush);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::FillSolidRect(const RECT &rect, const COLORREF color)
{
	const POINT pt = {0, 0};
	SetBkColor(color);
	ExtTextOut(pt, ETO_OPAQUE, rect, tstring_t());
}

void DeviceContext::Invert(const RECT &rect)
{
	const BOOL bResult = ::InvertRect(m_hDC, &rect);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::Invert(HRGN hRgn)
{
	const BOOL bResult = ::InvertRgn(m_hDC, hRgn);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////
// `

void DeviceContext::DrawFocusRect(const RECT &rect)
{
	const BOOL bResult = ::DrawFocusRect(m_hDC, &rect);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::DrawEdge(
	const RECT &rect,
	const UINT edge     /* = EDGE_ETCHED */,
	const UINT grfFlags /* = BF_RECT */)
{
	RECT tmp = rect;
	const BOOL bResult = ::DrawEdge(m_hDC, &tmp, edge, grfFlags);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////

void DeviceContext::MoveToEx(
	const int x,
	const int y,
	LPPOINT lpPoint)
{
	const BOOL bResult = ::MoveToEx(m_hDC, x, y, lpPoint);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::MoveTo(
	const int x,
	const int y)
{
	MoveToEx(x, y, NULL);
}

void DeviceContext::LineTo(
	const int x,
	const int y)
{
	const BOOL bResult = ::LineTo(m_hDC, x, y);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::Polyline(
	const POINT ptVertexes[], const UINT nCount)
{
	const BOOL bResult = ::Polyline(m_hDC, ptVertexes, nCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::Polygon(const POINT ptVertexes[], const UINT nCount)
{
	const BOOL bResult = ::Polygon(m_hDC, ptVertexes, nCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::PolyPolyline(const POINT ptVertexes[], const DWORD dwPolyPoints[], const DWORD dwCount)
{
	const BOOL bResult = ::PolyPolyline(m_hDC, ptVertexes, dwPolyPoints, dwCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::PolyPolygon(const POINT ptVertexes[], const INT nPolyPoints[], const INT nCount)
{
	const BOOL bResult = ::PolyPolygon(m_hDC, ptVertexes, nPolyPoints, nCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////
// eLXg`

// P`
void DeviceContext::TextOut(const int x, const int y, LPCTSTR lpString, const int nCount)
{
	const BOOL bResult = ::TextOut(m_hDC, x, y, lpString, nCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::TextOut(const int x, const int y, const tstring_t &tstr)
{
	TextOut(
		x, y,
		tstr.c_str(),
		static_cast<int>(tstr.length()));
}

void DeviceContext::TextOut(const POINT &pt, LPCTSTR lpString, const int nCount)
{
	TextOut(pt.x, pt.y, lpString, nCount);
}

void DeviceContext::TextOut(const POINT &pt, const tstring_t &tstr)
{
	TextOut(pt.x, pt.y, tstr);
}

// PCh`
void DeviceContext::TextOutWide(const int x, const int y, LPCWSTR lpString, const int nCount)
{
	const BOOL bResult = ::TextOutW(m_hDC, x, y, lpString, nCount);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::TextOutWide(const int x, const int y, const wstring_t &wstr)
{
	TextOutWide(
		x, y,
		wstr.c_str(),
		static_cast<int>(wstr.length()));
}

void DeviceContext::TextOutWide(const POINT &pt, LPCWSTR lpString, const int nCount)
{
	TextOutWide(pt.x, pt.y, lpString, nCount);
}

void DeviceContext::TextOutWide(const POINT &pt, const wstring_t &wstr)
{
	TextOutWide(pt.x, pt.y, wstr);
}


// g`
void DeviceContext::ExtTextOut(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	LPCTSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	const BOOL bResult = ::ExtTextOut(
		m_hDC,
		x, y,
		fuOptions,
		&rect,
		lpString, nCount,
		lpDx);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::ExtTextOut(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	const tstring_t &tstr,
	const int *lpDx /* = NULL */)
{
	ExtTextOut(
		x, y,
		fuOptions,
		rect,
		tstr.c_str(), static_cast<UINT>(tstr.length()),
		lpDx);
}

void DeviceContext::ExtTextOut(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	LPCTSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	ExtTextOut(
		pt.x, pt.y,
		fuOptions,
		rect,
		lpString, nCount,
		lpDx);
}

void DeviceContext::ExtTextOut(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	const tstring_t &tstr,
	const int *lpDx /* = NULL */)
{
	ExtTextOut(
		pt.x, pt.y,
		fuOptions,
		rect,
		tstr,
		lpDx);
}


// gCh`
void DeviceContext::ExtTextOutWide(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	LPCWSTR lpString,
	const UINT nCount,
	const int *lpDx   /* = NULL */)
{
	const BOOL bResult = ::ExtTextOutW(
		m_hDC,
		x, y,
		fuOptions,
		&rect,
		lpString, nCount,
		lpDx);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void DeviceContext::ExtTextOutWide(
	const int x,
	const int y,
	const UINT fuOptions,
	const RECT &rect,
	const wstring_t &wstr,
	const int *lpDx   /* = NULL */)
{
	ExtTextOutWide(
		x, y,
		fuOptions,
		rect,
		wstr.c_str(), static_cast<UINT>(wstr.length()),
		lpDx);
}

void DeviceContext::ExtTextOutWide(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	LPCWSTR lpString,
	const UINT nCount /* = -1 */,
	const int *lpDx   /* = NULL */)
{
	ExtTextOutWide(
		pt.x, pt.y,
		fuOptions,
		rect,
		lpString, nCount,
		lpDx);
}

void DeviceContext::ExtTextOutWide(
	const POINT &pt,
	const UINT fuOptions,
	const RECT &rect,
	const wstring_t &wstr,
	const int *lpDx   /* = NULL */)
{
	ExtTextOutWide(
		pt.x, pt.y,
		fuOptions,
		rect,
		wstr,
		lpDx);
}


// Ct`
int DeviceContext::DrawText(LPCTSTR lpString, const int nCount, RECT &rect, const UINT uFormat /* = DT_LEFT | DT_NOPREFIX */)
{
	const int nResult = ::DrawText(
		m_hDC,
		lpString, nCount,
		&rect, uFormat);
	if(nResult == 0)
	{
		wgfThrowLastError();
	}
	return nResult;
}

int DeviceContext::DrawText(const tstring_t &tstr, RECT &rect, const UINT uFormat /* = DT_LEFT | DT_NOPREFIX */)
{
	return DrawText(
		tstr.c_str(),
		static_cast<int>(tstr.length()),
		rect,
		uFormat);
}


void DeviceContext::GetTextExtent(const tstring_t &tstr, SIZE &size) const
{
	const BOOL bResult = ::GetTextExtentPoint32(
		m_hDC,
		tstr.c_str(),
		static_cast<int>(tstr.length()),
		&size);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// GDIIuWFNg̎IJ
AutoSelectGDI::AutoSelectGDI(DeviceContext &dc, GdiObject &gdi)
	: m_dc(dc), m_gdiOld(dc.SelectObject(gdi))
{
}

AutoSelectGDI::~AutoSelectGDI(void)
{
	m_dc.SelectObject(m_gdiOld);
}


////////////////////////////////////////////////////////////////////////////////
// hDC

////////////////////////////////////////////////////////////////////////////////
// NCAgDC
DeviceContext_Client::DeviceContext_Client(HWND hWnd)
	: DeviceContext(::GetDC(hWnd))
{
	m_hWnd = hWnd;
}

DeviceContext_Client::~DeviceContext_Client(void)
{
	::ReleaseDC(m_hWnd, m_hDC);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// EChEDC
DeviceContext_Window::DeviceContext_Window(HWND hWnd)
	: DeviceContext(::GetWindowDC(hWnd))
{
	m_hWnd = hWnd;
}

DeviceContext_Window::~DeviceContext_Window(void)
{
	::ReleaseDC(m_hWnd, m_hDC);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// yCgDC
DeviceContext_Paint::DeviceContext_Paint(HWND hWnd, LPPAINTSTRUCT lpPaint /* = NULL */)
	: DeviceContext(::BeginPaint(hWnd, &m_ps))
{
	m_hWnd = hWnd;
	if(lpPaint != NULL)
	{
		*lpPaint = m_ps;
	}
}

DeviceContext_Paint::~DeviceContext_Paint(void)
{
	::EndPaint(m_hWnd, &m_ps);
	m_hDC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// DC
DeviceContext_Memory::DeviceContext_Memory(HDC hDC)
	: DeviceContext(::CreateCompatibleDC(hDC))
{
}

DeviceContext_Memory::~DeviceContext_Memory(void)
{
	Delete();
}


////////////////////////////////////////////////////////////////////////////////
// v^DC
DeviceContext_Printer::DeviceContext_Printer(
	LPCTSTR lpszDriver,
	LPCTSTR lpszDevice,
	CONST DEVMODE *lpInitData /* = NULL */)
	: DeviceContext(::CreateDC(lpszDriver, lpszDevice, NULL, lpInitData))
{
}

DeviceContext_Printer::~DeviceContext_Printer(void)
{
	Delete();
}

int DeviceContext_Printer::StartDoc(const DOCINFO &rDocInfo)
{
	return ::StartDoc(m_hDC, &rDocInfo);
}

int DeviceContext_Printer::EndDoc(void)
{
	return ::EndDoc(m_hDC);
}

int DeviceContext_Printer::AbortDoc(void)
{
	return ::AbortDoc(m_hDC);
}

int DeviceContext_Printer::StartPage(void)
{
	return ::StartPage(m_hDC);
}

int DeviceContext_Printer::EndPage(void)
{
	return ::EndPage(m_hDC);
}

_WGC_END                                // }
