// undo_buffer.h cAhDobt@̃ev[gNX
#ifndef __SGC_UNDO_BUFFER__
#define __SGC_UNDO_BUFFER__

#include "sgc.h"
#include <assert.h>                     // assert()
#include <deque>                        // std::deque<>

_SGC_BEGIN

template<typename _Ty>
class undo_buffer
{
public:
	////////////////////////////////////////////////////////////////////////////////
	// o֐

	// RXgN^
	undo_buffer(void)
	{
		m_now   = -1;
		m_saved = -1;
		m_limit = -1;
	}

	// fXgN^
	~undo_buffer(void)
	{
	}


	// f[^vbV
	bool push(const _Ty &data)
	{
		// hDX^bNɂ
		_ShrinkRedoStack();

		try
		{
			// obt@Ƀf[^ǉ
			m_buffer.push_back(data);

			// őAhD񐔂I[o[擪̃f[^폜
			// i0 <= limit && limit < get_buffer_size() ̒Zk`j
			const uintptr_t limit = static_cast<uintptr_t>(get_limit());
			if(limit < get_buffer_size())
			{
				m_buffer.pop_front();
				if(m_saved > INDEX_NOT_REACH) { m_saved--; }
			}
			// I[o[ĂȂΌ݈ʒũCfbNXCNg
			else
			{
				m_now++;
			}
			return true;
		}
		catch(std::bad_alloc)
		{
			return false;
		}
	}

	// őAhD񐔂ݒ
	intptr_t set_limit(const intptr_t limit = -1)
	{
		// X^bNZ
		if(static_cast<size_t>(limit) < m_buffer.size())
		{
			// ɃAhDX^bNZ
			const intptr_t undo_size = get_undo_count() - limit;
			if(undo_size >= 0)
			{
				_ShrinkUndoStack(undo_size);
			}
			else
			{
				_ShrinkUndoStack();

				// Ȃ΃hDX^bNZ
				const intptr_t redo_size = get_redo_count() - limit;
				assert(redo_size >= 0);
				_ShrinkRedoStack(redo_size);
			}
		}
		m_limit = limit;
		return limit;
	}

	// 
	bool     is_modified    (void) const { return m_now != m_saved; }
	bool     can_undo       (void) const { return static_cast<size_t>(m_now + 1) > 0; }
	bool     can_redo       (void) const { return static_cast<size_t>(m_now + 1) < m_buffer.size(); }
	intptr_t get_limit      (void) const { return m_limit; }
	size_t   get_buffer_size(void) const { return m_buffer.size(); }
	size_t   get_undo_count (void) const { return static_cast<size_t>(m_now + 1); }
	size_t   get_redo_count (void) const { return get_buffer_size() - (m_now + 1); }

	// _[eB[tO̐ݒ
	void set_modify(const bool modified = true)
	{
		m_saved = modified ? INDEX_NOT_REACH : m_now;
	}

	// AhD
	bool undo(_Ty &data)
	{
		if(!can_undo()) { return false; }

		data = m_buffer[m_now--];
		return true;
	}

	// hD
	bool redo(_Ty &data)
	{
		if(!can_redo()) { return false; }

		data = m_buffer[++m_now];
		return true;
	}

	// NA
	void clear(void)
	{
		if(m_buffer.empty()) { return; }

		if(is_modified())
		{
			m_saved = INDEX_NOT_REACH;
		}
		else
		{
			m_saved = -1;
		}
		m_now = -1;

		m_buffer.clear();
	}

private:
	enum { INDEX_NOT_REACH = -2 };

	std::deque<_Ty> m_buffer;               // AhDobt@
	intptr_t        m_now;                  // ݈ʒu
	intptr_t        m_saved;                // ۑʒu
	intptr_t        m_limit;                // őAhD񐔁i-1j

	// AhDX^bNZ
	void _ShrinkUndoStack(const size_t size = 0)
	{
		const size_t new_size = (m_now + 1) - size;
		for(size_t i = 0; i < new_size; i++)
		{
			// hDX^bNƈႢCɒZłȂ̂ŁA1o
			m_buffer.pop_front();
		}
		m_now   -= new_size;
		m_saved -= new_size;
	}

	// hDX^bNZ
	void _ShrinkRedoStack(const size_t size = 0)
	{
		const size_t new_size = (m_now + 1) + size;
		if(new_size < m_buffer.size())
		{
			// obt@̃TCY邱ƂɂZ
			m_buffer.resize(new_size);
		}
	}
};

_SGC_END


#endif // __SGC_UNDO_BUFFER__
