// sgc.h c Shimataro's Generalized Component
#ifndef __SGC__
#define __SGC__

#include <stddef.h>
#include <string>


// z̗vf
#ifndef countof
#	define countof(array)  (sizeof(array) / sizeof(array[0]))
#endif

// sgc O
#define _SGC_BEGIN  namespace sgc {
#define _SGC_END    }
#define _SGC_USING  using namespace sgc;

_SGC_BEGIN


////////////////////////////////////////////////////////////////////////////////
// ^

// bitwɂ鐮
typedef   signed char       int8_t;
typedef unsigned char      uint8_t;
typedef   signed short      int16_t;
typedef unsigned short     uint16_t;
typedef   signed long       int32_t;
typedef unsigned long      uint32_t;
typedef   signed long long  int64_t;
typedef unsigned long long uint64_t;

// RpC̍œKȐ
typedef  intptr_t  integer_t;
typedef uintptr_t uinteger_t;

// Ch
typedef std::wstring wstring_t;


////////////////////////////////////////////////////////////////////////////////
// 
typedef enum _exception_t
{
	SGCEXP_SUCCESS = 0,                     // 
	SGCEXP_SIZE_MISMATCH,                   // TCYvȂ
} exception_t;


////////////////////////////////////////////////////////////////////////////////
// \
typedef struct _position_t
{
	intptr_t x;
	intptr_t y;

	// rZq
	bool operator==(const _position_t &rhs) const
	{
		return x == rhs.x && y == rhs.y;
	}
	bool operator<(const _position_t &rhs) const
	{
		if(y < rhs.y) { return true ; }
		if(y > rhs.y) { return false; }
		if(x < rhs.x) { return true ; }
		return false;
	}
	bool operator!=(const _position_t &rhs) const { return !(*this == rhs); }
	bool operator<=(const _position_t &rhs) const { return *this == rhs || *this < rhs; }
	bool operator> (const _position_t &rhs) const { return rhs <  *this; }
	bool operator>=(const _position_t &rhs) const { return rhs <= *this; }
} position_t;


////////////////////////////////////////////////////////////////////////////////
// NX̑OQ
template<typename _Ty> class array;
template<typename _Ty> class string_search;
class edit_manager;
class keyword_manager;


////////////////////////////////////////////////////////////////////////////////
// ֐
void init(void);                        // 
void illegal_access(void);              // sȃANZXifobOpj

_SGC_END

#endif // __SGC__
