// edit_manager.cpp cCve[Vt@C
#include "edit_manager.h"
#include <assert.h>                     // assert()


_SGC_BEGIN                              // namespace sgc {


////////////////////////////////////////////////////////////////////////////////
// public֐

////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
edit_manager::edit_manager(void)
{
	// X^C
	m_style.readonly = false;

	set_text(NULL, 0);

	select_clear();
}

// fXgN^
edit_manager::~edit_manager(void)
{
}


////////////////////////////////////////////////////////////
// 

// ݍs擾
void edit_manager::get_line(wstring_t &line, const wchar_t quote_mark /* = charcode::wNUL */) const
{
	m_pos.it->get_line(line, !is_end());
	if(quote_mark != charcode::wNUL && !line.empty()) { line = quote_mark + line; }
}

// sTCY擾
size_t edit_manager::get_line_count(void) const
{
	return m_buffer.size();
}

// P̋؂
size_t edit_manager::find_word_break(const bool forward /* = true */) const
{
	return _FindWordBreak(m_pos.it->c_str(), m_pos.it->length(), m_pos.xy.x, forward);
}

// 擪H
bool edit_manager::is_begin(void) const
{
	return m_buffer.begin() == m_pos.it;
}

// H
bool edit_manager::is_end(void) const
{
	const_iterator_t p = m_pos.it;
	return m_buffer.end() == ++p;
}

// sH
bool edit_manager::is_head(void) const
{
	return m_pos.xy.x == 0;
}

// sH
bool edit_manager::is_tail(void) const
{
	return static_cast<size_t>(m_pos.xy.x) == m_pos.it->length();
}


////////////////////////////////////////////////////////////
// W

// ݈ʒu擾
position_t edit_manager::get_xy(void) const
{
	return m_pos.xy;
}

// ݈ʒuݒ
edit_manager::const_iterator_t edit_manager::set_xy(const position_t &position, const move_select_t select_status /* = MS_CLEAR */)
{
	// Ky,x̏Őݒ肷邱
	set_y(position.y, select_status);
	set_x(position.x, select_status);

	return m_pos.it;
}

// XW擾
intptr_t edit_manager::get_x(void) const
{
	return m_pos.xy.x;
}

// YW擾
intptr_t edit_manager::get_y(void) const
{
	return m_pos.xy.y;
}

// XWݒ
intptr_t edit_manager::set_x(const intptr_t x, const move_select_t select_status /* = MS_CLEAR */)
{
	const size_t length = m_pos.it->length();

	// 
	intptr_t x2 = x;
	if(static_cast<size_t>(x2) > length) { x2 = length; }

	m_pos.xy.x = x2;

	// I͈͂XV
	_SetSelectStatus(select_status);

	return m_pos.xy.x;
}

// YWݒ
intptr_t edit_manager::set_y(const intptr_t y, const move_select_t select_status /* = MS_CLEAR */)
{
	const linenumber_t lines = _GetPosition(y + 1, m_pos.it);
	m_pos.xy.y = lines - 1;

	// xWI0ɂ
	// i̖ŕK݂xWړ̍œKȏꏊƂ͌Ȃ߁AU0ɂj
	m_pos.xy.x = 0;

	// I͈͂XV
	_SetSelectStatus(select_status);

	return m_pos.xy.y;
}

intptr_t edit_manager::shift_x(const intptr_t dx, const move_select_t select_status /* = MS_CLEAR */)
{
	const intptr_t x = m_pos.xy.x + dx;
	return set_x(x, select_status);
}

intptr_t edit_manager::shift_y(const intptr_t dy, const move_select_t select_status /* = MS_CLEAR */)
{
	intptr_t y = m_pos.xy.y + dy;
	if(y < 0) { y = 0; }
	return set_y(y, select_status);
}


////////////////////////////////////////////////////////////
// Ce[^

// wsiYWj̃Ce[^擾
edit_manager::const_iterator_t edit_manager::get_iterator(const linenumber_t y) const
{
	edit_manager::const_iterator_t p;
	_GetPosition(y, p);

	return p;
}

// 擪ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_begin(void) const
{
	return m_buffer.begin();
}

// ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_end(void) const
{
	return m_buffer.end();
}

// ݈ʒũCe[^擾
edit_manager::const_iterator_t edit_manager::get_iterator_now(void) const
{
	return m_pos.it;
}


////////////////////////////////////////////////////////////
// ̐ݒ/擾

// ֎~̐ݒ
void edit_manager::set_readonly(const bool readonly /* = true */)
{
	m_style.readonly = readonly;
}

// ֎~H
bool edit_manager::is_readonly(void) const
{
	return m_style.readonly;
}

// _[eB[tO̐ݒ
void edit_manager::set_modify(const bool modify /* = true */)
{
	m_undo_buffer.set_modify(modify);
}

// hLgύXĂ邩H
bool edit_manager::is_modified(void) const
{
	return m_undo_buffer.is_modified();
}


////////////////////////////////////////////////////////////
// ҏW

////////////////////////////////////////
// AhD/hD

// AhD
bool edit_manager::undo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.undo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text.size() != 1);

	if(info.insert)
	{
		// ͂ꂽ폜
		_Delete(info.text);
	}
	else
	{
		// 폜ꂽ𕜊
		_Insert(info.text, false, info.move_cursor);
	}
	return true;
}

// hD
bool edit_manager::redo(modify_info &mi)
{
	if(is_readonly()) { return false; }

	undo_info info;
	if(!m_undo_buffer.redo(info)) { return false; }

	set_xy(info.position);

	mi.modified_line         = info.position.y;
	mi.is_modified_linecount = (info.text.size() != 1);

	if(info.insert)
	{
		// }
		_Insert(info.text, false, info.move_cursor);
	}
	else
	{
		// 폜
		_Delete(info.text);
	}
	return true;
}

// AhDł邩H
bool edit_manager::can_undo(void) const
{
	return m_undo_buffer.can_undo();
}

// hDł邩H
bool edit_manager::can_redo(void) const
{
	return m_undo_buffer.can_redo();
}

// őAhD񐔂ݒ
intptr_t edit_manager::set_undo_limit(const intptr_t limit /* = -1 */)
{
	return m_undo_buffer.set_limit(limit);
}

// AhDobt@NA
void edit_manager::empty_undo_buffer(void)
{
	m_undo_buffer.clear();
}


////////////////////////////////////////
// obt@

// ݂̃obt@jĉsteLXgݒiǂݍݐp[hłIɐݒ肷j
bool edit_manager::set_text(const wchar_t *text, const size_t size)
{
	try
	{
		// {block}
		// eLXgݒ
		{
			linelist_t buffer;
			_CreateLineList(text, size, buffer);

			m_buffer.clear();
			m_buffer.splice(m_buffer.end(), buffer);
		}

		// {block}
		// ݈ʒuobt@̐擪ɂ
		{
			const position_t pos = {0, 0};
			set_xy(pos);
		}

		empty_undo_buffer();
		set_modify  (false);
		set_readonly(false);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}


// ݈ʒuɉsteLXg}
bool edit_manager::insert_text(const wchar_t *text, const size_t size, modify_info &mi, const wchar_t quote_mark /* = charcode::wNUL */, const move_select_t select_status /* = MS_CLEAR */)
{
	if(is_readonly()) { return false; }
	if(size == 0    ) { return false; }

	try
	{
		linelist_t buffer;
		_CreateLineList(text, size, buffer, quote_mark);

		// AhDobt@֒ǉ
		_PushUndo(buffer, m_pos.xy);

		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = (buffer.size() > 1);

		_Insert(buffer, true, true, select_status);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒuɉs}
bool edit_manager::insert_linefeed(modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	if(is_readonly()) { return false; }

	try
	{
		iterator_t p = m_pos.it;

		// ff
		assert(static_cast<size_t>(m_pos.xy.x) <= p->length());

		// s2܂ރobt@쐬
		linelist_t buffer;
		buffer.push_back(edit_line());
		buffer.push_back(edit_line());

		// AhDobt@֒ǉ
		_PushUndo(buffer, m_pos.xy);

		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = true;

		// obt@̓e}
		_Insert(buffer, true, true, select_status);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// }
bool edit_manager::insert_string(const wstring_t &wstr, modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	return insert_string(wstr.c_str(), wstr.length(), mi, select_status);
}

// }
bool edit_manager::insert_string(const wchar_t *wstr, const size_t length, modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	if(is_readonly()) { return false; }
	if(length == 0  ) { return false; }

	// ff
	assert(static_cast<size_t>(m_pos.xy.x) <= m_pos.it->length());

	try
	{
		linelist_t buffer(1, edit_line(wstr, length));

		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = false;

		// AhDobt@֒ǉ
		_PushUndo(buffer, m_pos.xy);

		// }
		_Insert(buffer, true, true, select_status);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ㏑
bool edit_manager::overwrite_string(const wstring_t &wstr, modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	return overwrite_string(wstr.c_str(), wstr.length(), mi, select_status);
}

// ㏑
bool edit_manager::overwrite_string(const wchar_t *wstr, const size_t length, modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	if(is_readonly()) { return false; }
	if(length == 0  ) { return false; }

	// ff
	assert(static_cast<size_t>(m_pos.xy.x) <= m_pos.it->length());

	try
	{
		mi.modified_line         = m_pos.xy.y;
		mi.is_modified_linecount = false;

		// {block}
		// 폜
		{
			wstring_t str_delete(m_pos.it->substr(m_pos.xy.x, length));

			// AhDobt@֒ǉ
			_PushUndo(linelist_t(1, edit_line(str_delete)), m_pos.xy, true, false);
		}

		// {block}
		// ㏑
		{
			// AhDobt@֒ǉ
			_PushUndo(linelist_t(1, edit_line(wstr, length)), m_pos.xy);

			mi.modified_line         = m_pos.xy.y;
			mi.is_modified_linecount = false;

			m_pos.it->overwrite(m_pos.xy.x, wstr, length);
		}

		shift_x(length);

		_SetSelectStatus(select_status);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݈ʒu̕폜
bool edit_manager::delete_char(const bool forward, modify_info &mi, const move_select_t select_status /* = MS_CLEAR */)
{
	if(is_readonly()) { return false; }

	try
	{
		undo_info info;
		info.insert = false;

		position_t sel_begin, sel_end;
		_SelectGetRange(sel_begin, sel_end);

		// ̕폜
		if(forward)
		{
			info.move_cursor = false;

			// s̏ꍇ
			const intptr_t length = m_pos.it->length();
			if(m_pos.xy.x == length)
			{
				// obt@̖ȂI
				const intptr_t size = m_buffer.size() - 1;
				if(m_pos.xy.y == size) { return false; }

				// I͈͂𒲐
				if(m_pos.xy < sel_begin)
				{
					if(m_pos.xy.y < sel_begin.y - 1)
					{
						sel_begin.y--;
					}
					if(m_pos.xy.y == sel_begin.y - 1)
					{
						sel_begin.y--;
						sel_begin.x += m_pos.it->length();
					}
				}
				if(m_pos.xy < sel_end)
				{
					if(m_pos.xy.y < sel_end.y - 1)
					{
						sel_end.y--;
					}
					if(m_pos.xy.y == sel_end.y - 1)
					{
						sel_end.y--;
						sel_end.x += m_pos.it->length();
					}
				}

				// {block}
				// 폜i[
				{
					iterator_t pos = m_pos.it;
					info.text.push_back(edit_line(pos->lf_type()));
					info.text.push_back(edit_line());
				}

				// ̍sƘA
				_Combine(m_pos, true, mi);
				goto push_undo;
			}
		}
		// O̕폜
		else
		{
			info.move_cursor = true;

			// s̏ꍇ
			if(m_pos.xy.x == 0)
			{
				// obt@̐擪ȂI
				if(m_pos.xy.y == 0) { return false; }

				// I͈͂𒲐
				if(m_pos.xy < sel_begin)
				{
					if(m_pos.xy.y < sel_begin.y)
					{
						sel_begin.y--;
					}
					if(m_pos.xy.y == sel_begin.y)
					{
						iterator_t it = m_pos.it;
						it--;
						sel_begin.y--;
						sel_begin.x += it->length();
					}
				}
				if(m_pos.xy < sel_end)
				{
					if(m_pos.xy.y < sel_end.y)
					{
						sel_end.y--;
					}
					if(m_pos.xy.y == sel_end.y)
					{
						iterator_t it = m_pos.it;
						it--;
						sel_end.y--;
						sel_end.x += it->length();
					}
				}

				// {block}
				// 폜i[
				{
					iterator_t pos = m_pos.it;
					pos--;
					info.text.push_back(edit_line(pos->lf_type()));
					info.text.push_back(edit_line());
				}

				// O̍sƘA
				_Combine(m_pos, false, mi);
				goto push_undo;
			}
			m_pos.xy.x--;
		}

		// I͈͂𒲐
		if(m_pos.xy < sel_begin)
		{
			if(m_pos.xy.y == sel_begin.y) { sel_begin.x--; }
		}
		if(m_pos.xy < sel_end)
		{
			if(m_pos.xy.y == sel_end.y) { sel_end.x--; }
		}

		// {block}
		// 폜
		{
			wstring_t deleted_string;
			m_pos.it->erase(m_pos.xy.x, 1, &deleted_string);
			info.text.assign(1, edit_line(deleted_string));

			mi.modified_line         = m_pos.xy.y;
			mi.is_modified_linecount = false;
		}

push_undo:
		// AhDobt@֒ǉ
		info.position = m_pos.xy;
		m_undo_buffer.push(info);

		_SetSelectStatus(select_status);
		return true;
	}
	catch(std::bad_alloc)
	{
		return false;
	}
}

// ݍs폜
bool edit_manager::delete_line(modify_info &mi)
{
	if(is_readonly()) { return false; }

	// I͈͂IɃNA
	select_clear();

	mi.is_modified_linecount = true;
	mi.modified_line         = m_pos.xy.y;

	undo_info info;
	info.move_cursor = false;
	info.insert      = false;
	info.position    = m_pos.xy;

	// ŏIsȂsɂ邾isԍ̕ύX͂Ȃj
	if(is_end())
	{
		if(m_pos.it->length() == 0)
		{
			return false;
		}
		info.text.assign(1, *m_pos.it);

		m_pos.it->erase(0);
		m_pos.xy.x = 0;
		mi.is_modified_linecount = false;
	}
	else
	{
		// ŏIsłȂΌݍs폜
		linelist_t::iterator p = m_pos.it++;
		info.text.assign(1, *p);
		info.text.push_back(edit_line());

		m_buffer.erase(p);
		m_pos.xy.x = 0;
	}

	m_undo_buffer.push(info);
	return true;
}

// modify_info}[W
void edit_manager::merge_modify_info(const modify_info mi_array[], const size_t count, modify_info &mi)
{
	mi.is_modified_linecount = false;
	mi.modified_line         = static_cast<linenumber_t>(-1);
	for(size_t i = 0; i < count; i++)
	{
		if(mi_array[i].is_modified_linecount           ) { mi.is_modified_linecount = true; }
		if(mi_array[i].modified_line < mi.modified_line) { mi.modified_line         = mi_array[i].modified_line; }
	}
}


////////////////////////////////////////////////////////////////
// I

// ݈ʒu̒PI
void edit_manager::select_word(const select_cursor_t cursor_pos /* = SC_NOMOVE */, const bool update_selection /* = false */)
{
	// ݈ʒuɁAJeSɑ镶݂̂I
	const wchar_t *line   = m_pos.it->c_str();
	const size_t   length = m_pos.it->length();
	const size_t x = m_pos.xy.x;

	bool end_forward = true;
	if(!update_selection)
	{
		m_select.begin = m_pos.xy;
		m_select.begin.x = _FindWordBreak(line, length, x, false);
	}
	else
	{
		end_forward = (m_pos.xy > m_select.begin);
	}
	m_select.end   = m_pos.xy;
	m_select.end.x = _FindWordBreak(line, length, x, end_forward);

	// J[\ʒu
	switch(cursor_pos)
	{
	case SC_BEGIN:
		m_pos.xy.x = m_select.begin.x;
		break;

	case SC_END:
		m_pos.xy.x = m_select.end.x;
		break;
	}
}

// ݍsI
void edit_manager::select_line(const select_cursor_t cursor_pos /* = SC_NOMOVE */, const bool update_selection /* = false */)
{
	// Jnʒu̐ݒ
	if(!update_selection)
	{
		m_select.begin   = m_pos.xy;
		m_select.begin.x = 0;
	}

	// Iʒu̐ݒ
	m_select.end = m_pos.xy;
	if(!update_selection || m_select.end > m_select.begin)
	{
		if(is_end())
		{
			// ݍsobt@̏I[ȂIʒu݈ʒu̖
			m_select.end.x = m_pos.it->length();
		}
		else
		{
			// I[łȂΏIʒu̍s̐擪
			m_select.end.x = 0;
			m_select.end.y++;
		}
	}
	else
	{
		m_select.end.x = 0;
	}

	// J[\ʒu
	switch(cursor_pos)
	{
	case SC_BEGIN:
		m_pos.xy = m_select.begin;
		break;

	case SC_END:
		// {block}
		{
			position_t xy = m_select.end;
			iterator_t it;
			_GetPosition(xy.y + 1, it);
			m_pos.xy = xy;
			m_pos.it = it;
		}
		break;
	}
}

// SđI
void edit_manager::select_all(void)
{
	// {block}
	{
		m_select.begin.x = 0;
		m_select.begin.y = 0;
	}
	// {block}
	{
		const_iterator_t it = m_buffer.end(); it--;
		m_select.end.x = it->length();
		m_select.end.y = m_buffer.size() - 1;
	}
}

// I
void edit_manager::select_clear(const select_cursor_t cursor_pos /* = SC_NOMOVE */)
{
	// J[\ʒuݒ
	if(cursor_pos != SC_NOMOVE)
	{
		position_t begin, end;
		_SelectGetRange(begin, end);

		switch(cursor_pos)
		{
		case SC_BEGIN:
			// {block}
			{
				_GetPosition(begin.y + 1, m_pos.it);
				m_pos.xy = begin;
			}
			break;

		case SC_END:
			// {block}
			{
				_GetPosition(end.y + 1, m_pos.it);
				m_pos.xy = end;
			}
			break;
		}
	}
	m_select.begin = m_select.end = m_pos.xy;
}

// I͈͂폜
bool edit_manager::select_delete(const bool move_cusror, modify_info &mi)
{
	if( is_readonly()) { return false; }
	if(!is_selected()) { return false; }

	position_t begin, end;
	_SelectGetRange(begin, end);

	// {block}
	{
		undo_info info;

		// ͈͂폜
		_RangeDelete(begin, end, info, mi);
		select_clear();

		info.move_cursor = move_cusror;
		m_undo_buffer.push(info);
	}

	return true;
}

// I͈͂̃eLXg擾
void edit_manager::select_get_text(wstring_t &wtext, const wchar_t quote_mark /* = charcode::wNUL */) const
{
	if(!is_selected()) { return; }

	position_t begin, end;
	_SelectGetRange(begin, end);

	// JnʒũCe[^擾
	const_iterator_t p;
	_GetPosition(begin.y + 1, p);

	// 1sIĂȂꍇ
	if(begin.y == end.y)
	{
		if(quote_mark != charcode::wNUL) { wtext = quote_mark + wtext; }
		wtext += p->substr(begin.x, end.x - begin.x);
	}
	// sIĂꍇ
	else
	{
		// 1s
		if(quote_mark != charcode::wNUL) { wtext = quote_mark; }
		wtext += p->substr(begin.x);
		wtext += charcode::get_linefeed_string(p->lf_type());

		// 2sځ`ŏIs-1s
		p++;
		for(intptr_t i = begin.y + 1; i < end.y; i++)
		{
			if(quote_mark != charcode::wNUL) { wtext += quote_mark; }

			wstring_t line;
			p->get_line(line);

			wtext += line;
			p++;
		}

		// ŏIs
		if(p != m_buffer.end())
		{
			wstring_t line = p->substr(0, end.x);

			if(quote_mark != charcode::wNUL && !line.empty()) { line = quote_mark + line; }
			wtext += line;
		}
	}
}

// IJnEIʒu擾
void edit_manager::select_get_range(position_t &begin, position_t &end) const
{
	_SelectGetRange(begin, end);
}

// IĂ邩H
bool edit_manager::is_selected(void) const
{
	// JnʒuIʒuȂtrue^łȂfalse
	return (m_select.begin != m_select.end);
}


////////////////////////////////////////////////////////////////////////////////
// protected֐

// AhDobt@ɒǉ
void edit_manager::_PushUndo(const linelist_t &text, const position_t &position, const bool move_cursor /* = true */, const bool insert /* = true */)
{
	undo_info info;
	info.move_cursor = move_cursor;
	info.insert      = insert;
	info.position    = position;
	info.text        = text;

	m_undo_buffer.push(info);
}

// posƎorO̍sA
bool edit_manager::_Combine(pos_t &pos, const bool forward, modify_info &mi)
{
	iterator_t it_end = pos.it;             // Ai폜鑤j

	// ̍sƘA
	if(forward)
	{
		const_iterator_t it_next = pos.it;
		if(++it_next == get_iterator_end()) { return false; }

		// A̍s
		it_end++;
	}
	// O̍sƘA
	else
	{
		if(pos.it == get_iterator_begin()) { return false; }

		// A恁O̍s
		pos.it--;
		pos.xy.y--;
	}

	mi.modified_line         = pos.xy.y;
	mi.is_modified_linecount = true;

	pos.xy.x = pos.it->length();

	// A
	*(pos.it) += *it_end;
	m_buffer.erase(it_end);

	return true;
}


// it̑Oiorjcounts폜
void edit_manager::_Delete(iterator_t &it, const size_t count /* = 1 */, const bool forward /* = true */)
{
	iterator_t begin = it;
	iterator_t end   = it;

	// O폜
	if(forward)
	{
		for(size_t i = 0; i < count; i++)
		{
			if(end == m_buffer.end())
			{
				break;
			}
			end++;
		}
	}
	// 폜
	else
	{
		for(size_t i = 0; i < count; i++)
		{
			if(begin == m_buffer.begin())
			{
				break;
			}
			begin--;
		}
	}

	// pos͍폜s̎w
	it = m_buffer.erase(begin, end);
}

// ݈ʒuobt@e폜imɂ́Aobt@eƓ̕폜j
// undo() / redo() Ŏgp
void edit_manager::_Delete(const linelist_t &buffer)
{
	if(buffer.empty()) { return; }

	const size_t delete_lines = buffer.size();

	position_t sel_begin, sel_end;
	_SelectGetRange(sel_begin, sel_end);

	// Eij폜
	if(delete_lines >= 2)
	{
		// I͈͂𒲐
		if(m_pos.xy < m_select.begin)
		{
			const_iterator_t it = buffer.end();
			it--;

			m_select.begin.y -= (delete_lines - 1);
			m_select.begin.x -= it->length();
			if(m_select.begin.y == m_pos.xy.y)
			{
				m_select.begin.x += m_pos.xy.x;
			}
		}
		if(m_pos.xy < m_select.end)
		{
			const_iterator_t it = buffer.end();
			it--;

			m_select.end.y -= (delete_lines - 1);
			m_select.end.x -= it->length();
			if(m_select.end.y == m_pos.xy.y)
			{
				m_select.end.x += m_pos.xy.x;
			}
		}

		iterator_t pos = m_pos.it;
		pos++;
		_Delete(pos, delete_lines - 2);

		const edit_line rear  = pos->substr(buffer.back().length()); pos--;
		const edit_line front = pos->substr(0, pos->length() - buffer.front().length());
		_Delete(pos, 2);

		m_pos.it = m_buffer.insert(pos, front + rear);
	}
	else
	{
		const size_t length = buffer.front().length();
		m_pos.it->erase(m_pos.xy.x, length);
	}
}

// ݈ʒubuffer}
void edit_manager::_Insert(linelist_t &buffer, const bool move_buffer /* = true */, const bool move_cursor /* = true */, const move_select_t select_status /* = MS_NOCHANGE */)
{
	if(buffer.empty()) { return; }

	const size_t lines  = buffer.size();
	const size_t length = buffer.back().length();

	// {block}
	// I͈͂𒲐
	{
		if(m_pos.xy < m_select.begin)
		{
			m_select.begin.y += (lines - 1);
			if(m_pos.xy.y == m_select.begin.y)
			{
				m_select.begin.x += length;
				if(lines > 1) { m_select.begin.x -= m_pos.xy.x; }
			}
		}
		if(m_pos.xy < m_select.end)
		{
			m_select.end.y += (lines - 1);
			if(m_pos.xy.y == m_select.end.y)
			{
				m_select.end.x += length;
				if(lines > 1) { m_select.end.x -= m_pos.xy.x; }
			}
		}
	}

	// {block}
	// obt@̓e}
	{
		// splice() p̃obt@쐬
		linelist_t buffer_tmp;
		if(move_buffer)
		{
			buffer_tmp.splice(buffer_tmp.end(), buffer);
		}
		else
		{
			buffer_tmp = buffer;
		}

		// {block}
		// ݈ʒu̕obt@̑Oɒǉ
		{
			// ݈ʒu̕𕪊
			edit_line front, rear;
			m_pos.it->split(m_pos.xy.x, front, rear);

			// O̕ǉ
			buffer_tmp.front() = front + buffer_tmp.front();
			buffer_tmp.back () = buffer_tmp.back() + rear;
		}

		// {block}
		// }
		{
			iterator_t p = m_pos.it;
			m_buffer.splice(++p, buffer_tmp);
		}
	}

	// {block}
	// ݈ʒu폜
	{
		// 폜OɌ݈ʒũCe[^1i߂
		iterator_t p = m_pos.it++;
		_Delete(p);
	}

	// ʒuXV
	if(move_cursor)
	{
		size_t x = length;
		if(lines == 1) { x += m_pos.xy.x; }

		shift_y(lines - 1, MS_NOCHANGE);
		set_x(x, MS_NOCHANGE);
	}

	_SetSelectStatus(select_status);
}


// P̋E
size_t edit_manager::_FindWordBreak(const wchar_t *line, const size_t length, const size_t pos, const bool forward /* = true */) const
{
	size_t idx = pos;

	// 擪
	if(forward)
	{
		if(pos >= length) { return pos; }
		const charcode::categorize_t category = charcode::categorize(line[pos]);
		while(idx < length)
		{
			if(charcode::categorize(line[idx]) != category) { break; }
			idx++;
		}
	}
	else
	{
		if(pos == 0) { return pos; }
		const charcode::categorize_t category = charcode::categorize(line[pos - 1]);
		while(idx > 0)
		{
			if(charcode::categorize(line[idx - 1]) != category) { break; }
			idx--;
		}
	}
	return idx;
}

// I͈͂擾
void edit_manager::_SelectGetRange(position_t &begin, position_t &end) const
{
	begin = m_select.begin;
	end   = m_select.end;

	if(begin > end)
	{
		std::swap(begin, end);
	}
}

// w͈͂̍sXg쐬
void edit_manager::_RangeCreateLineList(const position_t &begin, const position_t &end, linelist_t &linelist) const
{
	const_iterator_t it;
	_GetPosition(begin.y + 1, it);

	// 1sIĂȂꍇ
	if(begin.y == end.y)
	{
		const size_t offset = begin.x;
		const size_t count  = end.x - begin.x;
		linelist.push_back(edit_line(it->substr(offset, count)));
	}
	// sIĂꍇ
	else
	{
		linelist.push_back(edit_line(it->substr(begin.x), it->lf_type()));

		it++;
		for(intptr_t i = begin.y + 1; i < end.y; i++)
		{
			linelist.push_back(*it++);
		}
		linelist.push_back(edit_line(it->substr(0, end.x)));
	}
}

void edit_manager::_RangeDelete(const position_t &begin, const position_t &end, undo_info &info, modify_info &mi)
{
	iterator_t it_begin, it_end;
	_GetPosition(begin.y + 1, it_begin);
	_GetPosition(end  .y + 1, it_end);

	// sXg쐬
	info.insert   = false;
	info.position = begin;
	_RangeCreateLineList(begin, end, info.text);

	// {block}
	// ݈ʒu𒲐
	{
		// ݈ʒuI͈͂̏ꍇ
		if(end <= m_pos.xy)
		{
			// I͈͂̍ŏIsȂACe[^I͈͂̍ŏɐݒ
			if(m_pos.xy.y == end.y) { m_pos.it = it_begin; }

			// W𒲐
			const intptr_t diff = m_pos.xy.y - end.y;
			m_pos.xy.y -= (end.y - begin.y);
			if(diff == 0)
			{
				m_pos.xy.x -= end.x;
				if(m_pos.xy.y == begin.y)
				{
					m_pos.xy.x += begin.x;
				}
			}
		}
		// ݈ʒuȈ͈͓ꍇ
		else if(begin <= m_pos.xy)
		{
			// I͈͂̍ŏɐݒ
			m_pos.xy = begin;
			m_pos.it = it_begin;
		}
	}

	// 1sw肳ĂȂꍇ
	if(begin.y == end.y)
	{
		const size_t offset = begin.x;
		const size_t count  = end.x - begin.x;

		it_begin->erase(offset, count);
	}
	// sw肳Ăꍇ
	else
	{
		iterator_t it = it_begin; it++;

		// 2sځ`ŏIs-1sڂ폜
		m_buffer.erase(it, it_end);

		it_begin->erase(begin.x);               // 1sڂ̑Iʒuȍ~폜
		it_end  ->erase(0, end.x);              // ŏIs̑Iʒu܂ł폜

		// {block}
		// A
		{
			pos_t pos = {it_begin, begin};
			_Combine(pos, true, mi);
		}
	}

	mi.modified_line = begin.y;
	mi.is_modified_linecount = (info.text.size() > 1);
}

void edit_manager::_SetSelectStatus(const move_select_t select_status)
{
	// I͈͂XV
	switch(select_status)
	{
	case MS_CLEAR:
		m_select.begin = m_pos.xy;
		// no break

	case MS_UPDATE:
		m_select.end = m_pos.xy;
		break;
	}
}


// poscountsXN[
intptr_t edit_manager::_Scroll(const intptr_t count, const_iterator_t &pos) const
{
	if(count > 0)
	{
		return _ScrollForward(count, pos);
	}
	else
	{
		return -_ScrollBackward(-count, pos);
	}
}

// ɃXN[
intptr_t edit_manager::_ScrollForward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		const_iterator_t p = pos;
		if(++p == get_iterator_end())
		{
			return i;
		}
		pos++;
	}

	// ۂɃXN[sԂ
	return count;
}

// 擪ɃXN[
intptr_t edit_manager::_ScrollBackward(const size_t count, const_iterator_t &pos) const
{
	// ݈ʒuXV
	for(size_t i = 0; i < count; i++)
	{
		if(get_iterator_begin() == pos)
		{
			return i;
		}
		pos--;
	}

	// ۂɃXN[sԂ
	return count;
}


// wsԍ̃Ce[^擾ilinenumber==0 Ȃ疖Alinenumber==1 Ȃ擪j
edit_manager::linenumber_t edit_manager::_GetPosition(const linenumber_t linenumber, const_iterator_t &pos) const
{
	const size_t        line_count = get_line_count();
	const iterator_t   &base_iterator   = m_pos.it;   // ʒu݈ʒu
	const linenumber_t &base_linenumber = m_pos.xy.y + 1;

	// 擪
	if(linenumber == 1)
	{
		pos = get_iterator_begin();
		return 1;
	}
	// 
	if(linenumber == 0 || linenumber >= line_count)
	{
		pos = get_iterator_end();
		pos--;
		return line_count;
	}

	// ʒu擪
	if(linenumber < base_linenumber)
	{
		const linenumber_t diff = base_linenumber - linenumber;

		// 擪ɋ߂
		if(linenumber < diff)
		{
			// 擪猟
			pos = get_iterator_begin();
			_ScrollForward(linenumber - 1, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollBackward(diff, pos);
			return linenumber;
		}
	}
	// ʒu薖
	if(linenumber > base_linenumber)
	{
		const linenumber_t diff = linenumber - base_linenumber;

		// ɋ߂
		if(line_count - linenumber < diff)
		{
			// 猟
			pos = get_iterator_end();
			pos--;
			_ScrollBackward(line_count - linenumber, pos);
			return linenumber;
		}
		// ʒuɋ߂
		else
		{
			// ʒu猟
			pos = base_iterator;
			_ScrollForward(diff, pos);
			return linenumber;
		}
	}

	// ʒu
	pos = base_iterator;
	return linenumber;
}


// s̃eLXgAsȂ̕񃊃Xg쐬
void edit_manager::_CreateLineList(const wchar_t *text, const size_t size, linelist_t &linelist, const wchar_t quote_mark /* = charcode::wNUL */)
{
	size_t size2 = size;
	for(;;)
	{
		// sʒu
		charcode::linefeed_t lf_type;
		size_t skip;

		const size_t pos = charcode::find_linefeed(text, size2, lf_type, skip);
		if(pos == charcode::POS_INVALID)
		{
			// ŏIs
			edit_line line(text, size2);
			if(quote_mark != charcode::wNUL && !line.empty()) { line = quote_mark + line; }
			linelist.push_back(line);
			break;
		}

		// {block}
		// ؂o
		{
			edit_line line(text, pos, lf_type);
			if(quote_mark != charcode::wNUL) { line = quote_mark + line; }
			linelist.push_back(line);
		}

		// {block}
		// ̈ʒuvZ
		{
			const size_t offset = pos + skip;
			text  += offset;
			size2 -= offset;
		}
	}
}

_SGC_END                                // }
