// HyperLinkCtrl.cpp cCve[Vt@C
#include "HyperLinkCtrl.h"
#include <shlobj.h>                     // CFSTR_SHELLURL
#include <assert.h>                     // assert()

#include "COM_OleDropSource.h"            // wgc::COM_OleDropSource
#include "../DeviceContext.h"           // wgc::DeviceContext
#include "../wgfunc.h"                  // wgc::wgfMultiByteToWideChar()


#define CF_SHELLURL     static_cast<CLIPFORMAT>(::RegisterClipboardFormat(CFSTR_SHELLURL))

_WXC_BEGIN                              // namespace wxc {


////////////////////////////////////////////////////////////
// RXgNV

HyperLinkCtrl::HyperLinkCtrl(
	HCURSOR hCursor /* = NULL */,
	LPCTSTR lpszURL /* = NULL */,
	const COLORREF colorNormal /* = RGB_BLUE */,
	const COLORREF colorPoint  /* = RGB_ORANGE */,
	const COLORREF colorActive /* = RGB_RED */)
{
	m_hCursor = hCursor;
	m_hFont   = NULL;

	// eLXg̐Fݒ
	m_colorNormal = colorNormal;          // ʏ
	m_colorPoint  = colorPoint;           // |Cg
	m_colorActive = colorActive;          // NbN

	// Nԁʏ
	m_status = LS_NORMAL;

	// tH[JX`̕`恁Ȃ
	m_bDrawFocusRect = FALSE;

	// WvURLݒ
	SetURL(lpszURL);
}

HyperLinkCtrl::~HyperLinkCtrl()
{
	if(m_hFont != NULL)
	{
		::DeleteObject(m_hFont);
		m_hFont = NULL;
	}
}

BOOL HyperLinkCtrl::SetURL(LPCTSTR lpszURL /* = NULL */)
{
	// \[Xt@CURL擾
	if(lpszURL != NULL)
	{
		m_url = lpszURL;
		return TRUE;
	}

	// \Ă镶񂩂URL擾
	if(m_hWnd != NULL)
	{
		GetWindowText(m_url);
		return TRUE;
	}

	// 擾łȂ΃G[I
	m_url.erase();
	return FALSE;
}

void HyperLinkCtrl::SetFontStyle(const BOOL bUnderline /* = TRUE */, const BOOL bItalic /* = FALSE */)
{
	if(m_hFont != NULL)
	{
		::DeleteObject(m_hFont);
		m_hFont = NULL;
	}

	// {block}
	// w肳ꂽX^C̃tHg쐬
	{
		LOGFONT lf;
		::GetObject(GetFont(), sizeof(lf), &lf);
		lf.lfUnderline = static_cast<BYTE>(bUnderline);
		lf.lfItalic    = static_cast<BYTE>(bItalic);

		m_hFont = ::CreateFontIndirect(&lf);
	}
}

void HyperLinkCtrl::SetCursor(HCURSOR hCursor)
{
	m_hCursor = hCursor;
}


// NփWv
void HyperLinkCtrl::JumpToURL(void) const
{
	::ShellExecute(NULL, NULL, m_url.c_str(), NULL, NULL, SW_SHOWNORMAL);
}

// NԂݒ
void HyperLinkCtrl::SetStatus(const LINKSTATE status)
{
	m_status = status;
	Invalidate();
}

// NF擾
COLORREF HyperLinkCtrl::GetLinkColor(void) const
{
	COLORREF color;
	switch(m_status)
	{
	case LS_NORMAL:   color = m_colorNormal; break;
	case LS_HOVER:    color = m_colorPoint;  break;
	case LS_CLICKING: color = m_colorActive; break;
	case LS_DRAGGING: color = m_colorActive; break;
	default: __assume(0);
	}
	return color;
}

// URLOLEhbOhbv
DWORD HyperLinkCtrl::OleDragDrop(void) const
{
	COM_OleDropSource ods;

	// {block}
	// eLXgLbV
	{
		HGLOBAL hGlobal = COM_OleDropSource::CreateGlobalData(
			m_url.c_str(),
			sizeof(TCHAR) * (m_url.length() + 1));

		ods.CacheGlobalData(
			(sizeof(TCHAR) == sizeof(char)) ? CF_TEXT : CF_UNICODETEXT,
			hGlobal);
	}

	// {block}
	// URLLbV
	{
		wgc::string_t url;
#ifndef UNICODE
		url = m_url;
#else // UNICODE
		wgc::wgfWideCharToMultiByte(m_url, url);
#endif // UNICODE

		HGLOBAL hGlobal = COM_OleDropSource::CreateGlobalData(
			url.c_str(),
			url.length() + 1);
		ods.CacheGlobalData(CF_SHELLURL, hGlobal);
	}

	// OLEhbOhbvJn
	return ods.DoDragDrop(DROPEFFECT_MOVE | DROPEFFECT_COPY);
}


/////////////////////////////////////////////////////////////////////////////
// HyperLinkCtrl bZ[W nh

// J[\̌`ݒ
BOOL HyperLinkCtrl::OnSetCursor(HWND /* hWnd */, const UINT /* nHitTest */, const UINT /* message */) 
{
	if(m_hCursor != NULL)
	{
		::SetCursor(m_hCursor);
	}
	return TRUE;
}

// }EXRg[Oɏo
void HyperLinkCtrl::OnMouseLeave(void)
{
	// hbOłȂ΃NʏFɖ߂
	if(m_status != LS_DRAGGING)
	{
		SetStatus(LS_NORMAL);
	}
}


void HyperLinkCtrl::OnSetFocus(HWND /* hWndLoseFocus */)
{
	m_bDrawFocusRect = TRUE;
	Invalidate();
}

void HyperLinkCtrl::OnKillFocus(HWND /* hWndLoseFocus */)
{
	m_bDrawFocusRect = TRUE;
	Invalidate();
}


// qbgeXg
UINT HyperLinkCtrl::OnNcHitTest(const POINT & /* point */)
{
	// ŏɃNCAg̈ԂƂɂA
	// X^eBbNRg[ SS_NOTIFY X^CǉKvȂȂ
	// iSS_NOTIFY ݒ肵ĂȂX^eBbNRg[͏ HTTRANSPARENT Ԃj
	return HTCLIENT;
}


// }EXړ
void HyperLinkCtrl::OnMouseMove(const UINT /* nFlags */, const POINT & /* point */) 
{
	// NNbNĂꍇ
	if(m_status == LS_CLICKING)
	{
		// NOLEhbOhbvJn
		SetStatus(LS_DRAGGING);
		OleDragDrop();
	}

	if(m_status != LS_HOVER)
	{
		// Nzo[
		SetStatus(LS_HOVER);

		// WM_MOUSELEAVEbZ[WLv`
		TRACKMOUSEEVENT tme;
		tme.cbSize    = sizeof(tme);
		tme.dwFlags   = TME_LEAVE;
		tme.hwndTrack = m_hWnd;
		_TrackMouseEvent(&tme);
	}
}

// }EX̍{^ꂽ
void HyperLinkCtrl::OnLButtonDown(const UINT /* nFlags */, const POINT & /* point */) 
{
	// NNbN
	SetStatus(LS_CLICKING);
	SetFocus();
}

// }EX̍{^ꂽ
void HyperLinkCtrl::OnLButtonUp(const UINT /* nFlags */, const POINT & /* point */) 
{
	// WebPage\
	if(m_status == LS_CLICKING)
	{
		JumpToURL();
	}

	// Nzo[
	SetStatus(LS_HOVER);
}

// `
void HyperLinkCtrl::OnPaint(void)
{
	wgc::DeviceContext_Paint dc(m_hWnd);

	// tH[JX``/
	// DrawFocusRect() XORZgpĂ̂ŁA2xĂяoΏ
	if(m_bDrawFocusRect)
	{
		RECT rect;
		GetClientRect(rect);
		dc.DrawFocusRect(rect);

		m_bDrawFocusRect = FALSE;
	}

	wgc::GdiFont font((m_hFont != NULL) ? m_hFont : GetFont());
	{
		wgc::AutoSelectGDI selectFont(dc, font);

		// \eLXg擾
		wgc::tstring_t tstr;
		GetWindowText(tstr);

		// eLXg`
		dc.SetTextColor(GetLinkColor());
		dc.SetBkMode(TRANSPARENT);
		dc.TextOut(0, 0, tstr);
	}
}

_WXC_END                                // }
