// EditView.h cGfBbgR|[lgir[j
#ifndef __EDIT_VIEW__
#define __EDIT_VIEW__

#include "Edit.h"
#include "EditDoc.h"

// ̃R|[lǵAGfBbgRg[Eb`GfBbgRg[̃bZ[W󗝂
#include <richedit.h>


class EditView : public wgc::Window
{
private:
	////////////////////////////////////////////////////////////////
	// RXgNV

	// friendNXłEditDoĉ݃RXgN^̌Ăяo
	explicit EditView(
		EditDoc                 &rDocument,
		const EDITVIEW_PROPERTY &rProperty,
		HCURSOR hCursorMargin  = NULL,
		HFONT   hFont          = NULL);
	~EditView(void);

public:
	////////////////////////////////////////////////////////////
	// EChENX̓o^
	static void Register(void);

	BOOL Create(
		const DWORD dwStyle, const DWORD dwExStyle,
		wgc::Window *pParent,
		const UINT nID,
		HINSTANCE hInstance = NULL,
		const int x = CW_USEDEFAULT,
		const int y = CW_USEDEFAULT,
		const int nWidth  = CW_USEDEFAULT,
		const int nHeight = CW_USEDEFAULT);

	void SetProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword, HFONT hFont);
	void ResetCaretPos(void);


	////////////////////////////////////////////////////////////////
	// X^C
	BOOL IsLineNumberVisible(void) const;
	BOOL IsRulerVisible     (void) const;
	BOOL IsCursorUnderline  (void) const;

	////////////////////////////////////////////////////////////////
	// EM_xxx
	BOOL GetModify(void) const;
	void SetModify(const BOOL bModified = TRUE);
	BOOL SetReadOnly(const BOOL bReadOnly = TRUE);

	void  SetMargins(const UINT nLeft, const UINT nRight);
	DWORD GetMargins(void) const;

	SIZE_T GetLineCount(void) const;

	BOOL    Undo           (void);
	BOOL    CanUndo        (void) const;
	BOOL    Redo           (void);
	BOOL    CanRedo        (void) const;
	INT_PTR SetUndoLimit   (const INT_PTR nLimit = -1);
	void    EmptyUndoBuffer(void);
	void    Cut     (void);
	void    Copy    (void);
	void    Clear   (void);
	void    Paste   (void);
	BOOL    CanPaste(const UINT uFormat = 0) const;

	void Reconversion(void);

	////////////////////////////////////////////////////////////////
	// OLE Drag & Drop
	DWORD OnDragEnter(IDataObject *pDataObject, const DWORD dwKeyState, const POINTL &ptl);
	DWORD OnDragOver (                          const DWORD dwKeyState, const POINTL &ptl);
	void  OnDragLeave(void);
	DWORD OnDrop     (IDataObject *pDataObject, const DWORD dwKeyState, const POINTL &ptl);
	DWORD GetDropEffect(const DWORD dwKeyState) const;
	BOOL  GetUnicodeText(IDataObject *pDataObject, wgc::wstring_t &wstr) const;

protected:
	typedef EditDoc::linenumber_t LINENUMBER_T;
	typedef EditDoc::position_t position_t;
	typedef struct tagUPDATE_CLIENT_INFO
	{
		BOOL bUpdateLineNumber;
		SIZE szScroll;                          // XN[
		RECT rcValid;                           // L`
	} UPDATE_CLIENT_INFO;

	EditDoc           &m_rDocument;         // GfBbgR|[lgihLgj
	EDITVIEW_PROPERTY  m_property;          // GfBbgr[̃vpeB
	KEYWORD_INFO       m_keyword;           // L[[h

	// OLE Drag & Drop
	wxc::COM_OleDropTarget m_oleDropTarget; // OLE hbv^[Qbg
	CLIPFORMAT         m_cfAccept;          // hbOhbv󂯓Ƃ̃tH[}bgiOnDragEnter()/OnDragOver()/OnDrop() Ŏgpj

	BOOL m_bSelectLine;                     // sI𒆁H

	// gvNbNp
	DWORD m_dwDblClkTickCount;              // _uNbÑVXeԁiVXeŇoߎԁE~bj

	// ʂ̏[A[
	LINENUMBER_T m_nColumnLeft;             // ԍ̌ԍ
	LINENUMBER_T m_nLineNumberTop;          // ʂ̏[ɕ\Ăsԍi1 originj
	LINENUMBER_T m_nLineCountPrev;          // O`FbNƂ̍s
	UINT         m_nLineNumberCols;         // sԍ̌

	// 
	HCURSOR m_hCursorMargin;                // ]̃J[\

	HFONT m_hFont;                          // tHg
	SIZE  m_sizeFont;                       // tHg̑傫
	INT   m_nNumWidthMax;                   // i'0'`'9'j̍̕ől
	mutable LPINT m_lpCharWidthArray[256];  // ̕i0`65536256Ďgp팸j

	SIZE m_sizeTextArea;                    // eLXg̈̃TCYiJbgPʁj

	POINT    m_ptCaret;                     // Jbg̕Wiʏ̈ʒu _(0, 0)j
	POINT    m_ptCaretPrev;                 // O`FbNƂ̃Jbg̕W
	UINT_PTR m_nInternalX;                  // IXWi[][]L[̈ړXWێ鎞Ɏgpj

	position_t m_ptLogicalPrev;             // tH[JXO̘_JbgʒuiEChEƂ̂߂ɕKvj

	UINT m_nTextMarginLeft;                 // ]isԍ\j
	UINT m_nTextMarginRight;                // E]


	////////////////////////////////////////////////////////////
	// _/[`

	// Wϊ
	position_t PhysicalToLogical(const POINT      &pt      , LPUINT pInternalX = NULL) const;
	POINT      LogicalToPhysical(const position_t &position, LPUINT pInternalX = NULL) const;

	// tHgTCY擾
	UINT GetFontWidth (const BOOL bAddCharSpace = TRUE) const;
	UINT GetFontHeight(const BOOL bAddLineSpace = TRUE) const;

	void SetImeFont(void);

	// Jbg쐬
	void CreateEditCaret(void);
	void CreateDnDCaret (void);

	// vZ
	void   FreeCharWidthArray(void);
	INT    CalcCodeWidth(const wchar_t code, const BOOL bAddCharSpace = TRUE) const;
	UINT   CalcTabWidth (const wgc::UINDEX_T nCols) const;
	UINT   CalcPhysicalLength(const wgc::wstring_t &wstr) const;
	UINT   CalcPhysicalLength(LPCWSTR lpString, const SIZE_T nCount) const;
	SIZE_T CalcLogicalLength (LPCWSTR lpString, const SIZE_T nCount, const wgc::UINDEX_T iPosition) const;
	void   CalcNearestPos    (LPCWSTR lpString, const SIZE_T nCount, const wgc::UINDEX_T iPosition, wgc::UINDEX_T *pPosPhysical, wgc::UINDEX_T *pPosLogical) const;

	// XN[
	void ScrollPhysical(const INT_PTR nHorz, const INT_PTR nVert, UPDATE_CLIENT_INFO &rUpdateInfo);
	void ScrollLogicalHorz(const INT_PTR nScrollAmount);
	void ScrollLogicalVert(const INT_PTR nScrollAmount);
	void ScrollAuto(void);

	////////////////////////////////////////////////////////////
	// _[`
	void ExpandLineNumberCols(void);


	////////////////////////////////////////////////////////////
	// [`

	// qbgeXg
	typedef enum _client_hittest_t
	{
		CHT_TEXT,                               // eLXg̈
		CHT_MARGIN,                             // ]̈
		CHT_SELECTED,                           // Ï
	} client_hittest_t;
	client_hittest_t m_cht;
	client_hittest_t ClientHitTest(const POINT &ptDisplay) const;

	void UpdateTextAreaSize(void);          // eLXg̈̃TCYXV

	void SyncHScroll(void);                 // XN[o[𓯊
	void SyncVScroll(void);                 // XN[o[𓯊

	// ̈vZ[`
	UINT CalcMarginLeft(const BOOL bAddTextMargin = TRUE) const;
	UINT CalcMarginTop (void) const;
	void CalcRectLineNumber(RECT &rRect) const;
	void CalcRectRuler     (RECT &rRect) const;
	void CalcRectText      (RECT &rRect, const BOOL bIncludeMargin = TRUE) const;

	// Jbg[`
	void CalcDisplayPos(const POINT &ptCaret  , POINT &ptDisplay) const;
	void CalcCaretPos  (const POINT &ptDisplay, POINT &ptPhysical, position_t &ptLogical, UINT &nInternalX) const;
	void SetLogicalPos (const POINT &client, const BOOL bUpdateSelection = FALSE);
	void MoveCaret_Physical(const POINT &point);
	void MoveCaret_Client  (const POINT &point);
	void MoveCaretToPoint  (const POINT &point, const BOOL bUpdateSelection = FALSE);

	BOOL EnsureVisible(UPDATE_CLIENT_INFO &rUpdateInfo, const BOOL bByScroll = TRUE, const BOOL bUpdateLineNumber = FALSE);

	// L[{[h[`
	void KeyPageUp  (UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyPageDown(UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyHome    (UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyEnd     (UPDATE_CLIENT_INFO &rUpdateInfo);

	void KeyLeft (UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyRight(UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyUp   (UPDATE_CLIENT_INFO &rUpdateInfo);
	void KeyDown (UPDATE_CLIENT_INFO &rUpdateInfo);

	void KeyReturn(void);
	void KeyBack  (void);
	void KeyDelete(void);
	void KeyString(const wgc::wstring_t &wstr);

	void KeyInsert(void);
	void KeyEscape(void);

	void CharInput(const WCHAR wch, const UINT nRepeatCount);

	void OleDragDrop(void);

	////////////////////////////////////////////////////////////////
	// }EX[`
	BOOL IsTripleClick(void);

	////////////////////////////////////////////////////////////////
	// `惋[`
	void InitUpdateClientInfo(UPDATE_CLIENT_INFO &rUpdateInfo) const;
	void UpdateClient(const UPDATE_CLIENT_INFO &rUpdateInfo);
	void PaintClient(
		wgc::DeviceContext &dc,
		const INT_PTR nLineNumberRedraw = 0,
		const INT_PTR nLineCountRedraw  = -1,
		const BOOL    bLineNumber = TRUE,
		const BOOL    bRuler      = TRUE) const;

	void PaintText    (wgc::DeviceContext &dc, const INT_PTR nLineNumberRedraw, const INT_PTR nLineCountRedraw) const;
	void PaintTextBack(wgc::DeviceContext &dc) const;
	void PaintLineNumber    (wgc::DeviceContext &dc) const;
	void PaintLineNumberBack(wgc::DeviceContext &dc) const;
	void PaintRuler    (wgc::DeviceContext &dc) const;
	void PaintRulerBack(wgc::DeviceContext &dc) const;
	void PaintUnderline(wgc::DeviceContext &dc, const POINT &pt, const BOOL bDraw = TRUE) const;

	SIZE_T DrawLogicalLine  (wgc::DeviceContext &dc, const POINT &ptBase, LPCWSTR lpString, const SIZE_T nCount, const BOOL bLastLine = FALSE, const SIZE_T nSelBegin = 0, const SIZE_T nSelEnd = 0) const;
	void   DrawSelectedRange(wgc::DeviceContext &dc, const POINT &ptBase, LPCWSTR lpString, const SIZE_T nCount, const SIZE_T nSelBegin, const SIZE_T nSelEnd) const;
	UINT   DrawString       (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x, LPCWSTR lpString, const SIZE_T nCount, const FONT_COLOR &color) const;
	void   DrawMarkLineFeed (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	void   DrawMarkEOF      (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	int    DrawMarkTab      (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	int    DrawMarkSpace    (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	int    DrawMarkWideSpace(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	int    DrawMarkNul      (wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const;
	void   DrawPolyPolyLine (wgc::DeviceContext &dc, const RECT &rcFill, const POINT ptVertexes[], const DWORD dwPolyPoints[], const DWORD dwCount, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawStaple       (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawRect         (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawArrow        (wgc::DeviceContext &dc, const RECT &rcFill, const POINT &ptTail, const POINT &ptHead, const POINT &ptBranch1, const POINT &ptBranch2, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawArrowLeft    (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const UINT nFillWidth, const UINT nFillHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawArrowRight   (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const UINT nFillWidth, const UINT nFillHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawArrowUp      (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const UINT nFillWidth, const UINT nFillHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	void   DrawArrowDown    (wgc::DeviceContext &dc, const POINT &pt, const UINT nWidth, const UINT nHeight, const UINT nFillWidth, const UINT nFillHeight, const COLORREF colorPen, const COLORREF colorBack) const;
	UINT   PutString        (wgc::DeviceContext &dc, const POINT &pt, LPCWSTR lpString, const SIZE_T nCount, const UINT nOpaqueLength = 0) const;

	////////////////////////////////////////////////////////////
	// bZ[W֘A
	LRESULT WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam);

	void PostNcDestroy(void);

	int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	void OnDestroy(void);

	UINT OnGetDlgCode(LPMSG lpMsg);

	void OnSize(const UINT nType, const int cx, const int cy);

	void OnSetFocus (HWND hWndLoseFocus);
	void OnKillFocus(HWND hWndGetFocus);

	void  OnSetFont(HFONT hFont, const BOOL bRedraw);
	HFONT OnGetFont(void);

	void OnHScroll(const UINT nSBCode, const UINT nPos, HWND hWndScrollBar);
	void OnVScroll(const UINT nSBCode, const UINT nPos, HWND hWndScrollBar);

	BOOL OnSetCursor(HWND hWnd, const UINT nHitTest, const UINT message);

	void OnKeyDown(const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	void OnChar   (const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	void OnUniChar(const UINT nChar, const UINT nRepeatCount, const UINT nFlags);

	void  OnImeComposition(const WORD chDBCS, const UINT nFlags);
	DWORD OnImeRequest_ReconvertString(RECONVERTSTRING *lpRs);

	BOOL OnMouseWheel   (const UINT nFlags, const short zDelta, const POINT &point);
	void OnMouseMove    (const UINT nFlags, const POINT &point);
	void OnLButtonDown  (const UINT nFlags, const POINT &point);
	void OnLButtonUp    (const UINT nFlags, const POINT &point);
	void OnLButtonDblClk(const UINT nFlags, const POINT &point);
	void OnRButtonDown  (const UINT nFlags, const POINT &point);
	void OnMButtonDown  (const UINT nFlags, const POINT &point);

	void OnTimer(const UINT uIDEvent);

	void OnPaint(void);
	BOOL OnEraseBkgnd(HDC hDC);

	// 
	BOOL OnEmGetModify(void) const;
	void OnEmSetModify(const BOOL bModified);
	BOOL OnEmSetReadOnly(const BOOL bReadOnly);

	void  OnEmSetMargins(const WORD fwMargin, const WORD wLeft, const WORD wRight);
	DWORD OnEmGetMargins(void) const;

	SIZE_T OnEmGetLineCount(void) const;

	BOOL    OnEmUndo           (void);
	BOOL    OnEmCanUndo        (void) const;
	BOOL    OnEmRedo           (void);
	BOOL    OnEmCanRedo        (void) const;
	INT_PTR OnEmSetUndoLimit   (const INT_PTR nLimit);
	void    OnEmEmptyUndoBuffer(void);
	void    OnCut       (void);
	void    OnCopy      (void);
	void    OnClear     (void);
	void    OnPaste     (void);
	BOOL    OnEmCanPaste(const UINT uFormat) const;

	void OnEmReconversion(void);

private:
	// oϐ̐ݒ
	void SetFontSize    (const UINT cx, const UINT cy);
	void SetTextAreaSize(const UINT cx, const UINT cy);
	void SetLineNumberTop(const INT_PTR nNewLineNumberTop);
	void SetColumnLeft   (const INT_PTR nNewColumnLeft);

	// nh
	void OnSyncBuffer(const LINENUMBER_T lineModify, const BOOL bUpdateLineNumber = FALSE);
	void OnSyncCaret (const BOOL bUpdateSelection = FALSE, const BOOL bUpdateInternalX = TRUE);

	// 񑀍֐
	static SIZE_T String_strspn(LPCWSTR lpString, const SIZE_T nCount, LPCWSTR lpSearchString, const SIZE_T nSearchCount);

private:
	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(EditView)

	friend class EditDoc;
};

#endif // __EDIT_VIEW__
