// Setting.cpp cCve[Vt@C
#include "Setting.h"
#include <shlobj.h>                     // ::SHGetSpecialFolderPath()
#include <shlwapi.h>                    // ::PathRemoveFileSpec(), ::PathAppend()
#include <fstream>


////////////////////////////////////////////////////////////////////////////////
// }N`

// t@C^Cv֘A
#define TYPE_DIR    _T("types")
#define WILDCARD    _T("*.msd")
#define EXT_ASD     _T(".msd")          // Maxy Setting Description File
#define EXT_AKW     _T(".mkw")          // Maxy KeyWord File

// ftHgl
#define DEFAULT_CUSTOMIZE_FLAGS     0x0004
#define DEFAULT_CUSTOMIZE_EXCLUSION EXCLUSION_DISABLEWRITE


// anonymous namespace
namespace
{
	// t@C^CṽftHgl
	const EDITVIEW_PROPERTY g_viewproperty_default =
	{
		_T("Default"),                          // ݒ薼
		_T("*.*"),                              // tB^
		_T(""),                                 // ftHg̊gq

		0x00,                                   // tO
		sgc::CL_CRLF,                           // ftHg̉sR[h
		-1,                                     // ftHg̕Zbg

		// eLXgGA
		{
			0x00,                                   // tO
			8,                                      // ^u
			0,                                      // sԊu
			0,                                      // Ԋu
			8,                                      // ]
			0,                                      // E]
			{
				0x00,
				_T("lr oSVbN"),
				12,
			},
			RGB(224, 224, 224),                     // r̐F
		},

		// sԍGA
		{
			8,                                      // E]
		},

		// [[GA
		{
			8,                                      // 
			10,                                     // Ԋu
		},

		// F̐ݒ
		{0xff000000 | COLOR_WINDOWTEXT   , 0xff000000 | COLOR_WINDOW   },
		{0xff000000 | COLOR_HIGHLIGHTTEXT, 0xff000000 | COLOR_HIGHLIGHT},
		{RGB(  0, 128, 255), RGB(255, 255, 255)},
		{RGB(  0, 128, 128), RGB(255, 255, 255)},
		{RGB(  0, 128, 128), RGB(255, 255, 255)},
	};

	const KEYWORD_INFO g_keywordinfo_default;

	// .msf t@C̓ǂݍ
	typedef struct _SCANLINE
	{
		LPCWSTR lpszName;                       // O
		LPCWSTR lpszFormat;                     // sscanf() ̏ݒ
		LPVOID lpValue;                         // lւ̃|C^
	} SCANLINE;
	void ScanMSD(LPCTSTR lpszFileName, EDITVIEW_PROPERTY &rProperty);
	bool ScanMSDLine(LPCWSTR lpszLine, const SCANLINE scan_line[], const size_t count);

	// .mkw t@C̓ǂݍ
	void ScanMKW(LPCTSTR lpszFileName, KEYWORD_INFO &rInfo);
	bool ScanMKWLine(LPCWSTR lpszLine, KEYWORD_INFO &rInfo, sgc::keyword_manager::keyword_info_t &key_info, std::vector<sgc::keyword_manager::keyword_data_t> &key_array);

	sgc::charcode_linefeed_t GetLfCode(LPCWSTR lpszLfName);
	COLORREF                 GetColorRef(LPCWSTR lpszColorName);
}


////////////////////////////////////////////////////////////////////////////////
// 

void Setting_LoadStatus(void)
{
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_STATUS, TRUE);

	// {block}
	// JgfBNg̃[h
	{
		wgc::tstring_t strCurrentDirectory;
		if(reg.GetValue(REGKEY_ENTRY_STATUS_CURDIR, strCurrentDirectory) != ERROR_SUCCESS)
		{
			// 擾Ɏs"}C hLg"̃pX擾
			TCHAR buffer[MAX_PATH];
			::SHGetSpecialFolderPath(NULL, buffer, CSIDL_PERSONAL, FALSE);

			strCurrentDirectory = buffer;
		}

		wgc::wgfSetCurrentDirectory(strCurrentDirectory);
	}
}

void Setting_SaveStatus(void)
{
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_STATUS, TRUE);

	// {block}
	// JgfBNg̃Z[u
	{
		wgc::tstring_t strCurrentDirectory;
		wgc::wgfGetCurrentDirectory(strCurrentDirectory);

		reg.SetValue(REGKEY_ENTRY_STATUS_CURDIR, strCurrentDirectory);
	}
}

void Setting_LoadWindowPlacement(WINDOWPLACEMENT &rWndPl)
{
	DWORD dwData;
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_WINDOWPLACEMENT, TRUE);
	reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_FLAGS                , dwData); rWndPl.flags   = dwData;
	reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_SHOWCMD              , dwData); rWndPl.showCmd = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MINPOSITION_X        , dwData); rWndPl.ptMinPosition.x = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MINPOSITION_Y        , dwData); rWndPl.ptMinPosition.y = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MAXPOSITION_X        , dwData); rWndPl.ptMaxPosition.x = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MAXPOSITION_Y        , dwData); rWndPl.ptMaxPosition.y = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_TOP   , dwData); rWndPl.rcNormalPosition.top    = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_BOTTOM, dwData); rWndPl.rcNormalPosition.bottom = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_LEFT  , dwData); rWndPl.rcNormalPosition.left   = dwData;
    reg.GetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_RIGHT , dwData); rWndPl.rcNormalPosition.right  = dwData;

	rWndPl.length = sizeof(rWndPl);
}

void Setting_SaveWindowPlacement(const WINDOWPLACEMENT &rWndPl)
{
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_WINDOWPLACEMENT, TRUE);
	reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_FLAGS                , rWndPl.flags);
	reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_SHOWCMD              , rWndPl.showCmd);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MINPOSITION_X        , rWndPl.ptMinPosition.x);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MINPOSITION_Y        , rWndPl.ptMinPosition.y);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MAXPOSITION_X        , rWndPl.ptMaxPosition.x);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_MAXPOSITION_Y        , rWndPl.ptMaxPosition.y);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_TOP   , rWndPl.rcNormalPosition.top);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_BOTTOM, rWndPl.rcNormalPosition.bottom);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_LEFT  , rWndPl.rcNormalPosition.left);
    reg.SetValue(REGKEY_ENTRY_WINDOWPLACEMENT_NORMALPOSITION_RIGHT , rWndPl.rcNormalPosition.right);
}


////////////////////////////////////////////////////////////////////////////////
// MAINFRAME_PROPERTY

// vpeB̃[h
void Setting_LoadProperty(MAINFRAME_PROPERTY &rProperty)
{
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_CUSTOMIZE, TRUE);

	// {block}
	// tO
	{
		DWORD dwFlags = DEFAULT_CUSTOMIZE_FLAGS;
		reg.GetValue(REGKEY_ENTRY_CUSTOMIZE_FLAGS, dwFlags);

		rProperty.flags.dwAll = dwFlags;
	}

	// {block}
	// r[h
	{
		DWORD dwExclusion = DEFAULT_CUSTOMIZE_EXCLUSION;
		reg.GetValue(REGKEY_ENTRY_CUSTOMIZE_EXCLUSION, dwExclusion);

		if(dwExclusion > EXCLUSION_DISABLEREADWRITE)
		{
			dwExclusion = DEFAULT_CUSTOMIZE_EXCLUSION;
		}
		rProperty.dwExclusionMode = dwExclusion;
	}
}

// vpeB̃Z[u
void Setting_SaveProperty(const MAINFRAME_PROPERTY &rProperty)
{
	wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_CUSTOMIZE, TRUE);

	// tO
	reg.SetValue(REGKEY_ENTRY_CUSTOMIZE_FLAGS, rProperty.flags.dwAll);

	// r[h
	reg.SetValue(REGKEY_ENTRY_CUSTOMIZE_EXCLUSION, rProperty.dwExclusionMode);
}


////////////////////////////////////////////////////////////////////////////////
// EDITVIEW_PROPERTY

void Setting_LoadViewProperty(EDITVIEW_PROPERTY_vector &rPropertyArray, KEYWORD_INFO_vector &rKeywordArray)
{
	// ftHgo^
	// ̃ftHg͓ʈŁAuJvuۑv_CAÕtB^ɂ͏oĂȂ
	rPropertyArray.push_back(g_viewproperty_default);
	rKeywordArray.push_back(g_keywordinfo_default);

	// {block}
	// ݒt@Cǂݍ
	{
		// ݒt@C̃tH_
		TCHAR szDirectory[MAX_PATH];
		::GetModuleFileName(NULL, szDirectory, countof(szDirectory));
		::PathRemoveFileSpec(szDirectory);
		::PathAppend(szDirectory, TYPE_DIR);

		// pChJ[h
		TCHAR szWildCard[MAX_PATH];
		::PathCombine(szWildCard, szDirectory, WILDCARD);

		WIN32_FIND_DATA find_data;
		HANDLE hFound = ::FindFirstFile(szWildCard, &find_data);
		if(hFound != INVALID_HANDLE_VALUE)
		{
			int setting_count = 0;
			do
			{
				EDITVIEW_PROPERTY property = g_viewproperty_default;
				KEYWORD_INFO      keyword;

				// gq폜it@Cݒ薼j
				::PathRemoveExtension(find_data.cFileName);
				::lstrcpy(property.szSettingName, find_data.cFileName);

				// t@C쐬igqj
				TCHAR szPathName[MAX_PATH];
				::PathCombine(szPathName, szDirectory, find_data.cFileName);

				// MSDt@CAMKWt@Cǂݍ
				ScanMSD(szPathName, property);
				ScanMKW(szPathName, keyword);

				rPropertyArray.push_back(property);
				rKeywordArray.push_back(keyword);

				// o^\ɒBǂݍ݂I
				setting_count++;
				if(setting_count >= MAX_SETTING_COUNT)
				{
					break;
				}
			}
			while(::FindNextFile(hFound, &find_data));
			::FindClose(hFound);
			hFound = INVALID_HANDLE_VALUE;
		}
	}
}

void Setting_SaveViewProperty(const EDITVIEW_PROPERTY_vector & /* rPropertyArray */, const KEYWORD_INFO_vector & /* rKeywordArray */)
{
}


// anonymous namespace
namespace
{

void ScanMSD(LPCTSTR lpszFileName, EDITVIEW_PROPERTY &rProperty)
{
	// Op^[
	wchar_t lfDefault   [16]  = L"";
	wchar_t szFilter    [256] = L"";
	wchar_t szDefaultExt[256] = L"";
	wchar_t szFontName  [32]  = L"";

	typedef struct tagCOLORSTRING
	{
		wchar_t    szColorName[32];
		LPCOLORREF lpColorRef;
	} COLORSTRING;
	COLORSTRING csColor[] =
	{
		{L"", &rProperty.infoText.colorLine    },
		{L"", &rProperty.fcDefault.colorText   },
		{L"", &rProperty.fcDefault.colorBack   },
		{L"", &rProperty.fcMark.colorText      },
		{L"", &rProperty.fcMark.colorBack      },
		{L"", &rProperty.fcLineNumber.colorText},
		{L"", &rProperty.fcLineNumber.colorBack},
		{L"", &rProperty.fcRuler.colorText     },
		{L"", &rProperty.fcRuler.colorBack     },
	};

	const SCANLINE scan_line[] =
	{
		// S
		{L"filter"           , L"%256s",            szFilter    },  // tB^
		{L"default-extension", L"%256s",            szDefaultExt},  // ftHg̊gq
		{L"flags"            , L"%x"   , &rProperty.flags.dwAll },  // tO
		{L"default-linefeed" , L"%16s" ,            lfDefault   },  // ftHg̉sR[hij
		{L"default-charset"  , L"%d"   , &rProperty.csDefault   },  // ftHg̕Zbg

		// eLXgGA
		{L"text.flags"       , L"%x"  , &rProperty.infoText.flags.dwAll},   // tO
		{L"text.tab-size"    , L"%d"  , &rProperty.infoText.nTabSize   },   // ^u
		{L"text.line-space"  , L"%d"  , &rProperty.infoText.nLineSpace },   // sԊu
		{L"text.char-space"  , L"%d"  , &rProperty.infoText.nCharSpace },   // Ԋu
		{L"text.line-color"  , L"%32s", csColor[0].szColorName         },   // r̐F

		{L"text.font.flags", L"%x"        , &rProperty.infoText.font.flags.dwAll},  // tO
		{L"text.font.name" , L"%32[^\r\n]",                          szFontName },  // tHg
		{L"text.font.size" , L"%lf"       , &rProperty.infoText.font.fPointSize },  // tHgTCY

		// F̐ݒ
		{L"color.default.text"    , L"%32s", csColor[1].szColorName},
		{L"color.default.back"    , L"%32s", csColor[2].szColorName},
		{L"color.mark.text"       , L"%32s", csColor[3].szColorName},
		{L"color.mark.back"       , L"%32s", csColor[4].szColorName},
		{L"color.line-number.text", L"%32s", csColor[5].szColorName},
		{L"color.line-number.back", L"%32s", csColor[6].szColorName},
		{L"color.ruler.text"      , L"%32s", csColor[7].szColorName},
		{L"color.ruler.back"      , L"%32s", csColor[8].szColorName},
	};

	// {block}
	// t@Cǂݍ
	{
		// t@C̍Ō ".msd" ǉ
		TCHAR szPathName[MAX_PATH];
		::lstrcpyn(szPathName, lpszFileName, countof(szPathName));
		::PathAddExtension(szPathName, _T(".msd"));

//*
		FILE *fp = _tfopen(szPathName, _T("rb"));
		if(fp == NULL)
		{
			return;
		}
		for(;;)
		{
			wchar_t buffer[256];
			if(fgetws(buffer, countof(buffer), fp) == NULL)
			{
				// t@C̏I[ɒB甲
				break;
			}
			ScanMSDLine(buffer, scan_line, countof(scan_line));
		}
		fclose(fp);
		fp = NULL;
// */
/*
		std::wifstream ifs(szPathName);
		ifs.imbue(std::locale("C"));
		while(!ifs.eof())
		{
			std::wstring wstr;
			ifs >> wstr;
			ScanMSDLine(wstr.c_str(), scan_line, countof(scan_line));
		}
// */
	}

	// Op^[̏

	// {block}
	// lfDefault̏
	{
		_wcsupr(lfDefault);
		rProperty.lfDefault = GetLfCode(lfDefault);
	}

	// {block}
	// F̏
	{
		for(INT_PTR i = 0; i < countof(csColor); i++)
		{
			_wcsupr(csColor[i].szColorName);
			*(csColor[i].lpColorRef) = GetColorRef(csColor[i].szColorName);
		}
	}

	// {block}
	// wchar_tTCHAR̕ϊ
	{
#ifdef UNICODE
		wcscpy(rProperty.szFilter                , szFilter);
		wcscpy(rProperty.szDefaultExt            , szDefaultExt);
		wcscpy(rProperty.infoText.font.szFaceName, szFontName);
#else
		::WideCharToMultiByte(CP_ACP, 0, szFilter    , -1, rProperty.szFilter                , countof(rProperty.szFilter                ), NULL, NULL);
		::WideCharToMultiByte(CP_ACP, 0, szDefaultExt, -1, rProperty.szDefaultExt            , countof(rProperty.szDefaultExt            ), NULL, NULL);
		::WideCharToMultiByte(CP_ACP, 0, szFontName  , -1, rProperty.infoText.font.szFaceName, countof(rProperty.infoText.font.szFaceName), NULL, NULL);
#endif
	}
}

bool ScanMSDLine(LPCWSTR lpszLine, const SCANLINE scan_line[], const size_t count)
{
	// OƏ擾
	wchar_t szName[256], szFormat[256];
	if(swscanf(lpszLine, L"%256s = %256[^\r\n]", szName, szFormat) != 2)
	{
		// w̏ŋLqĂȂΏI
		return false;
	}

	// Yϐ𒀎
	for(size_t i = 0; i < count; i++)
	{
		if(wcscmp(szName, scan_line[i].lpszName) == 0)
		{
			swscanf(szFormat, scan_line[i].lpszFormat, scan_line[i].lpValue);
			return true;
		}
	}
	return false;
}

void ScanMKW(LPCTSTR lpszFileName, KEYWORD_INFO &rInfo)
{
	std::vector<sgc::keyword_manager::keyword_data_t> key_array;

	// {block}
	// t@Cǂݍ
	{
		// t@C̍Ō ".mkw" ǉ
		TCHAR szPathName[MAX_PATH];
		::lstrcpyn(szPathName, lpszFileName, countof(szPathName));
		::PathAddExtension(szPathName, _T(".mkw"));

		FILE *fp = _tfopen(szPathName, _T("rb"));
		if(fp == NULL)
		{
			return;
		}
		sgc::keyword_manager::keyword_info_t key_info = {sgc::KT_NONE, 0};
		for(;;)
		{
			wchar_t buffer[256];
			if(fgetws(buffer, countof(buffer), fp) == NULL)
			{
				break;
			}
			ScanMKWLine(buffer, rInfo, key_info, key_array);
		}
		fclose(fp);
		fp = NULL;
	}

	rInfo.cKeyMan.set_keywords(&key_array[0], key_array.size());
}

bool ScanMKWLine(LPCWSTR lpszLine, KEYWORD_INFO &rInfo, sgc::keyword_manager::keyword_info_t &key_info, std::vector<sgc::keyword_manager::keyword_data_t> &key_array)
{
	// {block}
	// L[[h^Cv
	{
		wchar_t type[256];
		FONT_COLOR color;
		if(swscanf(lpszLine, L"[%256s %6x %6x]", type, &color.colorText, &color.colorBack) == 3)
		{
			// sL[[h
			if(_wcsicmp(type, L"LINE") == 0)
			{
				rInfo.foLineComment.push_back(color);

				key_info.type  = sgc::KT_LINE;
				key_info.index = rInfo.foLineComment.size() - 1;
				return true;
			}
			// ʏL[[h
			if(_wcsicmp(type, L"NORMAL") == 0)
			{
				rInfo.foComment.push_back(color);

				key_info.type  = sgc::KT_NORMAL;
				key_info.index = rInfo.foComment.size() - 1;
				return true;
			}
		}
	}

	// L[[h
	if(key_info.type != sgc::KT_NONE)
	{
		wchar_t keyword[256];
		if(swscanf(lpszLine, L"%256[^\r\n]", keyword) == 1)
		{
			const sgc::keyword_manager::keyword_data_t data = {keyword, key_info};
			key_array.push_back(data);
			return true;
		}
	}
	return false;
}


sgc::charcode_linefeed_t GetLfCode(LPCWSTR lpszLfName)
{
	typedef struct tagLFNAME
	{
		LPCWSTR                  lpszLfName;
		sgc::charcode_linefeed_t lfCode;
	} LFNAME;
	const LFNAME lf_array[] =
	{
		{L"CR"   , sgc::CL_CR  },
		{L"LF"   , sgc::CL_LF  },
		{L"CR+LF", sgc::CL_CRLF},
		{L"NEL"  , sgc::CL_NEL },
		{L"LS"   , sgc::CL_LS  },
		{L"PS"   , sgc::CL_PS  },
	};

	sgc::charcode_linefeed_t lfCode = sgc::CL_DEFAULT;
	for(INT_PTR i = 0; i < countof(lf_array); i++)
	{
		if(wcscmp(lpszLfName, lf_array[i].lpszLfName) == 0)
		{
			lfCode = lf_array[i].lfCode;
			break;
		}
	}
	return lfCode;
}

COLORREF GetColorRef(LPCWSTR lpszColorName)
{
	typedef struct tagCOLORNAME
	{
		LPCWSTR  lpszColorName;
		COLORREF clIndex;
	} COLORNAME;
	const COLORNAME color_array[] =
	{
		{L"COLOR_SCROLLBAR"          , COLOR_SCROLLBAR          },
		{L"COLOR_BACKGROUND"         , COLOR_BACKGROUND         },
		{L"COLOR_ACTIVECAPTION"      , COLOR_ACTIVECAPTION      },
		{L"COLOR_INACTIVECAPTION"    , COLOR_INACTIVECAPTION    },
		{L"COLOR_MENU"               , COLOR_MENU               },
		{L"COLOR_WINDOW"             , COLOR_WINDOW             },
		{L"COLOR_WINDOWFRAME"        , COLOR_WINDOWFRAME        },
		{L"COLOR_MENUTEXT"           , COLOR_MENUTEXT           },
		{L"COLOR_WINDOWTEXT"         , COLOR_WINDOWTEXT         },
		{L"COLOR_CAPTIONTEXT"        , COLOR_CAPTIONTEXT        },
		{L"COLOR_ACTIVEBORDER"       , COLOR_ACTIVEBORDER       },
		{L"COLOR_INACTIVEBORDER"     , COLOR_INACTIVEBORDER     },
		{L"COLOR_APPWORKSPACE"       , COLOR_APPWORKSPACE       },
		{L"COLOR_HIGHLIGHT"          , COLOR_HIGHLIGHT          },
		{L"COLOR_HIGHLIGHTTEXT"      , COLOR_HIGHLIGHTTEXT      },
		{L"COLOR_BTNFACE"            , COLOR_BTNFACE            },
		{L"COLOR_BTNSHADOW"          , COLOR_BTNSHADOW          },
		{L"COLOR_GRAYTEXT"           , COLOR_GRAYTEXT           },
		{L"COLOR_BTNTEXT"            , COLOR_BTNTEXT            },
		{L"COLOR_INACTIVECAPTIONTEXT", COLOR_INACTIVECAPTIONTEXT},
		{L"COLOR_BTNHIGHLIGHT"       , COLOR_BTNHIGHLIGHT       },
	};

	COLORREF color = 0;
	for(INT_PTR i = 0; i < countof(color_array); i++)
	{
		const wchar_t *lpszIndexColorName = color_array[i].lpszColorName;
		if(wcscmp(lpszColorName, lpszIndexColorName) == 0)
		{
			color = 0xff000000 | color_array[i].clIndex;
			goto found;
		}
	}
	swscanf(lpszColorName, L"%6x", &color);

found:
	return color;
}

}
