// CodePage.cpp cCve[Vt@C
#include "CodePage.h"
#include <algorithm>                        // std::copy()


// UTFBOM
typedef struct tagUTF_BOM
{
	BYTE bom[4];                            // BOMp^[
	UINT bom_size;                          // BOMTCYioCgj
	UINT codepage;                          // R[hy[W
} UTF_BOM;

// eGR[h̏
const UTF_BOM g_utf_bom_array[] =
{
	{{0xef, 0xbb, 0xbf}, 3, CODEPAGE_UTF8   },  // UTF-8
	{{0xff, 0xfe      }, 2, CODEPAGE_UTF16LE},  // UTF-16LE
	{{0xfe, 0xff      }, 2, CODEPAGE_UTF16BE},  // UTF-16BE
};


////////////////////////////////////////////////////////////
// o

UINT CodePage_AutoDetect(wxc::COM_XMultiLanguage2 &xMultiLanguage2, LPCSTR pSrcStr, const SIZE_T cSrcSize, UINT &rOffset, const UINT uOption /* = CPAD_DETECTBOM */, const UINT uDefaultCodePage /* = CODEPAGE_ERROR */)
{
	// BOMo
	if(uOption & CPAD_DETECTBOM)
	{
		for(int i = 0; i < countof(g_utf_bom_array); i++)
		{
			const UTF_BOM &utf_bom = g_utf_bom_array[i];
			const UINT bom_size = utf_bom.bom_size;
			if(cSrcSize >= bom_size && memcmp(pSrcStr, utf_bom.bom, bom_size) == 0)
			{
				// BOM當R[h
				rOffset = bom_size;
				return utf_bom.codepage;
			}
		}
	}

	// BOMȂCOMɔC
	rOffset = 0;
	const UINT uCodePage = xMultiLanguage2.AutoDetect(pSrcStr, cSrcSize);
	if(uCodePage != CODEPAGE_ERROR)
	{
		return uCodePage;
	}

	// oɎsftHg̃R[hy[WԂ
	return uDefaultCodePage;
}

BOOL CodePage_GetBOM(const UINT uCodePage, BYTE rBom[], UINT &rBomSize)
{
	for(int i = 0; i < countof(g_utf_bom_array); i++)
	{
		const UTF_BOM &utf_bom = g_utf_bom_array[i];
		if(uCodePage == utf_bom.codepage)
		{
			rBomSize = utf_bom.bom_size;
			std::copy(utf_bom.bom, utf_bom.bom + utf_bom.bom_size, rBom);
			return TRUE;
		}
	}
	return FALSE;
}
