// ToolBarCtrl.cpp cCve[Vt@C
#include "ToolBarCtrl.h"
#include "wgfunc.h"                     // wgc::wgfLoadString()
#include <assert.h>                     // assert()


_WGC_BEGIN                              // namespace wgc {

// RXgN^
ToolBarCtrl::ToolBarCtrl(void)
{
}

// fXgN^
ToolBarCtrl::~ToolBarCtrl(void)
{
}


// c[o[̍쐬
BOOL ToolBarCtrl::Create(
	Window *parent,
	HIMAGELIST hImageList,
	HIMAGELIST hHotImageList,
	HIMAGELIST hDisabledImageList,
	HINSTANCE hResource,
	const int arCommand[],
	const int nCommandCount,
	const DWORD dwStyle        /* = WS_CHILD | WS_VISIBLE */,
	const DWORD dwCtlStyle     /* = CCS_TOP | CCS_ADJUSTABLE */,
	const DWORD dwToolBarStyle /* = TBSTYLE_FLAT | TBSTYLE_TOOLTIPS | TBSTYLE_ALTDRAG */,
	const DWORD dwExStyle      /* = 0 */,
	const UINT  nID            /* = IDW_STD_TOOLBAR */)
{
	assert(parent != NULL);

	m_button_array.resize(nCommandCount);
	std::vector<TBBUTTON> tbbutton(nCommandCount);

	int nButtonCount = 0;
	for(int i = 0; i < nCommandCount; i++)
	{
		if(arCommand[i] == 0)
		{
			tbbutton[i].iBitmap   = 0;
			tbbutton[i].idCommand = 0;
			tbbutton[i].fsState   = TBSTATE_ENABLED;
			tbbutton[i].fsStyle   = TBSTYLE_SEP;
		}
		else
		{
			tbbutton[i].iBitmap   = nButtonCount++;
			tbbutton[i].idCommand = arCommand[i];
			tbbutton[i].fsState   = TBSTATE_ENABLED;
			tbbutton[i].fsStyle   = TBSTYLE_BUTTON;
		}
		tbbutton[i].dwData  = 0;
		tbbutton[i].iString = 0;

		m_button_array[i].button = tbbutton[i];

		// {block}
		// @peLXg
		{
			tstring_t text;
			wgfLoadString(hResource, arCommand[i], text);
			wgfExtractSubString(m_button_array[i].str, text, 0, _T('\n'));
		}
	}

	// Rg[̃X^C܂Ƃ߂
	const BOOL bResult = Control::Create(
		TOOLBARCLASSNAME, _T(""),
		dwStyle, dwCtlStyle | (dwToolBarStyle & (~TBSTYLE_FLAT)), dwExStyle,
		parent,
		nID);

	if(!bResult)
	{
		return FALSE;
	}

	// TBSTYLE_FLAT ǉ
	if(dwToolBarStyle & TBSTYLE_FLAT)
	{
		const DWORD dwAllStyle = dwStyle | dwCtlStyle | dwToolBarStyle;
		SetStyle(dwAllStyle);
	}

	// C[WXgݒ
	SetImageList        (hImageList);
	SetHotImageList     (hHotImageList);
	SetDisabledImageList(hDisabledImageList);

	AddButtons(&tbbutton[0], static_cast<UINT>(tbbutton.size()));
	return TRUE;
}


////////////////////////////////////////////////////////////
// Agr[g

void ToolBarCtrl::GetButtonSize(SIZE &size) const
{
	const LRESULT lSize = SendMessage(TB_GETBUTTONSIZE);
	size.cx = LOWORD(lSize);
	size.cy = HIWORD(lSize);
}

BOOL ToolBarCtrl::GetButton(const UINT iButton, TBBUTTON &tbButton) const
{
	const LRESULT lResult = SendMessage(TB_GETBUTTON, iButton, reinterpret_cast<LPARAM>(&tbButton));
	return static_cast<BOOL>(lResult);
}

UINT ToolBarCtrl::GetButtonCount(void) const
{
	const LRESULT lResult = SendMessage(TB_BUTTONCOUNT);
	return static_cast<UINT>(lResult);
}

BOOL ToolBarCtrl::GetMaxSize(SIZE &size) const
{
	const LRESULT lResult = SendMessage(TB_GETMAXSIZE, 0, reinterpret_cast<LPARAM>(&size));
	return static_cast<BOOL>(lResult);
}


////////////////////////////////////////////////////////////
// Iy[V

void ToolBarCtrl::Customize(void)
{
	SendMessage(TB_CUSTOMIZE);
}

BOOL ToolBarCtrl::AddButtons(LPTBBUTTON lpButtons, const UINT nNumButtons)
{
	const LRESULT lResult = SendMessage(TB_ADDBUTTONS, nNumButtons, reinterpret_cast<LPARAM>(lpButtons));
	return static_cast<BOOL>(lResult);
}

BOOL ToolBarCtrl::DeleteButton(const UINT iButton)
{
	const LRESULT lResult = SendMessage(TB_DELETEBUTTON, iButton);
	return static_cast<BOOL>(lResult);
}

// C[WXg
HIMAGELIST ToolBarCtrl::SetImageList(HIMAGELIST hImageList)
{
	LRESULT lResult = SendMessage(
		TB_SETIMAGELIST,
		0,
		reinterpret_cast<LPARAM>(hImageList));

	return reinterpret_cast<HIMAGELIST>(lResult);
}

HIMAGELIST ToolBarCtrl::SetHotImageList(HIMAGELIST hHotImageList)
{
	LRESULT lResult = SendMessage(
		TB_SETHOTIMAGELIST,
		0,
		reinterpret_cast<LPARAM>(hHotImageList));

	return reinterpret_cast<HIMAGELIST>(lResult);
}

HIMAGELIST ToolBarCtrl::SetDisabledImageList(HIMAGELIST hDisabledImageList)
{
	LRESULT lResult = SendMessage(
		TB_SETDISABLEDIMAGELIST,
		0,
		reinterpret_cast<LPARAM>(hDisabledImageList));

	return reinterpret_cast<HIMAGELIST>(lResult);
}

void ToolBarCtrl::SaveRestore(const BOOL bSave, TBSAVEPARAMS &tbSaveParams)
{
	SendMessage(TB_SAVERESTORE, bSave, reinterpret_cast<LPARAM>(&tbSaveParams));
}


////////////////////////////////////////////////////////////////////////////////
// ʒmbZ[W̏
BOOL ToolBarCtrl::HandleNotifyMessage(LPNMHDR lpNmHeader, BOOL &bResult)
{
	LPTBNOTIFY lpTbNotify = reinterpret_cast<LPTBNOTIFY>(lpNmHeader);
	switch(lpNmHeader->code)
	{
	case TBN_BEGINADJUST: OnNotify_BeginAdjust(lpTbNotify); break;
	case TBN_ENDADJUST:   OnNotify_EndAdjust  (lpTbNotify); break;

	case TBN_BEGINDRAG: OnNotify_BeginDrag(lpTbNotify); break;
	case TBN_ENDDRAG:   OnNotify_EndDrag  (lpTbNotify); break;

	case TBN_QUERYINSERT: bResult = OnNotify_QueryInsert(lpTbNotify); break;
	case TBN_QUERYDELETE: bResult = OnNotify_QueryInsert(lpTbNotify); break;

	case TBN_GETBUTTONINFO: bResult = OnNotify_GetButtonInfo(lpTbNotify); break;

	case TBN_TOOLBARCHANGE: OnNotify_ToolbarChange(lpTbNotify); break;
	case TBN_RESET:         OnNotify_Reset        (lpTbNotify); break;
	case TBN_CUSTHELP:      OnNotify_CustHelp     (lpTbNotify); break;

	default:
		return FALSE;
	}
	return bResult;
}


// ʒmbZ[Wnh
void ToolBarCtrl::OnNotify_BeginAdjust(LPTBNOTIFY /* lpNotify */)
{
}

void ToolBarCtrl::OnNotify_EndAdjust(LPTBNOTIFY /* lpNotify */)
{
}


BOOL ToolBarCtrl::OnNotify_QueryInsert(LPTBNOTIFY /* lpNotify */)
{
	return TRUE;
}

BOOL ToolBarCtrl::OnNotify_QueryDelete(LPTBNOTIFY /* lpNotify */)
{
	return TRUE;
}


void ToolBarCtrl::OnNotify_BeginDrag(LPTBNOTIFY /* lpNotify */)
{
}

void ToolBarCtrl::OnNotify_EndDrag(LPTBNOTIFY /* lpNotify */)
{
}


BOOL ToolBarCtrl::OnNotify_GetButtonInfo(LPTBNOTIFY lpNotify)
{
	const size_t iItem = lpNotify->iItem;
	const size_t size  = m_button_array.size();
	if(iItem < size)
	{
		const button_info_t &info = m_button_array[iItem];

		// {^
		lpNotify->tbButton = info.button;

		// eLXg
		if(lpNotify->pszText != NULL)
		{
			const tstring_t &strText = info.str;

			::lstrcpyn(lpNotify->pszText, strText.c_str(), lpNotify->cchText);
			lpNotify->cchText = static_cast<int>(strText.length());
		}

		return TRUE;
	}
	return FALSE;
}


void ToolBarCtrl::OnNotify_ToolbarChange(LPTBNOTIFY /* lpNotify */)
{
}

void ToolBarCtrl::OnNotify_Reset(LPTBNOTIFY /* lpNotify */)
{
	// {block}
	// {^ׂč폜
	{
		const SIZE_T nOldButtonCount = GetButtonCount();
		for(SIZE_T i = 0; i < nOldButtonCount; i++)
		{
			DeleteButton(0);
		}
	}

	// {block}
	// ǉȂ
	{
		const SIZE_T nNewButtonCount = m_button_array.size();

		std::vector<TBBUTTON> tbbutton_array(nNewButtonCount);
		for(SIZE_T i = 0; i < nNewButtonCount; i++)
		{
			tbbutton_array[i] = m_button_array[i].button;
		}
		AddButtons(&tbbutton_array[0], static_cast<UINT>(nNewButtonCount));
	}
}

void ToolBarCtrl::OnNotify_CustHelp(LPTBNOTIFY /* lpNotify */)
{
}

_WGC_END                                // }
