// ScrollBarCtrl.h cXN[o[Rg[̃TuNX
#ifndef __WGC_SCROLLBARCTRL__
#define __WGC_SCROLLBARCTRL__

#include "Control.h"
#include <commctrl.h>


_WGC_BEGIN                              // namespace wgc {

class ScrollBarCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit ScrollBarCtrl(void);
	virtual ~ScrollBarCtrl(void);

	// XN[
	BOOL SetScrollInfo(const SCROLLINFO &si, const BOOL bRedraw = TRUE);
	BOOL GetScrollInfo(      SCROLLINFO &si, const UINT nMask = SIF_ALL) const;

	// y[WTCY
	int GetPageSize(void) const;
	int SetPageSize(const int nSize);

	// ͈
	void GetRange(      int &rMin,       int &rMax) const;
	void SetRange(const int  nMin, const int  nMax, const BOOL bRedraw = FALSE);

	// XN[ʒu
	int GetPos(void) const;
	void SetPos(const int nPos, const BOOL bRedraw = TRUE);

	// 
	BOOL EnableArrow(const UINT nArrowFlags = ESB_ENABLE_BOTH);

	int GetLimit(void) const;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(ScrollBarCtrl)
};

_WGC_END                                // }

#endif // __WGC_SCROLLBARCTRL__
