// gap_vector : MbvxN^
#ifndef GAP_VECTOR
#define GAP_VECTOR

#include <stddef.h>
#include <assert.h>


template <typename _Ty, const size_t GROW_GAP_SIZE = 256>
class gap_vector
{
public:
	////////////////////////////////////////////////////////////////////////////////
	// RXgNV
	gap_vector(const size_t size = 0, const size_t size_gap = GROW_GAP_SIZE)
		: m_buffer(NULL), m_size(size), m_size_gap(size_gap), m_index_gap(size)
	{
		m_buffer = new _Ty[m_size + m_size_gap];
	}

	~gap_vector(void)
	{
		delete []m_buffer;
		m_buffer = NULL;
	}

	////////////////////////////////////////////////////////////////////////////////
	// Iy[V
	_Ty &operator [](const size_t index)
	{
		if(index < m_index_gap) { return m_buffer[index]; }
		return m_buffer[m_size_gap + index];
	}

	const _Ty &operator [](const size_t index) const
	{
		if(index < m_index_gap) { return m_buffer[index]; }
		return m_buffer[m_size_gap + index];
	}

	// }
	void insert(const size_t index, const _Ty &datum, const size_t count = 1)
	{
		// MbvTCYȂΊg
		if(m_size_gap < count) { _GrowGap(count + GROW_GAP_SIZE); }

		// }ɌԂ󂯂
		_MoveGap(index);
		assert(m_index_gap == index);

		_GrowSize(count);

		// }
		for(size_t i = 0; i < count; i++) { m_buffer[index + i] = datum; }
		m_index_gap += count;
	}

	void insert(const size_t index, const _Ty data[], const size_t count)
	{
		// MbvTCYȂΊg
		if(m_size_gap < count) { _GrowGap(count + GROW_GAP_SIZE); }

		// }ɌԂ󂯂
		_MoveGap(index);
		assert(m_index_gap == index);

		_GrowSize(count);

		// }
		for(size_t i = 0; i < count; i++) { m_buffer[index + i] = data[i]; }
		m_index_gap += count;
	}

	// 폜
	void erase(const size_t index, const size_t count)
	{
		if(index + count < m_index_gap)
		{
			_MoveGap(index + count);
			_ShrinkSize(count);
			m_index_gap -= count;
			return;
		}
		if(index > m_index_gap + m_size_gap)
		{
			_MoveGap(index - m_size_gap);
			_ShrinkSize(count);
			return;
		}

		m_index_gap = index;
		_ShrinkSize(count);
	}

	////////////////////////////////////////////////////////////////////////////////
	// Agr[g
	size_t size(void) const
	{
		return m_size;
	}

private:
	_Ty   *m_buffer;
	size_t m_size;
	size_t m_size_gap;
	size_t m_index_gap;

	// index ̈ʒuɌԂ󂯂
	void _MoveGap(const size_t index)
	{
		if(index < m_index_gap)
		{
			const size_t count = m_index_gap - index;
			const size_t index_dst = m_index_gap + m_size_gap - 1;
			const size_t index_src = m_index_gap - 1;

			for(size_t i = 0; i < count; i++)
			{
				m_buffer[index_dst - i] = m_buffer[index_src - i];
			}
			m_index_gap -= count;
		}
		else
		{
			const size_t count = index - m_index_gap;
			const size_t index_dst = m_index_gap;
			const size_t index_src = m_index_gap + m_size_gap;

			for(size_t i = 0; i < count; i++)
			{
				m_buffer[index_dst + i] = m_buffer[index_src + i];
			}
			m_index_gap += count;
		}
	}

	// Ԃg
	void _GrowGap(const size_t grow_size)
	{
		_Ty *buffer = new _Ty[m_size + m_size_gap + grow_size];

		// [block]
		// Ԃ̑ORs[
		{
			const size_t count = m_index_gap;
			for(size_t i = 0; i < count; i++)
			{
				buffer[i] = m_buffer[i];
			}
		}

		// [block]
		// Ԃ̌Rs[
		{
			const size_t count = m_size - m_index_gap;
			const size_t index = m_index_gap + m_size_gap;
			for(size_t i = 0; i < count; i++)
			{
				buffer[index + grow_size + i] = m_buffer[index + i];
			}
		}

		// J
		delete []m_buffer;
		m_buffer = buffer;
		m_size_gap += grow_size;
	}

	// Ԃgăobt@g
	void _GrowSize(const size_t size_grow)
	{
		assert(m_size_gap >= size_grow);
		m_size     += size_grow;
		m_size_gap -= size_grow;
	}

	// obt@Ԃ֖߂
	void _ShrinkSize(const size_t size_shrink)
	{
		assert(m_size <= size_shrink);
		m_size     -= size_shrink;
		m_size_gap += size_shrink;
	}
};

#endif // GAP_VECTOR
