// charcode.h cLN^R[hɊւ鏈
// ɂLN^R[h̕ނsR[h́uChUnicodevł
// 肵̂Ȃ̂ŁÃChZbgg悤Ȋł
// ɂ킹ĕς邱ƁB
#ifndef __CHARCODE__
#define __CHARCODE__

#include "sgc.h"
#include <wchar.h>


_SGC_BEGIN                              // namespace sgc {

////////////////////////////////////////////////////////////
// 萔
#define CHARCODE_POS_INVALID    static_cast<size_t>(-1)


////////////////////////////////////////////////////////////
// R[h
const wchar_t wNUL = L'\0';             // NUL : U+0000

const wchar_t wTAB       = L'\t';       // TAB       : U+0009
const wchar_t wSPACE     = L' ' ;       // SPACE     : U+0020
const wchar_t wWIDESPACE = L'@';       // WIDESPACE : U+3000

const wchar_t wCR  = L'\r';             // LineFeed           : U+000A
const wchar_t wLF  = L'\n';             // CarriageReturn     : U+000D
const wchar_t wNEL = 0x0085;            // NextLine           : U+0085
const wchar_t wLS  = 0x2028;            // LineSeparator      : U+2028
const wchar_t wPS  = 0x2029;            // ParagraphSeparator : U+2029


////////////////////////////////////////////////////////////
// LN^R[g̕
typedef enum _charcode_categorize_t
{
	CC_SPACE,                               // zCgXy[X
	CC_ALPHA_UPPER,                         // At@xbg啶
	CC_ALPHA_LOWER,                         // At@xbg
	CC_NUMBER,                              // 
	CC_UNDERSCORE,                          // A_[XRAi_j
	CC_BRACKET,                             // ʁi()[]{}<>j
	CC_SPECIAL,                             // ꕶi#$"'%&~^\+-*/@`;:,.!?|j

	CC_WIDE_ALPHA_UPPER,                    // SpAt@xbg啶
	CC_WIDE_ALPHA_LOWER,                    // SpAt@xbg
	CC_WIDE_NUMBER,                         // Sp
	CC_WIDE_BRACKET,                        // Sp

	// {
	CC_JAPANESE_HIRAGANA,                   // Ђ炪
	CC_JAPANESE_KATAKANA,                   // J^Ji
	CC_JAPANESE_KANJI,                      // 
	CC_JAPANESE_SYMBOL,                     // L

	// nO
	CC_HANGEUL,                             // nO

	// 
	CC_CYRILLIC,                            // L
	CC_ARMENIAN,                            // AjA
	CC_HEBREW,                              // wuC
	CC_ARABIC,                              // ArA
	CC_ARABIC_NUMBER,                       // ArAiigĂ鐔Ƃ͈Ⴄ炵j
	CC_DEVANAGARI,                          // foi[K
	CC_DEVANAGARI_NUMBER,                   // foi[K

	CC_ETC,                                 // ȊO
} charcode_categorize_t;

void                  charcode_categorize_init(void);
charcode_categorize_t charcode_categorize(const wchar_t wchar);


////////////////////////////////////////////////////////////
// sʒǔ

// sR[h^Cv
typedef enum _charcode_linefeed_t
{
	CL_DEFAULT,                             // wȂiftHgj
	CL_CR,                                  // CRiMacintosh`j
	CL_LF,                                  // LFiUnix`j
	CL_CRLF,                                // CR-LFiWindows`j
	CL_NEL,                                 // NextLine
	CL_LS,                                  // LineSeparator
	CL_PS,                                  // ParagraphSeparator
} charcode_linefeed_t;

size_t               charcode_find_linefeed(const wchar_t *wstr, const size_t size, charcode_linefeed_t &type, size_t &skip);
bool                 charcode_set_linefeed_default(const charcode_linefeed_t type);
charcode_linefeed_t  charcode_set_linefeed_default(void);
const wchar_t       *charcode_get_linefeed_string (const charcode_linefeed_t type);

_SGC_END                                // }

#endif // __CHARCODE__
