// Thread.cpp cCve[Vt@C
#include "Thread.h"
#include "wgfunc.h"                     // wgc::wgfThrowLastError()
#include <windows.h>                    // ::xxxThread(), ::WaitForSingleObject(), ::CloseHandle()
#include <assert.h>                     // assert()

#ifdef _CRT
#include <process.h>                    // _beginthreadex(), _endthreadex()
#endif


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// Xbh

////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
ThreadBase::ThreadBase(void) : m_lpParameter(NULL), m_hThread(NULL)
{
}

// fXgN^
ThreadBase::~ThreadBase(void)
{
	// nhJ
	::CloseHandle(m_hThread);
	m_hThread = NULL;
}

void ThreadBase::Run(LPVOID lpParameter /* = NULL */, const DWORD dwCreationFlags /* = 0 */)
{
	m_lpParameter = lpParameter;

	// Xbh쐬
	m_hThread = Create(_ThreadProc, this, dwCreationFlags);

	// Xbh̍쐬Ɏsꍇ
	if(m_hThread == NULL)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////
// Iy[V

// f
DWORD ThreadBase::Suspend(void)
{
	return ::SuspendThread(m_hThread);
}

// ĊJ
DWORD ThreadBase::Resume(void)
{
	return ::ResumeThread(m_hThread);
}

// ҋ@
DWORD ThreadBase::Wait(const DWORD dwMilliseconds /* = INFINITE */)
{
	return ::WaitForSingleObject(m_hThread, dwMilliseconds);
}


////////////////////////////////////////////////////////////
// _CRT}N`Ăꍇ

#ifdef _CRT

// I
VOID ThreadBase::Exit(const DWORD dwExitCode /* = 0 */)
{
	_endthreadex(dwExitCode);
}

// VKXbh쐬
HANDLE ThreadBase::Create(
	unsigned int (__stdcall *start_address)(void *),
	void                    *this_ptr,
	unsigned int             initflag)
{
	unsigned int thread_id;

	uintptr_t handle = _beginthreadex(
		NULL         , 0,
		start_address, this_ptr,
		initflag     , &thread_id);

	return reinterpret_cast<HANDLE>(handle);
}

// XbhvV[W
unsigned int __stdcall ThreadBase::_ThreadProc(LPVOID lpParameter)
{
	assert(lpParameter != NULL);

	// XbhJn
	ThreadBase *lpThis = reinterpret_cast<ThreadBase *>(lpParameter);
	return lpThis->ThreadMain(lpThis->m_lpParameter);
}

////////////////////////////////////////////////////////////
// _CRT}N`ĂȂꍇ
#else

// I
VOID ThreadBase::Exit(const DWORD dwExitCode /* = 0 */)
{
	::ExitThread(dwExitCode);
}

// VKXbh쐬
HANDLE ThreadBase::Create(
	LPTHREAD_START_ROUTINE lpStartAddress,
	LPVOID                 lpThis,
	DWORD                  dwCreationFlags)
{
	DWORD dwThreadID;

	HANDLE hThread = ::CreateThread(
		NULL, 0,
		lpStartAddress, lpThis,
		dwCreationFlags, &dwThreadID);

	return hThread;
}

// XbhvV[W
DWORD WINAPI ThreadBase::_ThreadProc(LPVOID lpParameter)
{
	assert(lpParameter != NULL);

	// XbhJn
	ThreadBase *lpThis = reinterpret_cast<ThreadBase *>(lpParameter);
	return lpThis->ThreadMain(lpThis->m_lpParameter);
}

#endif

_WGC_END                                // }
