// edit_line.h cGfB^1si[NX
#ifndef __SGC_EDIT_LINE__
#define __SGC_EDIT_LINE__

#include "sgc.h"
#include "charcode.h"                   // charcode_linefeed_t
#include <string>                       // std::string


_SGC_BEGIN                              // namespace sgc {

// 1s̃f[^i[
// sR[h̎ނłɋLĂ̂ŁA
// ۑɌ̉̕sR[h𕜌łB
class edit_line
{
public:
	typedef wstring_t::size_type pos_t;
	typedef wstring_t::size_type size_t;

public:
	edit_line(                                        const charcode_linefeed_t lf = CL_DEFAULT);
	edit_line(const wchar_t *wstr, const size_t size, const charcode_linefeed_t lf = CL_DEFAULT);
	edit_line(const wstring_t &wstr                 , const charcode_linefeed_t lf = CL_DEFAULT);
	edit_line(const edit_line &rhs);

	size_t              length (void) const;
	const wchar_t      *c_str  (void) const;
	charcode_linefeed_t lf_type(void) const;

	wstring_t substr(const pos_t offset, const size_t count = -1) const;

	void insert   (const pos_t pos, const wchar_t *wstr, const size_t size);
	void overwrite(const pos_t pos, const wchar_t *wstr, const size_t size, wstring_t *deleted_ptr = NULL);
	void erase(const pos_t pos, const size_t size = -1, wstring_t *deleted_ptr = NULL);
	void split(const pos_t pos, edit_line &line_front, edit_line &line_rear) const;

	edit_line  operator + (const edit_line &rhs) const;
	edit_line  operator + (const wstring_t &rhs) const;
	edit_line &operator +=(const edit_line &rhs);
	edit_line &operator +=(const wstring_t &rhs);
	edit_line &operator = (const edit_line &rhs);
	edit_line &operator = (const wstring_t &rhs);

private:
	wstring_t           m_buffer;           // 1s̕f[^
	charcode_linefeed_t m_lf;               // sR[h
};

_SGC_END                                // }

#endif // __SGC_EDIT_LINE__
