// DialogPropertySheet.cpp cCve[Vt@C
#include "DialogPropertySheet.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogPropertySheet::DialogPropertySheet(const UINT uCaptionID, HINSTANCE hResource, HWND hWndParent /* = NULL */, const DWORD dwPshFlags /* = PSH_DEFAULT */)
	: m_uCaptionID(uCaptionID), m_dwPshFlags(dwPshFlags), m_hResource(hResource), m_hWndParent(hWndParent)
{
	wgc::wgfLoadString(m_hResource, m_uCaptionID, m_caption);
}

// fXgN^
DialogPropertySheet::~DialogPropertySheet(void)
{
}


INT_PTR DialogPropertySheet::DoModal(const LPARAM /* dwInitParam = 0 */)
{
	PROPSHEETHEADER psh;
	SetPSH(psh);

	_SetHookTarget(this);
	const INT_PTR result = ::PropertySheet(&psh);
	if(result < 0)
	{
		_SetHookTarget(NULL);
		wgfThrowLastError();
	}
	return result;
}

// [hX\
BOOL DialogPropertySheet::DoModeless(const LPARAM /* dwInitParam = 0 */)
{
	// 
	return TRUE;
}


void DialogPropertySheet::SetSheets(LPPROPPAGE_OBJ pPageArray[], const int nSheetCount)
{
	m_vPropSheetPage.resize(nSheetCount);
	for(int i = 0; i < nSheetCount; i++)
	{
		pPageArray[i]->GetPropPage(m_vPropSheetPage[i]);
	}
}

void DialogPropertySheet::SetPSH(PROPSHEETHEADER &psh) const
{
	psh.dwSize     = sizeof(psh);
	psh.dwFlags    = PSH_PROPSHEETPAGE | (m_dwPshFlags & (PSH_HASHELP | PSH_NOAPPLYNOW | PSH_NOCONTEXTHELP));
	psh.hwndParent = m_hWndParent;
	psh.nPages     = static_cast<int>(m_vPropSheetPage.size());
	psh.ppsp       =                 &m_vPropSheetPage[0];
	psh.hInstance  = m_hResource;
	psh.pszCaption = m_caption.c_str();
}

_WGC_END                                // }
