// Window.cpp cCve[Vt@C
#include "Window.h"
#include "wgfunc.h"                     // wgc::wgfLoadString()

#include <windowsx.h>                   // GET_WM_COMMAND_ID()
#include <commctrl.h>                   // WM_MOUSELEAVE
#include <tchar.h>                      // TCHAR
#include <assert.h>                     // assert()


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// staticϐ
tls<Window::GLOBAL_DATA> Window::m_tlsGlobalData;   // Xbh


////////////////////////////////////////////////////////////////////////////////
// RXgN^
Window::Window(HWND hWnd /* = NULL */)
{
	// Thread Local Storage ̍쐬
	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	if(pGlobalData == NULL)
	{
		// Xbh쐬
		pGlobalData = new GLOBAL_DATA;
		pGlobalData->lRefCount = 0;
		pGlobalData->hHook     = NULL;
		pGlobalData->pWindow   = NULL;

		// tbNvV[WCXg[
		pGlobalData->hHook = ::SetWindowsHookEx(
			WH_CBT,
			_CBTProc,
			NULL,
			::GetCurrentThreadId());

		// Xbhi[
		m_tlsGlobalData.SetValuePointer(pGlobalData);
	}
	pGlobalData->lRefCount++;

	// oϐ̏
	m_hWnd           = hWnd;
	m_bOwner         = FALSE;
	m_lpfnOldWndProc = NULL;
}

// fXgN^
Window::~Window(void)
{
	// L܂܃fXgN^ĂяoꂽꍇA
	// EChEjiOnNcDestroy()ĂяojO
	// EChEIuWFNgj邱ƂɂȂB
	// ̂悤ȏԂ́AX^bN Create() Ȃ
	// IuWFNg̊Ǘ~XȊOɂ肦Ȃ̂ŁA
	// G[ߑł悤ɃAT[V
	assert(!m_bOwner);


	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	assert(pGlobalData != NULL);

	// Xbh̎QƃJE^fNg
	pGlobalData->lRefCount--;
	if(pGlobalData->lRefCount == 0)
	{
		// tbNvV[WACXg[
		::UnhookWindowsHookEx(pGlobalData->hHook);
		pGlobalData->hHook = NULL;

		// Thread Local Storage NA
		m_tlsGlobalData.SetValuePointer();

		delete pGlobalData;
		pGlobalData = NULL;
	}
}


Window::operator HWND(void) const
{
	return IsWindow() ? m_hWnd : NULL;
}


////////////////////////////////////////////////////////////////////////////////
// EChE쐬
BOOL Window::Create(
	LPCTSTR lpszClassName, LPCTSTR lpszWindowName,
	const DWORD dwStyle, const DWORD dwExStyle,
	Window *parent,
	HMENU     hMenu     /* = NULL */,
	HINSTANCE hInstance /* = NULL */,
	const int x       /* = CW_USEDEFAULT */,
	const int y       /* = CW_USEDEFAULT */,
	const int nWidth  /* = CW_USEDEFAULT */,
	const int nHeight /* = CW_USEDEFAULT */,
	LPVOID lpParam /* = NULL */)
{
	// PreCreateWindow()Ăяo
	CREATESTRUCT cs;
	cs.dwExStyle      = dwExStyle;
	cs.lpszClass      = lpszClassName;
	cs.lpszName       = lpszWindowName;
	cs.style          = dwStyle;
	cs.x              = x;
	cs.y              = y;
	cs.cx             = nWidth;
	cs.cy             = nHeight;
	cs.hwndParent     = (parent == NULL) ? NULL : parent->m_hWnd;
	cs.hMenu          = hMenu;
	cs.hInstance      = (hInstance == NULL) ? ::GetModuleHandle(NULL) : hInstance;
	cs.lpCreateParams = lpParam;
	if(!PreCreateWindow(cs))
	{
		PostNcDestroy();
		return FALSE;
	}

	// tbNvV[WCXg[iACXg[̓tbNvV[Wōsj
	_SetHookTarget(this);
	HWND hWnd = ::CreateWindowEx(
		cs.dwExStyle,
		cs.lpszClass, cs.lpszName,
		cs.style,
		cs.x, cs.y, cs.cx, cs.cy,
		cs.hwndParent, cs.hMenu, cs.hInstance,
		cs.lpCreateParams);

	if(hWnd == NULL)
	{
		_SetHookTarget(NULL);
		return FALSE;
	}

	assert(hWnd == m_hWnd);
	return TRUE;
}


// gbvXg\
void Window::SetTopmost(const BOOL bTopmost)
{
	// gbvXg^gbvXg\
	SetWindowPos(
		bTopmost ? HWND_TOPMOST : HWND_NOTOPMOST,
		0, 0, 0, 0,
		SWP_SHOWWINDOW | SWP_NOSIZE | SWP_NOMOVE);
}


////////////////////////////////////////////////////////////////////////////////
// ff֐

BOOL Window::IsWindow(void) const
{
	return (this != NULL) && ::IsWindow(m_hWnd);
}

BOOL Window::IsChild(HWND hWnd) const
{
	return ::IsChild(m_hWnd, hWnd);
}


////////////////////////////////////////////////////////////////////////////////
// EChEID֐

HWND Window::GetDlgItem(const int nIDDlgItem) const
{
	return ::GetDlgItem(m_hWnd, nIDDlgItem);
}

WORD Window::GetDlgCtrlID(void) const
{
	const int nID = ::GetDlgCtrlID(m_hWnd);
	return static_cast<WORD>(nID);
}


////////////////////////////////////////////////////////////////////////////////
// X^C֐

BOOL Window::IsTopmost(void) const
{
	return GetExStyle() & WS_EX_TOPMOST;
}

DWORD Window::GetStyle(void) const
{
	return ::GetWindowLong(m_hWnd, GWL_STYLE);
}

void Window::SetStyle(const DWORD dwStyle)
{
	::SetWindowLong(m_hWnd, GWL_STYLE, dwStyle);
}

DWORD Window::GetExStyle(void) const
{
	return ::GetWindowLong(m_hWnd, GWL_EXSTYLE);
}

void Window::SetExStyle(const DWORD dwExStyle)
{
	::SetWindowLong(m_hWnd, GWL_EXSTYLE, dwExStyle);
}

void Window::ModifyStyle(const DWORD dwRemove, const DWORD dwAdd, const DWORD dwExRemove, const DWORD dwExAdd, const BOOL bRedraw /* = TRUE */)
{
	// {block}
	// X^CύX
	{
		DWORD dwStyle = GetStyle();
		dwStyle &= ~dwRemove;
		dwStyle |= dwAdd;
		SetStyle(dwStyle);
	}

	// {block}
	// gX^CύX
	{
		DWORD dwExStyle = GetExStyle();
		dwExStyle &= ~dwExRemove;
		dwExStyle |= dwExAdd;
		SetExStyle(dwExStyle);
	}

	// ĕ`
	if(bRedraw)
	{
		Invalidate();
		UpdateWindow();
	}
}


////////////////////////////////////////////////////////////////////////////////
// ^C}֐

UINT_PTR Window::SetTimer(const UINT_PTR uIDEvent, const UINT uElapse, TIMERPROC lpTimerFunc /* = NULL */)
{
	const UINT_PTR uNewID = ::SetTimer(m_hWnd, uIDEvent, uElapse, lpTimerFunc);
	if(uNewID == 0)
	{
		wgfThrowLastError();
	}

	return uNewID;
}

void Window::KillTimer(const UINT_PTR uIDEvent)
{
	const BOOL bResult = ::KillTimer(m_hWnd, uIDEvent);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// L/

// XV̈͂ދ`擾
BOOL Window::GetUpdateRect(RECT &rRect, const BOOL bErase /* = TRUE */)
{
	return ::GetUpdateRect(m_hWnd, &rRect, bErase);
}

// XV̈擾
BOOL Window::GetUpdateRgn(HRGN hRgn, const BOOL bErase /* = TRUE */)
{
	return ::GetUpdateRgn(m_hWnd, hRgn, bErase);
}

// NCAg̈ŜL
void Window::Validate(void)
{
	const BOOL bResult = ::ValidateRect(m_hWnd, NULL);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// NCAg̈̎w肵`L
void Window::ValidateRect(const RECT &rRect)
{
	const BOOL bResult = ::ValidateRect(m_hWnd, &rRect);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// NCAg̈̎w肵̈L
void Window::ValidateRgn(HRGN hRgn)
{
	const BOOL bResult = ::ValidateRgn(m_hWnd, hRgn);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// NCAg̈Ŝ𖳌
void Window::Invalidate(const BOOL bErase /* = TRUE */)
{
	const BOOL bResult = ::InvalidateRect(m_hWnd, NULL, bErase);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// NCAg̈̎w肵`𖳌
void Window::InvalidateRect(const RECT &rRect, const BOOL bErase /* = TRUE */)
{
	const BOOL bResult = ::InvalidateRect(m_hWnd, &rRect, bErase);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// NCAg̈̎w肵̈𖳌
void Window::InvalidateRgn(HRGN hRgn, const BOOL bErase /* = TRUE */)
{
	const BOOL bResult = ::InvalidateRgn(m_hWnd, hRgn, bErase);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// `֐

HDC Window::BeginPaint(LPPAINTSTRUCT ps)
{
	HDC hDC = ::BeginPaint(m_hWnd, ps);
	if(hDC == NULL)
	{
		wgfThrowLastError();
	}

	return hDC;
}

void Window::EndPaint(const PAINTSTRUCT *ps)
{
	::EndPaint(m_hWnd, ps);
}


////////////////////////////////////////////////////////////////////////////////
// tH[JX֐

HWND Window::SetFocus(void)
{
	return ::SetFocus(m_hWnd);
}

BOOL Window::SetForegroundWindow(void)
{
	return ::SetForegroundWindow(m_hWnd);
}

BOOL Window::IsFocused(void) const
{
	return ::GetFocus() == m_hWnd;
}


////////////////////////////////////////////////////////////////////////////////
// Jbg֐

void Window::CreateCaret(HBITMAP hBitmap, const int nWidth, const int nHeight) const
{
	const BOOL bResult = ::CreateCaret(m_hWnd, hBitmap, nWidth, nHeight);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::CreateSolidCaret(const int nWidth, const int nHeight) const
{
	CreateCaret(NULL, nWidth, nHeight);
}

void Window::CreateGrayCaret(const int nWidth, const int nHeight) const
{
	CreateCaret(reinterpret_cast<HBITMAP>(1), nWidth, nHeight);
}

BOOL Window::ShowCaret(void) const
{
	return ::ShowCaret(m_hWnd);
}

BOOL Window::HideCaret(void) const
{
	return ::HideCaret(m_hWnd);
}


////////////////////////////////////////////////////////////////////////////////
// eEChE֐

HWND Window::GetParent(void) const
{
	return ::GetParent(m_hWnd);
}

HWND Window::SetParent(HWND hWndNewParent)
{
	return ::SetParent(m_hWnd, hWndNewParent);
}


////////////////////////////////////////////////////////////////////////////////
// j[֐

HMENU Window::GetMenu(void) const
{
	return ::GetMenu(m_hWnd);
}

void Window::SetMenu(HMENU hMenu)
{
	const BOOL bResult = ::SetMenu(m_hWnd, hMenu);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::DrawMenuBar(void)
{
	const BOOL bResult = ::DrawMenuBar(m_hWnd);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// tHg֐

HFONT Window::GetFont(void) const
{
	const LRESULT lResult = SendMessage(WM_GETFONT);
	return reinterpret_cast<HFONT>(lResult);
}

void Window::SetFont(HFONT hFont, const BOOL bRedraw /* = TRUE */)
{
	SendMessage(
		WM_SETFONT,
		reinterpret_cast<WPARAM>(hFont),
		MAKELPARAM(bRedraw, 0));
}


////////////////////////////////////////////////////////////////////////////////
// }EX֐

HWND Window::SetCapture(void)
{
	return ::SetCapture(m_hWnd);
}


////////////////////////////////////////////////////////////////////////////////
// XN[֐

int Window::SetHScrollInfo(const SCROLLINFO &si, const BOOL bRedraw /* = TRUE */)
{
	return ::SetScrollInfo(m_hWnd, SB_HORZ, &si, bRedraw);
}

int Window::SetVScrollInfo(const SCROLLINFO &si, const BOOL bRedraw /* = TRUE */)
{
	return ::SetScrollInfo(m_hWnd, SB_VERT, &si, bRedraw);
}

void Window::GetHScrollInfo(SCROLLINFO &si)
{
	const BOOL bResult = ::GetScrollInfo(m_hWnd, SB_HORZ, &si);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::GetVScrollInfo(SCROLLINFO &si)
{
	const BOOL bResult = ::GetScrollInfo(m_hWnd, SB_VERT, &si);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// EChËꕔXN[
void Window::ScrollWindow(
	const int dx, const int dy,
	const RECT *prcScroll /* = NULL */, const RECT *prcClip /* = NULL */)
{
	const BOOL bResult = ::ScrollWindow(m_hWnd, dx, dy, prcScroll, prcClip);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

int Window::ScrollWindowEx(
	const int dx, const int dy,
	const RECT *prcScroll  /* = NULL */, const RECT *prcClip   /* = NULL */,
	HRGN        hrgnUpdate /* = NULL */, LPRECT      prcUpdate /* = NULL */,
	const UINT  flags      /* = 0 */)
{
	return ::ScrollWindowEx(m_hWnd, dx, dy, prcScroll, prcClip, hrgnUpdate, prcUpdate, flags);
}


////////////////////////////////////////////////////////////////////////////////
// EChE

// EChËʒu
void Window::SetWindowPlacement(const WINDOWPLACEMENT &rWndPl)
{
	const BOOL bResult = ::SetWindowPlacement(m_hWnd, &rWndPl);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::GetWindowPlacement(WINDOWPLACEMENT &rWndPl) const
{
	const BOOL bResult = ::GetWindowPlacement(m_hWnd, &rWndPl);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// EChEɃeLXgo
void Window::SetWindowText(const tstring_t &tstr)
{
	const BOOL bResult = ::SetWindowText(m_hWnd, tstr.c_str());
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

int Window::GetWindowText(tstring_t &tstr) const
{
	// eLXg̒m
	const int nLength  = GetWindowTextLength();
	LPTSTR    lpString = new TCHAR[nLength + 1];

	// eLXg̓e擾
	const int nResult = ::GetWindowText(m_hWnd, lpString, nLength + 1);
	tstr.assign(lpString, nLength);

	// J
	delete []lpString;
	lpString = NULL;

	return nResult;
}

int Window::GetWindowTextLength(void) const
{
	return ::GetWindowTextLength(m_hWnd);
}


// EChËʒuݒ
void Window::SetWindowPos(HWND hWndInsertAfter, const int x, const int y, const int cx, const int cy, const UINT uFlags)
{
	const BOOL bResult = ::SetWindowPos(m_hWnd, hWndInsertAfter, x, y, cx, cy, uFlags);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::MoveWindow(const int x, const int y, const int nWidth, const int nHeight, const BOOL bRepaint /* = TRUE */)
{
	const BOOL bResult = ::MoveWindow(m_hWnd, x, y, nWidth, nHeight, bRepaint);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::MoveWindow(const RECT &rect, const BOOL bRepaint /* = TRUE */)
{
	MoveWindow(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, bRepaint);
}

void Window::MoveWindow(const POINT &point, const SIZE &size, const BOOL bRepaint /* = TRUE */)
{
	MoveWindow(point.x, point.y, size.cx, size.cy, bRepaint);
}


BOOL Window::ShowWindow(const int nCmdShow)
{
	return ::ShowWindow(m_hWnd, nCmdShow);
}

void Window::UpdateWindow(void)
{
	const BOOL bResult = ::UpdateWindow(m_hWnd);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::DestroyWindow(void)
{
	const BOOL bResult = ::DestroyWindow(m_hWnd);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// EChË֐

// `擾
void Window::GetEffectiveClientRect(RECT &rect, LPINT lpInfo) const
{
	assert(lpInfo != NULL);
	::GetEffectiveClientRect(m_hWnd, &rect, lpInfo);
}

void Window::GetClientRect(RECT &rRect) const
{
	const BOOL bResult = ::GetClientRect(m_hWnd, &rRect);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::GetWindowRect(RECT &rRect) const
{
	const BOOL bResult = ::GetWindowRect(m_hWnd, &rRect);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// Wϊ
void Window::ScreenToClient(POINT &pt) const
{
	const BOOL bResult = ::ScreenToClient(m_hWnd, &pt);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::ClientToScreen(POINT &pt) const
{
	const BOOL bResult = ::ClientToScreen(m_hWnd, &pt);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// bZ[W֐

// bZ[W𑗐M
LRESULT Window::SendMessage(UINT uMsg, WPARAM wParam /* = 0 */, LPARAM lParam /* = 0 */)
{
	return ::SendMessage(m_hWnd, uMsg, wParam, lParam);
}

LRESULT Window::SendMessage(UINT uMsg, WPARAM wParam /* = 0 */, LPARAM lParam /* = 0 */) const
{
	return ::SendMessage(m_hWnd, uMsg, wParam, lParam);
}

// bZ[W|Xg
void Window::PostMessage(UINT uMsg, WPARAM wParam /* = 0 */, LPARAM lParam /* = 0 */)
{
	const BOOL bResult = ::PostMessage(m_hWnd, uMsg, wParam, lParam);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

void Window::PostMessage(UINT uMsg, WPARAM wParam /* = 0 */, LPARAM lParam /* = 0 */) const
{
	const BOOL bResult = ::PostMessage(m_hWnd, uMsg, wParam, lParam);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// bZ[W擾
BOOL Window::GetMessage(LPMSG lpMsg, UINT wMsgFilterMin /* = 0 */, UINT wMsgFilterMax /* = 0 */) const
{
	const BOOL bResult = ::GetMessage(lpMsg, m_hWnd, wMsgFilterMin, wMsgFilterMax);
	if(bResult == -1)
	{
		wgfThrowLastError();
	}

	return bResult;
}

BOOL Window::PeekMessage(LPMSG lpMsg, UINT wMsgFilterMin /* = 0 */, UINT wMsgFilterMax /* = 0 */, UINT wRemoveMsg /* = PM_REMOVE */) const
{
	return ::PeekMessage(lpMsg, m_hWnd, wMsgFilterMin, wMsgFilterMax, wRemoveMsg);
}

BOOL Window::TranslateAccelerator(HACCEL hAccTable, LPMSG lpMsg)
{
	return ::TranslateAccelerator(m_hWnd, hAccTable, lpMsg);
}


// bZ[W{bNX֐
int Window::MessageBox(HINSTANCE hResource, const UINT uText, const UINT uCaption, const UINT uType /* = MB_OK */)
{
	tstring_t text;
	wgfLoadString(hResource, uText, text);

	tstring_t caption;
	wgfLoadString(hResource, uCaption, caption);

	return MessageBox(text, caption, uType);
}

int Window::MessageBox(const tstring_t &text, const tstring_t &caption, const UINT uType /* = MB_OK */)
{
	const int nResult = ::MessageBox(m_hWnd, text.c_str(), caption.c_str(), uType);
	if(nResult == 0)
	{
		wgfThrowLastError();
	}

	return nResult;
}


// Nbv{[h
BOOL Window::OpenClipboard(void)
{
	return ::OpenClipboard(m_hWnd);
}


// OLE Drag & Drop
HRESULT Window::RegisterDragDrop(IDropTarget *pDropTarget)
{
	return ::RegisterDragDrop(m_hWnd, pDropTarget);
}

HRESULT Window::RevokeDragDrop(void)
{
	return ::RevokeDragDrop(m_hWnd);
}

// hbv^[Qbg
DWORD Window::OnDragEnter(
	IDataObject  * /* pDataObject */,
	const DWORD    /* dwKeyState */,
	const POINTL & /* pt */)
{
	return DROPEFFECT_NONE;
}

DWORD Window::OnDragOver(
	const DWORD    /* dwKeyState */,
	const POINTL & /* pt */)
{
	return DROPEFFECT_NONE;
}

void Window::OnDragLeave(void)
{
}

DWORD Window::OnDrop(
	IDataObject  * /* pDataObject */,
	const DWORD    /* dwKeyState */,
	const POINTL & /* pt */)
{
	return DROPEFFECT_NONE;
}


////////////////////////////////////////////////////////////////////////////////
// }bv֘A

WORD Window::_MapHash(HWND hWnd)
{
	LONG_PTR val = reinterpret_cast<LONG_PTR>(hWnd);
	val += (val >>  8);
	val += (val >> 16);
	return static_cast<WORD>(val & 0xff);
}

Window *Window::_MapFind(HWND hWnd)
{
	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	assert(pGlobalData != NULL);

	const WORD hash = _MapHash(hWnd);
	const handlemap_t &mapHandle = pGlobalData->mapHandle[hash];
	handlemap_t::const_iterator p = mapHandle.find(hWnd);
	if(p == mapHandle.end())
	{
		return NULL;
	}
	return p->second;
}

void Window::_MapAttach(HWND hWnd, Window *pWindow)
{
	assert(hWnd    != NULL);
	assert(pWindow != NULL);

	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	assert(pGlobalData != NULL);

	// nhƃIuWFNgΉt
	const WORD hash = _MapHash(hWnd);
	handlemap_t &mapHandle = pGlobalData->mapHandle[hash];
	mapHandle[hWnd] = pWindow;
	pWindow->m_hWnd = hWnd;
	pWindow->m_bOwner = TRUE;
}

void Window::_MapDetach(Window *pWindow)
{
	assert(pWindow != NULL);

	HWND hWndTmp = pWindow->m_hWnd;
	pWindow->m_hWnd   = NULL;
	pWindow->m_bOwner = FALSE;

	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	assert(pGlobalData != NULL);

	const WORD hash = _MapHash(hWndTmp);
	handlemap_t &mapHandle = pGlobalData->mapHandle[hash];
	mapHandle.erase(hWndTmp);
}


////////////////////////////////////////////////////////////////////////////////
// tbN֘A

// ֘At̃^[QbgEChEݒ
BOOL Window::_SetHookTarget(Window *pTargetWindow)
{
	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	if(pGlobalData == NULL)
	{
		return FALSE;
	}
	pGlobalData->pWindow = pTargetWindow;
	return TRUE;
}

// tbNvV[W
LRESULT CALLBACK Window::_CBTProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	GLOBAL_DATA *pGlobalData = m_tlsGlobalData.GetValuePointer();
	assert(pGlobalData != NULL);

	// tbNnh擾
	HHOOK hHook = pGlobalData->hHook;
	assert(hHook != NULL);

	if(nCode == HCBT_CREATEWND)
	{
		// ֘At̃^[QbgEChE擾
		Window *pTargetWindow = pGlobalData->pWindow;
		if(pTargetWindow != NULL)
		{
			HWND hWnd = reinterpret_cast<HWND>(wParam);

			LPCBT_CREATEWND lpCreateWnd = reinterpret_cast<LPCBT_CREATEWND>(lParam);
			LPCREATESTRUCT  lpCreateStruct = lpCreateWnd->lpcs;

			if(lpCreateStruct->lpszClass == WC_DIALOG)
			{
				// _CAO{bNX̓A^b`̂
				_MapAttach(hWnd, pTargetWindow);
			}
			else
			{
				// _CAO{bNXȊO̓TuNXs
				pTargetWindow->Subclass(hWnd);
			}

			// ^[QbgEChE̐ݒ͂
			_SetHookTarget(NULL);
		}
	}

	// tbN`FC̎̃tbNvV[WR[
	return ::CallNextHookEx(hHook, nCode, wParam, lParam);
}


////////////////////////////////////////////////////////////////////////////////
// TuNX

// EChETuNX
BOOL Window::Subclass(HWND hWnd)
{
	assert(  hWnd           != NULL);
	assert(m_hWnd           == NULL);
	assert(m_lpfnOldWndProc == NULL);

	_MapAttach(hWnd, this);

	// EChEvV[Wu
	WNDPROC lpfnOldWndProc = SetWindowLongPtr(GWLP_WNDPROC, _WindowProcBase);
	if(lpfnOldWndProc == _WindowProcBase)
	{
		// i::RegisterClass() ȂǂŁjł _WindowProcBase() 
		// EChEvV[WƂĊ蓖ĂĂΎs
		return FALSE;
	}

	m_lpfnOldWndProc = lpfnOldWndProc;
	return TRUE;
}

// TuNX
BOOL Window::Unsubclass(void)
{
	// EChEvV[Wɖ߂
	if(m_lpfnOldWndProc == NULL)
	{
		return FALSE;
	}

	// ATuNX
	SetWindowLongPtr(GWLP_WNDPROC, m_lpfnOldWndProc);
	m_lpfnOldWndProc = NULL;

	// EChȆΉ؂
	_MapDetach(this);
	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////
// bZ[W֘A

// bZ[Wp[^擾
void Window::GetMessageParam(MSGPARAM &rMsgParam) const
{
	rMsgParam = m_msgparam;
}


////////////////////////////////////////////////////////////////////////////////
// EChEvV[W

// bZ[WU蕪vV[W
LRESULT CALLBACK Window::_WindowProcBase(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// EChEƊ֘AtꂽIuWFNg擾
	Window *pTargetWindow = _MapFind(hWnd);
	assert(pTargetWindow->IsWindow());

	// bZ[Wۑ
	pTargetWindow->m_msgparam.uMsg   = uMsg;
	pTargetWindow->m_msgparam.wParam = wParam;
	pTargetWindow->m_msgparam.lParam = lParam;

	// IuWFNg̃vV[WɃbZ[Wn
	return pTargetWindow->WindowProc(uMsg, wParam, lParam);
}

// EChEvV[W
LRESULT Window::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// }EXW
	const POINT point = {GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam)};

	// bZ[Wɂĕ
	switch(uMsg)
	{
	case WM_HELP:
		OnHelp(
			reinterpret_cast<LPHELPINFO>(lParam));  // lpHelpInfo
		return TRUE;


	case WM_GETMINMAXINFO:
		OnGetMinMaxInfo(
			reinterpret_cast<LPMINMAXINFO>(lParam));    // lpMMI
		return 0;

	case WM_GETDLGCODE:
		return OnGetDlgCode(
			reinterpret_cast<LPMSG>(lParam));           // lpMsg

	case WM_NCCREATE:
		return OnNcCreate(
			reinterpret_cast<LPCREATESTRUCT>(lParam));  // lpCreateStruct

	case WM_CREATE:
		return OnCreate(
			reinterpret_cast<LPCREATESTRUCT>(lParam));  // lpCreateStruct

	case WM_CLOSE:
		OnClose();
		return 0;                               // ς

	case WM_DESTROY:
		OnDestroy();
		return 0;                               // ς

	case WM_NCDESTROY:
		OnNcDestroy();
		_MapDetach(this);                       // }bv̑Ή؂
		PostNcDestroy();                        // EChE̔jɍŌɌĂяo
		return 0;

	case WM_QUERYENDSESSION:
		return OnQueryEndSession(static_cast<BOOL>(wParam), static_cast<BOOL>(lParam));

	case WM_ENDSESSION:
		OnEndSession(static_cast<BOOL>(wParam), static_cast<BOOL>(lParam));
		return 0;

	case WM_SIZE:
		OnSize(
			static_cast<UINT>(wParam),              // nType
			GET_X_LPARAM(lParam),                   // cx
			GET_Y_LPARAM(lParam));                  // cy
		return 0;

	case WM_SIZING:
		OnSizing(
			static_cast     <UINT  >(wParam),       // nSide
			reinterpret_cast<LPRECT>(lParam));      // lpRect
		return 0;


	case WM_ACTIVATE:
		OnActivate(
			LOWORD(wParam),                         // nState
			HIWORD(wParam),                         // bMinimized
			reinterpret_cast<HWND>(lParam));        // hWndPrevious
		return 0;

	case WM_MOUSEACTIVATE:
		return OnMouseActivate(
			reinterpret_cast<HWND>(wParam),             // hDesktopWnd
			LOWORD(lParam),                             // uHitTest
			HIWORD(lParam));                            // uMessage

	case WM_SETFOCUS:
		OnSetFocus(
			reinterpret_cast<HWND>(wParam));        // hWndLoseFocus
		return 0;

	case WM_KILLFOCUS:
		OnKillFocus(
			reinterpret_cast<HWND>(wParam));        // hWndGetFocus
		return 0;


	case WM_SETFONT:
		OnSetFont(
			reinterpret_cast<HFONT>(wParam),        // hFont
			LOWORD(lParam));                        // bRedraw
		return 0;

	case WM_GETFONT:
		return reinterpret_cast<LRESULT>(
			OnGetFont());


	case WM_INITMENU:
		OnInitMenu(
			reinterpret_cast<HMENU>(wParam));       // hMenu
		return 0;

	case WM_INITMENUPOPUP:
		OnInitMenuPopup(
			reinterpret_cast<HMENU>(wParam),        // hMenu
			LOWORD(lParam),                         // uIndex
			HIWORD(lParam));                        // bSystemMenu
		return 0;

	case WM_MENUSELECT:
		OnMenuSelect(
			GET_WM_MENUSELECT_CMD  (wParam, lParam),    // nItemID
			GET_WM_MENUSELECT_FLAGS(wParam, lParam),    // nFlags
			GET_WM_MENUSELECT_HMENU(wParam, lParam));   // hSysMenu
		return 0;

	case WM_ENTERMENULOOP:
		OnEnterMenuLoop(
			static_cast<BOOL>(wParam));                 // bIsTrackPopupMenu
		return 0;

	case WM_EXITMENULOOP:
		OnExitMenuLoop(
			static_cast<BOOL>(wParam));                 // bIsTrackPopupMenu
		return 0;


	case WM_DROPFILES:
		OnDropFiles(
			reinterpret_cast<HDROP>(wParam));       // hDrop
		return 0;

	case WM_NOTIFY:
		return OnNotify(
			static_cast     <int    >(wParam),      // nIdCtrl
			reinterpret_cast<LPNMHDR>(lParam));     // lpNmHeader

	case WM_COMMAND:
		return OnCommand(
			GET_WM_COMMAND_CMD (wParam, lParam),    // wNotifyCode
			GET_WM_COMMAND_ID  (wParam, lParam),    // wID
			GET_WM_COMMAND_HWND(wParam, lParam));   // hWndCtrl


	case WM_NCHITTEST:
		return OnNcHitTest(
			point);                                 // point


	case WM_TIMER:
		OnTimer(static_cast<UINT>(wParam));         // uIDEvent
		return 0;


	case WM_PAINT:
		OnPaint();
		return 0;

	case WM_NCPAINT:
		OnNcPaint();
		return 0;

	case WM_ERASEBKGND:
		return OnEraseBkgnd(
			reinterpret_cast<HDC>(wParam));         // hDC


	case WM_SYSCOLORCHANGE:
		OnSysColorChange();
		return TRUE;

	case WM_CTLCOLORSTATIC:
		return reinterpret_cast<LRESULT>(
			OnCtlColorStatic(
				GET_WM_CTLCOLOR_HDC (wParam, lParam, uMsg),
				GET_WM_CTLCOLOR_HWND(wParam, lParam, uMsg)));


	case WM_PARENTNOTIFY:
		OnParentNotify(
			GET_WM_PARENTNOTIFY_MSG(wParam, lParam),// message
			lParam);                                // lParam
		return TRUE;

	case WM_HSCROLL:
		OnHScroll(
			GET_WM_HSCROLL_CODE(wParam, lParam),    // nSBCode
			GET_WM_HSCROLL_POS (wParam, lParam),    // nPos
			GET_WM_HSCROLL_HWND(wParam, lParam));   // hWndScrollBar
		return TRUE;

	case WM_VSCROLL:
		OnVScroll(
			GET_WM_VSCROLL_CODE(wParam, lParam),    // nSBCode
			GET_WM_VSCROLL_POS (wParam, lParam),    // nPos
			GET_WM_VSCROLL_HWND(wParam, lParam));   // hWndScrollBar
		return TRUE;


	////////////////////////////////////////////////////////////
	// J[\bZ[W
	case WM_SETCURSOR:
		return OnSetCursor(
			reinterpret_cast<HWND>(wParam),
			LOWORD(lParam),
			HIWORD(lParam));


	////////////////////////////////////////////////////////////
	// L[{[hbZ[W
	case WM_KEYDOWN:
		OnKeyDown(
			static_cast<UINT>(wParam),          // nChar
			LOWORD(lParam),                     // nRepeatCount
			HIWORD(lParam));                    // nFlags
		return 0;

	case WM_KEYUP:
		OnKeyUp(
			static_cast<UINT>(wParam),          // nChar
			LOWORD(lParam),                     // nRepeatCount
			HIWORD(lParam));                    // nFlags
		return 0;

	case WM_CHAR:
		OnChar(
			static_cast<UINT>(wParam),          // nChar
			LOWORD(lParam),                     // nRepeatCount
			HIWORD(lParam));                    // nFlags
		return 0;

	case WM_UNICHAR:
		OnUniChar(
			static_cast<UINT>(wParam),          // nChar
			LOWORD(lParam),			            // nRepeatCount
			HIWORD(lParam));		            // nFlags
		return 0;

	case WM_DEADCHAR:
		OnDeadChar(
			static_cast<UINT>(wParam),          // nChar
			LOWORD(lParam),                     // nRepeatCount
			HIWORD(lParam));                    // nFlags
		return 0;


	////////////////////////////////////////////////////////////
	// IMEbZ[W
	case WM_IME_STARTCOMPOSITION:
		OnImeStartComposition();
		return 0;

	case WM_IME_ENDCOMPOSITION:
		OnImeEndComposition();
		return 0;

	case WM_IME_COMPOSITIONFULL:
		OnImeCompositionFull();
		return 0;

	case WM_IME_COMPOSITION:
		OnImeComposition(
			static_cast<WORD>(wParam),          // chDBCS
			static_cast<UINT>(lParam));         // nFlags
		return 0;

	case WM_IME_REQUEST:
		switch(wParam)
		{
		case IMR_CANDIDATEWINDOW:
			return OnImeRequest_CandidateWindow(
				reinterpret_cast<CANDIDATEFORM *>(lParam));

		case IMR_COMPOSITIONFONT:
			return OnImeRequest_CompositionFont(
				reinterpret_cast<LOGFONT *>(lParam));

		case IMR_COMPOSITIONWINDOW:
			return OnImeRequest_CompositionWindow(
				reinterpret_cast<COMPOSITIONFORM *>(lParam));

		case IMR_CONFIRMRECONVERTSTRING:
			return OnImeRequest_ConfirmReconvertString(
				reinterpret_cast<RECONVERTSTRING *>(lParam));

		case IMR_RECONVERTSTRING:
			return OnImeRequest_ReconvertString(
				reinterpret_cast<RECONVERTSTRING *>(lParam));
		}
		break;


	////////////////////////////////////////////////////////////
	// }EXbZ[W
	case WM_MOUSEWHEEL:                     // }EXzC[]
		return OnMouseWheel(
			LOWORD(wParam),                     // nFlags
			HIWORD(wParam),                     // zDelta
			point);                             // point

	case WM_MOUSELEAVE:                     // }EX
		OnMouseLeave();
		return 0;

	case WM_MOUSEMOVE:                      // }EXړ
		OnMouseMove(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_LBUTTONDOWN:                    // }EX̍{^
		OnLButtonDown(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_LBUTTONUP:                      // }EX̍{^J
		OnLButtonUp(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_LBUTTONDBLCLK:                  // }EX̍{^_uNbN
		OnLButtonDblClk(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_RBUTTONDOWN:                    // }EX̉E{^
		OnRButtonDown(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_RBUTTONUP:                      // }EX̉E{^J
		OnRButtonUp(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_RBUTTONDBLCLK:                  // }EX̉E{^_uNbN
		OnRButtonDblClk(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_MBUTTONDOWN:                    // }EX̒{^
		OnMButtonDown(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_MBUTTONUP:                      // }EX̒{^J
		OnMButtonUp(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_MBUTTONDBLCLK:                  // }EX̒{^_uNbN
		OnMButtonDblClk(
			static_cast<UINT>(wParam),          // nFlags
			point);                             // point
		return 0;

	case WM_XBUTTONDOWN:                    // 5{^}EX̃{^
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnXButton1Down(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;

		case XBUTTON2:
			OnXButton2Down(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;
		}
		break;

	case WM_XBUTTONUP:                      // 5{^}EX̃{^J
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnXButton1Up(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;

		case XBUTTON2:
			OnXButton2Up(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;
		}
		break;

	case WM_XBUTTONDBLCLK:                  // 5{^}EX̃{^_uNbN
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnXButton1DblClk(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;

		case XBUTTON2:
			OnXButton2DblClk(
				static_cast<UINT>(wParam),          // nFlags
				point);                             // point
			return 0;
		}
		break;

	case WM_NCLBUTTONDOWN:                  // mNCAg̈ō{^
		OnNcLButtonDown(
			static_cast<UINT>(wParam),          // nHitTest
			point);                             // point
		return 0;

	case WM_NCLBUTTONUP:                    // mNCAg̈ō{^J
		OnNcLButtonUp(
			static_cast<UINT>(wParam),          // nHitTest
			point);                             // point
		return 0;

	case WM_NCLBUTTONDBLCLK:                // mNCAg̈ō{^_uNbN
		OnNcLButtonDblClk(
			static_cast<UINT>(wParam),          // nHitTest
			point);                             // point
		return 0;

	case WM_NCRBUTTONDOWN:                  // mNCAg̈ŉE{^
		OnNcRButtonDown(  
			static_cast<UINT>(wParam),          // nHitTest
			point);		                        // point
		return 0;

	case WM_NCRBUTTONUP:                    // mNCAg̈ŉE{^J
		OnNcRButtonUp(	
			static_cast<UINT>(wParam),          // nHitTest
			point);		                        // point
		return 0;

	case WM_NCRBUTTONDBLCLK:                // mNCAg̈ŉE{^_uNbN
		OnNcRButtonDblClk(	
			static_cast<UINT>(wParam),          // nHitTest
			point);			                    // point
		return 0;

	case WM_NCMBUTTONDOWN:                  // mNCAg̈Œ{^
		OnNcMButtonDown(  
			static_cast<UINT>(wParam),          // nHitTest
			point);		                        // point
		return 0;

	case WM_NCMBUTTONUP:                    // mNCAg̈Œ{^J
		OnNcMButtonUp(	
			static_cast<UINT>(wParam),          // nHitTest
			point);		                        // point
		return 0;

	case WM_NCMBUTTONDBLCLK:                // mNCAg̈ŉE{^_uNbN
		OnNcMButtonDblClk(	
			static_cast<UINT>(wParam),          // nHitTest
			point);			                    // point
		return 0;

	case WM_NCXBUTTONDOWN:                  // mNCAg̈5{^}EX̃{^
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnNcXButton1Down(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;

		case XBUTTON2:
			OnNcXButton2Down(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;
		}
		break;

	case WM_NCXBUTTONUP:                  // mNCAg̈5{^}EX̃{^J
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnNcXButton1Up(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;

		case XBUTTON2:
			OnNcXButton2Up(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;
		}
		break;

	case WM_NCXBUTTONDBLCLK:
		switch(GET_WM_COMMAND_CMD(wParam, lParam))
		{
		case XBUTTON1:
			OnNcXButton1DblClk(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;

		case XBUTTON2:
			OnNcXButton2DblClk(
				static_cast<UINT>(wParam),          // nHitTest
				point);                             // point
			return 0;
		}
		break;
	}

	// ftHg̃vV[WĂяo
	return _Default();
}

// bZ[W̃ftHg
LRESULT Window::_Default(void)
{
	MSGPARAM param;
	GetMessageParam(param);

	// EChEvV[WۑĂꍇ
	if(m_lpfnOldWndProc != NULL)
	{
		return ::CallWindowProc(
			m_lpfnOldWndProc,
			m_hWnd,
			param.uMsg,
			param.wParam,
			param.lParam);
	}

	return ::DefWindowProc(
		m_hWnd,
		param.uMsg,
		param.wParam,
		param.lParam);
}


////////////////////////////////////////////////////////////////////////////////
// z֐

// EChE쐬OɌĂяo
BOOL Window::PreCreateWindow(CREATESTRUCT & /* cs */)
{
	return TRUE;
}

// EChEjꂽɌĂяo
void Window::PostNcDestroy(void)
{
}


////////////////////////////////////////////////////////////////////////////////
// bZ[Wnh

////////////////////////////////////////////////////////////
// wv
void Window::OnHelp(LPHELPINFO /* lpHelpInfo */)
{
	_Default();
}


void Window::OnGetMinMaxInfo(LPMINMAXINFO /* lpMMI */)
{
	_Default();
}

UINT Window::OnGetDlgCode(LPMSG /* lpMsg */)
{
	const LRESULT lResult = _Default();
	return static_cast<UINT>(lResult);
}

BOOL Window::OnNcCreate(LPCREATESTRUCT /* lpCreateStruct */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

// EChE
int Window::OnCreate(LPCREATESTRUCT /* lpCreateStruct */)
{
	const LRESULT lResult = _Default();
	return static_cast<int>(lResult);
}

// EChE
void Window::OnClose(void)
{
	_Default();
}

// EChE̔j
void Window::OnDestroy(void)
{
	_Default();
}

// EChẼmNCAg̈̔j
void Window::OnNcDestroy(void)
{
	_Default();
}


// ZbVI̖₢킹
BOOL Window::OnQueryEndSession(const BOOL /* bRequestSource */, const BOOL /* bLogOff */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

// ZbVI
void Window::OnEndSession(const BOOL /* bEnding */, const BOOL /* bLogOff */)
{
	_Default();
}


// TCYύX
void Window::OnSize(const UINT /* nType */, const int /* cx */, const int /* cy */)
{
	_Default();
}

void Window::OnSizing(const UINT /* nSide */, LPRECT /* lpRect */)
{
	_Default();
}


void Window::OnActivate(const UINT /* nState */, const BOOL /* bMinimized */, HWND /* hWndPrevious */)
{
	_Default();
}

int Window::OnMouseActivate(HWND /* hDesktopWnd */, const UINT /* uHitTest */, const UINT /* uMessage */)
{
	const LRESULT lResult = _Default();
	return static_cast<int>(lResult);
}

// tH[JX
void Window::OnSetFocus(HWND /* hWndLoseFocus */)
{
	_Default();
}

void Window::OnKillFocus(HWND /* hWndGetFocus */)
{
	_Default();
}


// tHg
void Window::OnSetFont(HFONT /* hFont */, const BOOL /* bRedraw */)
{
	_Default();
}

HFONT Window::OnGetFont(void)
{
	const LRESULT lResult = _Default();
	return reinterpret_cast<HFONT>(lResult);
}


// j[
void Window::OnInitMenu(HMENU /* hMenu */)
{
	_Default();
}

void Window::OnInitMenuPopup(HMENU /* hMenu */, const UINT /* uIndex */, const BOOL /* bSystemMenu */)
{
	_Default();
}

void Window::OnMenuSelect(const UINT /* nItemID */, const UINT /* nFlags */, HMENU /* hSysMenu */)
{
	_Default();
}

void Window::OnEnterMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	_Default();
}

void Window::OnExitMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	_Default();
}


// t@C̃hbv
void Window::OnDropFiles(HDROP /* hDrop */)
{
	_Default();
}


// ʒmbZ[W
BOOL Window::OnNotify(const int /* nIdCtrl */, LPNMHDR /* lpNmHeader */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

// R}hbZ[W
BOOL Window::OnCommand(const WORD /* wNotifyCode */, const WORD /* wID */, HWND /* hWndCtrl */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}


// qbgeXg
UINT Window::OnNcHitTest(const POINT & /* point */)
{
	const LRESULT lResult = _Default();
	return static_cast<UINT>(lResult);
}


// ^C}
void Window::OnTimer(const UINT /* uIDEvent */)
{
	_Default();
}


// EChE`
void Window::OnPaint(void)
{
	_Default();
}

// EChE̔NCAg̈`
void Window::OnNcPaint(void)
{
	_Default();
}

// wi
BOOL Window::OnEraseBkgnd(HDC /* hDC */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}


void Window::OnSysColorChange(void)
{
	_Default();
}

HBRUSH Window::OnCtlColorStatic(HDC /* hDC */, HWND /* hWnd */)
{
	const LRESULT lResult = _Default();
	return reinterpret_cast<HBRUSH>(lResult);
}


// ʒmbZ[W
void Window::OnParentNotify(const UINT /* message */, const LPARAM /* lParam */)
{
	_Default();
}

// XN[o[
void Window::OnHScroll(const UINT /* nSBCode */, const UINT /* nPos */, HWND /* hWndScrollBar */)
{
	_Default();
}

// XN[o[
void Window::OnVScroll(const UINT /* nSBCode */, const UINT /* nPos */, HWND /* hWndScrollBar */)
{
	_Default();
}


////////////////////////////////////////////////////////////
// J[\bZ[W

BOOL Window::OnSetCursor(HWND /* hWnd */, const UINT /* nHitTest */, const UINT /* message */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}


////////////////////////////////////////////////////////////
// L[{[hbZ[W

// L[{[h
void Window::OnKeyDown(const UINT /* nChar */, const UINT /* nRepCnt */, const UINT /* nFlags */)
{
	_Default();
}

// L[{[hJ
void Window::OnKeyUp(const UINT /* nChar */, const UINT /* nRepCnt */, const UINT /* nFlags */)
{
	_Default();
}

// 
void Window::OnChar(const UINT /* nChar */, const UINT /* nRepCnt */, const UINT /* nFlags */)
{
	_Default();
}

// UnicodeiUTF-32j
void Window::OnUniChar(const UINT /* nChar */, const UINT /* nRepeatCount */, const UINT /* nFlags */)
{
	_Default();
}

// fbhL[
void Window::OnDeadChar(const UINT /* nChar */, const UINT /* nRepCnt */, const UINT /* nFlags */)
{
	_Default();
}


////////////////////////////////////////////////////////////
// IMEbZ[W

// ϊJn
void Window::OnImeStartComposition(void)
{
	_Default();
}

// ϊI
void Window::OnImeEndComposition(void)
{
	_Default();
}

void Window::OnImeCompositionFull(void)
{
	_Default();
}

void Window::OnImeComposition(const WORD /* chDBCS */, const UINT /* nFlags */)
{
	_Default();
}

BOOL Window::OnImeRequest_CandidateWindow(CANDIDATEFORM * /* lpCf */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

BOOL Window::OnImeRequest_CompositionFont(LOGFONT * /* lpLf */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

BOOL Window::OnImeRequest_CompositionWindow(COMPOSITIONFORM * /* lpCf */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

BOOL Window::OnImeRequest_ConfirmReconvertString(RECONVERTSTRING * /* lpRs */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

DWORD Window::OnImeRequest_ReconvertString(RECONVERTSTRING * /* lpRs */)
{
	const LRESULT lResult = _Default();
	return static_cast<DWORD>(lResult);
}


////////////////////////////////////////////////////////////
// }EXbZ[W

// zC[]
BOOL Window::OnMouseWheel(const UINT /* nFlags */, const short /* zDelta */, const POINT & /* point */)
{
	const LRESULT lResult = _Default();
	return static_cast<BOOL>(lResult);
}

// }EX
void Window::OnMouseLeave(void)
{
	_Default();
}

// }EXړ
void Window::OnMouseMove(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̍{^
void Window::OnLButtonDown(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̍{^J
void Window::OnLButtonUp(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̍{^_uNbN
void Window::OnLButtonDblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̉E{^
void Window::OnRButtonDown(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̉E{^J
void Window::OnRButtonUp(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̉E{^_uNbN
void Window::OnRButtonDblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̒{^
void Window::OnMButtonDown(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̒{^J
void Window::OnMButtonUp(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// }EX̒{^_uNbN
void Window::OnMButtonDblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̑{^
void Window::OnXButton1Down(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̑{^J
void Window::OnXButton1Up(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̑{^_uNbN
void Window::OnXButton1DblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̏{^
void Window::OnXButton2Down(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̏{^J
void Window::OnXButton2Up(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// 5{^}EX̏{^_uNbN
void Window::OnXButton2DblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̍{^
void Window::OnNcLButtonDown(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̍{^J
void Window::OnNcLButtonUp(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̍{^_uNbN
void Window::OnNcLButtonDblClk(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̉E{^
void Window::OnNcRButtonDown(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̉E{^J
void Window::OnNcRButtonUp(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̉E{^_uNbN
void Window::OnNcRButtonDblClk(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̒{^
void Window::OnNcMButtonDown(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̒{^J
void Window::OnNcMButtonUp(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈Ń}EX̒{^_uNbN
void Window::OnNcMButtonDblClk(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̑{^
void Window::OnNcXButton1Down(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̑{^J
void Window::OnNcXButton1Up(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̑{^_uNbN
void Window::OnNcXButton1DblClk(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̏{^
void Window::OnNcXButton2Down(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̏{^J
void Window::OnNcXButton2Up(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

// mNCAg̈5{^}EX̏{^_uNbN
void Window::OnNcXButton2DblClk(const UINT /* nHitTest */, const POINT & /* point */)
{
	_Default();
}

_WGC_END                                // }
