// File.cpp
#include "File.h"
#include "wgfunc.h"


_WGC_BEGIN

////////////////////////////////////////////////////////////
// RXgNV

// t@Cnhw
File::File(HANDLE hFile) : m_bOwner(FALSE)
{
	m_hFile = hFile;
}

// t@CwiIuWFNg̎g񂵂֎~邽߁AOpen() ͂Ȃj
File::File(
	LPCTSTR               lpszFileName,
	const DWORD           dwDesiredAccess       /* = GENERIC_READ | GENERIC_WRITE */,
	const DWORD           dwShareMode           /* = FILE_SHARE_READ */,
	LPSECURITY_ATTRIBUTES lpSecurityAttributes  /* = NULL */,
	const DWORD           dwCreationDisposition /* = CREATE_ALWAYS */,
	const DWORD           dwFlagsAndAttributes  /* = FILE_ATTRIBUTE_NORMAL */,
	HANDLE                hTemplateFile         /* = NULL */)
	: m_bOwner(TRUE)
{
	m_hFile = ::CreateFile(
		lpszFileName,
		dwDesiredAccess,
		dwShareMode,
		lpSecurityAttributes,
		dwCreationDisposition,
		dwFlagsAndAttributes,
		hTemplateFile);

	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		wgfThrowLastError();
	}
}

File::~File(void)
{
	if(m_bOwner)
	{
		::CloseHandle(m_hFile);
	}
}


////////////////////////////////////////////////////////////////////////////////
// ړ

DWORD File::Seek(const DWORD dwMoveMethod, const LONG lPositionLo, LPLONG lpPositionHi /* = NULL */)
{
	return ::SetFilePointer(
		m_hFile,
		lPositionLo,
		lpPositionHi,
		dwMoveMethod);
}

void File::SeekToBegin(void)
{
	Seek(FILE_BEGIN, 0);
}

void File::SeekToEnd(void)
{
	Seek(FILE_END, 0);
}


////////////////////////////////////////////////////////////////////////////////
// ǂݍ/

// ǂݍ
DWORD File::Read(LPVOID lpBuffer, const DWORD nNumber)
{
	DWORD nNumberOfRead;
	const BOOL bResult = ::ReadFile(m_hFile, lpBuffer, nNumber, &nNumberOfRead, NULL);
	if(!bResult)
	{
		wgfThrowLastError();
	}

	return nNumberOfRead;
}

// 
DWORD File::Write(LPCVOID lpBuffer, const DWORD nNumber)
{
	DWORD nNumberOfWritten;
	const BOOL bResult = ::WriteFile(m_hFile, lpBuffer, nNumber, &nNumberOfWritten, NULL);
	if(!bResult)
	{
		wgfThrowLastError();
	}

	return nNumberOfWritten;
}

// tbV
void File::Flush(void)
{
	const BOOL bResult = ::FlushFileBuffers(m_hFile);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}


////////////////////////////////////////////////////////////////////////////////
// 

// t@CTCY擾
DWORD File::GetSize(LPDWORD lpFileSizeHigh /* = NULL */) const
{
	const DWORD dwResult = ::GetFileSize(m_hFile, lpFileSizeHigh);
	if(dwResult == static_cast<DWORD>(-1))
	{
		if(lpFileSizeHigh != NULL && ::GetLastError() == NO_ERROR)
		{
			return dwResult;
		}
		wgfThrowLastError();
	}
	return dwResult;
}

// ANZX擾
void File::GetTime(
	LPFILETIME lpCreationTime   /* = NULL */,
	LPFILETIME lpLastAccessTime /* = NULL */,
	LPFILETIME lpLastWriteTime  /* = NULL */) const
{
	const BOOL bResult = ::GetFileTime(
		m_hFile,
		lpCreationTime,
		lpLastAccessTime,
		lpLastWriteTime);
	if(!bResult)
	{
		wgfThrowLastError();
	}
}

// 擾istatico֐j
DWORD File::GetAttributes(LPCTSTR lpszPathName)
{
	return ::GetFileAttributes(lpszPathName);
}

// ǂݎpHistatico֐j
BOOL File::IsReadOnly(LPCTSTR lpszPathName)
{
	return GetAttributes(lpszPathName) & FILE_ATTRIBUTE_READONLY;
}

// Bt@CHistatico֐j
BOOL File::IsHidden(LPCTSTR lpszPathName)
{
	return GetAttributes(lpszPathName) & FILE_ATTRIBUTE_HIDDEN;
}

// fBNgHistatico֐j
BOOL File::IsDirectory(LPCTSTR lpszPathName)
{
	return GetAttributes(lpszPathName) & FILE_ATTRIBUTE_DIRECTORY;
}


File::operator HANDLE(void) const
{
	return m_hFile;
}


////////////////////////////////////////////////////////////
// mapping_object
mapping_object::mapping_object(
	File                  &rFile,
	LPSECURITY_ATTRIBUTES lpFileMappingAttributes /* = NULL */,
	const DWORD           flProtect               /* = PAGE_READONLY */,
	const DWORD           dwMaximumSizeHigh       /* = 0 */,
	const DWORD           dwMaximumSizeLow        /* = 0 */,
	LPCTSTR               lpName                  /* = NULL */) : m_hMap(NULL)
{
	m_hMap = ::CreateFileMapping(
		rFile,
		lpFileMappingAttributes,
		flProtect,
		dwMaximumSizeHigh,
		dwMaximumSizeLow,
		lpName);

	if(m_hMap == NULL)
	{
		wgfThrowLastError();
	}
}

mapping_object::~mapping_object(void)
{
	::CloseHandle(m_hMap);
	m_hMap = NULL;
}

mapping_object::operator HANDLE(void) const
{
	return m_hMap;
}

_WGC_END
