#ifndef _HPL_MATH_
#define _HPL_MATH_

namespace hpl{
namespace math{
    /**
        ̎
    */
    namespace LineType{
        enum{
            Normal,
            Horizontal,
            Vertical,
        };
    };

    //exchange between a and b
    template<class T>
    void exchange(T *a, T *b)
    {
        T temp = *a;
        *a = *b;
        *b = temp;
    }

    /**
        get sign of num
    */
    template<class T>
    int sgn(T n)
    {
        if( n > 0){
            return 1;
        }else if( n < 0){
            return -1;
        }else{
            return 0;
        }
    }

    namespace RotationType{
        //̉v肩Av肩
        enum {
            Clockwise,
            Counterclockwise,

            MAX_POLYGON_ROTATION_TYPES
        };
    };
    /**
        WAƓx̕ϊ
    */
    double getDegreeFromRadian(double rad);
    double getRadianFromDegree(double deg);

    //////////////////////////////////////////////////////////////////////
    ///////////////  Is Point In  ////////////////////////////////////////
    /**
        _`ׂ
        <en>check point be in a rect
    */
    template<class T>
    bool isPointInRect(T px, T py, T rx0, T ry0, T rx1, T ry1)
    {
        T left = (rx0<rx1?rx0:rx1);
        T right = (rx0<rx1?rx1:rx0);
        T top = (ry0<ry1?ry0:ry1);
        T bottom = (ry0<ry1?ry1:ry0);

        if( left <= px && px <= right &&
        top <= py && py <= bottom){
            return true;
        }
        return false;
    }
    /**
        ``FbN
    */
    bool isLineInRect(int lx0, int ly0, int lx1, int ly1,
                        int rx0, int ry0, int rx1, int ry1);

    /**
        |S``FbN
    */
    bool isPolygonInRect(int **points, int point_num,
                        int rx0, int ry0, int rx1, int ry1);

    /**
        xNgpx߂܂(EXBY)
        calcurate degree from vector
        down to 90 degree. right to 0 degree.(right and bottom are plus)
    */
    double getDegreeFromVector(double dx, double dy);

    //////////////////////////////////////////////////////////////////////
    ///////////////  Length  /////////////////////////////////////////////
    /**
        <jp>_Ɛ̋臒lȉׂ
        <en>check distance between point and line is under threshold
    */
    bool isNearbyPointToLine(double px, double py, 
                     double lx0, double ly0, double lx1, double ly1,
                     double distance);

    /**
        _Ɠ_̋ȓ
        @param distance r[Wł̋臒l
        <en>check distance between points be under threshold
    */
    bool isNearbyPoints(double px0, double py0, 
                     double px1, double py1, double distance);

    //////////////////////////////////////////////////////////////////////
    ///////////////  Angle   /////////////////////////////////////////////
    /**
        ̐D萬px߂܂BXN[WnA
        v肪ƂȂ
        @param pax,y,pbx,y AB̍W
        @param pcx,y,pdx,y CD̍W
    */
    double getTwoLinesRadian(double pax, double pay, double pbx, double pby,
        double pcx, double pcy, double pdx, double pdy);
    double getTwoLinesDegree(double pax, double pay, double pbx, double pby,
        double pcx, double pcy, double pdx, double pdy);
    /**
        xNg̊px߂܂(0 deg = (1,0))
    */
    double getDegreeFromVector(double x, double y);
    double getRadianFromVector(double x, double y);

    /**
        px[0,360)ɒ܂
    */
    double optimizeDegree(double deg);
    double optimizeRadian(double rad);

    /////////////////////////////////////////////////////
    /////////////  cross  ///////////////////////////////
    /**
        2̐_擾܂B
        @param line0 0
        @param line1 1
        @return 2̐ĂȂꍇU
    */
    bool getCrossPointOfTwoLines(double line0[2][2],
        double line1[2][2], double dest[2]);

    /**
        ̒[_f[^A̐̌XƐؕЂ߂܂
        Ȑ̏ꍇ͌XtɂȂĂ̂Œ
        @param line line datas ([0][0],[0][1])-([1][0],[1][1])
        @param 
    */
    int getLineAngleAndSlice(double line[2][2], double *degree, double *slice);
    
    /**
        ̌Xpx瓾܂
    */
    double getAngleFromDegree(double degree);

    ///////////////////
    /**
        _ւ̋i̒j߂܂
        <en>get 
    */
    double getPointDistanceFromLine(double px, double py, 
                             double lx0, double ly0, double lx1, double ly1);

    /**
        <jp>O̒藝Œ߂
        <en>get length of (0,0)-(x,y)
    */
    double getLength(double x, double y);

    /**
        <jp>ς߂܂
    */
    double getInnerProduct(double x0, double y0, double x1, double y1);

    /**
        _~낵uvƌ邩fi┼ł͂Ȃj
    */
    bool isCrossPointLine(double px, double py, 
                             double lx0, double ly0, double lx1, double ly1);

    /////////////////////////////////////////////////////////
    //////  polygons  ///////////////////////////////////////
    /**
        w肵͈͂Ɏ܂np`𐶐܂B
        
        @param (x0,y0)-(x1,y1) range of rectangle. the polygon you want will be create fitting with this.
        @param n
        @param points destraction of this function. you can add points and lines and polygon
        @return true when succeeded
    */
    bool getRectangleScaledPreparedPolygon(double x0, double y0, double x1, double y1, int n,
                                                            double points[8][2]);
    /**
        `̒Sʒu𓾂܂
    */
    void getCenterOfRectangle(double x0, double y0, double x1, double y1, double center[2]);

    /**
        ~ɉnp`̓_𓾂܂
    */
    void getCirculatePolygonPoints(double centerx, double centery, double radius,
        int n, double dest[][2]);

    /**
        _|ŜȂɑ݂邩`FbN܂
    */
    bool isPointInPolygon(double px, double py, double polygonPoints[][2], int n);

    /**
        _̉Eɂ邩Aɂ邩f܂
    */
    int getPointRotationTypeFromLine(double px, double py, double line0x, double line0y,
        double line1x, double line1y);

    /**
        |Sɓsp݂ȂǂmF܂
    */
    bool isValidPolygon(double points[][2], int maxVertex);

	/**
		|SAreaiʐρj߂܂
		<en> calculate polygon's area
		referenced from
		http://local.wasp.uwa.edu.au/~pbourke/geometry/polyarea/
	*/
	double getPolygonArea(double points[][2], int maxVertex);

	/**
		|S̃ZgCh߂܂
		<en> calculate polygon's center(centre,centroid)
	*/
	void getPolygonCentroid(double points[][2], int maxVertex, double center[2]);
};
};
#endif
