#include "HPLMapTool.h"
#include "HPLMath.h"
#include <limits.h>
#include "HPLQuickSort.h"
#include <fstream>
#include "HPLError.h"
#include "HPLStringModifier.h"
#include "map.h"
#include "platforms.h"
#include "HPLStockManager.h"

//px̍ő
const double DEG_ROUND = 360.0;

///////////////////////////////////
//	vg^Cv
//	prototypes

//////////////////////////////////////////////////////
/////// add delete and modify
/**
	_ǉ܂
	@param ep ǉ_f[^ilnȂ̂ŃRs[܂j
	@return ǉꂽ_̃CfbNXl
*/
int hpl::aleph::map::addEndpoint(endpoint_data ep)
{
	EndpointList.push_back(ep);
	dynamic_world->endpoint_count = (int16)EndpointList.size();
	int index = dynamic_world->endpoint_count - 1;
	return index;
}
int hpl::aleph::map::addLine(line_data line)
{
	LineList.push_back(line);
	dynamic_world->line_count = (int16)LineList.size();
	int index = dynamic_world->line_count - 1;
	return index;
}
int hpl::aleph::map::addSide(side_data side, bool isClockwise)
{
	SideList.push_back(side);
	dynamic_world->side_count = (int16)SideList.size();
	int index = dynamic_world->side_count - 1;
	return index;
}
int hpl::aleph::map::addPolygon(polygon_data polygon)
{
	PolygonList.push_back(polygon);
	dynamic_world->polygon_count = (int16)PolygonList.size();
	int index = dynamic_world->polygon_count - 1;

	polygon_data* poly = get_polygon_data(index);

    //ȉ̈ˑ鍀ڂC
    //E_iadjacentj
    //Eiownerj
    //ESide
    //TODO
    for(int i = 0; i < poly->vertex_count; i ++){
        int next = i + 1;
        if(next >= poly->vertex_count){
            next = 0;
        }

		//get endpoint data
		wxASSERT(hpl::aleph::map::isValidIndex(poly->endpoint_indexes[i],
			EndpointList.size()));
        endpoint_data* ep1 = get_endpoint_data(poly->endpoint_indexes[i]);

		//֘A|S̎w肪Ύw
        if(!hpl::aleph::map::isValidIndex(ep1->supporting_polygon_index,
			PolygonList.size()))
		{
            ep1->supporting_polygon_index = index;
		}else{
			//łɎw肳Ă
			//already index set
		}

		wxASSERT(hpl::aleph::map::isValidIndex(poly->endpoint_indexes[next],
			EndpointList.size()));
        endpoint_data* ep2 = get_endpoint_data(poly->endpoint_indexes[next]);


		wxASSERT(hpl::aleph::map::isValidIndex(poly->line_indexes[i],
			LineList.size()));

        //
        line_data* line = get_line_data(poly->line_indexes[i]);
        if(line->endpoint_indexes[0] == poly->endpoint_indexes[i]){
            //clockwise
            line->clockwise_polygon_owner = index;
			hpl::aleph::map::isValidIndex(line->clockwise_polygon_side_index,
				SideList.size());
            side_data* side = get_side_data(line->clockwise_polygon_side_index);
            if(side)
                side->polygon_index = index;
        }else if(line->endpoint_indexes[0] == poly->endpoint_indexes[next]){
            //tcounterclockwise
            line->counterclockwise_polygon_owner = index;
			hpl::aleph::map::isValidIndex(line->counterclockwise_polygon_side_index,
				SideList.size());
            side_data* side = get_side_data(line->counterclockwise_polygon_side_index);
            if(side)
                side->polygon_index = index;
        }else{
            wxASSERT(false);
        }
    }
	wxASSERT(index >= 0);
	return index;
}
int hpl::aleph::map::addMapSavedObject(map_object object)
{
	SavedObjectList.push_back(object);
	//TODO
	//v[Xgɕt

	//ǉƂA̓_|SɃIuWFNg̃|Sԍݒ肷
	//	OłĂ

	//TODO ǂWvΗǂ̂H
//	dynamic_world->object_count ++;// SavedObjectList.size();
	dynamic_world->initial_objects_count = (int16)SavedObjectList.size();
	int index = dynamic_world->initial_objects_count - 1;
	
	
    map_object* obj = &SavedObjectList[index];

	//placement `FbNB
	object_frequency_definition* placement =
		hpl::aleph::map::getPlacementData(object.type, object.index);
	hpl::aleph::map::updateObjectInitialPlacement(obj->type, obj->index);

    //ˑ鍀ڂC
    //E|S
	hpl::aleph::map::isValidIndex(obj->polygon_index, PolygonList.size());
	/*
	if(!hpl::aleph::map::isValidIndex(obj->polygon_index)){
		obj->polygon_index = NULL;
	}else{
	    polygon_data* poly = get_polygon_data(obj->polygon_index);
	}
	*/
	return index;
}
int hpl::aleph::map::addAnnotation(map_annotation annotation)
{
	MapAnnotationList.push_back(annotation);
/*	dynamic_world-> = MapAnnotationList.size();
	int index = dynamic_world->annotation_count - 1;*/
	int index = (int16)MapAnnotationList.size() - 1;
	return index;
}

/**
    }bvACei_EESideE|SEIuWFNgj
    폜܂
    @ƂẮA
    PF̒[_ȂǁAQƌ폜ΏۂƂȂĂꍇA
        EQƂNONEɂ
        Eg폜ΏۂƂ
    QF폜Ώۂ폜Ă
        E폜ԍ̗
        E둤Ă

    @param 
*/
bool hpl::aleph::map::deleteMapItems(std::vector<bool>& delPoints, std::vector<bool>& delLines,
									 std::vector<bool>& delPolygons,
                                     std::vector<bool>& delSides,
								    std::vector<bool>& delObjects)
{
    if(delPoints.size() < EndpointList.size() ||
        EndpointList.size() != dynamic_world->endpoint_count ||
        delLines.size() < LineList.size() ||
        LineList.size() != dynamic_world->line_count ||
        delSides.size() < SideList.size() ||
        SideList.size() != dynamic_world->side_count ||
        delPolygons.size() < PolygonList.size() ||
        PolygonList.size() != dynamic_world->polygon_count ||
        delObjects.size() < SavedObjectList.size())
    {
        hpl::error::caution("dismatch delP[%d],EndpointList.size()[%d],world.endpoint_count[%d]",
			delPoints.size(), EndpointList.size(), dynamic_world->endpoint_count);
        hpl::error::caution("dismatch delL[%d],LineList.size()[%d],world.line_count[%d]",
			delLines.size(), LineList.size(), dynamic_world->line_count);
        hpl::error::caution("dismatch delPoly[%d],PolygonList.size()[%d],world.polygon_count[%d]",
			delPolygons.size(), PolygonList.size(), dynamic_world->polygon_count);
        hpl::error::caution("dismatch delS[%d],SideList.size()[%d],world.side_count[%d]",
			delSides.size(), SideList.size(), dynamic_world->side_count);
        hpl::error::halt("dismatch delO[%d],SavedObjectList.size()[%d],world.initial[%d]",
			delObjects.size(), SavedObjectList.size(), dynamic_world->initial_objects_count);
        return false;
    }



    /////////////////
    //ۂɍ폜
    std::map<int, int> indexMapPoints;
    std::map<int, int> indexMapLines;
    std::map<int, int> indexMapSides;
    std::map<int, int> indexMapPolygons;
    std::map<int, int> indexMapObjects;
    //Ή\
    int counter = 0;
    for(int i = 0; i < (int)EndpointList.size(); i ++){
        if(!delPoints[i]){
			indexMapPoints[i] = counter;   counter ++;
		}
    }
    counter = 0;
    for(int i = 0; i < (int)LineList.size(); i ++){
        if(!delLines[i]){
			indexMapLines[i] = counter;   counter ++;
		}
    }
    counter = 0;
    for(int i = 0; i < (int)PolygonList.size(); i ++){
        if(!delPolygons[i]){
			indexMapPolygons[i] = counter;   counter ++;
		}
    }
    counter = 0;
    for(int i = 0; i < (int)SideList.size(); i ++){
        if(!delSides[i]){
			indexMapSides[i] = counter;   counter ++;
		}
    }
    counter = 0;
    for(int i = 0; i < (int)SavedObjectList.size(); i ++){
        if(!delObjects[i]){
			indexMapObjects[i] = counter;   counter ++;
		}
    }
	//TODO Platform
	
	//폜܂
	for(int i = (int)EndpointList.size() - 1; i >= 0; i --){
		if(delPoints[i]){
			EndpointList.erase(EndpointList.begin() + i);
		}
	}
	for(int i = (int)LineList.size() - 1; i >= 0; i --){
		if(delLines[i]){
			LineList.erase(LineList.begin() + i);
		}
	}
	for(int i = (int)PolygonList.size() - 1; i >= 0; i --){
		if(delPolygons[i]){
			PolygonList.erase(PolygonList.begin() + i);
		}
	}
	for(int i = (int)SideList.size() - 1; i >= 0; i --){
		if(delSides[i]){
			SideList.erase(SideList.begin() + i);
		}
	}
	counter = 0;
	for(std::vector<map_object>::iterator it = SavedObjectList.begin(); 
		it != SavedObjectList.end(); )
	{
		if(delObjects[counter]){
			it = SavedObjectList.erase(it);
		}else{
			it ++;
		}
		counter ++;
	}
	/*
	for(int i = (int)delPlatforms.size() - 1; i >= 0; i --){
		if(delPlatforms[i]){
			PlatformList.erase(PlatformList.begin() + i);
		}
	}*/
	
    //CfbNXt
	hpl::aleph::map::changeIndexMapping(
		EndpointList,
		LineList,
		PolygonList,
		SideList,
		SavedObjectList,
		0, (int)EndpointList.size(),
		0, (int)LineList.size(),
		0, (int)PolygonList.size(),
		0, (int)SideList.size(),
		0, (int)SavedObjectList.size(),
		indexMapPoints, indexMapLines, indexMapPolygons, indexMapSides, indexMapObjects);
    return true;
}



///////////////////////////////////////////////////////
///////////////////////////////////////////////////////
/// add
/**
    {̐&_Ȃ̂ATCYƂȂ悤
    _̃Xg擾܂B_̕т̓|Swɂ̂܂܎g镨ƂȂĂ܂B

    ċAIɌĂяo܂B
    @param pointIndexes ܂łɂȂĂ_̃XgB̌MAXIMUM_VERTEX_PER_POLYGON
        𒴂猩Ȃ̂Ƃ
    @return |Sꍇ^
*/
static bool getValidLines(int basePointIndex, int baseLineIndex,
                          std::vector<int> *pointIndexes,
                          hpl::aleph::HPLStockManager* smgr,
                          int rotRem, std::set<int>* doneList,
                          int zMin, int zMax,
                          world_point2d& wpoint)
{
    //ő̊px
    double maxDeg = 0;
    int maxLineIndex = NONE;

    line_data* baseLine = get_line_data(baseLineIndex);
    int startBasePointIndex = baseLine->endpoint_indexes[0];
    int endBasePointIndex =  baseLine->endpoint_indexes[1];
    if(startBasePointIndex == basePointIndex){
        //ւ
        hpl::math::exchange(&startBasePointIndex, &endBasePointIndex);
    }else if(endBasePointIndex == basePointIndex){
    }else{
#ifdef __WXDEBUG__
        wxASSERT(false);
#else
        return false;
#endif

    }

    int lastPointIndex = NONE;
    //x[X|CgɌqo
    std::vector<int> conLines = hpl::aleph::map::getLineIndexesIncludePoint(basePointIndex);
    for(int k = 0; k < (int)conLines.size(); k ++){
        int conLineIndex = conLines[k];
        if(doneList->find(conLines[k]) != doneList->end()){
            //Ɍô͏Ȃ
            continue;
        }
        //delLines͏Ȃ
        if(smgr->isDeleteLine(conLineIndex)){
            continue;
        }
        //x[X̐ƈꏏ̏ꍇO
        if(baseLineIndex == conLineIndex){
            continue;
        }

        line_data* line = get_line_data(conLineIndex);
#ifdef __WXDEBUG__
        wxASSERT(line );
#else
        if(!line )continue;
#endif
        //`FbN
        if(!hpl::aleph::map::isValidHeight(line->highest_adjacent_floor,
            line->lowest_adjacent_ceiling, zMin, zMax))
        {
            continue;
        }

        int ep0Index = line->endpoint_indexes[0];
        int ep1Index = line->endpoint_indexes[1];
        if(basePointIndex == ep0Index){
        }else if(basePointIndex == ep1Index){
            //ւ
            hpl::math::exchange(&ep0Index, &ep1Index);
        }else{
#ifdef __WXDEBUG__
            wxASSERT(false );
#else
            continue;
#endif
        }

        endpoint_data* ep0 = get_endpoint_data(ep0Index);
#ifdef __WXDEBUG__
        wxASSERT(ep0 );
#else
        if(!ep0 )continue;
#endif
        endpoint_data* ep1 = get_endpoint_data(ep1Index);
#ifdef __WXDEBUG__
        wxASSERT(ep1 );
#else
        if(!ep1 )continue;
#endif

        double l0x = ep0->vertex.x;
        double l0y = ep0->vertex.y;
        double l1x = ep1->vertex.x;
        double l1y = ep1->vertex.y;
        //w_ɑ΂px߂iE̊mFj
        int rot = hpl::math::getPointRotationTypeFromLine(
            wpoint.x, wpoint.y, l0x, l0y, l1x, l1y);
        //ŏ̐ƈႤitjɎw_Ăꍇ͐Ȃ̂ƂB
        if(rotRem != rot){
            continue;
        }

        //O̐̎n_L_Ō̓_Ŋpx߂
        //O̐̎n_
        endpoint_data* prevStartEp = get_endpoint_data(startBasePointIndex);
#ifdef __WXDEBUG__
        wxASSERT(prevStartEp );
#else
        if(!prevStartEp )continue;
#endif
        double deg = hpl::math::getTwoLinesDegree(prevStartEp->vertex.x,
            prevStartEp->vertex.y, l0x, l0y,
            l0x, l0y, l1x, l1y);
        //[0,360)ɐ
        deg = hpl::math::optimizeDegree(deg);
        if(deg > DEG_ROUND / 2.0){
            deg = DEG_ROUND - deg;
        }
        //pxݍő傩ǂmF
        if(deg > maxDeg){
            maxDeg = deg;
            //܂ł傫
            maxLineIndex = conLineIndex;
            //Ō̓_
            lastPointIndex = ep1Index;
        }
        //ς
        doneList->insert(conLineIndex);
    }

    if(maxLineIndex == NONE){
        //Ȃ
        //Ė߂Ă
        return false;
    }else{
        //
        //Ōɒǉ
        pointIndexes->push_back(lastPointIndex);

        //Ō̓_pointIndexes[0]ƓiĂj
        //IƂ
        if(lastPointIndex == pointIndexes->at(0)){
            //|SƂĐZbgo
            return true;
        }else{
            //܂܂
            if(pointIndexes->size() >= MAXIMUM_VERTICES_PER_POLYGON + 1){
                return false;
            }
            //ő吔𒴂Ă
            //T
            baseLineIndex = maxLineIndex;
            basePointIndex = lastPointIndex;
            bool found = getValidLines(basePointIndex, baseLineIndex, pointIndexes,
                smgr, rotRem, doneList, zMin, zMax, wpoint);
            //ǌǂ͎qmĂ
            return found;
        }
    }
}

/**
    W͂ރ|ŜA|SƂĐĂ̂܂
    łɃ|S݂Ăꍇ͖܂
    @param wpoint T_B͂ރ|ST
    @return |S̎f[^BɐƗǂBf[^createPolygonŐׂ
*/
std::vector<polygon_data> hpl::aleph::map::searchValidPolygon(world_point2d wpoint,
                                                              hpl::aleph::HPLStockManager* smgr,
                                                              int zMin, int zMax)
{
    std::vector<polygon_data> polyDatas;

    int max = (int)LineList.size();
    //ւ̐̋Ő񂷂
    //S̐ւ̐߂
    struct hpl::math::qsort::Pair<double>* pairs = new struct hpl::math::qsort::Pair<double>[max];
    for(int i = 0; i < max; i ++){
        line_data* line = get_line_data(i);
        assert(line);
        endpoint_data* epStart = get_endpoint_data(line->endpoint_indexes[0]);
        assert(epStart);
        endpoint_data* epEnd = get_endpoint_data(line->endpoint_indexes[1]);
        assert(epEnd);
        pairs[i].data = hpl::math::getPointDistanceFromLine(wpoint.x, wpoint.y, 
            epStart->vertex.x, epStart->vertex.y, epEnd->vertex.x, epEnd->vertex.y);
    }
    hpl::math::qsort::quickSort<double>(pairs, max);

    //ɒׂXg(̃CfbNXl)
    std::set<int> doneList;

    //߂ɂ猩Ă
    for(int i = 0; i < max; i ++){
        //폜ΏۂȂ疳
        if(smgr->isDeleteLine(i)){
            continue;
        }
        //łɒׂȂ疳
        if(doneList.find(i) != doneList.end()){
            continue;
        }
        int lineIndexBase = pairs[i].index;
        line_data* startLine = get_line_data(lineIndexBase);
#ifdef __WXDEBUG__
        wxASSERT(startLine );
#else
        if(!startLine )continue;
#endif
        //`FbN
        if(!hpl::aleph::map::isValidHeight(startLine->highest_adjacent_floor,
            startLine->lowest_adjacent_ceiling, zMin, zMax))
        {
            continue;
        }

        int startPointIndex = startLine->endpoint_indexes[0];
		endpoint_data* epStart = get_endpoint_data(startPointIndex);
#ifdef __WXDEBUG__
        wxASSERT(epStart );
#else
        if(!epStart )continue;
#endif
        int endPointIndex = startLine->endpoint_indexes[1];
		endpoint_data* epEnd = get_endpoint_data(endPointIndex);
#ifdef __WXDEBUG__
        wxASSERT(epEnd );
#else
        if(!epEnd )continue;
#endif

        //̍Eǂ̑ɓ_邩`FbN܂
		int rotRem = hpl::math::getPointRotationTypeFromLine(
			wpoint.x, wpoint.y, epStart->vertex.x, epStart->vertex.y,
			epEnd->vertex.x, epEnd->vertex.y);
        if(rotRem == hpl::math::RotationType::Clockwise &&
            startLine->counterclockwise_polygon_owner != NONE)
        {
            //EŁA̉Eiw_̂̈j
            //Ƀ|SɂꍇXLbv
//            hpl::error::caution("already polygon exists");
            continue;
        }
        if(rotRem == hpl::math::RotationType::Counterclockwise &&
            startLine->clockwise_polygon_owner != NONE)
        {
//            hpl::error::caution("already polygon exists");
            continue;
        }
        //ȍ~͂łɎw_̕Ƀ|SȂƉ肷

        //_
		int nowBasePointIndex = endPointIndex;
        int prevLineIndex = lineIndexBase;
		//TODO
        //startLine->endpoint_indexes[1]Ȃ𒲂ׂ
        std::vector<int> pointIndexes;
        //ŏ̓Ă
        pointIndexes.push_back(startPointIndex);
        pointIndexes.push_back(endPointIndex);

        bool found = getValidLines(nowBasePointIndex, prevLineIndex,
            &pointIndexes, smgr, rotRem, &doneList,
            zMin, zMax, wpoint);
        if(found){
            //I
            //_CfbNXilnpj
            int indexes[MAXIMUM_VERTICES_PER_POLYGON];

            //_f[^Wv
            for(int l = 0; l < (int)pointIndexes.size() - 1; l ++){
                //
                indexes[l] = pointIndexes[l];
            }
            int vertexCount = (int)pointIndexes.size() - 1;
            //|S쐬
            polygon_data poly;
            hpl::aleph::map::createPolygon(indexes, vertexCount, &poly);
            
            polyDatas.push_back(poly);

            //TODO ôH
            //ĤƂˁH
            //oIɋ߂΂񂶂ˁH
            break;
        }
        doneList.insert(i);
    }
    
    //
    delete pairs;
    return polyDatas;
}


void hpl::aleph::map::addNewPolygon(world_distance points[][2], int n)
{
    world_point2d pt[MAXIMUM_VERTICES_PER_POLYGON];
    for(int i = 0; i < n; i ++){
        pt[i].x = points[i][0];
        pt[i].y = points[i][1];
    }
    hpl::aleph::map::addNewPolygon(pt, n);
}
void hpl::aleph::map::addNewPolygon(world_point2d points[], int n)
{
    //endpoint̍쐬
    int epIndexes[MAXIMUM_VERTICES_PER_POLYGON];
    for(int i = 0; i < n; i ++){
        //endpoint̐
        endpoint_data ep;
        hpl::aleph::map::createPoint(points[i], &ep);
        int epIndex = hpl::aleph::map::addEndpoint(ep);
        epIndexes[i] = epIndex;
    }

    //line̍쐬
    //int lineIndexes[MAXIMUM_VERTICES_PER_POLYGON];
    for(int i = 0; i < n; i ++){
        int next = i + 1;
        if(next >= n){
            next = 0;
        }
        line_data line;
        hpl::aleph::map::createLine(epIndexes[i], epIndexes[next], &line);
        int lineIndex = hpl::aleph::map::addLine(line);
        //lineIndexes[i] = lineIndex;
    }
    polygon_data poly;
    hpl::aleph::map::createPolygon(epIndexes, n, &poly);
    hpl::aleph::map::addPolygon(poly);
}

