/*  DefaultStringSets.cpp - support for compiled-in 

	Copyright (C) 2002 and beyond by the "Aleph One" developers.
 
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	This license is contained in the file "COPYING",
	which is included with this source code; it is available online at
	http://www.gnu.org/licenses/gpl.html

	Default text StringSets, in case no MML provides them.
	by Woody Zenfell, III
	June 3, 2002

    June 3, 2002: captured text_strings.mml into C++ form for this file.
*/

#include    "cseries.h"

#include    "TextStrings.h"

// This works through what may seem like some weird voodoo.  Static objects are instantiated
// (despite the fact they have no storage); this results in the creation of StringSets in the
// normal StringSet storage area.  Nobody outside this file needs to know it exists; you just
// compile and link it, and the C++ runtime takes care of the instantiations.

class AutoStringSetBuilder {
public:
    AutoStringSetBuilder(short inStringSetID, const char** inStrings, short inNumStrings) {
        for(int i = 0; i < inNumStrings; i++)
            TS_PutCString(inStringSetID, i, inStrings[i]);
    }
};

#define NUMBER_OF_STRINGS(sa)   (sizeof(sa) / sizeof((sa)[0]))

#define BUILD_STRINGSET(id, strs)   static AutoStringSetBuilder (strs ## Builder) (id, strs, NUMBER_OF_STRINGS(strs))



// StringSets from original Bungie resources
// -----------------------------------------------------------------------------------------
// <!-- STR# Resource: "Errors" -->
static const char* sStringSetNumber128[] = {
	"AlephOneɂ68040ȏ̃vZbTKvłB",
	"AlephOneɂ Color QuickDraw KvłB",
	"AlephOneɂ Talk 7.1 ȍ~̃VXeKvłB",
	"AlephOneɂ 3000k ȏ̋RAMKvłB",
	"AlephOneɂ13C`ȏ(640x480)256F(܂̓O[)\\ł郂j^KvłB",
	"Map, Shapes, Images, Sounds ̃t@C Marathon AvP[VƓtH_ɓĂ邩mFĂB",
	"VXeȂ߃TEhp̃蓖Ă܂(Marathon̊蓖ă炵Ă)B",
	"AlephOne̎sɃt@CVXeG[܂BfBXN̋v̂ƃbNĂȂmFĂB",
	"AlephOnẽRs[̓ECXȂǂɂĕύXĂ܂BIWĩfBXNēxCXg[ĂB",
	"This beta copy of Marathon has expired and is no longer functional. Call Bungie at (312) 563-6200 ext. 21 for more information.",
	"̃L[͊Ƀ{[ɎgĂ܂B",
	"̃L[͊ɒn}̃Y[ɎgĂ܂B",
	"̃L[͊ɃACẽXN[ɎgĂ܂B",
	"̃L[͊ɃQ[̋@\\ɎgĂ܂B",
	"AlephOne͂̃}bv[h邽߂̃܂Bʂ𑝂₵ĂxsĂB",
	"AlephOne͂ꂩʂ̕ݒt@C[h܂B̂ߐ\\ANbVAۑQ[t@CAlbg[NQ[sɂȂ邨ꂪ܂Bӂ!",
	"AlephOne BungieȊO̒n}gĂ܂B̂ߐ\\ANbVAۑQ[t@C邨ꂪ܂Bӂ!",
	"n}܂͕ۑQ[t@CǂݍލۂɒvIG[܂B",
	"Z[ut@C}bvǂݍނƂɃVXeG[܂B",
	"ۑQ[t@C̕ۑɃG[܂Bn[hfBXNtAbNĂ邩܂B",
	"VAԍłBx͂ĂB",
	"lbg[NQ[̍ۂɓVAԍ𕡐̃}VłgpƂ͂ł܂BVɐiwKv܂Bڂ͓{̔̔㗝X܂ŘAĂB",
	"AlephOnẽRs[̓lbg[Np̃VAԍœo^Ă܂Blbg[Np̃VAԍł͈lp̃v[͂ł܂B",
	"ǂݍƂĂn}Ă邼BobNAbvRs[ēxCXg[悤B",
	"`FbN|Cg %d ͌܂ł!",
	"sN`[ %d ͌܂ł!",
	"̃o[WAleph One̓vr[łɂAlbg[NQ[T|[gĂ܂BBungieЂ́A܂Ȃlbg[NΉło܂Bȋ̃N[ȓj",
	"v[[W߂v[[ɂ݂ȂăQ[IĂ܂B{l悢...B",
	"܂BAlephOne̓lbg[NQ[̏IɎsĂ܂B̌ʁÃxł̌N̓w̖͂͐AƂȂĂ܂B",
	"̕ۑꂽQ[̃ViIt@C܂BxւƂAftHg̒n}ɖ߂܂B",
	"̉fL^n}܂Bf͍Đł܂B",
	"AlephOnelbg[NŗVԂɂ 6000k ȏ̋RAMKvłBʂ𑝂₵ĂxsĂB",
	"XNvgmNĂ悤łBMMLƃlbgXNvgŒNLuaŃRg[邩قȂĂƎv܂B\\Ȃ⓯ꂪN邩܂B",
	"̒ʒḿAVo[WAlephOneɍĂAvCłȂꍇɕ\\܂BAlephOneAbvO[hĂB",
	"XN[zC[́A̐؂ւŎgpĂ܂B",
};

// STR# Resource: "Filenames"
static const char* sStringSetNumber129[] = {
    "Shapes",
    "Shapes.16",
    "Sounds",
    "Sounds.16",
    "Aleph One Preferences",
    "Map",
    "Untitled Game",
    "Marathon",
    "Aleph One Recording",
    "Physics Model",
    "Music",
    "Images",
    "Movie",
    "Default",
};

// STR# Resource: "Top-Level Interface Items"
static const char* sStringSetNumber130[] = {
	"VKQ[",
	"̃Q[J",
	"",
	"Ō̃Q[Đ",
	"tBJ",
	"tB̕ۑ",
	"",
	"lbgQ[W",
	"lbgQ[Q",
	"",
	"ݒ",
	"fJn",
	"I",
};

// STR# Resource: "Prompts"
static const char* sStringSetNumber131[] = {
    "Q[ۑF",
    "f̕ۑF",
    "f̑IF",
    "ftHg",
};

// STR# Resource: "Network Errors"
static const char* sStringSetNumber132[] = {
	"̃v[[̓lbg[NŌ܂BQ[Q̃_CAOLZ܂B",

	"̃v[[lbg[NŌȂ߁A"
	"Q[f܂B",

	"zXgĂRs[^̉܂B"
	"t@C[EH[K؂ɐݒ肳Ă邩AAhXԈĂȂmFĉB",

	"Sorry, the gathering computer has cancelled the game (you should all gang up on him next game).",

	"The map was not received in its entirety, so the game has been canceled.",

	"ĂяõRs[^n}𑗂Ȃ߁AQ[LZ܂B̃Rs[^̐ڑ؂ꂽ܂B",
	"AlephOnéAQ[Jnł܂B̃Rs[^̐ڑ؂ꂽ܂B",
	"Q[̎QɃG[܂(AvP[Ṽo[WႤ܂)BxĂ݂ĂB",
	"lbg[NG[̂AlephOne͑sł܂B",

	"o[WقȂ邽߂̃v[[̓Q[ɎQł܂łB",

	"̃vC[́AݕWĂQ[̂̊g@\\gpłȂÂo[WAlephOnegpĂ悤łB̂߁ÃQ[Jn邱Ƃł܂B",
	"ݕWĂQ[ɁAg@\\ɑΉĂȂAlephOnegĂvC[Q悤Ƃ܂B",
	"AlephOnéÃx̃}bvt@C邱Ƃł܂łB̃^[~iɕ\\Ȃ܂B܂ÃRs[^[ŃQ[ۑ邱Ƃ͐ł܂B",
	"WĂlȂȂ܂B",

	"WĂl邱Ƃł܂BAhX͂Ă邩mFB",

	"T[o[}bv𑗂ƂɃG[܂BQ[I܂B",

	"The gatherer is using the star protocol, but your configuration is set to ring. You will not appear in the list of available players.",

	"The gatherer is using the ring protocol, but your configuration is set to star. You will not appear in the list of available players.",

	"The gatherer is using a Lua netscript, but this version was built without Lua support. You will not appear in the list of available players.",

	"There was a problem connecting to the server that tracks Internet games.  Please try again later.",

	"Your game could not be advertised on the Internet.  Please distribute your public IP address by other means or try again later.",

	"Aleph OnéAt@C[EH[⃋[^[̐ݒύX邱Ƃł܂łBvC[W邱Ƃł܂B"
	
};

// STR# Resource: "Key Codes To Names"
static const char* sStringSetNumber133[] = {
    "A",
    "S",
    "D",
    "F",
    "H",
    "G",
    "Z",
    "X",
    "C",
    "V",
    "0x0A",
    "B",
    "Q",
    "W",
    "E",
    "R",
    "Y",
    "T",
    "1",
    "2",
    "3",
    "4",
    "6",
    "5",
    "=",
    "9",
    "7",
    "-",
    "8",
    "0",
    "]",
    "O",
    "U",
    "[",
    "I",
    "P",
    "Return",
    "L",
    "J",
    "'",
    "K",
    ";",
    "\\",
    ",",
    "/",
    "N",
    "M",
    ".",
    "Tab",
    "Space",
    "`",
    "Delete",
    "0x34",
    "Escape",
    "0x35",
    "?",
    "Shift",
    "Caps Lock",
    "Option",
    "Control",
    "0x3c",
    "0x3d",
    "0x3e",
    "0x3f",
    "0x40",
    "Keypad .",
    "0x42",
    "Keypad *",
    "0x44",
    "Keypad +",
    "0x46",
    "Clear",
    "0x48",
    "0x49",
    "0x4a",
    "Keypad /",
    "Enter",
    "0x4d",
    "Keypad -",
    "0x4f",
    "0x50",
    "Keypad =",
    "Keypad 0",
    "Keypad 1",
    "Keypad 2",
    "Keypad 3",
    "Keypad 4",
    "Keypad 5",
    "Keypad 6",
    "Keypad 7",
    "0x5a",
    "Keypad 8",
    "Keypad 9",
    "0x5d",
    "0x5e",
    "0x5f",
    "F5",
    "F6",
    "F7",
    "F3",
    "F8",
    "F9",
    "0x66",
    "F11",
    "0x68",
    "F13",
    "0x6a",
    "F14",
    "0x6c",
    "F10",
    "0x6e",
    "F12",
    "0x70",
    "F15",
    "Help",
    "Home",
    "Page Up",
    "Forw. Del.",
    "F4",
    "End",
    "F2",
    "",
    "F1",
    "",
    "",
    "",
    "",
    "Power",
};

// STR# Resource: "Preferences Advice"
static const char* sStringSetNumber134[] = {
	"OXs[J[̓wbhtHڑATEh̃Rg[plŃXeIo͂IɂȂĂ邱ƂmFĂB",
	"Cybermaxx wbgVA|[gɐڑAIɂȂĂ邱ƂmFĂB",
	"@\\gtH_ QuickTime Musical Instruments t@CĂ邱ƂmFĂBĂȂBGM͂oJ炵邼..."
};

// STR# Resource: "Computer Interface"
static const char* sStringSetNumber135[] = {
    "U.E.S.C. Marathon",
//    "Opening Connection to b.4.5-23",
	".4.5-23 ƐڑJn",
    "CAS.qterm//CyberAcme Systems Inc.",
    "<931.461.60231.14.vt920>",
//    "UESCTerm 802.11 (remote override)",
	"UESC^[~i 802.11i[gI[o[hCuj",
//    "PgUp/PgDown/Arrows To Scroll",
	"PgUp/PgDown/L[ŃXN[",
//    "Return/Enter To Acknowledge",
	"Return/EnterL[ŗ",
//    "Disconnecting...",
	"ڑؒf",
//    "Connection Terminated.",
	"ڑI",
    "%H%M %m.%d.%Y",
};

// STR# Resource: "Join Dialog Messages"
static const char* sStringSetNumber136[] = {
	"uQvNbNƃlbg[NQ[ɎQł܂B",
	"T[o[lbg[NQ[ɌĂяô҂Ă܂BuLZvNbNƒf܂B",
	"lbg[NQ[ɎQ܂BT[o[͑̃v[[W߂Ă܂..."
};

// STR# Resource: "Weapon Names"
static const char* sStringSetNumber137[] = {
	"",
	".44 }OiEK A1",
	"[EXjZsXg",
	"MA-75B @֏e/Ol[hC",
	"SPNKR-X18^~TC`[",
	"TOZT-7 Ήˋ@",
	"ޕs VXeG[ 0xfded",
	"WSTE-M 퓬pVbgK",
	"(somehow related to time of applicability)",
	"KKV-7 10MMt`Gbg^y@֏e",
};

// STR# Resource: "file search path"
static const char* sStringSetNumber138[] = {
    "Marathon Trilogy:Marathon Infinity:Marathon Infinity:",
};

// STR# Resource: "Preferences Groupings"
static const char* sStringSetNumber139[] = {
	"OtBbN",
	"vC[",
	"TEh",
	"Rg[",
	""
};

// STR# Resource: "Postgame network game stats"
static const char* sStringSetNumber140[] = {
	"%d ",
	"%d:%02d",
	"%d _",
	"`[",
	"{[̕ێ",
	"̕ߊl",
	"",
	"S[",
	"wnɂ",
	"wnɂ",
	"|Cg",
	""
};

// STR# Resource: "Net Game Setup"
static const char* sStringSetNumber141[] = {
	"E",
	"E",
	"ߊl",
	"",
	"_",
	"_",
	"wnɂ",
	"",
	"|Cg",
	""
};

// STR# Resource: "New Join Dialog Messages"
static const char* sStringSetNumber142[] = {
	"Ńu%svQ[Ɏ󂯓܂BT[o[c̃v[[ǉ܂ŏX܂c",
	"lΐ"
	"ŃuΐvQ[Ɏ󂯓܂BT[o[c̃v[[ǉ܂ŏX܂c",
	"",
	"wn",
	"{[̎荇",
	"hq",
	"Or[",
	"S",
	"N̓JX^Q[Ɏ󂯓܂BT[o[c̃v[[ǉ܂ŏX܂c",
};

// STR# Resource: "Progress strings for networking"
static const char* sStringSetNumber143[] = {
	"vC[֒n}]łB",
	"vC[֒n}]łB",
	"T[o[n}]Ă܂B",
	"T[o[n}̓]҂B",
	"f[^𑼂̃vC[֓]łB",
	"f[^𑼂̃vC[֓]łB",
	"f[^T[o[]Ă܂B",
	"ǂݍݒc"
	"[^[̃|[gJĂ܂c",
	"[^[̃|[gĂ܂c",
	"Abvf[gmFłc"
};

BUILD_STRINGSET(128, sStringSetNumber128);
BUILD_STRINGSET(129, sStringSetNumber129);
BUILD_STRINGSET(130, sStringSetNumber130);
BUILD_STRINGSET(131, sStringSetNumber131);
BUILD_STRINGSET(132, sStringSetNumber132);
BUILD_STRINGSET(133, sStringSetNumber133);
BUILD_STRINGSET(134, sStringSetNumber134);
BUILD_STRINGSET(135, sStringSetNumber135);
BUILD_STRINGSET(136, sStringSetNumber136);
BUILD_STRINGSET(137, sStringSetNumber137);
BUILD_STRINGSET(138, sStringSetNumber138);
BUILD_STRINGSET(139, sStringSetNumber139);
BUILD_STRINGSET(140, sStringSetNumber140);
BUILD_STRINGSET(141, sStringSetNumber141);
BUILD_STRINGSET(142, sStringSetNumber142);
BUILD_STRINGSET(143, sStringSetNumber143);



// Stringsets for SDL w_select widgets.
// -----------------------------------------------------------------------------------------
#include    "network_dialogs.h"  // for stringset ID's

static const char*    sDifficultyLevelsStrings[] = {
	"тq",
	"ȒP",
	"",
	"",
	"sE"
};

static const char*    sNetworkGameTypesStrings[] = {
	"lΐ",
	"`[vC",
	"",
	"wn",
	"S",
	"Or[",
	"^O",
	"lbgXNvg"
};

static const char*    sEndConditionTypeStrings[] = {
//    "No Limit (Alt+Q to quit)",
	"",
	"Ԑ",
	"XRA"
};

static const char*	sSingleOrNetworkStrings[] = {
	"\\ŃQ[",
	"lbg[NŃQ["
};


BUILD_STRINGSET(kDifficultyLevelsStringSetID,   sDifficultyLevelsStrings);
BUILD_STRINGSET(kNetworkGameTypesStringSetID,   sNetworkGameTypesStrings);
BUILD_STRINGSET(kEndConditionTypeStringSetID,   sEndConditionTypeStrings);
BUILD_STRINGSET(kSingleOrNetworkStringSetID,	sSingleOrNetworkStrings);


// More Mac OS string-resource stringsets.
// -----------------------------------------------------------------------------------------
// STR# Resource: "Item names"
static const char* sStringSetNumber150[] = {
    "",
    ".44 }OiEK",
    ".44 }OiEK",
    ".44 e (x8)",
    ".44 e (x8)",
    "[EXjZsXg",
    "jZobe",
    "jZobe",
    "MA-75B @֏e",
    "MA-75B e (x52)",
    "MA-75B e (x52)",
    "MA-75B Ol[h (x7)",
    "MA-75B Ol[h (x7)",
    "SPNKR-X18 SSM ~TCˋ@",
    "SSM ~TC (x2)",
    "SSM ~TC (x2)",
    "GCA̕",
    "VbgKe (x2)",
    "VbgKe (x2)",
    "TOZT-7 wΉˋ@",
    "ip[Ue",
    "ip[Ue",
    "POWERPC 620 `bv",
    "POWERPC 620 `bv",
    "GCÃGlM[ϊ@",
    "gC",
    "݌v}",
    "WSTE-M 퓬pVbgK",
    "WSTE-M 퓬pVbgK",
    "XtgJ[hL[",
    "XtgJ[hL[",
    "AbvN`bv",
    "AbvN`bv",
    "F̃{[",
    "W",
    "F̃{[",
    "F̃{[",
    "F̃{[",
    "F̃{[",
    "F̃{[",
    "ΐF̃{[",
    "KKV-7 10MM t`Fbg^y@֏e",
    "10MM t`Fbgeq",
    "10MM t`Fbgeq",
};

// STR# Resource: "Item types"
static const char* sStringSetNumber151[] = {
    "",
    "e",
    "p[Abv",
    "",
    "^p[Abv",
    "{[",
    "lbg[N",
};

// STR# Resource: "Net Statistics Strings"
static const char* sStringSetNumber153[] = {
    "E: %dl",
    "S: %dl",
    "E: %dl",
    "v",
    "G",
    "E̍v: %d (ꕪ %.2fl)",
    "S̍v: %d (ꕪ %.2fl)",
    " - E %dl܂",
    "`[sE̍v",
    " - m %dl܂",
    "",
    "`[̐",
    // ZZZ: added for team vs. team carnage in postgame report
    "%s̃`[",
    // ZZZ: added for legend/key in SDL postgame report
    "E",
    "S",
    "",
    "",
};

// STR# Resource: "OpenGL-Option Color-Picker Prompts"
static const char* sStringSetNumber200[] = {
    "ȂԂ̐F́H",
    "̒nʂ̐F́H",
    "̋̐F́H",
    "Ԃ̒nʂ̐F́H",
    "Ԃ̋̐F́H",
    "̒nʂ̐F́H",
    "̋̐F́H",
    "FԂ̒nʂ̐F́H",
    "FԂ̋̐F́H",
    "tHbO̐F́H",
};

BUILD_STRINGSET(150, sStringSetNumber150);
BUILD_STRINGSET(151, sStringSetNumber151);
BUILD_STRINGSET(153, sStringSetNumber153);
BUILD_STRINGSET(200, sStringSetNumber200);


#include "player.h" // for kTeamColorsStringSetID

static const char* sTeamColorNamesStrings[] = {
    "D",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
};

BUILD_STRINGSET(kTeamColorsStringSetID, sTeamColorNamesStrings);

