#include "MainFrame.h"
#include "PhysicsEditorOneWX.h"

const int WINDOW_DEFAULT_WIDTH = 800;
const int WINDOW_DEFAULT_HEIGHT = 600;


/**
	Cxgp̎ID(Ȃ̂Ɍ)
*/
namespace MainFrameEventId{
	enum{
		//y[WύX
		ID_NOTE,
		//X^[y[Wp
		ID_MONSTER_PAGE,
		ID_EFFECT_PAGE,
		ID_PROJECTILE_PAGE,
		ID_PHYSICS_PAGE,
		ID_WEAPON_PAGE,
	};
};

/**Cxg֘AÂ*/
BEGIN_EVENT_TABLE(MainFrame, wxFrame)
	EVT_MENU(wxID_NEW, MainFrame::OnNew)
	EVT_MENU(wxID_OPEN, MainFrame::OnOpen)
	EVT_MENU(wxID_SAVE, MainFrame::OnSave)
	EVT_MENU(wxID_SAVEAS, MainFrame::OnSaveAs)
	EVT_MENU(wxID_EXIT, MainFrame::OnQuit)
END_EVENT_TABLE()

void MainFrame::Create(wxWindow* parent, wxWindowID id)
{
	wxString title = wxConvertMB2WX(TITLE);
	if(!wxFrame::Create(parent, id, title, wxDefaultPosition,
		wxSize(WINDOW_DEFAULT_WIDTH, WINDOW_DEFAULT_HEIGHT)))
	{
		hpl::error::halt("Unknown error occured when launch app.");
	}

	this->SetSize(WINDOW_DEFAULT_WIDTH, WINDOW_DEFAULT_HEIGHT);

	//status bar
	CreateStatusBar();
	SetStatusText( _T("get ready..."));

	wxFont font = GetFont();
	font.SetPointSize(8);
	SetFont(font);

	//j[̍쐬
	//File
	wxMenu* menuFile = new wxMenu;
	menuFile->Append(wxID_NEW, _T("&New"));
	menuFile->Append(wxID_OPEN, _T("&Open"));
	menuFile->Append(wxID_SAVE, _T("&Save"));
	menuFile->Append(wxID_SAVEAS, _T("Save as..."));
	menuFile->AppendSeparator();
	menuFile->Append(wxID_EXIT, _T("E&xit"));

    wxMenuBar *menuBar = new wxMenuBar;
	menuBar->Append(menuFile, _T("&File"));

    SetMenuBar(menuBar);

	//zu
	this->notebook = new wxNotebook(this, MainFrameEventId::ID_NOTE, wxDefaultPosition, wxDefaultSize,
		wxNB_LEFT);
	bool select = true;
	//X^[pl
	this->monsterPanel = new MonsterPanel(notebook, wxID_ANY);
	this->effectPanel = new EffectPanel(notebook, wxID_ANY);
	this->projectilePanel = new ProjectilePanel(notebook, wxID_ANY);
	this->physicsPanel = new PhysicsPanel(notebook, wxID_ANY);
	this->weaponPanel = new WeaponPanel(notebook, wxID_ANY);

	this->notebook->AddPage(monsterPanel, _T("Monsters"), select);
	this->notebook->AddPage(effectPanel, _T("Effects"));
	this->notebook->AddPage(projectilePanel, _T("Projectiles"));
	this->notebook->AddPage(physicsPanel, _T("Physics"));
	this->notebook->AddPage(weaponPanel, _T("Weapons"));

	this->notebook->SetMinSize(wxSize(WINDOW_DEFAULT_WIDTH, WINDOW_DEFAULT_HEIGHT));

    wxGridSizer* sizer_base = new wxGridSizer(1);
	sizer_base->Add(this->notebook, 0,wxEXPAND,0);
	wxGridSizer* monsterSizer = new wxGridSizer(1);
	monsterSizer->Add(monsterPanel, 0, wxEXPAND, 0);
	notebook->SetSizer(monsterSizer);

    SetSizer(sizer_base);
    sizer_base->Fit(this);
    Layout();
}
/**
	ҏWłΓej邩ȂOɕۑ邩ALZ邩
	ǂ₢܂B
	@return 
		wxYES:	jOɕۑ
		wxNO:	ۑɔj
		wxCANCEL:LZďsȂ
*/
int MainFrame::askDestroy()
{
	if(wxGetApp().isChanged()){
		//ύX
        wxMessageDialog dlg(this,
			_T("Physics data has been modified. Do you save this before destruction? Click No to skip save."),
			_T("Destroy!"), wxYES_NO | wxCANCEL);
		return dlg.ShowModal();
	}else{
		//ύX͂Ȃ
		return wxNO;
	}
}

void MainFrame::OnNew(wxCommandEvent& ev)
{
	int result = askDestroy();
	wxCommandEvent dummy;
	if(result == wxYES){
		//ۑ
		OnSave(dummy);
	}else if(result == wxNO){
		//̂܂܏
	}else{
		//LZ
		return;
	}
	wxGetApp().loadDefaultPhysicsFile();

	//Xe[^Xo[ɕ\
	SetStatusText(_T("Create new physics file."));
}
void MainFrame::OnOpen(wxCommandEvent& ev)
{
	int result = askDestroy();
	wxCommandEvent dummy;
	if(result == wxYES){
		//ۑ
		OnSave(dummy);
	}else if(result == wxNO){
		//̂܂܃I[v
	}else{
		//LZ
		return;
	}
    wxFileDialog fileDialog(this, _T("Choose a file"),
        _T("."), _T(""), _T("*.*"));

    if(fileDialog.ShowModal() == wxID_OK){
        wxString path = fileDialog.GetPath();
		wxGetApp().loadPhysicsFile(path.mb_str());

		//Xe[^Xo[ɕ\
		SetStatusText(_T("Load physics file complete."));
	}
}
void MainFrame::OnSave(wxCommandEvent& ev)
{
	wxCommandEvent dummy;

	if(wxGetApp().isNew()){
		//VK
		OnSaveAs(dummy);
	}else{
		//Ăt@Cŕۑ܂
		std::string saveFilePath = wxGetApp().getSaveFilePath();
		wxGetApp().savePhysicsFile(saveFilePath.c_str());
		//Xe[^Xo[ɕ\
		SetStatusText(_T("Save physics file complete."));
	}
}
void MainFrame::OnSaveAs(wxCommandEvent& ev)
{
	//VKۑI܂
    int style = wxFD_SAVE | wxFD_OVERWRITE_PROMPT;
    wxString wildcard(_T("AlephOne physics file (*.phyA)|*.phyA|Any file|*.*"));
    wxFileDialog dlg(this, wxString(_T("Save at...")), 
        wxString(_T("")), wxString(_T("unknown.phyA")), wildcard,
        style);
    if(dlg.ShowModal() == wxID_OK){
		wxString str = dlg.GetPath();
		//ۑ
		wxGetApp().savePhysicsFile(str.mb_str());
		//Xe[^Xo[ɕ\
		SetStatusText(_T("Save physics file complete."));
	}
}
void MainFrame::OnQuit(wxCommandEvent& ev)
{
	int result = this->askDestroy();
	wxCommandEvent dummy;
	if(result == wxYES){
		//ۑ
		OnSave(dummy);
	}else if(result == wxNO){
		//̂܂܃I[v
	}else{
		//LZ
		return;
	}
	Destroy();
}
