package jp.hpl.gui.render;

import javax.swing.JDialog;
import javax.swing.JFrame;

import jp.hpl.gui.IMapViewerFrame;

import src.backend.Level;

/**
 * 
 * @author koji
 *
 */
public class VisualModeDialog extends JDialog {
	private static int DEFAULT_WIDTH = 400;
	private static int DEFAULT_HEIGHT = 400;
	
	private RenderCanvas canvas;
	public VisualModeDialog(JFrame frame, Level l){
		super(frame, "Visual mode", false);
		
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		setLocationByPlatform(true);
		
		reload(l);
	}
	
	public void reload(Level l){
		canvas = new RenderCanvas(((IMapViewerFrame)getParent()), l);
		getContentPane().add(canvas);
		canvas.setPreferredSize(getSize());
	}
}
