package jp.hpl.gui.render;

import jp.hpl.exception.IntegerOverFlowException;

public class ViewPort {
	double xmin, xmax, ymin, ymax;
	int width, height;
	double nXMin, nYMin;
	
	double transX = 0;
	double transY = 0;
	public ViewPort(){
	
	}
	public void setViewSize(int width, int height, 
			double xmin, double xmax, double ymin, double ymax){
		this.width = width;
		this.height = height;
		this.xmin = xmin;
		this.xmax = xmax;
		this.ymin = ymin;
		this.ymax = ymax;
		transformView(0, 0, true);
	}
	
	private void transformView(int noDrawTop, int noDrawBottom, boolean isSaveAspect){
		double ap = (ymax - ymin) / (xmax - xmin);
		double aw = (double)(height - noDrawTop - noDrawBottom) / (double)width;
		
		transX = (double)width / (xmax - xmin);
		transY = (double)(height - noDrawTop - noDrawBottom) / (ymax - ymin);
		nXMin = 0;
		nYMin = noDrawBottom;
		if(isSaveAspect){
			if(ap > aw){
				nXMin = (int)(0.5 * (1.0 - transY / transX) * (double)width);
				transX = transY;
			}else{
				nYMin += (int)(0.5 * (1.0 - transX / transY) * (double)height);
				transY = transX;
			}
		}
	}
	public int[] getViewPoint(double y, double z) throws IntegerOverFlowException {
		int[] point2D = new int[2];
		double X = (transX * (y - xmin) + nXMin);
		double Y = height - nYMin - (transY * (z - ymin));
		if(Math.abs(X) >= Integer.MAX_VALUE ||
				Math.abs(Y) >= Integer.MAX_VALUE){
			throw new IntegerOverFlowException();
		}
		point2D[0] = (int)X;
		point2D[1] = (int)Y;
		return point2D;
	}
}
