package jp.hpl.gui.render;

import jp.hpl.exception.BackwardException;
import jp.hpl.exception.IntegerOverFlowException;

/**
 * 2D <-> 3D
 * @author koji
 *
 */
public class Transformer {
	private Camera camera = new Camera();
	
	ViewPort viewPort;
	
	/** transform array [column][row] */
	private double[][] transform = new double[3][3];

	public static final double TRANSPARENT_FUNCTION_MAX = 100;
	
//	public static double[][] getTransformArray()
	
	public Transformer(){
		doCalcTransformArray();
		viewPort = new ViewPort();
	}
	
//	public int[] getViewPointFrom3DPoint(double[] point3D) throws IntegerOverFlowException, BackwardException{
//		double[] transformedPoints = get3DView(point3D);
//		if(transformedPoints[2] < 0){
//			throw new BackwardException();
//		}
//		double[] peredPoint = getPers(transformedPoints);
//		int[] point2D = viewPort.getViewPoint(peredPoint[0], peredPoint[1]);
//		return point2D;
//	}
	
	public double[] getPers(double[] transformedPoint) {
		double[] points = new double[transformedPoint.length];
		
		double base = transformedPoint[2];//TRANSPARENT_FUNCTION_MAX - transformedPoint[2];
		double pers = 0;
		if(base == 0){
			base = 0.001;
		}
		pers = TRANSPARENT_FUNCTION_MAX / base;//TRANSPARENT_FUNCTION_MAX / base;
		for(int j = 0; j < transformedPoint.length; j ++){
			points[j] = transformedPoint[j] * pers;
		}
		return points;
	}

	public double[] get3DView(double[] sourcePoints){
		double[] destPoints = new double[sourcePoints.length];
		
		double[] center = camera.getCenter();
		double[] trans = new double[3];
		for(int j = 0; j < trans.length; j ++){
			trans[j] = sourcePoints[j] - center[j];
		}
		for(int k = 0; k < trans.length; k ++){
			destPoints[k] = 0;
			for(int j = 0; j < trans.length; j ++){
				destPoints[k] += trans[j] * transform[j][k];
			}
		}
		return destPoints;
	}
	
	public void doCalcTransformArray(){
		double theta = camera.getTheta();
		double phi = camera.getPhi();
		
		double sinT = Math.sin(theta);
		double cosT = Math.cos(theta);
		double sinP = Math.sin(phi);
		double cosP = Math.cos(phi);
		//transform[column][row]
		transform[0][0] = cosP;
		transform[0][1] = 0;
		transform[0][2] = -sinP;

		transform[1][0] = -sinT * sinP;
		transform[1][1] = cosT;
		transform[1][2] = -sinT * cosP;

		transform[2][0] = cosT * sinP;
		transform[2][1] = sinT;
		transform[2][2] = cosT * cosP;
//		transform[0][0] = cosP * cosT;
//		transform[0][1] = -sinT;
//		transform[0][2] = -sinP * cosT;
//
//		transform[1][0] = cosP * sinT;
//		transform[1][1] = cosT;
//		transform[1][2] = -sinP * sinT;
//
//		transform[2][0] = sinP;
//		transform[2][1] = 0;
//		transform[2][2] = cosP;
	}

	public void setViewSize(int width, int height, double xmin, double xmax,
			double ymin, double ymax) {
		this.viewPort.setViewSize(width, height, xmin, xmax, ymin, ymax);
	}

	public Camera getCamera() {
		return camera;
	}

	public int[] getViewPoint(double[] peredPoint) throws IntegerOverFlowException {
		int[] point2D = viewPort.getViewPoint(peredPoint[0], peredPoint[1]);
		return point2D;
	}
}
