package jp.hpl.gui.render;

import java.util.Arrays;

public class Camera {
	private double[] center = new double[3];
	
	/** x <-> y rotation (radian) */
	private double theta;
	
	/** x <-> z rotation (radian) */
	private double phi;
	
	public Camera(){
		Arrays.fill(center, 0.0);
		theta = 0;
		phi = 0;
	}

	protected double[] getCenter() {
		double[] array = new double[center.length];
		for(int i = 0; i < array.length; i ++){
			array[i] = center[i];
		}
		return array;
	}

	public void setCenter(double[] c) {
		for(int i = 0; i < c.length; i ++){
			center[i] = c[i];
		}
	}
	public void setCenter(double x, double y, double z){
		center[0] = x;
		center[1] = y;
		center[2] = z;
	}

	protected double getPhi() {
		return phi;
	}

	protected void setPhi(double phi) {
		this.phi = phi;
	}

	protected double getTheta() {
		return theta;
	}

	protected void setTheta(double theta) {
		this.theta = theta;
	}
}
