package jp.hpl.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import src.backend.Level;

public class SelectLevelDialog extends JDialog implements ActionListener{
	
	private static final int DEFAULT_WIDTH = 400;
	private static final int DEFAULT_HEIGHT = 400;

//	private JTable levelTable = new JTable();
//	private DefaultTableModel levelTableModel = new DefaultTableModel();
	private JList levelList;
	private DefaultListModel listModel = new DefaultListModel();
	
	private static String CMD_OK_BUTTON = "Ok";
	private static String CMD_CANCEL_BUTTON = "Cancel";
	
	public SelectLevelDialog(JFrame parent, List levelNameList){
		super(parent, "Select level", true);
		
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		setLocationRelativeTo(null);
		
		JButton okBtn = new JButton("OK");
		JButton cancelBtn = new JButton("CANCEL");
//		levelTable.setModel(levelTableModel);
		this.setLayout(new BoxLayout(this.getContentPane(), BoxLayout.Y_AXIS));
		
		this.getContentPane().add(new JLabel("Select a level"));
//		this.getContentPane().add(levelTable);
		levelList = new JList(listModel);
		JScrollPane sp = new JScrollPane();
		sp.getViewport().setView(levelList);
		
		this.getContentPane().add(sp);
		
//		this.getContentPane().add(okBtn);
//		this.getContentPane().add(cancelBtn);
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		this.getContentPane().add(p);
		p.add(okBtn);
		p.add(cancelBtn);
		
//		levelList.setPreferredSize(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT - 100));
//		Vector vec = new Vector();
		//setting
		for(int i = 0; i < levelNameList.size(); i ++){
			listModel.addElement(((Level)levelNameList.get(i)).getlevelSelectName());
//			vec.add();
//			levelTable.add
//			levelTableModel.addRow(vec);
		}
		
		okBtn.setActionCommand(CMD_OK_BUTTON);
		cancelBtn.setActionCommand(CMD_CANCEL_BUTTON);
	}

	
	public int getSelectedIndex(){
		return levelList.getSelectedIndex();
	}

	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();
		
		if(cmd.equals(CMD_OK_BUTTON)){
			
		}else if(cmd.equals(CMD_CANCEL_BUTTON)){
			
		}
	}


}
