package jp.hpl.gui;

import java.awt.Point;

import jp.hpl.data.StaticData;

import src.backend.StaticFunctions;

/**
 * scroll manager
 * @author koji
 *
 */
public class Scroller {
	
	private static final double zoomDefault = 0.01;
	public static final double ZOOM_STEP = 0.001;
	
	/** offset for drawing map in canvas's view */
	private Point offset;
	
	/** zoom */
	private double zoom;
	
	public Scroller(){
		offset = new Point(0,0);
		zoom = zoomDefault;
	}
	public Point getOffset() {
		return new Point(offset);
	}
	public void setOffset(Point offset) {
		this.offset = new Point(offset);
	}
	
	public void setZoom(double z, int width, int height){
//		width = height = StaticData.WORLD_MAX;
		if(z == 0){
			z = ZOOM_STEP;
		}
		try{
			offset.x = (int)((double)(width / 2 + offset.x) * z / zoom - width / 2);
			offset.y = (int)((double)(height / 2 + offset.y) * z / zoom - height / 2);
		}catch (Exception e) {
			//divide for zero, etc.
			return;
		}
		zoom = z;
	}
	
	public double getZoom(){
		return zoom;
	}
//	public int getZoomDivision(){
//		int div = (int)((double))
//	}
}
