package jp.hpl.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import src.backend.MapData;
import src.gui.FlagsFrame;

import jp.hpl.data.DefaultMarathonDataModel;
import jp.hpl.gui.preferences.Preferences;
import jp.hpl.gui.render.VisualModeDialog;
import jp.hpl.gui.thread.ProgressBarDialog;
import jp.hpl.gui.thread.ProgressLoadThread;


public class MainViewFrame extends JFrame implements IMapViewerFrame{

	/**the level you see*/
	private int levelIndex;
	
	private DefaultMarathonDataModel model;
	
	private List/*<JFrame>*/ childFrames;
	
	
	////// gui
	JMenu menuLevel = new JMenu("Level");
	JMenu menuMode = new JMenu("Mode");
	
	
//	JProgressBar progressBar = new JProgressBar();
	
	MapCanvas canvas;
	
	/** progress bar dialog */
	ProgressBarDialog progressBarDialog;
	
	/** tool bar */
	ToolbarDialog toolbarDialog;
	
	/** mode for editing (draw, visual, polygon type, and so on) */
	private int editMode;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public MainViewFrame(){
		
		this.model = new DefaultMarathonDataModel(this);
		childFrames = new ArrayList();//<JFrame>();
		canvas = new MapCanvas(this);
		
		toolbarDialog = new ToolbarDialog(this);
		toolbarDialog.setVisible(true);
		canvas.setToolbarDialog(toolbarDialog);
		jbInit();
	}

	private void jbInit() {
		//close operation
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setLocationByPlatform(true);
		
//		this.setLocationRelativeTo(null);

		//layout
		/** menu bar */
		JMenuBar menuBar = new JMenuBar();
		this.setJMenuBar(menuBar);
		setupMenuBar(menuBar);
		
		canvas.setBounds(0,0,this.getWidth(), this.getHeight());
		getContentPane().add(canvas);
		
		this.progressBarDialog = new ProgressBarDialog(this);
		
	}
	
	private void setupMenuBar(JMenuBar menuBar) {
		// files
		{
			JMenu menuFile = new JMenu("File");
			JMenuItem miOpen = new JMenuItem("Open");
			JMenuItem miSave = new JMenuItem("Save");
			JMenuItem miSaveAs = new JMenuItem("SaveAs ...");
			JMenuItem miExit = new JMenuItem("Exit");
	//		JMenuItem miNew = new JMenuItem("New");
	//		JMenu menuFile = new JMenu("Edit");
			menuBar.add(menuFile);
	//			menuFile.add(miNew);
			menuFile.add(miOpen);
			menuFile.add(miSave);
			menuFile.add(miSaveAs);
			menuFile.addSeparator();
			menuFile.add(miExit);
			
			miOpen.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemOpen(e);
				}
			});
			miSave.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemSave(e);
				}

			});
			miSaveAs.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemSaveAs(e);
				}
			});
			miExit.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemExit(e);
				}
				
			});
		}
		
		//edit
		{
			JMenu menuEdit = new JMenu("Edit");
			JMenuItem miPreferences = new JMenuItem("Preferences");
			menuBar.add(menuEdit);
			menuEdit.add(miPreferences);
			miPreferences.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemPreference(e);
				}
			});
		}
	
		//level
		{
			menuLevel.setEnabled(false);
			menuBar.add(menuLevel);
			JMenuItem miSelectLevel = new JMenuItem("Select level");
			JMenuItem miItemPlacement = new JMenuItem("Item placement");
			JMenuItem miMonsterPlacement = new JMenuItem("Monster placement");
			
			menuLevel.add(miSelectLevel);
			menuLevel.addSeparator();
			menuLevel.add(miItemPlacement);
			menuLevel.add(miMonsterPlacement);
	
			miSelectLevel.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemSelectLevel(e);
				}

			});
		}
		
		{
			menuMode.setEnabled(false);
			menuBar.add(menuMode);
			JMenuItem miDrawMode = new JMenuItem("Draw mode");
			JMenuItem miVisualMode = new JMenuItem("Visual mode");
			JMenuItem miPolygonTypeMode = new JMenuItem("Polygon type mode");
			JMenuItem miElevationMode = new JMenu("Elevation mode");
			JMenuItem miiElevationFloor = new JMenuItem("Floor");
			JMenuItem miiElevationCeiling = new JMenuItem("Ceiling");
			JMenuItem miLightMode = new JMenu("Light mode");
			JMenuItem miiLightFloor = new JMenuItem("Floor");
			JMenuItem miiLightCeiling = new JMenuItem("Ceiling");
			JMenuItem miSoundMode = new JMenu("Sound mode");
			JMenuItem miiSoundFloor = new JMenuItem("Floor");
			JMenuItem miiSoundCeiling = new JMenuItem("Ceiling");
			JMenuItem miTextureMode = new JMenu("Texture mode");
			JMenuItem miiTextureFloor = new JMenuItem("Floor");
			JMenuItem miiTextureCeiling = new JMenuItem("Ceiling");
			menuMode.add(miDrawMode);
			menuMode.add(miVisualMode);
			menuMode.addSeparator();
			menuMode.add(miPolygonTypeMode);
			menuMode.add(miElevationMode);
			miElevationMode.add(miiElevationFloor);
			miElevationMode.add(miiElevationCeiling);
			menuMode.add(miLightMode);
			miLightMode.add(miiLightFloor);
			miLightMode.add(miiLightCeiling);
			menuMode.add(miSoundMode);
			miSoundMode.add(miiSoundFloor);
			miSoundMode.add(miiSoundCeiling);
			menuMode.add(miTextureMode);
			miTextureMode.add(miiTextureFloor);
			miTextureMode.add(miiTextureCeiling);
			
			miVisualMode.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					doMenuItemVisualMode(e);
				}

			});
		}
	}
	private void doMenuItemVisualMode(ActionEvent e) {
		//show visual mode (modeless) dialog
		VisualModeDialog dlg = new VisualModeDialog(this,
				this.model.getMapData().getLevel(getLevelIndex()));
		dlg.setVisible(true);
	}

	private void doMenuItemSaveAs(ActionEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	
	private void doMenuItemSave(ActionEvent e) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	
	private void doMenuItemSelectLevel(ActionEvent e) {
		SelectLevelDialog dlg = new SelectLevelDialog(this, this.model.getMapData().getLevels());
		dlg.setVisible(true);
	}

	private void doMenuItemPreference(ActionEvent e){
		//TODO open Preference setting dialog
		
	}
	/**
	 * Load map file
	 * @param e
	 */
	private void doMenuItemOpen(ActionEvent e){
		String openFilePath = "";
		final JFileChooser fc = new JFileChooser();
		
		Preferences preferences = Preferences.getInstance();
		
		String path = preferences.get(Preferences.MAP_DEFAULT_PATH);
		try{
			if(!path.equals("")){
				fc.setCurrentDirectory(new File(path));
			}
		}catch (Exception e1) {
			System.out.println(e);
			fc.setCurrentDirectory(new File("user.dir"));
		}
		int retVal = fc.showOpenDialog(this);
		if(retVal == JFileChooser.APPROVE_OPTION){
			openFilePath = fc.getSelectedFile().getPath();
		}else if(retVal == JFileChooser.CANCEL_OPTION){
			return;
		}
		
		this.setTitle("Map Viewer (Powered by JUICE) - " + fc.getSelectedFile().getName());
		
		turnProgOn();
		this.progressBarDialog.start(new ProgressLoadThread(model, openFilePath));
		
		
	}
	private void doMenuItemExit(ActionEvent e) {
		System.exit(0);
	}

	public void addChildFrame(JFrame frm) throws Exception {
		this.childFrames.add(frm);
	}

//	public void fillLevelSelector() throws Exception {
//		levelSelect
//	}

	public int getLevelIndex() {
		return this.levelIndex;
	}

//	private int temporaryLevelIndex = 0;
	/*
	 * (non-Javadoc)
	 * @see jp.hpl.gui.IMapViewerFrame#initLoad()
	 */
	public void initLoad() throws Exception {
		//called by thread
		//@see Progress+padThread

		//reset level index
		loadLevel(0);
		menuLevel.setEnabled(true);
		menuMode.setEnabled(true);
//		//setup level menu
//		menuLevel.removeAll();
//		for(int i = 0; i < this.model.getMapData().getNumLevels(); i ++){
//			String name = this.model.getMapData().getLevel(i).getlevelSelectName();
//			JMenuItem item = new JMenuItem(name);
//			temporaryLevelIndex = i;
//			item.addActionListener(new ActionListener(){
//				public void actionPerformed(ActionEvent e){
//					loadLevel(temporaryLevelIndex);
//				}
//			});
//			menuLevel.add(item);
//		}
//	      fillLevelSelector();
//	      loadGametypeCheckboxes();
//	      loadMissionCheckboxes();
//	      loadEnvCheckboxes();
//	      loadLandscape();
	}

	private void loadLevel(int levelIndex2) {
		System.out.println("Get level #" + levelIndex2);
		this.levelIndex = levelIndex2;
		getCanvas().setLevel(model.getMapData().getLevel(levelIndex2));
	}

	public void removeChildFrame(JFrame frm) throws Exception {
		if(childFrames.contains(frm)){
			this.childFrames.remove(frm);
		}
	}

	private void setAllEnable(boolean enable){
		this.setEnabled(enable);
		Iterator it = childFrames.iterator();
		while(it.hasNext()){
			((JFrame)it.next()).setEnabled(enable);
		}
		if(enable){
			setVisible(true);
		}
	}
	public void turnProgOn() {
		this.progressBarDialog.setVisible(true);
		setAllEnable(false);
	}
	public void turnProgOff() {
		this.progressBarDialog.setVisible(false);
		setAllEnable(true);
		
	}

	public MapCanvas getCanvas() {
		return this.canvas;
	}

	protected int getEditMode() {
		return editMode;
	}

	protected void setEditMode(int editMode) {
		this.editMode = editMode;
	}

	public void setCameraCenter(int x, int y) {
		int[] center = {x,y};
		canvas.setCameraPosition(center);
		repaint();
	}

	public ToolbarDialog getToolbarDialog() {
		return toolbarDialog;
	}

//	public MapData getMapData() {
//		return 
//	}
//
//	public void openMapFile(String path) {
//		// TODO 自動生成されたメソッド・スタブ
//		
//	}


}
