#include "MapEditorMainFrame.h"
#include "AnnotationDialog.h"

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
/**
    {^ƂɌĂ΂
*/
void MapEditorMainFrame::OnLeftDown(wxMouseEvent &ev)
{
	wxGetApp().isChanged = true;
    //J[\ݒ
    wxGetApp().setCursor();
    //}EXWL^
    wxGetApp().getViewGridManager()->setNewMousePoint(ev.m_x, ev.m_y);
    bool shift = ev.ShiftDown();
    bool ctrl = ev.ControlDown();

//    int toolType = wxGetApp().getEventManager()->getToolType();

    if(ctrl){
        Refresh();
        return;
    }
    switch(wxGetApp().getEventManager()->getEditModeType()){
    case EditModeType::EM_DRAW:
        doLButtonOnDrawMode(ev);
        break;
    case EditModeType::EM_POLYGON_TYPE:
        doLButtonOnPolygonMode(ev);
        break;
    case EditModeType::EM_FLOOR_HEIGHT:
        doLButtonOnFloorHeightMode(ev);
        break;
    case EditModeType::EM_CEILING_HEIGHT:
        doLButtonOnCeilingHeightMode(ev);
        break;
    case EditModeType::EM_FLOOR_LIGHT:
        doLButtonOnFloorLightMode(ev);
        break;
    case EditModeType::EM_CEILING_LIGHT:
        doLButtonOnCeilingLightMode(ev);
        break;
    case EditModeType::EM_MEDIA:
        doLButtonOnMediaMode(ev);
        break;
    case EditModeType::EM_FLOOR_TEXTURE:
        doLButtonOnFloorTextureMode(ev);
        break;
    case EditModeType::EM_CEILING_TEXTURE:
        doLButtonOnCeilingTextureMode(ev);
        break;
    }
    Refresh();
}
void MapEditorMainFrame::doLButtonOnDrawMode(wxMouseEvent& ev)
{
    int tool = wxGetApp().getEventManager()->getToolType();
    switch(tool){
    case ToolType::TI_ARROW:
        doLButtonOnArrowTool(ev);
        break;
    case ToolType::TI_FILL:
        doLButtonOnFillTool(ev);
        break;
    case ToolType::TI_HAND:
        doLButtonOnHandTool(ev);
        break;
    case ToolType::TI_LINE:
        doLButtonOnLineTool(ev);
        break;
    case ToolType::TI_MAGNIFY:
        doLButtonOnMagnifyTool(ev);
        break;
    case ToolType::TI_SKULL:
        doLButtonOnSkullTool(ev);
        break;
    case ToolType::TI_TEXT:
        doLButtonOnTextTool(ev);
        break;
    case ToolType::TI_POLYGON:
        doLButtonOnPolygonTool(ev);
        break;
    default:
        hpl::error::halt("Invalid tool type");
    }
}

void MapEditorMainFrame::doLButtonOnArrowTool(wxMouseEvent& ev)
{
    //If[^
    hpl::aleph::map::HPLSelectData* sel = &wxGetApp().selectData;
    
    //Obh}l[W[
    hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
    //r[ItZbg
    int voffset[2];
    vmgr->getOffset(voffset);
    int div = vmgr->getZoomDivision();

    int zMin = vmgr->getViewHeightMin();
    int zMax = vmgr->getViewHeightMax();
    int mx = ev.m_x;
    int my = ev.m_y;

	//AhDɒǉĂ܂
//	hpl::aleph::map::HPLDoneHistory* hmgr = wxGetApp().getDoneHistoryManager();
	sel->setMousePosition(mx, my);
	hpl::aleph::HPLEventManager* emgr = wxGetApp().getEventManager();

    if(sel->isSelected()){
        //ɑI

        //}EXWI𕔕Ɋ܂܂邩`FbN
        if(hpl::aleph::map::isPointInSelection(mx, my,
            voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD,
            POINT_DISTANCE_EPSILON, LINE_DISTANCE_EPSILON, OBJECT_DISTANCE_EPSILON,
            sel, zMax, zMin, div))
        {
            //I𕔕NbNĂ
            //ItZbgݒ肷
            //<en> clicked on selection datas
            //-> set offsets
            hpl::aleph::map::setupSelectDataGroupOffsets(mx, my,
                &wxGetApp().selectData, voffset[0], voffset[1],
                OFFSET_X_WORLD, OFFSET_Y_WORLD, div);
			emgr->setGrabItems(true);
        }else{
            //NbNĂȂ
			
			//IĂ邩
			if(this->tryToSelectOneItem(ev)){
				//ЂƂǏ㏈
				//ΏۑI(ς)
				//ItZbgݒ
				//sɒǉ
				this->selectOneThingAfter(mx, my);
			}else{
				//I
				//͈͑IJn
				this->selectNothing(mx, my);
			}
        }
	}else{
		//IĂȂ
		//Ił邩Ă݂܂
		if(this->tryToSelectOneItem(ev)){
			//Iiς݁jEΏۂIiς݁j
			//ItZbgݒ
			//sɒǉ
			this->selectOneThingAfter(mx, my);
		}else{
			//IȂ
			//I
			//͈͑IJn
			this->selectNothing(mx, my);
		}

	}

	//I̍XV
	wxGetApp().getStockManager()->updateSelects(wxGetApp().selectData);
}
/**
	ȂɂIłȂꍇ
*/
void MapEditorMainFrame::selectNothing(int mx, int my)
{
	//͈͑I̊Jn
	wxGetApp().getEventManager()->setSelectGroupStartPoint(mx, my);

	//IҏWACe
	//TODO xȂ\̂ŁACKv
	//(Ƀ_CAÕR{{bNXč\ẑɎԂ)
	this->unselect();

	//I
	wxGetApp().selectData.clear();
}

/**
	the function called when select one thing
	@param mx, my }EXW mouse cursor position
*/
void MapEditorMainFrame::selectOneThingAfter(int mx, int my)
{
	//IĂȂڂɊւ_CAO̐ݒ܂
	this->unselect();
	
	int voffset[2];
	hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
	vmgr->getOffset(voffset);
	int div = vmgr->getZoomDivision();

	//ItZbgݒ
	hpl::aleph::map::setupSelectDataGroupOffsets(mx, my,
		&wxGetApp().selectData, voffset[0], voffset[1],
		OFFSET_X_WORLD, OFFSET_Y_WORLD, div);
	
	hpl::aleph::map::HPLSelectData* sel = &wxGetApp().selectData;
	sel->setMousePosition(mx, my);
	//ނɉă_CAO\
	if(sel->isSelectOneObject()){
        this->objPropDialog.setObjIndex(sel->getSelObjects()->at(0).index);
		this->objPropDialog.Show(true);
	}else{
        this->objPropDialog.setObjIndex(NONE);
	}
	if(sel->isSelectOnePoint()){
	}else{
	}
	if(sel->isSelectOneAnnotation()){
	}else{
	}
	if(sel->isSelectOneLine()){
	}else{
	}
	/*
	if(sel->isSelectOnePolygon()){
        this->polyPropDialog.setPolyIndex(sel->getSelPolygons()->at(0).index,
			wxGetApp().getStockManager());
        this->polyPropDialog.Show(true);
	}else{
        this->polyPropDialog.setPolyIndex(NONE, wxGetApp().getStockManager());
	}*/

	//Ił̂
	//͈͑I͉܂
	hpl::aleph::HPLEventManager *emgr = wxGetApp().getEventManager();
	emgr->exitSelectingGroup();
	emgr->setGrabItems(true);

	//AhD@\̂߂ɋLĂ܂
	wxGetApp().getDoneHistoryManager()->push_back(
		hpl::aleph::map::ActionType::None, wxGetApp().selectData);

	//ŌɑIʒũ}EX|CgL܂
	emgr->setLastMouseSelectPoint(mx, my);
}

void MapEditorMainFrame::unselect()
{
    hpl::aleph::map::HPLSelectData* sel = &wxGetApp().selectData;
    //_IĂȂ̂indexNONEł͂Ȃ
	//***************************
	//̐l͖q̉\̂ŁAisValidȂǂ͎gȂƁI
	//_AASideA|S̓[_Ȃ̂łȂ
	if(!sel->isSelectOneObject() && objPropDialog.getObjIndex() != NONE)
		this->objPropDialog.setObjIndex(NONE);
//	if(!sel->isSelectOneSide() && sidePropDialog.getIndex() != NONE)
//		this->sidePropDialog.setIndex(NONE);
}

/**
    @param ev
    @return Iɐꍇ^
*/
bool MapEditorMainFrame::tryToSelectOneItem(wxMouseEvent& ev)
{
    //VtgL[
    bool shift = ev.ShiftDown();

    hpl::aleph::map::HPLSelectData* sel = &wxGetApp().selectData;
    //Cxg}l[W[
    hpl::aleph::HPLEventManager* emgr = wxGetApp().getEventManager();
    hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();

    //r[ItZbg
    int voffset[2];
    vmgr->getOffset(voffset);
    int div = vmgr->getZoomDivision();

    int zMin = vmgr->getViewHeightMin();
    int zMax = vmgr->getViewHeightMax();
    int mx = ev.m_x;
    int my = ev.m_y;


    //I̗D揇ʂ
    //1:IuWFNg
    //2:_
    //-:Ame[V
    //3:
    //4:|S


    //IuWFNg
    for(int i = 0; i < (int)SavedObjectList.size(); i ++){
        if(wxGetApp().getStockManager()->isDeleteObject(i)){
            continue;
        }
        map_object* obj = &SavedObjectList[i];
        int x = obj->location.x;
        int y = obj->location.y;
        int z = obj->location.z;

        //͈͊Oǂ
        if(z > zMax || z < zMin){
            continue;
        }

        //IuWFNgI
        if(hpl::aleph::map::isSelectPoint(mx, my,
            x, y, voffset[0], voffset[1],
            OFFSET_X_WORLD, OFFSET_Y_WORLD, div, OBJECT_DISTANCE_EPSILON))
        {
		    if(!shift){
				//VtgL[ɃNbNU
				selectOneThingBefore();
			}

            //Iǉ
            int offset[2];

            sel->addSelObject(i, offset);
            return true;
        }
    }

    //////////
    //_
    for(int i = 0; i < (int)EndpointList.size(); i ++){
        if(wxGetApp().getStockManager()->isDeletePoint(i)){
            continue;
        }
        endpoint_data* ep = get_endpoint_data(i);

        //`FbN
        int floor = ep->highest_adjacent_floor_height;
        int ceiling = ep->lowest_adjacent_ceiling_height;
        if(floor > zMax || ceiling < zMin){
            continue;
        }
        if(hpl::aleph::map::isSelectPoint(mx, my,
            ep->vertex.x, ep->vertex.y,
            voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD,
            div, POINT_DISTANCE_EPSILON))
        {
		    if(!shift){
				//VtgL[ɃNbNU
				selectOneThingBefore();
			}
            //
            int offset[2];
            sel->addSelPoint(i, offset);
            return true;
        }
    }

	//////////////////////////////////////
	//Ame[V
	int annotationIndex = hpl::aleph::map::getSelectAnnotationIndex(mx, my,
		POINT_DISTANCE_EPSILON, zMin, zMax,
		voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD, div, 
		wxGetApp().getStockManager());
	if(hpl::aleph::map::isValidIndex(annotationIndex, MapAnnotationList.size())){
	    if(!shift){
			//VtgL[ɃNbNU
			selectOneThingBefore();
		}
		map_annotation* annotation = &MapAnnotationList[annotationIndex];
		//ItZbgݒ
		int offset[2];
		int vpoint[2];
		wxGetApp().getViewPointFromWorldPoint(annotation->location, vpoint);
		offset[0] = vpoint[0] - mx;
		offset[1] = vpoint[1] - my;
		sel->addSelAnnotation(annotationIndex, offset);
		return true;
	}

    /////////////////////////
    //lines
	int lineIndex = hpl::aleph::map::getSelectLineIndex(mx ,my,
		LINE_DISTANCE_EPSILON, zMin, zMax,
		voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD, div, 
		wxGetApp().getStockManager());
	
	if(hpl::aleph::map::isValidIndex(lineIndex, LineList.size())){
	    if(!shift){
			//VtgL[ɃNbNU
			selectOneThingBefore();
		}
		line_data* line = get_line_data(lineIndex);
		endpoint_data* start = get_endpoint_data(line->endpoint_indexes[0]);
		endpoint_data* end = get_endpoint_data(line->endpoint_indexes[1]);

        //I

        int offset[2][2];
        sel->addSelLine(lineIndex, offset);
        return true;
    }

    //|S
    //TODO Ƀ\[g(܂ĂȂ)
	int polyIndex = hpl::aleph::map::getSelectPolygonIndex(mx ,my,
		zMin, zMax,
		voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD, div, 
		wxGetApp().getStockManager());
	if(hpl::aleph::map::isValidIndex(polyIndex, EndpointList.size())){
	    if(!shift){
			//VtgL[ɃNbNU
			selectOneThingBefore();
		}
        polygon_data* poly = get_polygon_data(polyIndex);
#ifdef __WXDEBUG__
		wxASSERT(poly);
#endif
        int n = poly->vertex_count;
        int offset[MAXIMUM_VERTICES_PER_POLYGON][2];
        
        sel->addSelPolygon(polyIndex, offset, n);
        return true;
    }

	//IłȂ

    return false;
}
//Iɐꍇ̑O
void MapEditorMainFrame::selectOneThingBefore()
{
	//I
	wxGetApp().selectData.clear();
}


/////////////////////////////////////////////////////////////
void MapEditorMainFrame::doLButtonOnFillTool(wxMouseEvent& ev)
{
    hpl::aleph::HPLStockManager* smgr = wxGetApp().getStockManager();

    int mx = ev.m_x;
    int my = ev.m_y;
    world_point2d wmp = wxGetApp().getWorldPointFromViewPoint(mx, my);

    hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
    int zMin = vmgr->getViewHeightMin();
    int zMax = vmgr->getViewHeightMax();
    //TODO
    //hԂ\ȃ|Sf[^擾܂
    std::vector<polygon_data> polyDatas = hpl::aleph::map::searchValidPolygon(
        wmp, smgr, zMin, zMax);
    if(polyDatas.size() == 0){
        //s
        hpl::error::caution("No frame to fill as a VALID polygon found (it seems to be a illegal polygon or a none)");
    }else{
        //ǉ
        hpl::aleph::map::addPolygon(polyDatas[0]);
        //XV
        smgr->updateDeletes();
    }
}
void MapEditorMainFrame::doLButtonOnHandTool(wxMouseEvent& ev)
{
    //MouseMotionɊۓ
    
}
void MapEditorMainFrame::doLButtonOnLineTool(wxMouseEvent& ev)
{
    //ǉ
#ifdef MAPVIEWER
#else
    //I
    wxGetApp().selectData.clear();

    hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();

//    int mx = ev.m_x;
//    int my = ev.m_y;
    //EWɂ
    world_point2d wpoint = wxGetApp().getWorldPointFromViewPoint(ev.m_x, ev.m_y);
	wpoint = this->getGridedWorldPoint(wpoint);

    bool isFirst = wxGetApp().isFirstOfLineToAdd;

    hpl::aleph::HPLEventManager* emgr = wxGetApp().getEventManager();
    
    int voffset[2];
    vmgr->getOffset(voffset);
    int div = wxGetApp().getViewGridManager()->getZoomDivision();
    int zMin = vmgr->getViewHeightMin();
    int zMax = vmgr->getViewHeightMax();

    hpl::aleph::HPLStockManager* smgr = wxGetApp().getStockManager();

    //dȂ_邩ǂ`FbN
    int pointIndex = hpl::aleph::map::getSelectPointIndex(
        wpoint, POINT_DISTANCE_EPSILON, zMin, zMax, div, smgr);
    //dȂ邩肷
    int lineIndex = hpl::aleph::map::getSelectLineIndex(
        wpoint, LINE_DISTANCE_EPSILON, zMin, zMax, div, smgr);

    if(hpl::aleph::map::isValidIndex(pointIndex, EndpointList.size()))
    {
        //̓_NbNĂ
        /*
        1:_̏ŃNbN
	        1:ŏ̃NbN
		        ONbN_̍XV
	        2:ڈȍ~̃NbN
		        1:ɐ݂Ă
			        Ȃ
		        2:݂͑ĂȂ
			        ̒ǉ
		        ONbN_̍XV
        */
        if(wxGetApp().isFirstOfLineToAdd){
            //ŏ̃NbN
            //n_Ƃ
            wxGetApp().prevPointIndex = pointIndex;

        }else{
            //2ڈȍ~̃NbN
            //_NbNĂ邩H
            if(wxGetApp().prevPointIndex == pointIndex){
                //n_Ƃ
            }else{
                //ɐ݂Ă邩H
                int lineIndex = hpl::aleph::map::getLineIndexFromTwoLPoints(
                    wxGetApp().prevPointIndex, pointIndex);
                if(hpl::aleph::map::isValidIndex(lineIndex, LineList.size())){
                    //ɐ݂Ă
                    //Ȃ
                }else{
                    //łȂΐ쐬
                    line_data line;
                    hpl::aleph::map::createLine(wxGetApp().prevPointIndex,
                        pointIndex, &line);
                    int newLineIndex = hpl::aleph::map::addLine(line);
                }
                wxGetApp().prevPointIndex = pointIndex;
            }
        }

        //ŏ̃NbNł͂ȂȂ
        wxGetApp().isFirstOfLineToAdd = false;
    }else{
        //𓥂łȂ`FbN܂
        if(hpl::aleph::map::isValidIndex(lineIndex, LineList.size())){
            /*
                2:̏ŃNbN
	                1:ŏ̃NbN
		                1:|Sɏ
			                xoĉȂ
		                2:Ȃ
			                ̐폜
			                _ǉ
			                ̎n_V_I_ƂVǉ
			                V_̏I_I_ƂVǉ
			                ONbN_̍XV
	                2:ڈȍ~̃NbN
		                
            */
            line_data* line = get_line_data(lineIndex);
            assert(line != NULL);

            //|SɏĂ邩m߂܂
            if(hpl::aleph::map::isValidIndex(line->clockwise_polygon_owner, PolygonList.size()) || 
                hpl::aleph::map::isValidIndex(line->counterclockwise_polygon_owner, PolygonList.size()))
            {
                //|Sɑ
                //xoB𕪒f肵Ȃ
                hpl::error::caution("cannot divide line , because line belongs to polygon (line's index:%d, clockwise polygon's index:%d, counterclockwise polygon's index:%d)",
                    lineIndex, line->clockwise_polygon_owner, line->counterclockwise_polygon_owner);
                //Ɨ_ǉ
                endpoint_data ep;
                hpl::aleph::map::createPoint(wpoint, &ep);
                int newPointIndex = hpl::aleph::map::addEndpoint(ep);
            }else{
                //n_AI_̏擾
                //endpoint_data* begin = get_endpoint_data(line->endpoint_indexes[0]);
                //endpoint_data* end = get_endpoint_data(line->endpoint_indexes[1]);
                int epStartIndex = line->endpoint_indexes[0];
                int epEndIndex = line->endpoint_indexes[1];

                //폜
                smgr->deleteLine(lineIndex);
                smgr->updateDeletes();

                //_ǉ
                endpoint_data ep;
                hpl::aleph::map::createPoint(wpoint, &ep);
                int newPointIndex = hpl::aleph::map::addEndpoint(ep);
                endpoint_data *newEp = get_endpoint_data(newPointIndex);

                //n__̐ǉ
                line_data newLine1;
                hpl::aleph::map::createLine(epStartIndex,
                    newPointIndex, &newLine1);
                int newLine1Index = hpl::aleph::map::addLine(newLine1);

                //_I_̐ǉ
                line_data newLine2;
                hpl::aleph::map::createLine(newPointIndex, epEndIndex,
                    &newLine2);
                int newLine2Index = hpl::aleph::map::addLine(newLine2);


                if(wxGetApp().isFirstOfLineToAdd){
                    //ŏȂȂɂȂ
                }else{
                    //O񁨍̓_̊Ԃɐǉ
                    line_data newLine;
                    hpl::aleph::map::createLine(wxGetApp().prevPointIndex, newPointIndex, &newLine);
                    int lineIndex = hpl::aleph::map::addLine(newLine);
                }
                wxGetApp().prevPointIndex = newPointIndex;
            }
            wxGetApp().isFirstOfLineToAdd = false;

        }else{
            //VKǉ
            endpoint_data ep;
            hpl::aleph::map::createPoint(wpoint, &ep);
            int newPointIndex = hpl::aleph::map::addEndpoint(ep);
            if(wxGetApp().isFirstOfLineToAdd){
                //ŏ̓_Ȃ̂ŒǉȂ
            }else{
                //ǉ
                line_data line;
                hpl::aleph::map::createLine(wxGetApp().prevPointIndex, newPointIndex, &line);
                int newLineIndex = hpl::aleph::map::addLine(line);
            }
            
            wxGetApp().isFirstOfLineToAdd = false;
            wxGetApp().prevPointIndex = newPointIndex;
        }
    }

    //XV
    wxGetApp().getStockManager()->updateDeletes();
    
#endif
}
void MapEditorMainFrame::doLButtonOnMagnifyTool(wxMouseEvent& ev)
{
    bool shift = ev.ShiftDown();
    wxCommandEvent dummy;
    if(shift){
        //k
        this->OnZoomOut(dummy);
    }else{
        this->OnZoomIn(dummy);
    }
}
void MapEditorMainFrame::doLButtonOnSkullTool(wxMouseEvent& ev)
{
    //IuWFNgzu
//#ifdef MAPVIEWER
//#else
    int mx = ev.m_x;
    int my = ev.m_y;
    world_point2d wpoint = wxGetApp().getWorldPointFromViewPoint(mx, my);

    hpl::aleph::HPLStockManager* smgr = wxGetApp().getStockManager();

    bool found = false;
    for(int i = 0; i < (int)PolygonList.size(); i ++){
        if(smgr->isDeletePolygon(i)){
            continue;
        }
        polygon_data* poly = get_polygon_data(i);
        if(hpl::aleph::map::isPointInPolygon(wpoint, i)){
            //_܂܂
            //̃|Sɒu
            //TODO
            int flags = 0;

			//_CAOIuWFNg쐬
            map_object objv = this->objPropDialog.getObject();
            objv.polygon_index = i;
			//|Sʒu擾
			objv.location.x = wpoint.x;
			objv.location.y = wpoint.y;
			objv.location.z = poly->floor_height;
			if(objv.flags & _map_object_hanging_from_ceiling){
				//TODO V䂩Ԃ牺ĂꍇAVɍW킹ׂH
			}

            int newIndex = hpl::aleph::map::addMapSavedObject(objv);
			//IuWFNg_CAO{bNXXV܂
			objPropDialog.setObjIndex(newIndex);
			//ĨIuWFNgɕύX܂
			wxGetApp().selectData.clear();
			int offset[2] = {0};
			wxGetApp().selectData.addSelObject(newIndex, offset);
			//TODO Prepare "Add" Undo
            found = true;
            break;
        }
    }
    if(!found){
        hpl::error::caution("You must place objects ON POLYGON");
    }
	this->updateMapItems();
//#endif
}
void MapEditorMainFrame::doLButtonOnTextTool(wxMouseEvent& ev)
{
    int mx = ev.m_x;
    int my = ev.m_y;
    int voffset[2];
    //Obh}l[W[
    hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
    vmgr->getOffset(voffset);
    int div = wxGetApp().getViewGridManager()->getZoomDivision();
    int zMin = vmgr->getViewHeightMin();
    int zMax = vmgr->getViewHeightMax();
#ifdef MAPVIEWER
#else
    //shiftȂ炾ƕҏW[hɂȂ
    if(ev.ShiftDown()){
        int annotationIndex = NONE;
        //Ame[VIł邩Ă݂܂
        for(int i = 0; i < (int)MapAnnotationList.size(); i ++){
            map_annotation* annotation = &MapAnnotationList[i];
            if(hpl::aleph::map::isSelectPoint(mx, my,
                annotation->location.x, annotation->location.y,
                voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD,
                div, POINT_DISTANCE_EPSILON))
            {
                //Io
                annotationIndex = i;
                break;
            }
        }
        if(hpl::aleph::map::isValidIndex(annotationIndex, MapAnnotationList.size())){
            //Ame[VҏW܂
            AnnotationDialog dlg;
            dlg.Create(this, wxID_ANY, MapAnnotationList[annotationIndex]);
            if(dlg.ShowModal() == wxID_OK){
                map_annotation newAn = dlg.getAnnotation();
                //ύX
                MapAnnotationList[annotationIndex] = newAn;
            }
        }

        //Ȃ
        hpl::error::caution("No annotation found there");
    }else{

        //Ame[Vǉ
        //_CAO
        AnnotationDialog dlg;
        map_annotation sample;
        //
        memset(&sample, 0, SIZEOF_map_annotation);

        //}EXẄʒuɒǉ
        int viewX = ev.m_x;
        int viewY = ev.m_y;
        world_point2d wpoint = wxGetApp().getWorldPointFromViewPoint(viewX, viewY);
        sample.location.x = wpoint.x;
        sample.location.y = wpoint.y;
        sample.polygon_index = NONE;

        //_CAO\
        dlg.Create(this, ID_ANNOTATION_DIALOG, sample);
        if(dlg.ShowModal() == wxID_OK){
            //
            //Ame[Vf[^擾
            map_annotation newAnnotation = dlg.getAnnotation();
            //ǉ
            hpl::aleph::map::addAnnotation(newAnnotation);
        }
        //XV
        wxGetApp().getStockManager()->updateDeletes();
    }
#endif
}
void MapEditorMainFrame::doLButtonOnPolygonTool(wxMouseEvent& ev)
{
#ifdef MAPVIEWER
#else
	int mx = ev.m_x;
	int my = ev.m_y;
	//KvȂObhW𓾂
	int vPoint[2];
	this->getGridedViewPoint(mx, my, vPoint);
    //͈͑IJn
    wxGetApp().getEventManager()->setSelectGroupStartPoint(vPoint[0], vPoint[1]);
#endif
}

void MapEditorMainFrame::doLButtonOnPolygonMode(wxMouseEvent& ev)
{
	//c[IE{
	int tool = wxGetApp().getEventManager()->getToolType();
	int mx = ev.m_x;
	int my = ev.m_y;
	int voffset[2];
	hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
	vmgr->getOffset(voffset);
	int div = vmgr->getZoomDivision();
	hpl::aleph::HPLStockManager* smgr = wxGetApp().getStockManager();
	int zMin = vmgr->getViewHeightMin();
	int zMax = vmgr->getViewHeightMax();

	int polyIndex = hpl::aleph::map::getSelectPolygonIndex(mx ,my,
		voffset[0], voffset[1], OFFSET_X_WORLD, OFFSET_Y_WORLD, zMin, zMax, div,
		smgr);
	polygon_data* poly = get_polygon_data(polyIndex);
	if(tool == ToolType::TI_ARROW){
		if(poly){
			//IeXgRg[ɔf
			this->polyTypeDialog.setType(poly->type);
		}
	}
#ifdef MAPVIEWER
#else
	//hԂc[ݑIĂ^CvœhԂ
	if(tool == ToolType::TI_FILL){
		if(poly){
			int polyType = this->polyTypeDialog.getType();
			if(polyType >= 0){
				//^CvύX
				poly->type = polyType;
				Refresh();
			}
		}
	}
#endif
}
void MapEditorMainFrame::doLButtonOnHeightModeCommon(wxMouseEvent& ev, bool isFloor)
{
	hpl::aleph::view::HPLViewGridManager* vmgr = wxGetApp().getViewGridManager();
	hpl::aleph::HPLStockManager* smgr = wxGetApp().getStockManager();
	hpl::aleph::map::HPLSelectData* sel = &wxGetApp().selectData;

	int toolType = wxGetApp().getEventManager()->getToolType();
	
	int zMin = vmgr->getViewHeightMin();
	int zMax = vmgr->getViewHeightMax();
	int div = vmgr->getZoomDivision();
	//int voffset[2];

	//EWɂȂ܂
	int mx = ev.m_x;
	int my = ev.m_y;
	world_point2d wmp = wxGetApp().getWorldPointFromViewPoint(mx, my);
	if(toolType == ToolType::TI_ARROW){

		sel->clear();
		//NbNł|ST܂
		int polyIndex = hpl::aleph::map::getSelectPolygonIndex(wmp.x, wmp.y,
			zMin, zMax, smgr);
		if(polyIndex != NONE){
			//Ił
			//IΏۂƂ
			polygon_data* poly = get_polygon_data(polyIndex);
			wxASSERT(poly);
			int offset[MAXIMUM_VERTICES_PER_POLYGON][2];
			sel->addSelPolygon(polyIndex, offset, poly->vertex_count);
			//_CAOIԂɂ
			int height = poly->ceiling_height;
			if(isFloor){
				height = poly->floor_height;
			}
			this->heightPaletteDialog.setSelection(height);
		}else{
			//IłȂ
			//IĂ̂ŉȂ
			//pbg̑IH
			//c͂Ȃ
		}
		this->updateMapItems();

	}
}

void MapEditorMainFrame::doLButtonOnFloorHeightMode(wxMouseEvent& ev)
{
	doLButtonOnHeightModeCommon(ev, true);
}
void MapEditorMainFrame::doLButtonOnCeilingHeightMode(wxMouseEvent& ev)
{
	doLButtonOnHeightModeCommon(ev, false);
}
void MapEditorMainFrame::doLButtonOnFloorLightMode(wxMouseEvent& ev)
{
}
void MapEditorMainFrame::doLButtonOnCeilingLightMode(wxMouseEvent& ev)
{
}
void MapEditorMainFrame::doLButtonOnMediaMode(wxMouseEvent& ev)
{
}
void MapEditorMainFrame::doLButtonOnFloorTextureMode(wxMouseEvent& ev)
{
}
void MapEditorMainFrame::doLButtonOnCeilingTextureMode(wxMouseEvent& ev)
{
}
