// MapEditorSDI.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "MapEditorSDI.h"
#include "MainFrm.h"

#include "MapEditorSDIDoc.h"
#include "MapEditorSDIView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//logger
HPLLogger logger;

// CMapEditorSDIApp

BEGIN_MESSAGE_MAP(CMapEditorSDIApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CMapEditorSDIApp::OnAppAbout)
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, &CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, &CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, &CWinApp::OnFilePrintSetup)
    ON_COMMAND(ID_FILE_OPEN, &CMapEditorSDIApp::OnFileOpen)
END_MESSAGE_MAP()


// CMapEditorSDIApp RXgNV

void loadInformations(const char* filename, int max, 
                             Information *informations)
{
    const int LENGTH = 1024 * 10;
    char cstr[LENGTH];

    CFile f;
    if(!f.Open(CString(filename), CFile::modeRead)){
        CString errMsg = CString("Couldn't open:");
        errMsg += L"[" + CString(filename) + L"]";
        MessageBox(NULL, errMsg, L"Error", MB_OK);
        exit(-1);
    }
    f.Read(cstr, LENGTH);
    CString str = CString(cstr);
    CStringArray array;
    splitString(str, "\r\n", array);
    for(int i = 0; i < max; i ++){
        informations[i].jname = array.GetAt(i);
    }
    f.Close();
}

/**
    ݒ
*/
bool CMapEditorSDIApp::initialize(){

    //t@CR{pǂݍ
    //
    loadInformations("data/ObjectTypes.txt", NUMBER_OF_OBJECT_TYPES,
        objectTypeInformations);
    //X^[
    loadInformations("data/MonsterTypes.txt", NUMBER_OF_MONSTER_TYPES,
        monsterTypeInformations);
    //IuWF
    loadInformations("data/SceneryTypes.txt", NUMBER_OF_SCENERY_DEFINITIONS,
        sceneryTypeInformations);
    //ACe
    loadInformations("data/DefinedItems.txt", NUMBER_OF_DEFINED_ITEMS,
        itemTypeInformations);
    //sounds
    loadInformations("data/SoundSourceTypes.txt", NUMBER_OF_AMBIENT_SOUND_DEFINITIONS,
        soundSourceInformations);
    //N
    loadInformations("data/ActivateTypes.txt", NUMBER_OF_ACTIVATE_TYPES,
        activateTypeInformations);
    //tO
    objectFlagInformations[0].bind = _map_object_is_invisible;
    objectFlagInformations[1].bind = _map_object_hanging_from_ceiling;
    objectFlagInformations[2].bind = _map_object_is_blind;
    objectFlagInformations[3].bind = _map_object_is_deaf;
    objectFlagInformations[4].bind = _map_object_floats;
    objectFlagInformations[5].bind = _map_object_is_network_only;

    //termnal groups
    loadInformations("data/TerminalGroupTypes.txt", NUMBER_OF_GROUP_TYPES,
        terminalGroupTypeInformations);

    //polygon type
    loadInformations("data/PolygonType.txt", NUMBER_OF_POLYGON_TYPE,
        polygonTypeInformations);

    //environments
    loadInformations("data/Environments.txt", NUMBER_OF_ENVIRONMENTS,
        environmentInformations);
    //landscape
    loadInformations("data/Landscapes.txt", NUMBER_OF_LANDSPACES,
        landscapeInformations);
    //game type(bind)
    //(same order)
    //env type(bind)
    environmentTypeInformations[0].bind = _environment_normal;
    environmentTypeInformations[1].bind = _environment_vacuum;
    environmentTypeInformations[2].bind = _environment_magnetic;
    environmentTypeInformations[3].bind = _environment_rebellion;
    environmentTypeInformations[4].bind = _environment_low_gravity;
    environmentTypeInformations[5].bind = _environment_network;
    environmentTypeInformations[6].bind = _environment_single_player;
    //mission type(bind)
    missionTypeInformations[0].bind = _mission_none;
    missionTypeInformations[1].bind = _mission_extermination;
    missionTypeInformations[2].bind = _mission_exploration;
    missionTypeInformations[3].bind = _mission_retrieval;
    missionTypeInformations[4].bind = _mission_repair;
    missionTypeInformations[5].bind = _mission_rescue;
    
    //ambient sounds
    //landscape
    loadInformations("data/AmbientSoundTypes.txt", NUMBER_OF_AMBIENT_SOUND_DEFINITIONS,
        ambientSoundTypeInformations);
    //random sounds
    loadInformations("data/RandomSoundTypes.txt", NUMBER_OF_RANDOM_SOUND_DEFINITIONS,
        randomSoundTypeInformations);

    //Fݒ
    //t@Cǂݍ
    if(!loadColorSetting()){
        return false;
    }




    objectPropertyDialog = NULL;
    {
//        isPressLButtonWithCtrl = false;

    }



    AfxInitRichEdit();

    //I֌W
    this->selectDatas.clear();


    viewHeightMin = - SHRT_MAX;
    viewHeightMax = -viewHeightMin;
    isRevealHiddenLines = false;

    //no changes found(new)
    isChanged = false;

    //Ot@C
    logger = HPLLogger(LOG_FILE_NAME);
    if(!logger.open()){
        MessageBox(NULL, L"Cannot open log file for writing. Close it!", L"Error", 
            MB_OK | MB_ICONEXCLAMATION);
        return false;
    }

    //ACRprbg}bvJĕێ
    loadIconBitmaps();

    //menu name to id
    menuIDMap[EditModeType::EM_DRAW] = ID_32795;
    menuIDMap[EditModeType::EM_VISUAL] = ID_32796;

    isNowOnThePoint = false;

	//vC[񏉊{AP[g
    allocate_player_memory();

	//|S̍XV
	//this->polygonValidity;
	
    //int id = new_player(0, 0, 0);
    return true;
}

/**
    Cxg}l[W[擾
*/
mapeditorone::EventManager* CMapEditorSDIApp::getEventManager()
{
    return &this->eventManager;
}

//ACR摜ǂݍ
void CMapEditorSDIApp::loadIconBitmaps()
{
    char cstr[260];
    //load image file name list from file
    //bitmapList.resize();
    const int NUMBER_OF_MAP_ICON_FILES = NUMBER_OF_DEFINED_ITEMS +
        NUMBER_OF_MAP_ICONS;
    Information mapIconFileNameInformations[NUMBER_OF_MAP_ICON_FILES];

    sprintf(cstr, "%s%s", DATA_DIR_NAME, MAP_ICONS_IMAGE_NAME_LIST_FILE_NAME);
    loadInformations(cstr, NUMBER_OF_MAP_ICON_FILES, mapIconFileNameInformations);

    for(int i = 0; i < 2 * NUMBER_OF_DEFINED_ITEMS + 2 * NUMBER_OF_MAP_ICONS; i ++){
        string path = string(DATA_DIR_NAME) +
            string(MAP_ICONS_DIR_NAME);
        const int SELECTED_OFFSET = NUMBER_OF_DEFINED_ITEMS + NUMBER_OF_MAP_ICONS;
        if( i >= SELECTED_OFFSET){
            path += string(HILIGHTED_ICONS_DIR_NAME);
        }
        int index = i;

        //selected
        if(i >= SELECTED_OFFSET){
            index -= SELECTED_OFFSET;
        }
        strToChar(mapIconFileNameInformations[index].jname, cstr);
        path += string(cstr);
        //strToChar(path, cstr);
        HBITMAP bitmap = loadBitmapFromFile(path.c_str());
        bitmapList.push_back(bitmap);
    }

}

//ObhZbgAbv
void CMapEditorSDIApp::setupGridManager(hpl::aleph::view::HPLViewGridManager* mgr,
                                        mapeditorone::MapEditorOneInnerSetting* innerSetting)
{
    //1WU 1/2WU 1/4WU 1/8 WU
    int intervals[]={
        WORLD_ONE * 2, WORLD_ONE, WORLD_ONE / 2, WORLD_ONE / 4, WORLD_ONE / 8
    };
    for(int i = 0; i < NUMBER_OF_GLID; i ++){
        gridIntervals[i] = intervals[i];
    }

    hpl::aleph::view::ZoomProperties zoomProp;
    zoomProp.zoomDivisionStep = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIVISION_STEP);
    zoomProp.zoomDivisionDefault = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIVISION_DEFAULT);
    zoomProp.zoomDivisionMin = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIVISION_MIN);
    zoomProp.zoomDivisionMax = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIVISION_MAX);
    zoomProp.zoomDivStepThreshold = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIV_STEP_THRESHOLD);
    zoomProp.zoomDivisionStepDetail = innerSetting->getInt(mapeditorone::TagType::ZOOM_DIVISION_STEP_DETAIL);
    for(int i = 0; i < NUMBER_OF_GLID; i ++){
        zoomProp.gridIntervals[i] = intervals[i];
    }
    mgr->setProp(&zoomProp);
}

//J[ݒǂݍ
bool CMapEditorSDIApp::loadColorSetting()
{
    ifstream is;
    const char* filename = POLYGON_COLOR_FILE_NAME;
    is.open(filename);

    if(!is.is_open()){
        CString errMsg = CString("Couldn't open color datas of polygon type:");
        errMsg += L"[" + CString(filename) + L"]";
        MessageBox(NULL, errMsg, L"Error", MB_OK);
        return false;
    }
    char cstr[260];
    int count = 0;
    while(is.getline(cstr, sizeof(cstr))){
        string line = string(cstr);
        if(line.compare("") == 0){
            continue;
        }
        vector<string> sp = hpl::string::Split(line, ",");
        int col[3];
        for(int i = 0; i < 3; i ++){
            col[i] = atoi(sp[i].c_str());
        }
        this->polygonTypeColor[count] = RGB(col[0], col[1], col[2]);
        count ++;
    }
    is.close();
    return true;
}

/********************************************
*/
CMapEditorSDIApp::CMapEditorSDIApp()
{
    //try to load ini file
    /*CString path = GetModulePathFileName(CString(INI_FILE_NAME));
    char pname[_MAX_PATH];
    strToChar(path, pname);*/
    WCHAR buf[1024];
    WCHAR wstr[256];
    charToWChar(INI_FILE_NAME, wstr);
    GetFullPathName(wstr, sizeof(wstr), buf, NULL);
    char pname[_MAX_PATH];
    wcharToChar(buf, pname); 
    setting.setIniFileName(pname);
    if(!setting.loadSetting()){
        AfxMessageBox(L"no setting file. I'll make default one");
        setting.setSettingToDefault();
    }
    m_SDLToWindows = NULL;

    //pݒ肳
    char* tagNameFilePath = "data/InnerSettingTagList.ini";
    char* innerDataFilePath = "data/InnerSetting.ini";
    //ݒǂݍ
    mapeditorone::MapEditorOneInnerSetting innerSetting = 
        mapeditorone::MapEditorOneInnerSetting(tagNameFilePath, innerDataFilePath);
    //g֘A̐ݒ
    this->setupGridManager(&this->gridManager, &innerSetting);

}

CMapEditorSDIApp::~CMapEditorSDIApp()
{
    if(!setting.saveSetting()){
        AfxMessageBox(CString("fail to save setting:") + setting.getFilePath());
    }
    //if(m_SDLToWindows)delete m_SDLToWindows;
    shutdown_shape_handler();
    exit_screen();
    for(int i = 0; i < (int)bitmapList.size(); i ++){
        DeleteObject(bitmapList[i]);
    }
    bitmapList.clear();
    logger.close();
    for(int i = 0; i < (int)textureBitmaps.size(); i ++){
        for(int j = 0; j < (int)textureBitmaps[0].size(); j ++){
            textureBitmaps[i][j]->DeleteObject();
        }
    }
    textureBitmaps.clear();
}

// B CMapEditorSDIApp IuWFNgłB

CMapEditorSDIApp theApp;


// CMapEditorSDIApp 

BOOL CMapEditorSDIApp::InitInstance()
{
//TODO: call AfxInitRichEdit2() to initialize richedit2 library.
	// AvP[V }jtFXg visual X^CLɂ邽߂ɁA
	// ComCtl32.dll Version 6 ȍ~̎gpw肷ꍇ́A
	// Windows XP  InitCommonControlsEx() KvłBȂ΁AEBhE쐬ׂ͂Ďs܂B
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// AvP[VŎgp邷ׂẴR Rg[ NX܂߂ɂ́A
	// ݒ肵܂B
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

    if(!initialize()){
        return FALSE;
    }

	// OLE Cu܂B
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	// W
	// ̋@\g킸ɍŏIIȎs\t@C
	// TCYkꍇ́Aȉsvȏ
	// [`폜ĂB
	// ݒ肪i[Ă郌WXg L[ύX܂B
	// TODO: Ж܂͑gDȂǂ̓K؂ȕ
	// ̕ύXĂB
	SetRegistryKey(_T("MapViewerOne"));
	LoadStdProfileSettings(4);  // W INI t@C̃IvV[h܂ (MRU ܂)
	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	//  ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CMapEditorSDIDoc),
		RUNTIME_CLASS(CMainFrame),       // C SDI t[ EBhE
		RUNTIME_CLASS(CMapEditorSDIView));
	if (!pDocTemplate)
		return FALSE;
	AddDocTemplate(pDocTemplate);


	// DDE Execute open gp\ɂ܂B
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// DDEAfile open ȂǕW̃VF R}h̃R}h C͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);


	// R}h CŎw肳ꂽfBXpb` R}hłBAvP[V
	// /RegServerA/RegisterA/Unregserver ܂ /Unregister ŋNꂽꍇAFalse Ԃ܂B
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// C EBhEꂽ̂ŁA\ƍXVs܂B
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();
	// ڔ݂ꍇɂ̂ DragAcceptFiles ĂяoĂB
	//  SDI AvP[Vł́AProcessShellCommand ̒ɂ̌ĂяoȂ΂Ȃ܂B
	// hbO/hbv I[v܂B
	m_pMainWnd->DragAcceptFiles();

	return TRUE;
}



// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CMapEditorSDIApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CMapEditorSDIApp bZ[W nh

static void loadMap(const char* filename)
{
}

void CMapEditorSDIApp::OnFileOpen()
{
    
    // TODO: ɃR}h nh R[hǉ܂B
    //J_CAO
}


void loadIcon(int id, CImageList* imageList){
    HICON icon;
    icon = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(id));
    imageList->Add(icon);
}
/*void loadBitmap(int id, CImageList* imageList, COLORREF key)
{
    CBitmap image;
    image.LoadBitmap(id);
    imageList->Add(&image, key);
    image.DeleteObject();
}*/
//set object property to default
void setObjectPropertyToDefault()
{
    memset(&theApp.objectPropertyDialog->store, 0, sizeof(map_object));
    theApp.objectPropertyDialog->setupDialogByStore();
}


//TODO
void setCursor()
{
    //
    int cursors[] = {
        (IDC_CURSOR_ARROW),
        (IDC_CURSOR_FILL),
        (IDC_CURSOR_HAND),
        (IDC_CURSOR_LINE),//line
        (IDC_CURSOR_MAGNIFY),//magnify
        (IDC_CURSOR_SKULL),//skull
        (IDC_CURSOR_TEXT),//ibeam
        (IDC_CURSOR_POLYGON)    //polygon
    };
    int toolType = theApp.getEventManager()->getToolType();
    int cursorId = cursors[toolType];
    if(toolType == ToolType::TI_LINE && theApp.isNowOnThePoint){
        cursorId = IDC_CURSOR_POINT;
    }
    //J[\ω
    HCURSOR cursor = LoadCursor(AfxGetInstanceHandle(),
        //MAKEINTRESOURCE(cursor[));
        MAKEINTRESOURCE(cursorId));
    SetCursor(cursor);
    //SetClassLong(AfxGetMainWnd()->m_hWnd, GCL_HCURSOR, NULL);
    //SetCursor(cursor);
    ShowCursor(TRUE);
}



/**
    add objet on polygon
*/
int addObject(struct world_point2d &world_point, int polygonIndex)
{
    //IuWFNg
    map_object obj;
    memcpy(&obj, &theApp.objectPropertyDialog->store, sizeof(map_object));
    obj.polygon_index = polygonIndex;
    obj.location.x = world_point.x;
    obj.location.y = world_point.y;
    //calc height(delta)
    /*if(obj.flags & _map_object_hanging_from_ceiling){
        obj.location.z = polygon->ceiling_height;
    }else{
        obj.location.z = polygon->floor_height;
    }*/
    //ǉ
    SavedObjectList.push_back(obj);
    int objectIndex = (int)SavedObjectList.size() - 1;
    //add
    hpl::aleph::map::addInitialPlacementNum(obj.type, obj.index, 1);
    theApp.objectPropertyDialog->setupDialog(objectIndex);

    //check polygon's first object
    int firstObjectIndex = PolygonList[polygonIndex].first_object;
    if(firstObjectIndex == NONE){
        //set
        PolygonList[polygonIndex].first_object = objectIndex;
    }
    //Eݒ
    dynamic_world->initial_objects_count = (int)SavedObjectList.size();
    return objectIndex;
}
/**
    get platform_data by using polygon index
    only platform has polygon index. not polygon have
*/
int searchPlatformIndexByPolygonIndex(int index)
{
    for(int i = 0; i < (int)PlatformList.size(); i ++){
        if(PlatformList[i].polygon_index == index){
            return i;
        }
    }
    return NONE;
}

//load bitmap from file
HBITMAP loadBitmapFromFile(const char *pathName)
{
    /*CBitmap *bitmap = new CBitmap;
    if(!bitmap){
        AfxMessageBox(L"Memory over run");
        exit(1);
    }*/
    HBITMAP handleBitmap = (HBITMAP)LoadImage(
        AfxGetInstanceHandle(), CString(pathName),
        IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
    if(handleBitmap == NULL){
        AfxMessageBox(CString("Couldn't load [") + CString(pathName) + CString("]"));
        exit(1);
    }/*
    memcpy(bitmap, CBitmap::FromHandle(handleBitmap), sizeof(CBitmap));
    //DeleteObject(handleBitmap);
    return bitmap;
    */
    return handleBitmap;
}

/**
    add point on polygon
    if it is on line, add point to the line and polygon
    @return added or already existed point's index
        NONE : fail to add
*/
int addPoint(struct world_point2d &world_point)
{
    endpoint_data newPoint;
    newPoint.vertex.x = world_point.x;
    newPoint.vertex.y = world_point.y;
    newPoint.flags = POINT_FLAG_SOLID;

    bool isFound = false;

    //_𓥂łȂmF
    int endpointIndex = NONE;
    for(int i = 0; i < (int)EndpointList.size(); i ++){
        endpoint_data *point = &EndpointList[i];
        //check height
        if( point->highest_adjacent_floor_height > theApp.viewHeightMax ||
            point->lowest_adjacent_ceiling_height < theApp.viewHeightMin)
        {
            continue;
        }
        if(hpl::aleph::map::isSelectPoint(world_point, point->vertex,
            POINT_DISTANCE_EPSILON * theApp.gridManager.getZoomDivision()))
        {
            //ǉȂ
            isFound = true;
            endpointIndex = i;
            break;
        }
    }
    
    if(isFound){
        return endpointIndex;
    }

    //𓥂łȂmF
    int lineIndex = NONE;
    for(int i = 0; i < (int)LineList.size(); i ++){
        line_data *line = &LineList[i];
        //check height
        if(line->highest_adjacent_floor > theApp.viewHeightMax ||
            line->lowest_adjacent_ceiling < theApp.viewHeightMin)
        {
            //not add on the outter height line
            continue;
        }
        endpoint_data *begin = &EndpointList[line->endpoint_indexes[0]];
        endpoint_data *end = &EndpointList[line->endpoint_indexes[1]];
        if(hpl::aleph::map::isSelectLine(world_point, begin->vertex, end->vertex,
            LINE_DISTANCE_EPSILON * theApp.gridManager.getZoomDivision()))
        {
            isFound = true;
            lineIndex = i;
            break;
        }
    }

    if(isFound){
        line_data* line = get_line_data(lineIndex);
//        int polygonIndex = getPolygonIndexFromLineIndex(lineIndex);
        if(line->clockwise_polygon_owner != NONE ||
            line->counterclockwise_polygon_owner != NONE){
            // there is already a polygon! delete it before add point!
            MessageBeep(MB_OK);
            AfxMessageBox(L"Couldn't add point because there is already a polygon. Delete it before add point");
            return NONE;
        }else{
            //add point on the line (if it is included)

            //old line
            line_data* oldLine = &LineList[lineIndex];

            //add point
            newPoint.highest_adjacent_floor_height = oldLine->highest_adjacent_floor;
            newPoint.lowest_adjacent_ceiling_height = oldLine->lowest_adjacent_ceiling;
            newPoint.supporting_polygon_index = NONE;
            //TODO newPoint.transformed = ;??
            EndpointList.push_back(newPoint);
            int newPointIndex = (int)EndpointList.size() - 1;

            //set oldLine's end to newPoint
            int oldLineEndPointIndex = oldLine->endpoint_indexes[1];
            oldLine->endpoint_indexes[1] = newPointIndex;
            double dx = EndpointList[oldLine->endpoint_indexes[0]].vertex.x - EndpointList[oldLine->endpoint_indexes[1]].vertex.x;
            double dy = EndpointList[oldLine->endpoint_indexes[0]].vertex.y - EndpointList[oldLine->endpoint_indexes[1]].vertex.y;
            oldLine->length = (world_distance)sqrt(dx * dx + dy * dy);

            //add new line
            int newLineIndex = addLine(newPointIndex, oldLineEndPointIndex);

            return newPointIndex;
        }
        
    }

    //add point in space
    {
        newPoint.highest_adjacent_floor_height = theApp.viewHeightMin;
        newPoint.lowest_adjacent_ceiling_height = theApp.viewHeightMax;
        newPoint.supporting_polygon_index = NONE;
        EndpointList.push_back(newPoint);
        int newPointIndex = (int)EndpointList.size() - 1;
        return newPointIndex;
    }
}

int addLine(int beginPointIndex, int endPointIndex)
{
    line_data newLine;
    memset(&newLine, 0, sizeof(line_data));
    newLine.endpoint_indexes[0] = beginPointIndex;
    newLine.endpoint_indexes[1] = endPointIndex;
    newLine.clockwise_polygon_owner = NONE;
    newLine.clockwise_polygon_side_index = NONE;
    newLine.counterclockwise_polygon_owner = NONE;
    newLine.counterclockwise_polygon_side_index = NONE;
    newLine.flags = SOLID_LINE_BIT;
    newLine.highest_adjacent_floor = max(EndpointList[beginPointIndex].highest_adjacent_floor_height,
        EndpointList[endPointIndex].highest_adjacent_floor_height);
    newLine.lowest_adjacent_ceiling = min(EndpointList[beginPointIndex].lowest_adjacent_ceiling_height,
        EndpointList[endPointIndex].lowest_adjacent_ceiling_height);
    double dx = EndpointList[newLine.endpoint_indexes[0]].vertex.x - EndpointList[newLine.endpoint_indexes[1]].vertex.x;
    double dy = EndpointList[newLine.endpoint_indexes[0]].vertex.y - EndpointList[newLine.endpoint_indexes[1]].vertex.y;
    newLine.length = (world_distance)sqrt(dx * dx + dy * dy);
	int newLineIndex = hpl::aleph::map::addLine(newLine);
    return newLineIndex;
}

/**
    get line index from point of edge.
    @return index of point
        NONE : not found
*/
int getLineIndexFromPointIndex(int pointIndex)
{
    AfxMessageBox(L"not yet");
    exit(1);
}
/*
int getPolygonIndexFromLineIndex(int lineIndex)
{
    for(int i = 0; i < (int)PolygonList.size(); i ++){
        polygon_data *polygon = &PolygonList[i];

        int vertexCount = polygon->vertex_count;
        for(int j = 0; j < vertexCount - 1; j ++){
            if(polygon->line_indexes[j] == lineIndex){
                return i;
            }
        }
    }
    return NONE;
}

int getPolygonIndexFromPointIndex(int pointIndex)
{
    AfxMessageBox(L"not yet");
    exit(1);
}
*/
CString GetModulePathFileName(CString pName)
{
	//exet@C̃tpX擾
	TCHAR path[_MAX_PATH];
	::GetModuleFileName(NULL,path,sizeof path);

	//exet@C̃pX𕪉
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];
	_splitpath((const char*)path,(char*)drive,(char*)dir,(char*)fname,(char*)ext);

	//̃t@Cexet@C̃pXŃtpX
    char pname[_MAX_FNAME];
    strToChar(pName, pname);
	_makepath((char*)path,(const char*)drive,(const char*)dir,(const char*)pname,"");

	CString str(path);
	return str;
}

void addPolygon(polygon_data* data)
{
    PolygonList.push_back(*data);
}

//|Sǂ܂iŁj
bool CMapEditorSDIApp::isPolygonValidityStored(int polyIndex)
{
	if(polyIndex < 0){
		return false;
	}else if(polyIndex >= (int)this->polygonValidity.size()){
		//݂Ȃ
		//XV
		updatePolygonValidityStored();
		if(polyIndex >= (int)this->polygonValidity.size()){
			//
			return false;
		}
	}

	return this->polygonValidity[polyIndex];
}
//|S̐XV܂
void CMapEditorSDIApp::updatePolygonValidityStored()
{
	polygonValidity.clear();
	for(int i = 0; i < (int)PolygonList.size(); i ++){
		bool isValid = hpl::aleph::map::isValidPolygon(i);
		this->polygonValidity.push_back(isValid);
	}
}
