/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.SidsFlagsFrame;
import src.gui.SidsPropertiesFrame;
import src.gui.SidsTableModel;

public class SidsFrame
extends JFrame {
    private String[] columnNames = new String[]{"Index", "Type", "Line Index"};
    private Model model;
    private int levelIndex;
    private JTable table;
    private JScrollPane scroller;
    private SidsTableModel tableModel;
    private int clickCount;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();

    public SidsFrame(Model model, int levelIndex) {
        try {
            this.model = model;
            this.levelIndex = levelIndex;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new SidsTableModel(this.columnNames, this.model, this.levelIndex);
        this.tableModel.addTableModelListener(new SidsTableModelListener());
        this.table = new JTable(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn typeCol = this.table.getColumnModel().getColumn(1);
        JComboBox<String> cmbType = new JComboBox<String>();
        cmbType.addItem("Full");
        cmbType.addItem("High");
        cmbType.addItem("Low");
        cmbType.addItem("Composite");
        cmbType.addItem("Split");
        typeCol.setCellEditor(new DefaultCellEditor(cmbType));
        this.scroller = new JScrollPane(this.table);
        TableColumn lineIndexCol = this.table.getColumnModel().getColumn(2);
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent m) {
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseReleased(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
            }

            public void mouseClicked(MouseEvent m) {
                Point mousePoint = new Point(m.getX(), m.getY());
                int header = SidsFrame.this.table.getTableHeader().columnAtPoint(mousePoint);
                SidsFrame sidsFrame = SidsFrame.this;
                sidsFrame.clickCount = sidsFrame.clickCount + 1;
                boolean reverseOrder = false;
                if (SidsFrame.this.clickCount % 2 == 0) {
                    reverseOrder = true;
                }
                SidsFrame.this.tableModel.sort(header, reverseOrder);
            }
        });
        this.getContentPane().add(this.scroller);
        this.addWindowListener(new WindowListener(){

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                SidsFrame.this.closeTable();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        lineIndexCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextArea text = new JTextArea();
                text.setBackground(Color.LIGHT_GRAY);
                try {
                    text.setText(Integer.toString((Integer)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return text;
            }
        });
        this.clickCount = 0;
        this.jMenu1.setText("Commands");
        this.jMenuItem1.setText("Properties (ctrl-p)");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SidsFrame.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.jMenuItem2.setText("Flags (ctrl-f)");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SidsFrame.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem2);
        this.setJMenuBar(this.jMenuBar1);
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 80 && e.isControlDown()) {
                    try {
                        SidsPropertiesFrame s = new SidsPropertiesFrame(SidsFrame.this.model, SidsFrame.this.levelIndex, SidsFrame.this.tableModel.getData()[SidsFrame.this.table.getSelectedRow()]);
                        SidsFrame.this.model.addChildFrame(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && e.isControlDown()) {
                    try {
                        SidsFlagsFrame s = new SidsFlagsFrame(SidsFrame.this.model, SidsFrame.this.levelIndex, SidsFrame.this.tableModel.getData()[SidsFrame.this.table.getSelectedRow()]);
                        SidsFrame.this.model.addChildFrame(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.setSize(600, 500);
        this.setTitle("Sides - " + this.model.getLevelSelectName());
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    private void closeTable() {
        this.model.removeChildFrame(this);
    }

    public void jMenuItem1_actionPerformed(ActionEvent e) {
        try {
            SidsPropertiesFrame s = new SidsPropertiesFrame(this.model, this.levelIndex, this.tableModel.getData()[this.table.getSelectedRow()]);
            this.model.addChildFrame(s);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void jMenuItem2_actionPerformed(ActionEvent e) {
        try {
            SidsFlagsFrame s = new SidsFlagsFrame(this.model, this.levelIndex, this.tableModel.getData()[this.table.getSelectedRow()]);
            this.model.addChildFrame(s);
        }
        catch (Exception ex) {
            return;
        }
    }

    class SidsTableModelListener
    implements TableModelListener {
        SidsTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int column = evt.getColumn();
                int row = evt.getFirstRow();
                try {
                    SidsFrame.this.table.setRowSelectionInterval(row, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

