/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import javax.swing.table.AbstractTableModel;
import src.backend.PlacEntry;
import src.backend.StaticFunctions;
import src.gui.Model;

public class PlacTableModel
extends AbstractTableModel {
    public static final int PLAC_ITEM = 0;
    public static final int PLAC_INITIAL = 1;
    public static final int PLAC_MIN = 2;
    public static final int PLAC_MAX = 3;
    public static final int PLAC_RANDOM = 4;
    public static final int PLAC_RANDOM_NUM = 5;
    public static final int PLAC_INF_AVAIL = 6;
    public static final int PLAC_RAND_APPEAR = 7;
    public static final int INF_AMOUNT = 65535;
    private String[] colNames;
    private PlacEntry[] data;
    private String[] itemName;
    private Model model;

    public PlacTableModel(String[] colNames, Model model, int levelIndex, int numItems, int startIndex, int endIndex) {
        this.colNames = colNames;
        this.model = model;
        this.data = new PlacEntry[numItems];
        this.itemName = new String[numItems];
        int position = 0;
        int i = startIndex;
        while (i < endIndex) {
            this.itemName[position] = StaticFunctions.getPlacName(i);
            this.data[position++] = this.model.getPlacItem(levelIndex, i);
            ++i;
        }
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                try {
                    return this.itemName[row];
                }
                catch (Exception e) {
                    return "";
                }
            }
            case 1: {
                try {
                    return new Integer(this.data[row].getInitial());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 2: {
                try {
                    return new Integer(this.data[row].getMinimum());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 3: {
                try {
                    return new Integer(this.data[row].getMaximum());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 4: {
                try {
                    if (this.data[row].getFlags() == 1) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
                catch (Exception e) {
                    return new Boolean(false);
                }
            }
            case 5: {
                try {
                    if (this.data[row].getRandomCount() == 65535) {
                        return "Infinite";
                    }
                    return new Integer(this.data[row].getRandomCount());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 6: {
                try {
                    if (this.data[row].getRandomCount() == 65535) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
                catch (Exception e) {
                    return new Boolean(false);
                }
            }
            case 7: {
                try {
                    return new Integer(this.data[row].getRandomChancePercent());
                }
                catch (Exception e) {
                    return "0";
                }
            }
        }
        return new Object();
    }

    public void setValueAt(Object value, int row, int column) {
        int intValue = 0;
        boolean boolValue = false;
        try {
            intValue = Integer.parseInt((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolValue = (Boolean)value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            switch (column) {
                case 1: {
                    if (intValue > 256) {
                        this.data[row].setInitial((short)256);
                        break;
                    }
                    if (intValue < 0) {
                        this.data[row].setInitial((short)0);
                        break;
                    }
                    this.data[row].setInitial((short)intValue);
                    break;
                }
                case 2: {
                    if (intValue > 256) {
                        this.data[row].setMinimum((short)256);
                        break;
                    }
                    if (intValue < 0) {
                        this.data[row].setMinimum((short)0);
                        break;
                    }
                    this.data[row].setMinimum((short)intValue);
                    break;
                }
                case 3: {
                    if (intValue > 256) {
                        this.data[row].setMaximum((short)256);
                        break;
                    }
                    if (intValue < 0) {
                        this.data[row].setMaximum((short)0);
                        break;
                    }
                    this.data[row].setMaximum((short)intValue);
                    break;
                }
                case 4: {
                    if (boolValue) {
                        this.data[row].setFlags((short)1);
                        break;
                    }
                    this.data[row].setFlags((short)0);
                    break;
                }
                case 5: {
                    if (intValue >= 65535) {
                        this.setValueAt(new Boolean(true), row, column + 1);
                        this.data[row].setRandomCount(65535);
                    } else if (intValue < 0) {
                        this.setValueAt(new Boolean(false), row, column + 1);
                        this.data[row].setRandomCount(0);
                    } else {
                        this.setValueAt(new Boolean(false), row, column + 1);
                        this.data[row].setRandomCount(intValue);
                    }
                    this.fireTableCellUpdated(row, column + 1);
                    break;
                }
                case 6: {
                    if (!boolValue) {
                        this.data[row].setRandomCount(0);
                    } else {
                        this.data[row].setRandomCount(65535);
                    }
                    this.fireTableCellUpdated(row, column - 1);
                    break;
                }
                case 7: {
                    if (intValue > 100) {
                        this.data[row].setRandomChancePercent(100);
                        break;
                    }
                    if (intValue < 0) {
                        this.data[row].setRandomChancePercent(0);
                        break;
                    }
                    this.data[row].setRandomChancePercent((short)intValue);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableCellUpdated(row, column);
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public PlacEntry[] getData() {
        return this.data;
    }

    public void setData(PlacEntry[] data) {
        try {
            this.data = data;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sort(int header, boolean reverse) {
        try {
            switch (header) {
                case 0: {
                    this.sortBy(reverse, "item");
                    break;
                }
                case 1: {
                    this.sortBy(reverse, "initial");
                    break;
                }
                case 2: {
                    this.sortBy(reverse, "min");
                    break;
                }
                case 3: {
                    this.sortBy(reverse, "max");
                    break;
                }
                case 5: {
                    this.sortBy(reverse, "random num");
                    break;
                }
                case 7: {
                    this.sortBy(reverse, "random appear");
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sortBy(boolean reverse, String type) {
        this.mergeSort(0, this.itemName.length, reverse, type);
    }

    private void mergeSort(int first, int n, boolean reverse, String type) {
        if (n > 1) {
            int n1 = n / 2;
            int n2 = n - n1;
            this.mergeSort(first, n1, reverse, type);
            this.mergeSort(first + n1, n2, reverse, type);
            this.merge(first, n1, n2, reverse, type);
        }
    }

    private void merge(int first, int n1, int n2, boolean reverse, String type) {
        PlacEntry[] tempEntry = new PlacEntry[n1 + n2];
        String[] tempStr = new String[n1 + n2];
        int copied = 0;
        int copied1 = 0;
        int copied2 = 0;
        while (copied1 < n1 && copied2 < n2) {
            if (this.compare(reverse, type, first, copied1, copied2, n1)) {
                tempStr[copied++] = this.itemName[first + copied1++];
                tempEntry[copied - 1] = this.data[first + copied1 - 1];
                continue;
            }
            tempStr[copied++] = this.itemName[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        while (copied1 < n1) {
            tempStr[copied++] = this.itemName[first + copied1++];
            tempEntry[copied - 1] = this.data[first + copied1 - 1];
        }
        while (copied2 < n2) {
            tempStr[copied++] = this.itemName[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        int i = 0;
        while (i < n1 + n2) {
            this.itemName[first + i] = tempStr[i];
            this.data[first + i] = tempEntry[i];
            ++i;
        }
    }

    private boolean compare(boolean reverse, String type, int first, int copied1, int copied2, int n1) {
        if (!reverse && type.equals("item")) {
            return this.itemName[first + copied1].compareTo(this.itemName[first + n1 + copied2]) < 0;
        }
        if (reverse && type.equals("item")) {
            return this.itemName[first + copied1].compareTo(this.itemName[first + n1 + copied2]) > 0;
        }
        if (!reverse && type.equals("initial")) {
            return this.data[first + copied1].getInitial() < this.data[first + n1 + copied2].getInitial();
        }
        if (reverse && type.equals("initial")) {
            return this.data[first + copied1].getInitial() > this.data[first + n1 + copied2].getInitial();
        }
        if (!reverse && type.equals("min")) {
            return this.data[first + copied1].getMinimum() < this.data[first + n1 + copied2].getMinimum();
        }
        if (reverse && type.equals("min")) {
            return this.data[first + copied1].getMinimum() > this.data[first + n1 + copied2].getMinimum();
        }
        if (!reverse && type.equals("max")) {
            return this.data[first + copied1].getMaximum() < this.data[first + n1 + copied2].getMaximum();
        }
        if (reverse && type.equals("max")) {
            return this.data[first + copied1].getMaximum() > this.data[first + n1 + copied2].getMaximum();
        }
        if (!reverse && type.equals("random num")) {
            return this.data[first + copied1].getRandomCount() < this.data[first + n1 + copied2].getRandomCount();
        }
        if (reverse && type.equals("random num")) {
            return this.data[first + copied1].getRandomCount() > this.data[first + n1 + copied2].getRandomCount();
        }
        if (!reverse && type.equals("random appear")) {
            return this.data[first + copied1].getRandomChancePercent() < this.data[first + n1 + copied2].getRandomChancePercent();
        }
        if (reverse && type.equals("random appear")) {
            return this.data[first + copied1].getRandomChancePercent() > this.data[first + n1 + copied2].getRandomChancePercent();
        }
        return false;
    }
}

