/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import src.backend.StaticFunctions;
import src.gui.MapNameFrame_btnCancel_actionAdapter;
import src.gui.MapNameFrame_btnOK_actionAdapter;
import src.gui.Model;

public class MapNameFrame
extends JFrame {
    private Model model;
    private int lvlIndex;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField txtSelectionName = new JTextField();
    JTextField txtOverHeadName = new JTextField();
    JButton btnOK = new JButton();
    JButton btnCancel = new JButton();

    public MapNameFrame(Model m, int levelIndex) {
        try {
            this.model = m;
            this.lvlIndex = levelIndex;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.setJMenuBar(null);
        this.jLabel1.setText("Level Over Head Name:");
        this.jLabel1.setBounds(new Rectangle(13, 76, 295, 23));
        this.txtOverHeadName.setText("");
        this.txtOverHeadName.setBounds(new Rectangle(13, 108, 315, 23));
        this.txtSelectionName.setText("");
        this.txtSelectionName.setBounds(new Rectangle(13, 44, 315, 23));
        this.btnOK.setBounds(new Rectangle(180, 152, 80, 31));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new MapNameFrame_btnOK_actionAdapter(this));
        this.btnCancel.setBounds(new Rectangle(88, 152, 80, 31));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new MapNameFrame_btnCancel_actionAdapter(this));
        this.getContentPane().add(this.jLabel3);
        this.getContentPane().add(this.txtSelectionName);
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.txtOverHeadName);
        this.getContentPane().add(this.btnCancel);
        this.getContentPane().add(this.btnOK);
        this.jLabel3.setText("Level Selection Name:");
        this.jLabel3.setBounds(new Rectangle(13, 12, 295, 23));
        if (this.model.getLevelSelectName(this.lvlIndex) == null) {
            return;
        }
        this.txtSelectionName.setText(this.model.getLevelSelectName(this.lvlIndex));
        this.txtOverHeadName.setText(this.model.getLevelOverHeadName(this.lvlIndex));
        if (!this.model.getIsMerged()) {
            this.jLabel3.setText("Level Selection Name: (merged maps only)");
            this.txtSelectionName.setEnabled(false);
        }
        this.setSize(350, 220);
        this.setTitle("Change Map Name");
        StaticFunctions.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void btnCancel_actionPerformed(ActionEvent e) {
        this.model.removeChildFrame(this);
        this.dispose();
    }

    public void btnOK_actionPerformed(ActionEvent e) {
        this.model.setLevelSelectName(this.txtSelectionName.getText(), this.lvlIndex);
        this.model.setLevelSelectorNames();
        this.model.setLevelOverHeadName(this.txtOverHeadName.getText(), this.lvlIndex);
        if (!this.model.getIsMerged()) {
            this.model.setLevelSelectName(this.txtOverHeadName.getText(), this.lvlIndex);
            this.model.setLevelSelectorNames();
        }
        this.model.removeChildFrame(this);
        this.dispose();
    }
}

