/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

public class WrkArrayReader {
    private byte[] data;
    private int position;

    public WrkArrayReader(byte[] data) {
        this.data = data;
        this.position = 0;
    }

    public short readShort() {
        int b0 = this.data[this.position] & 0xFF;
        ++this.position;
        int b1 = this.data[this.position] & 0xFF;
        ++this.position;
        short s = (short)(b0 << 8 | b1);
        return s;
    }

    public void writeShort(short s) {
        this.data[this.position] = (byte)(s >> 8);
        ++this.position;
        this.data[this.position] = (byte)s;
        ++this.position;
    }

    public int readInt() {
        int b0 = this.data[this.position] & 0xFF;
        ++this.position;
        int b1 = this.data[this.position] & 0xFF;
        ++this.position;
        int b2 = this.data[this.position] & 0xFF;
        ++this.position;
        int b3 = this.data[this.position] & 0xFF;
        ++this.position;
        int ans = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return ans;
    }

    public void writeInt(int i) {
        this.data[this.position] = (byte)(i >> 24);
        ++this.position;
        this.data[this.position] = (byte)(i >> 16);
        ++this.position;
        this.data[this.position] = (byte)(i >> 8);
        ++this.position;
        this.data[this.position] = (byte)i;
        ++this.position;
    }

    public int getPosition() {
        return this.position;
    }

    public void seek(int pos) {
        this.position = pos;
    }
}

