/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.io.File;
import java.io.RandomAccessFile;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.IChunk;
import src.backend.Level;
import src.backend.MapWriter;

public class TermChunk
extends Chunk
implements IChunk {
    private char[] text;

    public TermChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public TermChunk() {
    }

    public void setText(String txt) {
        this.text = txt.toCharArray();
    }

    public void setText(char[] txt) {
        this.text = txt;
    }

    public void setText(byte[] txt) {
        char[] converted = new char[txt.length];
        int i = 0;
        while (i < txt.length) {
            converted[i] = (char)txt[i];
            ++i;
        }
        this.text = converted;
    }

    public void setText(File textFile) {
        try {
            RandomAccessFile r = new RandomAccessFile(textFile, "r");
            byte[] b = new byte[(int)r.length()];
            r.read(b);
            this.setText(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return new String(this.text);
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        byte[] data = new byte[this.header.getLength()];
        mw.read(data);
        this.setText(data);
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16 + this.getLevel().getOffset());
        byte[] data = new byte[this.text.length];
        int i = 0;
        while (i < this.text.length) {
            data[i] = (byte)this.text[i];
            ++i;
        }
        mw.write(data);
    }

    public void saveTerminal(String filename) {
        try {
            RandomAccessFile r = new RandomAccessFile(filename, "rw");
            r.writeBytes(this.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getEntryLength() {
        return this.text.length;
    }

    public int getNumEntries() {
        return 1;
    }
}

