/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Entry;
import src.backend.IEntry;
import src.backend.MapWriter;
import src.backend.PolyChunk;
import src.backend.ShapeDescriptor;
import src.backend.WrkArrayReader;

public class PolyEntry
extends Entry
implements IEntry {
    public static final int ENTRY_LENGTH = 128;
    short type;
    int flags;
    short permutation;
    int vertex_count;
    short[] endpoint_indexes = new short[8];
    short[] line_indexes = new short[8];
    ShapeDescriptor floor_texture;
    ShapeDescriptor ceiling_texture;
    short floor_height;
    short ceiling_height;
    short floor_light_index;
    short ceiling_light_index;
    int area;
    short first_object;
    short first_exclusion_zone_index;
    short line_exclusion_count;
    short point_exclusion_count;
    short floor_transfer_mode;
    short ceiling_transfer_mode;
    short[] adjacent_polygon_indexes = new short[8];
    short first_neighbor_index;
    short neighbor_count;
    short center_x;
    short center_y;
    short[] side_indexes = new short[8];
    short floor_x;
    short floor_y;
    short ceiling_x;
    short ceiling_y;
    short media_index;
    short media_light_index;
    short sound_source_index;
    short ambient_sound_index;
    short random_sound_index;
    short unused;
    public static final int NORMAL = 0;
    public static final int ITEM_IMPASSABLE = 1;
    public static final int MONSTER_IMPASSABLE = 2;
    public static final int HILL = 3;
    public static final int BASE = 4;
    public static final int PLATFORM = 5;
    public static final int LIGHT_ON_TRIGGER = 6;
    public static final int PLATFORM_ON_TRIGGER = 7;
    public static final int LIGHT_OFF_TRIGGER = 8;
    public static final int PLATFORM_OFF_TRIGGER = 9;
    public static final int TELEPORTER = 10;
    public static final int ZONE_BORDER = 11;
    public static final int GOAL = 12;
    public static final int VISIBLE_MONSTER_TRIGGER = 13;
    public static final int INVISIBLE_MONSTER_TRIGGER = 14;
    public static final int DUAL_MONSTER_TRIGGER = 15;
    public static final int ITEM_TRIGGER = 16;
    public static final int MUST_BE_EXPLORED = 17;
    public static final int AUTOMATIC_EXIT = 18;
    public static final int MINOR_OUCH = 19;
    public static final int MAJOR_OUCH = 20;
    public static final int GLUE = 21;
    public static final int GLUE_TRIGGER = 22;
    public static final int SUPERGLUE = 23;

    public PolyEntry(PolyChunk chunk) {
        super(chunk);
    }

    public void setPermutation(short permutation) {
        this.permutation = permutation;
    }

    public short getPermutation() {
        return this.permutation;
    }

    public void setType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public double getX() {
        return (double)this.center_x / 1024.0;
    }

    public double getY() {
        return (double)this.center_y / 1024.0;
    }

    public ShapeDescriptor getFloorTexture() {
        return this.floor_texture;
    }

    public ShapeDescriptor getCeilingTexture() {
        return this.ceiling_texture;
    }

    public void setFloorTexture(ShapeDescriptor s) {
        this.floor_texture = s;
    }

    public void setCeilingTexture(ShapeDescriptor s) {
        this.ceiling_texture = s;
    }

    public void setCeilingTransferMode(short t) {
        this.ceiling_transfer_mode = t;
    }

    public void setFloorTransferMode(short t) {
        this.floor_transfer_mode = t;
    }

    public short getCeilingTransferMode() {
        return this.ceiling_transfer_mode;
    }

    public short getFloorTransferMode() {
        return this.floor_transfer_mode;
    }

    public PolyEntry read() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[128];
        mapWriter.read(data);
        WrkArrayReader mw = new WrkArrayReader(data);
        this.type = mw.readShort();
        this.flags = mw.readShort();
        this.permutation = mw.readShort();
        this.vertex_count = mw.readShort();
        int i = 0;
        while (i < this.endpoint_indexes.length) {
            this.endpoint_indexes[i] = mw.readShort();
            ++i;
        }
        i = 0;
        while (i < this.line_indexes.length) {
            this.line_indexes[i] = mw.readShort();
            ++i;
        }
        short shr = mw.readShort();
        this.floor_texture = new ShapeDescriptor(shr);
        shr = mw.readShort();
        this.ceiling_texture = new ShapeDescriptor(shr);
        this.floor_height = mw.readShort();
        this.ceiling_height = mw.readShort();
        this.floor_light_index = mw.readShort();
        this.ceiling_light_index = mw.readShort();
        this.area = mw.readInt();
        this.first_object = mw.readShort();
        this.first_exclusion_zone_index = mw.readShort();
        this.line_exclusion_count = mw.readShort();
        this.point_exclusion_count = mw.readShort();
        this.floor_transfer_mode = mw.readShort();
        this.ceiling_transfer_mode = mw.readShort();
        int i2 = 0;
        while (i2 < this.adjacent_polygon_indexes.length) {
            this.adjacent_polygon_indexes[i2] = mw.readShort();
            ++i2;
        }
        this.first_neighbor_index = mw.readShort();
        this.neighbor_count = mw.readShort();
        this.center_x = mw.readShort();
        this.center_y = mw.readShort();
        i2 = 0;
        while (i2 < this.side_indexes.length) {
            this.side_indexes[i2] = mw.readShort();
            ++i2;
        }
        this.floor_x = mw.readShort();
        this.floor_y = mw.readShort();
        this.ceiling_x = mw.readShort();
        this.ceiling_y = mw.readShort();
        this.media_index = mw.readShort();
        this.media_light_index = mw.readShort();
        this.sound_source_index = mw.readShort();
        this.ambient_sound_index = mw.readShort();
        this.random_sound_index = mw.readShort();
        this.unused = mw.readShort();
        return this;
    }

    public void write() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[128];
        WrkArrayReader mw = new WrkArrayReader(data);
        mw.writeShort(this.type);
        mw.writeShort((short)this.flags);
        mw.writeShort(this.permutation);
        mw.writeShort((short)this.vertex_count);
        int i = 0;
        while (i < this.endpoint_indexes.length) {
            mw.writeShort(this.endpoint_indexes[i]);
            ++i;
        }
        i = 0;
        while (i < this.line_indexes.length) {
            mw.writeShort(this.line_indexes[i]);
            ++i;
        }
        mw.writeShort((short)this.floor_texture.getDesc());
        mw.writeShort((short)this.ceiling_texture.getDesc());
        mw.writeShort(this.floor_height);
        mw.writeShort(this.ceiling_height);
        mw.writeShort(this.floor_light_index);
        mw.writeShort(this.ceiling_light_index);
        mw.writeInt(this.area);
        mw.writeShort(this.first_object);
        mw.writeShort(this.first_exclusion_zone_index);
        mw.writeShort(this.line_exclusion_count);
        mw.writeShort(this.point_exclusion_count);
        mw.writeShort(this.floor_transfer_mode);
        mw.writeShort(this.ceiling_transfer_mode);
        i = 0;
        while (i < this.adjacent_polygon_indexes.length) {
            mw.writeShort(this.adjacent_polygon_indexes[i]);
            ++i;
        }
        mw.writeShort(this.first_neighbor_index);
        mw.writeShort(this.neighbor_count);
        mw.writeShort(this.center_x);
        mw.writeShort(this.center_y);
        i = 0;
        while (i < this.side_indexes.length) {
            mw.writeShort(this.side_indexes[i]);
            ++i;
        }
        mw.writeShort(this.floor_x);
        mw.writeShort(this.floor_y);
        mw.writeShort(this.ceiling_x);
        mw.writeShort(this.ceiling_y);
        mw.writeShort(this.media_index);
        mw.writeShort(this.media_light_index);
        mw.writeShort(this.sound_source_index);
        mw.writeShort(this.ambient_sound_index);
        mw.writeShort(this.random_sound_index);
        mw.writeShort(this.unused);
        mapWriter.write(data);
    }

    public short[] getEndpoint_indexes() {
        return this.endpoint_indexes;
    }

    public int getVertex_count() {
        return this.vertex_count;
    }
}

