/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Level;
import src.backend.MapWriter;

public class MapData {
    private static boolean READ_PATCH = false;
    private static String PATCH_PATH = "Shapes Patch";
    private ArrayList levels;
    private MapWriter mw;
    private boolean isValidMapFile = true;
    private boolean isMergedMapFile = true;
    private short version;
    private short dataVersion;
    private char[] mapName = new char[64];
    private long checksum;
    private int mapLength;
    private short numLevels;
    private short appSpecificDirSize;
    private short entryHeaderSize;
    private short baseDirectoryEntrySize;
    private int parentChecksum;
    private long fileLength = 0L;
    private boolean hasChanged = false;
    private boolean isOptimized = false;
    private String fPath;

    public MapData(String filePath) {
        this.fPath = filePath;
        System.out.println("Reading map ...");
        long startTime = System.currentTimeMillis();
        this.mw = new MapWriter(filePath);
        if (!this.mw.getFileLoaded()) {
            return;
        }
        if (!this.mw.isValidMapFile()) {
            this.isValidMapFile = false;
            return;
        }
        this.isValidMapFile = true;
        if (this.mw.isMacBinary()) {
            this.mw.seek(83L);
            this.fileLength = this.mw.readLong();
        } else {
            this.fileLength = this.mw.length();
        }
        this.readHeader();
        if (this.appSpecificDirSize != 74) {
            this.isMergedMapFile = false;
        }
        this.levels = new ArrayList(0);
        int a = 0;
        while (a < this.numLevels) {
            System.out.println("Level " + a);
            Level level = new Level(this);
            this.mw.seek(this.mapLength + a * 84);
            MapData.print(this.mapLength);
            level.setOffset(this.mw.readInt());
            level.setLength(this.mw.readInt());
            level = this.isMergedMapFile ? this.processMergedLevel(level) : this.processUnmergedLevel(level);
            this.levels.add(level);
            ++a;
        }
        System.out.println("Reading took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
    }

    private Level processMergedLevel(Level level) {
        this.mw.skipBytes(8);
        level.setFlags(this.mw.readShort());
        String tmpName = "";
        byte present = this.mw.readByte();
        while (present != 0) {
            char newChar = (char)present;
            tmpName = String.valueOf(tmpName) + newChar;
            present = this.mw.readByte();
        }
        level.setLevelSelectName(tmpName);
        level.processChunks();
        return level;
    }

    private Level processUnmergedLevel(Level level) {
        level.processChunks();
        level.setLevelSelectName(level.getMinfChunk().getName());
        level.setFlags((short)level.getMinfChunk().getEntry());
        return level;
    }

    public boolean isMergedMapFile() {
        return this.isMergedMapFile;
    }

    public void setMapWriter(MapWriter mw) {
        this.mw = mw;
    }

    public void setNumLevels(short numLevels) {
        this.numLevels = numLevels;
    }

    public void setMapLength(int mapLength) {
        int diff = mapLength - this.mapLength;
        this.mapLength = mapLength;
        MapData.print("Map Length set to " + mapLength);
    }

    public void setLevels(ArrayList levels) {
        this.levels = levels;
        this.numLevels = (short)levels.size();
    }

    public void setLevel(int num, Level level) {
        this.levels.set(num, level);
    }

    public void addLevels(ArrayList levels) {
        this.levels.addAll(levels);
        this.numLevels = (short)this.levels.size();
        int i = 0;
        while (i < this.levels.size()) {
            this.getLevel(i).setMapData(this);
            ++i;
        }
    }

    public MapWriter getMapWriter() {
        return this.mw;
    }

    public short getNumLevels() {
        return this.numLevels;
    }

    public int getMapLength() {
        return this.mapLength;
    }

    public ArrayList getLevels() {
        return this.levels;
    }

    public void addLevel(Level l) {
        this.levels.add(l);
        this.numLevels = (short)(this.numLevels + 1);
    }

    public Level getLevel(int num) {
        return (Level)this.levels.get(num);
    }

    public boolean getIsValidMap() {
        return this.isValidMapFile;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public void setOptimized(boolean b) {
        this.isOptimized = b;
    }

    public static void print(String msg) {
        System.out.println(msg);
    }

    public static void print(long msg) {
        System.out.println(msg);
    }

    public void write() {
        System.out.println("Saving map...");
        long startTime = System.currentTimeMillis();
        this.calc();
        if (this.mw.isMacBinary()) {
            this.mw.writeMacBinary();
        }
        this.writeHeader();
        this.mw.seek(128L);
        int i = 0;
        while (i < this.numLevels) {
            System.out.print("\n\tWriting level " + i);
            this.getLevel(i).write();
            ++i;
        }
        this.writeTrailers();
        this.writeChecksum();
        System.out.println("Writing took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
    }

    public void writeFlags(int level) {
        short flags = ((Level)this.levels.get(level)).getFlags();
        this.mw.seek(this.mapLength + 84 * level + 16);
        this.mw.writeShort(flags);
    }

    public void writeTrailers() {
        this.mw.seek(this.getMapLength());
        int i = 0;
        while (i < this.numLevels) {
            this.writeOffset(i);
            this.writeLength(i);
            if (this.isMergedMapFile) {
                this.writeIndex(i);
                this.writeFlags(i);
                this.writeLevelSelectName(i);
            } else {
                this.mw.writeShort((short)0);
            }
            ++i;
        }
    }

    public void writeIndex(int level) {
        this.mw.seek(this.mapLength + 84 * level + 8);
        this.mw.writeShort((short)level);
    }

    public void writeLevelSelectName(int level) {
        String levelSelectName = ((Level)this.levels.get(level)).getlevelSelectName();
        if (levelSelectName.length() > 64) {
            levelSelectName = levelSelectName.substring(0, 64);
        }
        this.mw.seek(this.mapLength + 84 * level + 18);
        int i = 0;
        while (i < 64) {
            if (i < levelSelectName.length()) {
                this.mw.writeByte(levelSelectName.charAt(i));
            } else {
                this.mw.writeByte(0);
            }
            ++i;
        }
    }

    public void writeOffset(int level) {
        int offset = ((Level)this.levels.get(level)).getOffset();
        this.mw.seek(this.mapLength + 84 * level);
        this.mw.writeInt(offset);
    }

    public void writeLength(int level) {
        int length = ((Level)this.levels.get(level)).getLength();
        this.mw.seek(this.mapLength + 84 * level + 4);
        this.mw.writeInt(length);
    }

    public void calc() {
        int total = 128;
        int i = 0;
        while (i < this.levels.size()) {
            Level l = (Level)this.levels.get(i);
            l.setOffset(total);
            int len = l.calc();
            l.setLength(len);
            total += len;
            ++i;
        }
        this.setMapLength(total);
    }

    public void readHeader() {
        this.mw.seek(0L);
        this.version = this.mw.readShort();
        MapData.print(this.version);
        this.dataVersion = this.mw.readShort();
        MapData.print(String.valueOf(this.dataVersion) + "\n");
        int z = 0;
        while (z < 64) {
            this.mapName[z] = (char)this.mw.readByte();
            if (this.mapName[z] != '\u0000') {
                System.out.print(this.mapName[z]);
            }
            ++z;
        }
        this.checksum = this.mw.readInt();
        MapData.print("\n" + this.checksum);
        this.mapLength = this.mw.readInt();
        MapData.print(this.mapLength);
        this.numLevels = this.mw.readShort();
        MapData.print(String.valueOf(this.numLevels) + " level(s) found in map.");
        this.appSpecificDirSize = this.mw.readShort();
        this.entryHeaderSize = this.mw.readShort();
        this.parentChecksum = this.mw.readInt();
    }

    public void writeHeader() {
        this.mw.seek(0L);
        this.mw.writeShort(this.version);
        this.mw.writeShort(this.dataVersion);
        int z = 0;
        while (z < 64) {
            this.mw.writeByte((byte)this.mapName[z]);
            ++z;
        }
        System.out.println("Original Checksum: " + (int)this.checksum);
        this.mw.writeInt(0);
        this.mw.writeInt(this.mapLength);
        MapData.print(this.mapLength);
        this.mw.writeShort(this.numLevels);
        this.mw.writeShort(this.appSpecificDirSize);
        this.mw.writeShort(this.entryHeaderSize);
        this.mw.writeInt(this.parentChecksum);
        int i = 0;
        while (i < 20) {
            this.mw.writeShort((short)0);
            ++i;
        }
    }

    public void writeNew(String path) {
        this.fPath = path;
        this.mw.newRF(path, this);
        this.write();
    }

    public void mergeWith(MapData[] mapData) {
        this.isMergedMapFile = true;
        this.version = (short)4;
        this.appSpecificDirSize = (short)74;
        ArrayList<Level> newLevels = new ArrayList<Level>(0);
        int i = 0;
        while (i < mapData.length) {
            Level level = mapData[i].getLevel(0);
            newLevels.add(level);
            ++i;
        }
        this.addLevels(newLevels);
    }

    public void writeChecksum() {
        int trailerLength = this.numLevels * 84;
        if (!this.isMergedMapFile) {
            trailerLength = 10;
        }
        this.checksum = this.mw.generateChecksum(this.mapLength, trailerLength);
        System.out.println("\nNew Checksum     : " + (int)this.checksum);
        this.mw.seek(68L);
        this.mw.writeInt((int)this.checksum);
    }
}

