/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.EpntChunk;
import src.backend.JuceChunk;
import src.backend.LinsChunk;
import src.backend.MapData;
import src.backend.MapWriter;
import src.backend.MinfChunk;
import src.backend.ObjsChunk;
import src.backend.PlacChunk;
import src.backend.PolyChunk;
import src.backend.ShPaChunk;
import src.backend.SidsChunk;
import src.backend.StaticFunctions;
import src.backend.TermChunk;
import src.backend.UnknownChunk;

public class Level {
    private static short SOLO = 1;
    private static short COOP = (short)2;
    private static short EMFH = (short)4;
    private static short BALL = (short)8;
    private static short KOTH = (short)16;
    private static short RUGBY = (short)32;
    private static short DEFENSE = (short)64;
    MapData md;
    ArrayList chunks;
    private boolean hasChanged = false;
    private PlacChunk placChunk;
    private MinfChunk minfChunk;
    private JuceChunk juceChunk;
    private PolyChunk polyChunk;
    private ObjsChunk objsChunk;
    private LinsChunk linsChunk;
    private SidsChunk sidsChunk;
    private ShPaChunk shpaChunk;
    private TermChunk termChunk;
    private EpntChunk epntChunk;
    private short flags;
    private int offset;
    private int length;
    private String levelSelectName;
    private boolean isSavedGame = false;
    private int chunksToStrip = 0;
    private ArrayList chunkNums = new ArrayList(0);

    public Level(MapData md) {
        this.md = md;
    }

    public void processChunks() {
        MapWriter mw = this.md.getMapWriter();
        this.chunks = new ArrayList(0);
        mw.seek(this.offset);
        int numChunks = 0;
        while (mw.getFilePointer() < (long)(this.offset + this.length)) {
            long presentOffset = mw.getFilePointer();
            String tag = "";
            int z = 0;
            while (z < 4) {
                tag = String.valueOf(tag) + (char)mw.readByte();
                ++z;
            }
            mw.seek(presentOffset);
            ChunkHeader header = new ChunkHeader();
            header.setTag(mw.readInt());
            header.setTagString(tag);
            header.setNextOffset(mw.readInt());
            header.setLength(mw.readInt());
            header.setOffset((int)presentOffset);
            mw.readInt();
            ++numChunks;
            int cTag = header.getTag();
            switch (cTag) {
                case 1886151011: {
                    this.placChunk = new PlacChunk(this, header);
                    this.chunks.add(this.placChunk);
                    break;
                }
                case 1298755174: {
                    this.minfChunk = new MinfChunk(this, header);
                    this.chunks.add(this.minfChunk);
                    break;
                }
                case 1247101765: {
                    this.juceChunk = new JuceChunk(this, header);
                    this.chunks.add(this.juceChunk);
                    break;
                }
                case 1347374169: {
                    this.polyChunk = new PolyChunk(this, header);
                    this.polyChunk.read();
                    this.chunks.add(this.polyChunk);
                    break;
                }
                case 1329744467: {
                    this.objsChunk = new ObjsChunk(this, header);
                    this.objsChunk.read();
                    this.chunks.add(this.objsChunk);
                    break;
                }
                case 1279872595: {
                    this.linsChunk = new LinsChunk(this, header);
                    this.linsChunk.read();
                    this.chunks.add(this.linsChunk);
                    break;
                }
                case 1397310547: {
                    this.sidsChunk = new SidsChunk(this, header);
                    this.sidsChunk.read();
                    this.chunks.add(this.sidsChunk);
                    break;
                }
                case 1399345249: {
                    this.shpaChunk = new ShPaChunk(this, header);
                    this.shpaChunk.read();
                    this.chunks.add(this.shpaChunk);
                    break;
                }
                case 1952805485: {
                    this.termChunk = new TermChunk(this, header);
                    this.termChunk.read();
                    this.chunks.add(this.termChunk);
                    break;
                }
                case 1162890836: {
                    this.epntChunk = new EpntChunk(this, header);
                    this.epntChunk.read();
                    this.chunks.add(this.epntChunk);
                    break;
                }
                default: {
                    UnknownChunk chunk = new UnknownChunk(this, header);
                    this.chunks.add(chunk);
                }
            }
            if (header.getNextOffset() == 0) break;
            mw.seek(header.getNextOffset() + this.offset);
        }
        int opt = 0;
        while (opt < this.chunks.size()) {
            Chunk chun = (Chunk)this.chunks.get(opt);
            if (chun.getTag() == 1768514680) {
                this.md.setOptimized(true);
            }
            ++opt;
        }
        int z = 0;
        while (z < this.chunks.size()) {
            boolean saveChunk = false;
            Chunk chunk = (Chunk)this.chunks.get(z);
            int cTag = chunk.getHeader().getTag();
            int y = 0;
            while (y < StaticFunctions.SAVE_CHUNKS.length) {
                if (cTag == StaticFunctions.SAVE_CHUNKS[y]) {
                    this.isSavedGame = true;
                    saveChunk = true;
                    System.out.println("Removing chunk " + chunk.getHeader().getTagString());
                }
                ++y;
            }
            if (saveChunk) {
                Chunk aChunk = (Chunk)this.chunks.get(z);
                ChunkHeader aHeader = chunk.getHeader();
                aHeader.setTag(0);
                ++this.chunksToStrip;
            }
            ++z;
        }
        this.stripSavedGame();
    }

    public void stripSavedGame() {
        if (this.chunksToStrip > 0) {
            System.out.println("Detected chunks to strip from level.");
            int i = 0;
            while (i < this.chunksToStrip) {
                int j = 0;
                while (j < this.chunks.size()) {
                    Chunk chunk = (Chunk)this.chunks.get(j);
                    ChunkHeader header = chunk.getHeader();
                    if (header.getTag() == 0) {
                        this.removeChunk(j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public MapData getMapData() {
        return this.md;
    }

    public void setMapData(MapData m) {
        this.md = m;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void updateLength(int length) {
        int diff = length - this.length;
        this.length = length;
        this.md.setMapLength(this.md.getMapLength() + diff);
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getlevelSelectName() {
        return this.levelSelectName;
    }

    public void setLevelSelectName(String name) {
        this.levelSelectName = name;
    }

    public ArrayList getChunks() {
        return this.chunks;
    }

    public void addChunk(Chunk chunk) {
        ChunkHeader header = new ChunkHeader();
        chunk.setHeader(header);
        header.setChunk(chunk);
        header.setTag(1247101765);
        chunk.setLevel(this);
        if (chunk instanceof JuceChunk) {
            this.juceChunk = (JuceChunk)chunk;
        } else if (chunk instanceof ShPaChunk) {
            header.setTag(1399345249);
            this.shpaChunk = (ShPaChunk)chunk;
        } else if (chunk instanceof TermChunk) {
            header.setTag(1952805485);
            this.termChunk = (TermChunk)chunk;
        }
        this.chunks.add(chunk);
    }

    public Chunk removeChunk(int index) {
        Chunk deadChunk = (Chunk)this.chunks.remove(index);
        return deadChunk;
    }

    public PlacChunk getPlacChunk() {
        return this.placChunk;
    }

    public MinfChunk getMinfChunk() {
        return this.minfChunk;
    }

    public JuceChunk getJuceChunk() {
        return this.juceChunk;
    }

    public PolyChunk getPolyChunk() {
        return this.polyChunk;
    }

    public ObjsChunk getObjsChunk() {
        return this.objsChunk;
    }

    public LinsChunk getLinsChunk() {
        return this.linsChunk;
    }

    public SidsChunk getSidsChunk() {
        return this.sidsChunk;
    }

    public ShPaChunk getShPaChunk() {
        return this.shpaChunk;
    }

    public TermChunk getTermChunk() {
        return this.termChunk;
    }

    public void convertLevelTextures() {
        this.polyChunk.convertTextures();
        this.sidsChunk.convertTextures();
    }

    public void convertLevelTextures(int coll1, int bmp1, int coll2, int bmp2) {
        short newcoll = (short)coll2;
        short newbmp = (short)bmp2;
        switch (bmp2) {
            case -2: {
                newcoll = 27;
                newbmp = 0;
                break;
            }
            case -3: {
                newcoll = 28;
                newbmp = 0;
                break;
            }
            case -4: {
                newcoll = 29;
                newbmp = 0;
                break;
            }
            case -5: {
                newcoll = 30;
                newbmp = 0;
                break;
            }
        }
        this.polyChunk.convertTextures((short)coll1, (short)bmp1, newcoll, newbmp);
        this.sidsChunk.convertTextures((short)coll1, (short)bmp1, newcoll, newbmp);
    }

    public void convertLevelTextures(int c1, int b1, int x1, int c2, int b2, int x2) {
        short newcoll = (short)c2;
        short newbmp = (short)b2;
        switch (b2) {
            case -2: {
                newcoll = 27;
                newbmp = 0;
                break;
            }
            case -3: {
                newcoll = 28;
                newbmp = 0;
                break;
            }
            case -4: {
                newcoll = 29;
                newbmp = 0;
                break;
            }
            case -5: {
                newcoll = 30;
                newbmp = 0;
                break;
            }
        }
        this.polyChunk.convertTextures((short)c1, (short)b1, (short)x1, newcoll, newbmp, (short)x2);
        this.sidsChunk.convertTextures((short)c1, (short)b1, (short)x1, newcoll, newbmp, (short)x2);
    }

    public void convertLevelTextures(int c1, int b1, int x1, int cp1, int c2, int b2, int x2, int cp2) {
        short newcoll = (short)c2;
        short newbmp = (short)b2;
        switch (b2) {
            case -2: {
                newcoll = 27;
                newbmp = 0;
                break;
            }
            case -3: {
                newcoll = 28;
                newbmp = 0;
                break;
            }
            case -4: {
                newcoll = 29;
                newbmp = 0;
                break;
            }
            case -5: {
                newcoll = 30;
                newbmp = 0;
                break;
            }
        }
        this.polyChunk.convertTextures((short)c1, (short)b1, (short)x1, newcoll, newbmp, (short)x2);
        this.sidsChunk.convertTextures((short)c1, (short)b1, (short)x1, (short)cp1, newcoll, newbmp, (short)x2, (short)cp2);
    }

    public void write() {
        int i = 0;
        while (i < this.chunks.size()) {
            ((Chunk)this.chunks.get(i)).write();
            ++i;
        }
    }

    public int calc() {
        int total = 0;
        int i = 0;
        while (i < this.chunks.size()) {
            Chunk c = (Chunk)this.chunks.get(i);
            ChunkHeader h = c.getHeader();
            int len = c.calc();
            h.setLength(len);
            h.setOffset(total);
            total += len + 16;
            if (i == this.chunks.size() - 1) {
                h.setNextOffset(0);
            } else {
                h.setNextOffset(total);
            }
            ++i;
        }
        return total;
    }

    public String toString() {
        return "Name: " + this.getMinfChunk().getName() + "\n" + this.chunks.size() + " chunks.";
    }

    public boolean isSavedGame() {
        return this.isSavedGame;
    }

    public EpntChunk getEpntChunk() {
        return this.epntChunk;
    }
}

