/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import javax.swing.table.AbstractTableModel;
import src.backend.SidsEntry;
import src.gui.Model;

public class SidsTableModel
extends AbstractTableModel {
    public static final int SIDS_INDEX = 0;
    public static final int SIDS_TYPE = 1;
    public static final int SIDS_LINEINDEX = 2;
    private String[] colNames;
    private SidsEntry[] data;
    private int[] indexNums;
    private Model model;

    public SidsTableModel(String[] colNames, Model model, int levelIndex) {
        this.colNames = colNames;
        this.model = model;
        this.data = new SidsEntry[this.model.getSidsNumber(levelIndex)];
        this.indexNums = new int[this.model.getSidsNumber(levelIndex)];
        int i = 0;
        while (i < this.model.getSidsNumber(levelIndex)) {
            this.indexNums[i] = i;
            this.data[i] = this.model.getSide(levelIndex, i);
            ++i;
        }
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    private String getType(int num) {
        if (num == 0) {
            return "Full";
        }
        if (num == 1) {
            return "High";
        }
        if (num == 2) {
            return "Low";
        }
        if (num == 3) {
            return "Composite";
        }
        return "Split";
    }

    private short getTypeNum(String str) {
        if (str.equals("Full")) {
            return 0;
        }
        if (str.equals("High")) {
            return 1;
        }
        if (str.equals("Low")) {
            return 2;
        }
        if (str.equals("Composite")) {
            return 3;
        }
        return 4;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return new Integer(this.indexNums[row]);
            }
            case 1: {
                return this.getType(this.data[row].getType());
            }
            case 2: {
                return new Integer(this.data[row].getLineIndex());
            }
        }
        return new Object();
    }

    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 1: {
                this.data[row].setType(this.getTypeNum((String)value));
                break;
            }
            default: {
                System.out.println("Invalid LinsTable index");
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public void sort(int header, boolean reverse) {
        try {
            switch (header) {
                case 0: {
                    this.sortBy(reverse, "index");
                    break;
                }
                case 1: {
                    this.sortBy(reverse, "type");
                    break;
                }
                case 2: {
                    this.sortBy(reverse, "lineindex");
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sortBy(boolean reverse, String type) {
        this.mergeSort(0, this.data.length, reverse, type);
    }

    private void mergeSort(int first, int n, boolean reverse, String type) {
        if (n > 1) {
            int n1 = n / 2;
            int n2 = n - n1;
            this.mergeSort(first, n1, reverse, type);
            this.mergeSort(first + n1, n2, reverse, type);
            this.merge(first, n1, n2, reverse, type);
        }
    }

    private void merge(int first, int n1, int n2, boolean reverse, String type) {
        int[] temp = new int[n1 + n2];
        SidsEntry[] tempEntry = new SidsEntry[n1 + n2];
        int copied = 0;
        int copied1 = 0;
        int copied2 = 0;
        while (copied1 < n1 && copied2 < n2) {
            if (this.compare(reverse, type, first, copied1, copied2, n1)) {
                temp[copied++] = this.indexNums[first + copied1++];
                tempEntry[copied - 1] = this.data[first + copied1 - 1];
                continue;
            }
            temp[copied++] = this.indexNums[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        while (copied1 < n1) {
            temp[copied++] = this.indexNums[first + copied1++];
            tempEntry[copied - 1] = this.data[first + copied1 - 1];
        }
        while (copied2 < n2) {
            temp[copied++] = this.indexNums[first + n1 + copied2++];
            tempEntry[copied - 1] = this.data[first + n1 + copied2 - 1];
        }
        int i = 0;
        while (i < n1 + n2) {
            this.indexNums[first + i] = temp[i];
            this.data[first + i] = tempEntry[i];
            ++i;
        }
    }

    private boolean compare(boolean reverse, String type, int first, int copied1, int copied2, int n1) {
        if (!reverse && type.equals("index")) {
            return this.indexNums[first + copied1] < this.indexNums[first + n1 + copied2];
        }
        if (reverse && type.equals("index")) {
            return this.indexNums[first + copied1] > this.indexNums[first + n1 + copied2];
        }
        if (!reverse && type.equals("type")) {
            return this.data[first + copied1].getType() < this.data[first + n1 + copied2].getType();
        }
        if (reverse && type.equals("type")) {
            return this.data[first + copied1].getType() > this.data[first + n1 + copied2].getType();
        }
        if (!reverse && type.equals("lineindex")) {
            return this.data[first + copied1].getLineIndex() < this.data[first + n1 + copied2].getLineIndex();
        }
        if (reverse && type.equals("lineindex")) {
            return this.data[first + copied1].getLineIndex() > this.data[first + n1 + copied2].getLineIndex();
        }
        return false;
    }

    public SidsEntry[] getData() {
        return this.data;
    }
}

