/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.PolyTableModel;

public class PolyFrame
extends JFrame {
    private String[] columnNames = new String[]{"Index", "Type", "Permutation"};
    private Model model;
    private int levelIndex;
    private JTable table;
    private JScrollPane scroller;
    private PolyTableModel tableModel;
    private int clickCount;

    public PolyFrame(Model model, int levelIndex) {
        this.model = model;
        this.levelIndex = levelIndex;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new PolyTableModel(this.columnNames, this.model, this.levelIndex);
        this.tableModel.addTableModelListener(new PolyTableModelListener());
        this.table = new JTable(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn sportColumn = this.table.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        int i = 0;
        while (i < StaticFunctions.polygonTypeNames.length) {
            comboBox.addItem(StaticFunctions.polygonTypeNames[i]);
            ++i;
        }
        sportColumn.setCellEditor(new DefaultCellEditor(comboBox));
        this.scroller = new JScrollPane(this.table);
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent m) {
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseReleased(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
            }

            public void mouseClicked(MouseEvent m) {
                Point mousePoint = new Point(m.getX(), m.getY());
                int header = PolyFrame.this.table.getTableHeader().columnAtPoint(mousePoint);
                PolyFrame polyFrame = PolyFrame.this;
                polyFrame.clickCount = polyFrame.clickCount + 1;
                boolean reverseOrder = false;
                if (PolyFrame.this.clickCount % 2 == 0) {
                    reverseOrder = true;
                }
                PolyFrame.this.tableModel.sort(header, reverseOrder);
            }
        });
        this.getContentPane().add(this.scroller);
        this.addWindowListener(new WindowListener(){

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                PolyFrame.this.closeTable();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.clickCount = 0;
        this.setSize(525, 440);
        this.setTitle("Polygons - " + this.model.getLevelSelectName());
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    private void closeTable() {
        this.model.removeChildFrame(this);
    }

    class PolyTableModelListener
    implements TableModelListener {
        PolyTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int column = evt.getColumn();
                int row = evt.getFirstRow();
                try {
                    PolyFrame.this.table.setRowSelectionInterval(row, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

